/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeObservationResponse extends ApplicationInsightsResponse implements
        ToCopyableBuilder<DescribeObservationResponse.Builder, DescribeObservationResponse> {
    private static final SdkField<Observation> OBSERVATION_FIELD = SdkField.<Observation> builder(MarshallingType.SDK_POJO)
            .memberName("Observation").getter(getter(DescribeObservationResponse::observation))
            .setter(setter(Builder::observation)).constructor(Observation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Observation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBSERVATION_FIELD));

    private final Observation observation;

    private DescribeObservationResponse(BuilderImpl builder) {
        super(builder);
        this.observation = builder.observation;
    }

    /**
     * <p>
     * Information about the observation.
     * </p>
     * 
     * @return Information about the observation.
     */
    public final Observation observation() {
        return observation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(observation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeObservationResponse)) {
            return false;
        }
        DescribeObservationResponse other = (DescribeObservationResponse) obj;
        return Objects.equals(observation(), other.observation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeObservationResponse").add("Observation", observation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Observation":
            return Optional.ofNullable(clazz.cast(observation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeObservationResponse, T> g) {
        return obj -> g.apply((DescribeObservationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationInsightsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeObservationResponse> {
        /**
         * <p>
         * Information about the observation.
         * </p>
         * 
         * @param observation
         *        Information about the observation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder observation(Observation observation);

        /**
         * <p>
         * Information about the observation.
         * </p>
         * This is a convenience method that creates an instance of the {@link Observation.Builder} avoiding the need to
         * create one manually via {@link Observation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Observation.Builder#build()} is called immediately and its result
         * is passed to {@link #observation(Observation)}.
         * 
         * @param observation
         *        a consumer that will call methods on {@link Observation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #observation(Observation)
         */
        default Builder observation(Consumer<Observation.Builder> observation) {
            return observation(Observation.builder().applyMutation(observation).build());
        }
    }

    static final class BuilderImpl extends ApplicationInsightsResponse.BuilderImpl implements Builder {
        private Observation observation;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeObservationResponse model) {
            super(model);
            observation(model.observation);
        }

        public final Observation.Builder getObservation() {
            return observation != null ? observation.toBuilder() : null;
        }

        public final void setObservation(Observation.BuilderImpl observation) {
            this.observation = observation != null ? observation.build() : null;
        }

        @Override
        public final Builder observation(Observation observation) {
            this.observation = observation;
            return this;
        }

        @Override
        public DescribeObservationResponse build() {
            return new DescribeObservationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
