/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateApplicationRequest extends ApplicationInsightsRequest implements
        ToCopyableBuilder<UpdateApplicationRequest.Builder, UpdateApplicationRequest> {
    private static final SdkField<String> RESOURCE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceGroupName").getter(getter(UpdateApplicationRequest::resourceGroupName))
            .setter(setter(Builder::resourceGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceGroupName").build()).build();

    private static final SdkField<Boolean> OPS_CENTER_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("OpsCenterEnabled").getter(getter(UpdateApplicationRequest::opsCenterEnabled))
            .setter(setter(Builder::opsCenterEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsCenterEnabled").build()).build();

    private static final SdkField<Boolean> CWE_MONITOR_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CWEMonitorEnabled").getter(getter(UpdateApplicationRequest::cweMonitorEnabled))
            .setter(setter(Builder::cweMonitorEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CWEMonitorEnabled").build()).build();

    private static final SdkField<String> OPS_ITEM_SNS_TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OpsItemSNSTopicArn").getter(getter(UpdateApplicationRequest::opsItemSNSTopicArn))
            .setter(setter(Builder::opsItemSNSTopicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsItemSNSTopicArn").build())
            .build();

    private static final SdkField<Boolean> REMOVE_SNS_TOPIC_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RemoveSNSTopic").getter(getter(UpdateApplicationRequest::removeSNSTopic))
            .setter(setter(Builder::removeSNSTopic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveSNSTopic").build()).build();

    private static final SdkField<Boolean> AUTO_CONFIG_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoConfigEnabled").getter(getter(UpdateApplicationRequest::autoConfigEnabled))
            .setter(setter(Builder::autoConfigEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoConfigEnabled").build()).build();

    private static final SdkField<Boolean> ATTACH_MISSING_PERMISSION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AttachMissingPermission").getter(getter(UpdateApplicationRequest::attachMissingPermission))
            .setter(setter(Builder::attachMissingPermission))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachMissingPermission").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_GROUP_NAME_FIELD,
            OPS_CENTER_ENABLED_FIELD, CWE_MONITOR_ENABLED_FIELD, OPS_ITEM_SNS_TOPIC_ARN_FIELD, REMOVE_SNS_TOPIC_FIELD,
            AUTO_CONFIG_ENABLED_FIELD, ATTACH_MISSING_PERMISSION_FIELD));

    private final String resourceGroupName;

    private final Boolean opsCenterEnabled;

    private final Boolean cweMonitorEnabled;

    private final String opsItemSNSTopicArn;

    private final Boolean removeSNSTopic;

    private final Boolean autoConfigEnabled;

    private final Boolean attachMissingPermission;

    private UpdateApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.resourceGroupName = builder.resourceGroupName;
        this.opsCenterEnabled = builder.opsCenterEnabled;
        this.cweMonitorEnabled = builder.cweMonitorEnabled;
        this.opsItemSNSTopicArn = builder.opsItemSNSTopicArn;
        this.removeSNSTopic = builder.removeSNSTopic;
        this.autoConfigEnabled = builder.autoConfigEnabled;
        this.attachMissingPermission = builder.attachMissingPermission;
    }

    /**
     * <p>
     * The name of the resource group.
     * </p>
     * 
     * @return The name of the resource group.
     */
    public final String resourceGroupName() {
        return resourceGroupName;
    }

    /**
     * <p>
     * When set to <code>true</code>, creates opsItems for any problems detected on an application.
     * </p>
     * 
     * @return When set to <code>true</code>, creates opsItems for any problems detected on an application.
     */
    public final Boolean opsCenterEnabled() {
        return opsCenterEnabled;
    }

    /**
     * <p>
     * Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as
     * <code>instance terminated</code>, <code>failed deployment</code>, and others.
     * </p>
     * 
     * @return Indicates whether Application Insights can listen to CloudWatch events for the application resources,
     *         such as <code>instance terminated</code>, <code>failed deployment</code>, and others.
     */
    public final Boolean cweMonitorEnabled() {
        return cweMonitorEnabled;
    }

    /**
     * <p>
     * The SNS topic provided to Application Insights that is associated to the created opsItem. Allows you to receive
     * notifications for updates to the opsItem.
     * </p>
     * 
     * @return The SNS topic provided to Application Insights that is associated to the created opsItem. Allows you to
     *         receive notifications for updates to the opsItem.
     */
    public final String opsItemSNSTopicArn() {
        return opsItemSNSTopicArn;
    }

    /**
     * <p>
     * Disassociates the SNS topic from the opsItem created for detected problems.
     * </p>
     * 
     * @return Disassociates the SNS topic from the opsItem created for detected problems.
     */
    public final Boolean removeSNSTopic() {
        return removeSNSTopic;
    }

    /**
     * <p>
     * Turns auto-configuration on or off.
     * </p>
     * 
     * @return Turns auto-configuration on or off.
     */
    public final Boolean autoConfigEnabled() {
        return autoConfigEnabled;
    }

    /**
     * <p>
     * If set to true, the managed policies for SSM and CW will be attached to the instance roles if they are missing.
     * </p>
     * 
     * @return If set to true, the managed policies for SSM and CW will be attached to the instance roles if they are
     *         missing.
     */
    public final Boolean attachMissingPermission() {
        return attachMissingPermission;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(opsCenterEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(cweMonitorEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(opsItemSNSTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(removeSNSTopic());
        hashCode = 31 * hashCode + Objects.hashCode(autoConfigEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(attachMissingPermission());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationRequest)) {
            return false;
        }
        UpdateApplicationRequest other = (UpdateApplicationRequest) obj;
        return Objects.equals(resourceGroupName(), other.resourceGroupName())
                && Objects.equals(opsCenterEnabled(), other.opsCenterEnabled())
                && Objects.equals(cweMonitorEnabled(), other.cweMonitorEnabled())
                && Objects.equals(opsItemSNSTopicArn(), other.opsItemSNSTopicArn())
                && Objects.equals(removeSNSTopic(), other.removeSNSTopic())
                && Objects.equals(autoConfigEnabled(), other.autoConfigEnabled())
                && Objects.equals(attachMissingPermission(), other.attachMissingPermission());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateApplicationRequest").add("ResourceGroupName", resourceGroupName())
                .add("OpsCenterEnabled", opsCenterEnabled()).add("CWEMonitorEnabled", cweMonitorEnabled())
                .add("OpsItemSNSTopicArn", opsItemSNSTopicArn()).add("RemoveSNSTopic", removeSNSTopic())
                .add("AutoConfigEnabled", autoConfigEnabled()).add("AttachMissingPermission", attachMissingPermission()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceGroupName":
            return Optional.ofNullable(clazz.cast(resourceGroupName()));
        case "OpsCenterEnabled":
            return Optional.ofNullable(clazz.cast(opsCenterEnabled()));
        case "CWEMonitorEnabled":
            return Optional.ofNullable(clazz.cast(cweMonitorEnabled()));
        case "OpsItemSNSTopicArn":
            return Optional.ofNullable(clazz.cast(opsItemSNSTopicArn()));
        case "RemoveSNSTopic":
            return Optional.ofNullable(clazz.cast(removeSNSTopic()));
        case "AutoConfigEnabled":
            return Optional.ofNullable(clazz.cast(autoConfigEnabled()));
        case "AttachMissingPermission":
            return Optional.ofNullable(clazz.cast(attachMissingPermission()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateApplicationRequest, T> g) {
        return obj -> g.apply((UpdateApplicationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationInsightsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateApplicationRequest> {
        /**
         * <p>
         * The name of the resource group.
         * </p>
         * 
         * @param resourceGroupName
         *        The name of the resource group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceGroupName(String resourceGroupName);

        /**
         * <p>
         * When set to <code>true</code>, creates opsItems for any problems detected on an application.
         * </p>
         * 
         * @param opsCenterEnabled
         *        When set to <code>true</code>, creates opsItems for any problems detected on an application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opsCenterEnabled(Boolean opsCenterEnabled);

        /**
         * <p>
         * Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as
         * <code>instance terminated</code>, <code>failed deployment</code>, and others.
         * </p>
         * 
         * @param cweMonitorEnabled
         *        Indicates whether Application Insights can listen to CloudWatch events for the application resources,
         *        such as <code>instance terminated</code>, <code>failed deployment</code>, and others.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cweMonitorEnabled(Boolean cweMonitorEnabled);

        /**
         * <p>
         * The SNS topic provided to Application Insights that is associated to the created opsItem. Allows you to
         * receive notifications for updates to the opsItem.
         * </p>
         * 
         * @param opsItemSNSTopicArn
         *        The SNS topic provided to Application Insights that is associated to the created opsItem. Allows you
         *        to receive notifications for updates to the opsItem.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opsItemSNSTopicArn(String opsItemSNSTopicArn);

        /**
         * <p>
         * Disassociates the SNS topic from the opsItem created for detected problems.
         * </p>
         * 
         * @param removeSNSTopic
         *        Disassociates the SNS topic from the opsItem created for detected problems.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeSNSTopic(Boolean removeSNSTopic);

        /**
         * <p>
         * Turns auto-configuration on or off.
         * </p>
         * 
         * @param autoConfigEnabled
         *        Turns auto-configuration on or off.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoConfigEnabled(Boolean autoConfigEnabled);

        /**
         * <p>
         * If set to true, the managed policies for SSM and CW will be attached to the instance roles if they are
         * missing.
         * </p>
         * 
         * @param attachMissingPermission
         *        If set to true, the managed policies for SSM and CW will be attached to the instance roles if they are
         *        missing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachMissingPermission(Boolean attachMissingPermission);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApplicationInsightsRequest.BuilderImpl implements Builder {
        private String resourceGroupName;

        private Boolean opsCenterEnabled;

        private Boolean cweMonitorEnabled;

        private String opsItemSNSTopicArn;

        private Boolean removeSNSTopic;

        private Boolean autoConfigEnabled;

        private Boolean attachMissingPermission;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationRequest model) {
            super(model);
            resourceGroupName(model.resourceGroupName);
            opsCenterEnabled(model.opsCenterEnabled);
            cweMonitorEnabled(model.cweMonitorEnabled);
            opsItemSNSTopicArn(model.opsItemSNSTopicArn);
            removeSNSTopic(model.removeSNSTopic);
            autoConfigEnabled(model.autoConfigEnabled);
            attachMissingPermission(model.attachMissingPermission);
        }

        public final String getResourceGroupName() {
            return resourceGroupName;
        }

        public final void setResourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
        }

        @Override
        public final Builder resourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
            return this;
        }

        public final Boolean getOpsCenterEnabled() {
            return opsCenterEnabled;
        }

        public final void setOpsCenterEnabled(Boolean opsCenterEnabled) {
            this.opsCenterEnabled = opsCenterEnabled;
        }

        @Override
        public final Builder opsCenterEnabled(Boolean opsCenterEnabled) {
            this.opsCenterEnabled = opsCenterEnabled;
            return this;
        }

        public final Boolean getCweMonitorEnabled() {
            return cweMonitorEnabled;
        }

        public final void setCweMonitorEnabled(Boolean cweMonitorEnabled) {
            this.cweMonitorEnabled = cweMonitorEnabled;
        }

        @Override
        public final Builder cweMonitorEnabled(Boolean cweMonitorEnabled) {
            this.cweMonitorEnabled = cweMonitorEnabled;
            return this;
        }

        public final String getOpsItemSNSTopicArn() {
            return opsItemSNSTopicArn;
        }

        public final void setOpsItemSNSTopicArn(String opsItemSNSTopicArn) {
            this.opsItemSNSTopicArn = opsItemSNSTopicArn;
        }

        @Override
        public final Builder opsItemSNSTopicArn(String opsItemSNSTopicArn) {
            this.opsItemSNSTopicArn = opsItemSNSTopicArn;
            return this;
        }

        public final Boolean getRemoveSNSTopic() {
            return removeSNSTopic;
        }

        public final void setRemoveSNSTopic(Boolean removeSNSTopic) {
            this.removeSNSTopic = removeSNSTopic;
        }

        @Override
        public final Builder removeSNSTopic(Boolean removeSNSTopic) {
            this.removeSNSTopic = removeSNSTopic;
            return this;
        }

        public final Boolean getAutoConfigEnabled() {
            return autoConfigEnabled;
        }

        public final void setAutoConfigEnabled(Boolean autoConfigEnabled) {
            this.autoConfigEnabled = autoConfigEnabled;
        }

        @Override
        public final Builder autoConfigEnabled(Boolean autoConfigEnabled) {
            this.autoConfigEnabled = autoConfigEnabled;
            return this;
        }

        public final Boolean getAttachMissingPermission() {
            return attachMissingPermission;
        }

        public final void setAttachMissingPermission(Boolean attachMissingPermission) {
            this.attachMissingPermission = attachMissingPermission;
        }

        @Override
        public final Builder attachMissingPermission(Boolean attachMissingPermission) {
            this.attachMissingPermission = attachMissingPermission;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateApplicationRequest build() {
            return new UpdateApplicationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
