/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.applicationinsights.model.ApplicationInsightsRequest;
import software.amazon.awssdk.services.applicationinsights.model.WorkloadConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddWorkloadRequest
extends ApplicationInsightsRequest
implements ToCopyableBuilder<Builder, AddWorkloadRequest> {
    private static final SdkField<String> RESOURCE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceGroupName").getter(AddWorkloadRequest.getter(AddWorkloadRequest::resourceGroupName)).setter(AddWorkloadRequest.setter(Builder::resourceGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceGroupName").build()}).build();
    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComponentName").getter(AddWorkloadRequest.getter(AddWorkloadRequest::componentName)).setter(AddWorkloadRequest.setter(Builder::componentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentName").build()}).build();
    private static final SdkField<WorkloadConfiguration> WORKLOAD_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WorkloadConfiguration").getter(AddWorkloadRequest.getter(AddWorkloadRequest::workloadConfiguration)).setter(AddWorkloadRequest.setter(Builder::workloadConfiguration)).constructor(WorkloadConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_GROUP_NAME_FIELD, COMPONENT_NAME_FIELD, WORKLOAD_CONFIGURATION_FIELD));
    private final String resourceGroupName;
    private final String componentName;
    private final WorkloadConfiguration workloadConfiguration;

    private AddWorkloadRequest(BuilderImpl builder) {
        super(builder);
        this.resourceGroupName = builder.resourceGroupName;
        this.componentName = builder.componentName;
        this.workloadConfiguration = builder.workloadConfiguration;
    }

    public final String resourceGroupName() {
        return this.resourceGroupName;
    }

    public final String componentName() {
        return this.componentName;
    }

    public final WorkloadConfiguration workloadConfiguration() {
        return this.workloadConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddWorkloadRequest)) {
            return false;
        }
        AddWorkloadRequest other = (AddWorkloadRequest)((Object)obj);
        return Objects.equals(this.resourceGroupName(), other.resourceGroupName()) && Objects.equals(this.componentName(), other.componentName()) && Objects.equals(this.workloadConfiguration(), other.workloadConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"AddWorkloadRequest").add("ResourceGroupName", (Object)this.resourceGroupName()).add("ComponentName", (Object)this.componentName()).add("WorkloadConfiguration", (Object)this.workloadConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceGroupName": {
                return Optional.ofNullable(clazz.cast(this.resourceGroupName()));
            }
            case "ComponentName": {
                return Optional.ofNullable(clazz.cast(this.componentName()));
            }
            case "WorkloadConfiguration": {
                return Optional.ofNullable(clazz.cast(this.workloadConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddWorkloadRequest, T> g) {
        return obj -> g.apply((AddWorkloadRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationInsightsRequest.BuilderImpl
    implements Builder {
        private String resourceGroupName;
        private String componentName;
        private WorkloadConfiguration workloadConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(AddWorkloadRequest model) {
            super(model);
            this.resourceGroupName(model.resourceGroupName);
            this.componentName(model.componentName);
            this.workloadConfiguration(model.workloadConfiguration);
        }

        public final String getResourceGroupName() {
            return this.resourceGroupName;
        }

        public final void setResourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
        }

        @Override
        public final Builder resourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
            return this;
        }

        public final String getComponentName() {
            return this.componentName;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        @Override
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final WorkloadConfiguration.Builder getWorkloadConfiguration() {
            return this.workloadConfiguration != null ? this.workloadConfiguration.toBuilder() : null;
        }

        public final void setWorkloadConfiguration(WorkloadConfiguration.BuilderImpl workloadConfiguration) {
            this.workloadConfiguration = workloadConfiguration != null ? workloadConfiguration.build() : null;
        }

        @Override
        public final Builder workloadConfiguration(WorkloadConfiguration workloadConfiguration) {
            this.workloadConfiguration = workloadConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddWorkloadRequest build() {
            return new AddWorkloadRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApplicationInsightsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AddWorkloadRequest> {
        public Builder resourceGroupName(String var1);

        public Builder componentName(String var1);

        public Builder workloadConfiguration(WorkloadConfiguration var1);

        default public Builder workloadConfiguration(Consumer<WorkloadConfiguration.Builder> workloadConfiguration) {
            return this.workloadConfiguration((WorkloadConfiguration)((WorkloadConfiguration.Builder)WorkloadConfiguration.builder().applyMutation(workloadConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

