/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeImagePermissionsRequest extends AppStreamRequest implements
        ToCopyableBuilder<DescribeImagePermissionsRequest.Builder, DescribeImagePermissionsRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DescribeImagePermissionsRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(DescribeImagePermissionsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<List<String>> SHARED_AWS_ACCOUNT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SharedAwsAccountIds")
            .getter(getter(DescribeImagePermissionsRequest::sharedAwsAccountIds))
            .setter(setter(Builder::sharedAwsAccountIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedAwsAccountIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeImagePermissionsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, MAX_RESULTS_FIELD,
            SHARED_AWS_ACCOUNT_IDS_FIELD, NEXT_TOKEN_FIELD));

    private final String name;

    private final Integer maxResults;

    private final List<String> sharedAwsAccountIds;

    private final String nextToken;

    private DescribeImagePermissionsRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.maxResults = builder.maxResults;
        this.sharedAwsAccountIds = builder.sharedAwsAccountIds;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of the private image for which to describe permissions. The image must be one that you own.
     * </p>
     * 
     * @return The name of the private image for which to describe permissions. The image must be one that you own.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The maximum size of each page of results.
     * </p>
     * 
     * @return The maximum size of each page of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the SharedAwsAccountIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSharedAwsAccountIds() {
        return sharedAwsAccountIds != null && !(sharedAwsAccountIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The 12-digit identifier of one or more AWS accounts with which the image is shared.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSharedAwsAccountIds} method.
     * </p>
     * 
     * @return The 12-digit identifier of one or more AWS accounts with which the image is shared.
     */
    public final List<String> sharedAwsAccountIds() {
        return sharedAwsAccountIds;
    }

    /**
     * <p>
     * The pagination token to use to retrieve the next page of results for this operation. If this value is null, it
     * retrieves the first page.
     * </p>
     * 
     * @return The pagination token to use to retrieve the next page of results for this operation. If this value is
     *         null, it retrieves the first page.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(hasSharedAwsAccountIds() ? sharedAwsAccountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImagePermissionsRequest)) {
            return false;
        }
        DescribeImagePermissionsRequest other = (DescribeImagePermissionsRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(maxResults(), other.maxResults())
                && hasSharedAwsAccountIds() == other.hasSharedAwsAccountIds()
                && Objects.equals(sharedAwsAccountIds(), other.sharedAwsAccountIds())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeImagePermissionsRequest").add("Name", name()).add("MaxResults", maxResults())
                .add("SharedAwsAccountIds", hasSharedAwsAccountIds() ? sharedAwsAccountIds() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "SharedAwsAccountIds":
            return Optional.ofNullable(clazz.cast(sharedAwsAccountIds()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeImagePermissionsRequest, T> g) {
        return obj -> g.apply((DescribeImagePermissionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppStreamRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeImagePermissionsRequest> {
        /**
         * <p>
         * The name of the private image for which to describe permissions. The image must be one that you own.
         * </p>
         * 
         * @param name
         *        The name of the private image for which to describe permissions. The image must be one that you own.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The maximum size of each page of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum size of each page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The 12-digit identifier of one or more AWS accounts with which the image is shared.
         * </p>
         * 
         * @param sharedAwsAccountIds
         *        The 12-digit identifier of one or more AWS accounts with which the image is shared.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedAwsAccountIds(Collection<String> sharedAwsAccountIds);

        /**
         * <p>
         * The 12-digit identifier of one or more AWS accounts with which the image is shared.
         * </p>
         * 
         * @param sharedAwsAccountIds
         *        The 12-digit identifier of one or more AWS accounts with which the image is shared.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedAwsAccountIds(String... sharedAwsAccountIds);

        /**
         * <p>
         * The pagination token to use to retrieve the next page of results for this operation. If this value is null,
         * it retrieves the first page.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to use to retrieve the next page of results for this operation. If this value is
         *        null, it retrieves the first page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppStreamRequest.BuilderImpl implements Builder {
        private String name;

        private Integer maxResults;

        private List<String> sharedAwsAccountIds = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImagePermissionsRequest model) {
            super(model);
            name(model.name);
            maxResults(model.maxResults);
            sharedAwsAccountIds(model.sharedAwsAccountIds);
            nextToken(model.nextToken);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Collection<String> getSharedAwsAccountIds() {
            if (sharedAwsAccountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return sharedAwsAccountIds;
        }

        public final void setSharedAwsAccountIds(Collection<String> sharedAwsAccountIds) {
            this.sharedAwsAccountIds = AwsAccountIdListCopier.copy(sharedAwsAccountIds);
        }

        @Override
        public final Builder sharedAwsAccountIds(Collection<String> sharedAwsAccountIds) {
            this.sharedAwsAccountIds = AwsAccountIdListCopier.copy(sharedAwsAccountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sharedAwsAccountIds(String... sharedAwsAccountIds) {
            sharedAwsAccountIds(Arrays.asList(sharedAwsAccountIds));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeImagePermissionsRequest build() {
            return new DescribeImagePermissionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
