/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arczonalshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A practice run configuration for a resource includes the Amazon CloudWatch alarms that you've specified for a
 * practice run, as well as any blocked dates or blocked windows for the practice run.
 * </p>
 * <p>
 * You can update or delete a practice run configuration. Before you delete a practice run configuration, you must
 * disable zonal autoshift for the resource. A practice run configuration is required when zonal autoshift is enabled.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PracticeRunConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<PracticeRunConfiguration.Builder, PracticeRunConfiguration> {
    private static final SdkField<List<String>> BLOCKED_DATES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("blockedDates")
            .getter(getter(PracticeRunConfiguration::blockedDates))
            .setter(setter(Builder::blockedDates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockedDates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> BLOCKED_WINDOWS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("blockedWindows")
            .getter(getter(PracticeRunConfiguration::blockedWindows))
            .setter(setter(Builder::blockedWindows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockedWindows").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ControlCondition>> BLOCKING_ALARMS_FIELD = SdkField
            .<List<ControlCondition>> builder(MarshallingType.LIST)
            .memberName("blockingAlarms")
            .getter(getter(PracticeRunConfiguration::blockingAlarms))
            .setter(setter(Builder::blockingAlarms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockingAlarms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ControlCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(ControlCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ControlCondition>> OUTCOME_ALARMS_FIELD = SdkField
            .<List<ControlCondition>> builder(MarshallingType.LIST)
            .memberName("outcomeAlarms")
            .getter(getter(PracticeRunConfiguration::outcomeAlarms))
            .setter(setter(Builder::outcomeAlarms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outcomeAlarms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ControlCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(ControlCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCKED_DATES_FIELD,
            BLOCKED_WINDOWS_FIELD, BLOCKING_ALARMS_FIELD, OUTCOME_ALARMS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> blockedDates;

    private final List<String> blockedWindows;

    private final List<ControlCondition> blockingAlarms;

    private final List<ControlCondition> outcomeAlarms;

    private PracticeRunConfiguration(BuilderImpl builder) {
        this.blockedDates = builder.blockedDates;
        this.blockedWindows = builder.blockedWindows;
        this.blockingAlarms = builder.blockingAlarms;
        this.outcomeAlarms = builder.outcomeAlarms;
    }

    /**
     * For responses, this returns true if the service returned a value for the BlockedDates property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBlockedDates() {
        return blockedDates != null && !(blockedDates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of one or more dates that you can specify when Amazon Web Services does not start practice runs for a
     * resource.
     * </p>
     * <p>
     * Specify blocked dates, in UTC, in the format <code>YYYY-MM-DD</code>, separated by spaces.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlockedDates} method.
     * </p>
     * 
     * @return An array of one or more dates that you can specify when Amazon Web Services does not start practice runs
     *         for a resource.</p>
     *         <p>
     *         Specify blocked dates, in UTC, in the format <code>YYYY-MM-DD</code>, separated by spaces.
     */
    public final List<String> blockedDates() {
        return blockedDates;
    }

    /**
     * For responses, this returns true if the service returned a value for the BlockedWindows property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBlockedWindows() {
        return blockedWindows != null && !(blockedWindows instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of one or more windows of days and times that you can block Route 53 ARC from starting practice runs for
     * a resource.
     * </p>
     * <p>
     * Specify the blocked windows in UTC, using the format <code>DAY:HH:MM-DAY:HH:MM</code>, separated by spaces. For
     * example, <code>MON:18:30-MON:19:30 TUE:18:30-TUE:19:30</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlockedWindows} method.
     * </p>
     * 
     * @return An array of one or more windows of days and times that you can block Route 53 ARC from starting practice
     *         runs for a resource.</p>
     *         <p>
     *         Specify the blocked windows in UTC, using the format <code>DAY:HH:MM-DAY:HH:MM</code>, separated by
     *         spaces. For example, <code>MON:18:30-MON:19:30 TUE:18:30-TUE:19:30</code>.
     */
    public final List<String> blockedWindows() {
        return blockedWindows;
    }

    /**
     * For responses, this returns true if the service returned a value for the BlockingAlarms property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBlockingAlarms() {
        return blockingAlarms != null && !(blockingAlarms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The <i>blocking alarm</i> for practice runs is an optional alarm that you can specify that blocks practice runs
     * when the alarm is in an <code>ALARM</code> state.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlockingAlarms} method.
     * </p>
     * 
     * @return The <i>blocking alarm</i> for practice runs is an optional alarm that you can specify that blocks
     *         practice runs when the alarm is in an <code>ALARM</code> state.
     */
    public final List<ControlCondition> blockingAlarms() {
        return blockingAlarms;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutcomeAlarms property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutcomeAlarms() {
        return outcomeAlarms != null && !(outcomeAlarms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The <i>outcome alarm</i> for practice runs is an alarm that you specify that ends a practice run when the alarm
     * is in an <code>ALARM</code> state.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutcomeAlarms} method.
     * </p>
     * 
     * @return The <i>outcome alarm</i> for practice runs is an alarm that you specify that ends a practice run when the
     *         alarm is in an <code>ALARM</code> state.
     */
    public final List<ControlCondition> outcomeAlarms() {
        return outcomeAlarms;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasBlockedDates() ? blockedDates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBlockedWindows() ? blockedWindows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBlockingAlarms() ? blockingAlarms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOutcomeAlarms() ? outcomeAlarms() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PracticeRunConfiguration)) {
            return false;
        }
        PracticeRunConfiguration other = (PracticeRunConfiguration) obj;
        return hasBlockedDates() == other.hasBlockedDates() && Objects.equals(blockedDates(), other.blockedDates())
                && hasBlockedWindows() == other.hasBlockedWindows() && Objects.equals(blockedWindows(), other.blockedWindows())
                && hasBlockingAlarms() == other.hasBlockingAlarms() && Objects.equals(blockingAlarms(), other.blockingAlarms())
                && hasOutcomeAlarms() == other.hasOutcomeAlarms() && Objects.equals(outcomeAlarms(), other.outcomeAlarms());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PracticeRunConfiguration").add("BlockedDates", hasBlockedDates() ? blockedDates() : null)
                .add("BlockedWindows", hasBlockedWindows() ? blockedWindows() : null)
                .add("BlockingAlarms", hasBlockingAlarms() ? blockingAlarms() : null)
                .add("OutcomeAlarms", hasOutcomeAlarms() ? outcomeAlarms() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "blockedDates":
            return Optional.ofNullable(clazz.cast(blockedDates()));
        case "blockedWindows":
            return Optional.ofNullable(clazz.cast(blockedWindows()));
        case "blockingAlarms":
            return Optional.ofNullable(clazz.cast(blockingAlarms()));
        case "outcomeAlarms":
            return Optional.ofNullable(clazz.cast(outcomeAlarms()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PracticeRunConfiguration, T> g) {
        return obj -> g.apply((PracticeRunConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PracticeRunConfiguration> {
        /**
         * <p>
         * An array of one or more dates that you can specify when Amazon Web Services does not start practice runs for
         * a resource.
         * </p>
         * <p>
         * Specify blocked dates, in UTC, in the format <code>YYYY-MM-DD</code>, separated by spaces.
         * </p>
         * 
         * @param blockedDates
         *        An array of one or more dates that you can specify when Amazon Web Services does not start practice
         *        runs for a resource.</p>
         *        <p>
         *        Specify blocked dates, in UTC, in the format <code>YYYY-MM-DD</code>, separated by spaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockedDates(Collection<String> blockedDates);

        /**
         * <p>
         * An array of one or more dates that you can specify when Amazon Web Services does not start practice runs for
         * a resource.
         * </p>
         * <p>
         * Specify blocked dates, in UTC, in the format <code>YYYY-MM-DD</code>, separated by spaces.
         * </p>
         * 
         * @param blockedDates
         *        An array of one or more dates that you can specify when Amazon Web Services does not start practice
         *        runs for a resource.</p>
         *        <p>
         *        Specify blocked dates, in UTC, in the format <code>YYYY-MM-DD</code>, separated by spaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockedDates(String... blockedDates);

        /**
         * <p>
         * An array of one or more windows of days and times that you can block Route 53 ARC from starting practice runs
         * for a resource.
         * </p>
         * <p>
         * Specify the blocked windows in UTC, using the format <code>DAY:HH:MM-DAY:HH:MM</code>, separated by spaces.
         * For example, <code>MON:18:30-MON:19:30 TUE:18:30-TUE:19:30</code>.
         * </p>
         * 
         * @param blockedWindows
         *        An array of one or more windows of days and times that you can block Route 53 ARC from starting
         *        practice runs for a resource.</p>
         *        <p>
         *        Specify the blocked windows in UTC, using the format <code>DAY:HH:MM-DAY:HH:MM</code>, separated by
         *        spaces. For example, <code>MON:18:30-MON:19:30 TUE:18:30-TUE:19:30</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockedWindows(Collection<String> blockedWindows);

        /**
         * <p>
         * An array of one or more windows of days and times that you can block Route 53 ARC from starting practice runs
         * for a resource.
         * </p>
         * <p>
         * Specify the blocked windows in UTC, using the format <code>DAY:HH:MM-DAY:HH:MM</code>, separated by spaces.
         * For example, <code>MON:18:30-MON:19:30 TUE:18:30-TUE:19:30</code>.
         * </p>
         * 
         * @param blockedWindows
         *        An array of one or more windows of days and times that you can block Route 53 ARC from starting
         *        practice runs for a resource.</p>
         *        <p>
         *        Specify the blocked windows in UTC, using the format <code>DAY:HH:MM-DAY:HH:MM</code>, separated by
         *        spaces. For example, <code>MON:18:30-MON:19:30 TUE:18:30-TUE:19:30</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockedWindows(String... blockedWindows);

        /**
         * <p>
         * The <i>blocking alarm</i> for practice runs is an optional alarm that you can specify that blocks practice
         * runs when the alarm is in an <code>ALARM</code> state.
         * </p>
         * 
         * @param blockingAlarms
         *        The <i>blocking alarm</i> for practice runs is an optional alarm that you can specify that blocks
         *        practice runs when the alarm is in an <code>ALARM</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockingAlarms(Collection<ControlCondition> blockingAlarms);

        /**
         * <p>
         * The <i>blocking alarm</i> for practice runs is an optional alarm that you can specify that blocks practice
         * runs when the alarm is in an <code>ALARM</code> state.
         * </p>
         * 
         * @param blockingAlarms
         *        The <i>blocking alarm</i> for practice runs is an optional alarm that you can specify that blocks
         *        practice runs when the alarm is in an <code>ALARM</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockingAlarms(ControlCondition... blockingAlarms);

        /**
         * <p>
         * The <i>blocking alarm</i> for practice runs is an optional alarm that you can specify that blocks practice
         * runs when the alarm is in an <code>ALARM</code> state.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.arczonalshift.model.ControlCondition.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.arczonalshift.model.ControlCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.arczonalshift.model.ControlCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #blockingAlarms(List<ControlCondition>)}.
         * 
         * @param blockingAlarms
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.arczonalshift.model.ControlCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blockingAlarms(java.util.Collection<ControlCondition>)
         */
        Builder blockingAlarms(Consumer<ControlCondition.Builder>... blockingAlarms);

        /**
         * <p>
         * The <i>outcome alarm</i> for practice runs is an alarm that you specify that ends a practice run when the
         * alarm is in an <code>ALARM</code> state.
         * </p>
         * 
         * @param outcomeAlarms
         *        The <i>outcome alarm</i> for practice runs is an alarm that you specify that ends a practice run when
         *        the alarm is in an <code>ALARM</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outcomeAlarms(Collection<ControlCondition> outcomeAlarms);

        /**
         * <p>
         * The <i>outcome alarm</i> for practice runs is an alarm that you specify that ends a practice run when the
         * alarm is in an <code>ALARM</code> state.
         * </p>
         * 
         * @param outcomeAlarms
         *        The <i>outcome alarm</i> for practice runs is an alarm that you specify that ends a practice run when
         *        the alarm is in an <code>ALARM</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outcomeAlarms(ControlCondition... outcomeAlarms);

        /**
         * <p>
         * The <i>outcome alarm</i> for practice runs is an alarm that you specify that ends a practice run when the
         * alarm is in an <code>ALARM</code> state.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.arczonalshift.model.ControlCondition.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.arczonalshift.model.ControlCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.arczonalshift.model.ControlCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #outcomeAlarms(List<ControlCondition>)}.
         * 
         * @param outcomeAlarms
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.arczonalshift.model.ControlCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outcomeAlarms(java.util.Collection<ControlCondition>)
         */
        Builder outcomeAlarms(Consumer<ControlCondition.Builder>... outcomeAlarms);
    }

    static final class BuilderImpl implements Builder {
        private List<String> blockedDates = DefaultSdkAutoConstructList.getInstance();

        private List<String> blockedWindows = DefaultSdkAutoConstructList.getInstance();

        private List<ControlCondition> blockingAlarms = DefaultSdkAutoConstructList.getInstance();

        private List<ControlCondition> outcomeAlarms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PracticeRunConfiguration model) {
            blockedDates(model.blockedDates);
            blockedWindows(model.blockedWindows);
            blockingAlarms(model.blockingAlarms);
            outcomeAlarms(model.outcomeAlarms);
        }

        public final Collection<String> getBlockedDates() {
            if (blockedDates instanceof SdkAutoConstructList) {
                return null;
            }
            return blockedDates;
        }

        public final void setBlockedDates(Collection<String> blockedDates) {
            this.blockedDates = BlockedDatesCopier.copy(blockedDates);
        }

        @Override
        public final Builder blockedDates(Collection<String> blockedDates) {
            this.blockedDates = BlockedDatesCopier.copy(blockedDates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockedDates(String... blockedDates) {
            blockedDates(Arrays.asList(blockedDates));
            return this;
        }

        public final Collection<String> getBlockedWindows() {
            if (blockedWindows instanceof SdkAutoConstructList) {
                return null;
            }
            return blockedWindows;
        }

        public final void setBlockedWindows(Collection<String> blockedWindows) {
            this.blockedWindows = BlockedWindowsCopier.copy(blockedWindows);
        }

        @Override
        public final Builder blockedWindows(Collection<String> blockedWindows) {
            this.blockedWindows = BlockedWindowsCopier.copy(blockedWindows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockedWindows(String... blockedWindows) {
            blockedWindows(Arrays.asList(blockedWindows));
            return this;
        }

        public final List<ControlCondition.Builder> getBlockingAlarms() {
            List<ControlCondition.Builder> result = ControlConditionsCopier.copyToBuilder(this.blockingAlarms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlockingAlarms(Collection<ControlCondition.BuilderImpl> blockingAlarms) {
            this.blockingAlarms = ControlConditionsCopier.copyFromBuilder(blockingAlarms);
        }

        @Override
        public final Builder blockingAlarms(Collection<ControlCondition> blockingAlarms) {
            this.blockingAlarms = ControlConditionsCopier.copy(blockingAlarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockingAlarms(ControlCondition... blockingAlarms) {
            blockingAlarms(Arrays.asList(blockingAlarms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockingAlarms(Consumer<ControlCondition.Builder>... blockingAlarms) {
            blockingAlarms(Stream.of(blockingAlarms).map(c -> ControlCondition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ControlCondition.Builder> getOutcomeAlarms() {
            List<ControlCondition.Builder> result = ControlConditionsCopier.copyToBuilder(this.outcomeAlarms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutcomeAlarms(Collection<ControlCondition.BuilderImpl> outcomeAlarms) {
            this.outcomeAlarms = ControlConditionsCopier.copyFromBuilder(outcomeAlarms);
        }

        @Override
        public final Builder outcomeAlarms(Collection<ControlCondition> outcomeAlarms) {
            this.outcomeAlarms = ControlConditionsCopier.copy(outcomeAlarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outcomeAlarms(ControlCondition... outcomeAlarms) {
            outcomeAlarms(Arrays.asList(outcomeAlarms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outcomeAlarms(Consumer<ControlCondition.Builder>... outcomeAlarms) {
            outcomeAlarms(Stream.of(outcomeAlarms).map(c -> ControlCondition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public PracticeRunConfiguration build() {
            return new PracticeRunConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
