/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateNamedQueryRequest extends AthenaRequest implements
        ToCopyableBuilder<UpdateNamedQueryRequest.Builder, UpdateNamedQueryRequest> {
    private static final SdkField<String> NAMED_QUERY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NamedQueryId").getter(getter(UpdateNamedQueryRequest::namedQueryId))
            .setter(setter(Builder::namedQueryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NamedQueryId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateNamedQueryRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateNamedQueryRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryString").getter(getter(UpdateNamedQueryRequest::queryString)).setter(setter(Builder::queryString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryString").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMED_QUERY_ID_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, QUERY_STRING_FIELD));

    private final String namedQueryId;

    private final String name;

    private final String description;

    private final String queryString;

    private UpdateNamedQueryRequest(BuilderImpl builder) {
        super(builder);
        this.namedQueryId = builder.namedQueryId;
        this.name = builder.name;
        this.description = builder.description;
        this.queryString = builder.queryString;
    }

    /**
     * <p>
     * The unique identifier (UUID) of the query.
     * </p>
     * 
     * @return The unique identifier (UUID) of the query.
     */
    public final String namedQueryId() {
        return namedQueryId;
    }

    /**
     * <p>
     * The name of the query.
     * </p>
     * 
     * @return The name of the query.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The query description.
     * </p>
     * 
     * @return The query description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The contents of the query with all query statements.
     * </p>
     * 
     * @return The contents of the query with all query statements.
     */
    public final String queryString() {
        return queryString;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(namedQueryId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(queryString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateNamedQueryRequest)) {
            return false;
        }
        UpdateNamedQueryRequest other = (UpdateNamedQueryRequest) obj;
        return Objects.equals(namedQueryId(), other.namedQueryId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(queryString(), other.queryString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateNamedQueryRequest").add("NamedQueryId", namedQueryId()).add("Name", name())
                .add("Description", description()).add("QueryString", queryString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NamedQueryId":
            return Optional.ofNullable(clazz.cast(namedQueryId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "QueryString":
            return Optional.ofNullable(clazz.cast(queryString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateNamedQueryRequest, T> g) {
        return obj -> g.apply((UpdateNamedQueryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AthenaRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateNamedQueryRequest> {
        /**
         * <p>
         * The unique identifier (UUID) of the query.
         * </p>
         * 
         * @param namedQueryId
         *        The unique identifier (UUID) of the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namedQueryId(String namedQueryId);

        /**
         * <p>
         * The name of the query.
         * </p>
         * 
         * @param name
         *        The name of the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The query description.
         * </p>
         * 
         * @param description
         *        The query description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The contents of the query with all query statements.
         * </p>
         * 
         * @param queryString
         *        The contents of the query with all query statements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryString(String queryString);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AthenaRequest.BuilderImpl implements Builder {
        private String namedQueryId;

        private String name;

        private String description;

        private String queryString;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateNamedQueryRequest model) {
            super(model);
            namedQueryId(model.namedQueryId);
            name(model.name);
            description(model.description);
            queryString(model.queryString);
        }

        public final String getNamedQueryId() {
            return namedQueryId;
        }

        public final void setNamedQueryId(String namedQueryId) {
            this.namedQueryId = namedQueryId;
        }

        @Override
        public final Builder namedQueryId(String namedQueryId) {
            this.namedQueryId = namedQueryId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getQueryString() {
            return queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateNamedQueryRequest build() {
            return new UpdateNamedQueryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
