/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetProfileResponse extends B2BiResponse implements
        ToCopyableBuilder<GetProfileResponse.Builder, GetProfileResponse> {
    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("profileId").getter(getter(GetProfileResponse::profileId)).setter(setter(Builder::profileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileId").build()).build();

    private static final SdkField<String> PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("profileArn").getter(getter(GetProfileResponse::profileArn)).setter(setter(Builder::profileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetProfileResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("email")
            .getter(getter(GetProfileResponse::email)).setter(setter(Builder::email))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("email").build()).build();

    private static final SdkField<String> PHONE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("phone")
            .getter(getter(GetProfileResponse::phone)).setter(setter(Builder::phone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("phone").build()).build();

    private static final SdkField<String> BUSINESS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("businessName").getter(getter(GetProfileResponse::businessName)).setter(setter(Builder::businessName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("businessName").build()).build();

    private static final SdkField<String> LOGGING_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("logging")
            .getter(getter(GetProfileResponse::loggingAsString)).setter(setter(Builder::logging))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logging").build()).build();

    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logGroupName").getter(getter(GetProfileResponse::logGroupName)).setter(setter(Builder::logGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(GetProfileResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("modifiedAt")
            .getter(getter(GetProfileResponse::modifiedAt))
            .setter(setter(Builder::modifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_ID_FIELD,
            PROFILE_ARN_FIELD, NAME_FIELD, EMAIL_FIELD, PHONE_FIELD, BUSINESS_NAME_FIELD, LOGGING_FIELD, LOG_GROUP_NAME_FIELD,
            CREATED_AT_FIELD, MODIFIED_AT_FIELD));

    private final String profileId;

    private final String profileArn;

    private final String name;

    private final String email;

    private final String phone;

    private final String businessName;

    private final String logging;

    private final String logGroupName;

    private final Instant createdAt;

    private final Instant modifiedAt;

    private GetProfileResponse(BuilderImpl builder) {
        super(builder);
        this.profileId = builder.profileId;
        this.profileArn = builder.profileArn;
        this.name = builder.name;
        this.email = builder.email;
        this.phone = builder.phone;
        this.businessName = builder.businessName;
        this.logging = builder.logging;
        this.logGroupName = builder.logGroupName;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
    }

    /**
     * <p>
     * Returns the unique, system-generated identifier for the profile.
     * </p>
     * 
     * @return Returns the unique, system-generated identifier for the profile.
     */
    public final String profileId() {
        return profileId;
    }

    /**
     * <p>
     * Returns an Amazon Resource Name (ARN) for a specific Amazon Web Services resource, such as a capability,
     * partnership, profile, or transformer.
     * </p>
     * 
     * @return Returns an Amazon Resource Name (ARN) for a specific Amazon Web Services resource, such as a capability,
     *         partnership, profile, or transformer.
     */
    public final String profileArn() {
        return profileArn;
    }

    /**
     * <p>
     * Returns the name of the profile, used to identify it.
     * </p>
     * 
     * @return Returns the name of the profile, used to identify it.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Returns the email address associated with this customer profile.
     * </p>
     * 
     * @return Returns the email address associated with this customer profile.
     */
    public final String email() {
        return email;
    }

    /**
     * <p>
     * Returns the phone number associated with the profile.
     * </p>
     * 
     * @return Returns the phone number associated with the profile.
     */
    public final String phone() {
        return phone;
    }

    /**
     * <p>
     * Returns the name for the business associated with this profile.
     * </p>
     * 
     * @return Returns the name for the business associated with this profile.
     */
    public final String businessName() {
        return businessName;
    }

    /**
     * <p>
     * Returns whether or not logging is enabled for this profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logging} will
     * return {@link Logging#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #loggingAsString}.
     * </p>
     * 
     * @return Returns whether or not logging is enabled for this profile.
     * @see Logging
     */
    public final Logging logging() {
        return Logging.fromValue(logging);
    }

    /**
     * <p>
     * Returns whether or not logging is enabled for this profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logging} will
     * return {@link Logging#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #loggingAsString}.
     * </p>
     * 
     * @return Returns whether or not logging is enabled for this profile.
     * @see Logging
     */
    public final String loggingAsString() {
        return logging;
    }

    /**
     * <p>
     * Returns the name of the logging group.
     * </p>
     * 
     * @return Returns the name of the logging group.
     */
    public final String logGroupName() {
        return logGroupName;
    }

    /**
     * <p>
     * Returns a timestamp for creation date and time of the transformer.
     * </p>
     * 
     * @return Returns a timestamp for creation date and time of the transformer.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Returns a timestamp for last time the profile was modified.
     * </p>
     * 
     * @return Returns a timestamp for last time the profile was modified.
     */
    public final Instant modifiedAt() {
        return modifiedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(profileId());
        hashCode = 31 * hashCode + Objects.hashCode(profileArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(email());
        hashCode = 31 * hashCode + Objects.hashCode(phone());
        hashCode = 31 * hashCode + Objects.hashCode(businessName());
        hashCode = 31 * hashCode + Objects.hashCode(loggingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProfileResponse)) {
            return false;
        }
        GetProfileResponse other = (GetProfileResponse) obj;
        return Objects.equals(profileId(), other.profileId()) && Objects.equals(profileArn(), other.profileArn())
                && Objects.equals(name(), other.name()) && Objects.equals(email(), other.email())
                && Objects.equals(phone(), other.phone()) && Objects.equals(businessName(), other.businessName())
                && Objects.equals(loggingAsString(), other.loggingAsString())
                && Objects.equals(logGroupName(), other.logGroupName()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(modifiedAt(), other.modifiedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetProfileResponse").add("ProfileId", profileId()).add("ProfileArn", profileArn())
                .add("Name", name()).add("Email", email() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Phone", phone() == null ? null : "*** Sensitive Data Redacted ***").add("BusinessName", businessName())
                .add("Logging", loggingAsString()).add("LogGroupName", logGroupName()).add("CreatedAt", createdAt())
                .add("ModifiedAt", modifiedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "profileId":
            return Optional.ofNullable(clazz.cast(profileId()));
        case "profileArn":
            return Optional.ofNullable(clazz.cast(profileArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "email":
            return Optional.ofNullable(clazz.cast(email()));
        case "phone":
            return Optional.ofNullable(clazz.cast(phone()));
        case "businessName":
            return Optional.ofNullable(clazz.cast(businessName()));
        case "logging":
            return Optional.ofNullable(clazz.cast(loggingAsString()));
        case "logGroupName":
            return Optional.ofNullable(clazz.cast(logGroupName()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "modifiedAt":
            return Optional.ofNullable(clazz.cast(modifiedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetProfileResponse, T> g) {
        return obj -> g.apply((GetProfileResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends B2BiResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetProfileResponse> {
        /**
         * <p>
         * Returns the unique, system-generated identifier for the profile.
         * </p>
         * 
         * @param profileId
         *        Returns the unique, system-generated identifier for the profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileId(String profileId);

        /**
         * <p>
         * Returns an Amazon Resource Name (ARN) for a specific Amazon Web Services resource, such as a capability,
         * partnership, profile, or transformer.
         * </p>
         * 
         * @param profileArn
         *        Returns an Amazon Resource Name (ARN) for a specific Amazon Web Services resource, such as a
         *        capability, partnership, profile, or transformer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileArn(String profileArn);

        /**
         * <p>
         * Returns the name of the profile, used to identify it.
         * </p>
         * 
         * @param name
         *        Returns the name of the profile, used to identify it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Returns the email address associated with this customer profile.
         * </p>
         * 
         * @param email
         *        Returns the email address associated with this customer profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(String email);

        /**
         * <p>
         * Returns the phone number associated with the profile.
         * </p>
         * 
         * @param phone
         *        Returns the phone number associated with the profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phone(String phone);

        /**
         * <p>
         * Returns the name for the business associated with this profile.
         * </p>
         * 
         * @param businessName
         *        Returns the name for the business associated with this profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder businessName(String businessName);

        /**
         * <p>
         * Returns whether or not logging is enabled for this profile.
         * </p>
         * 
         * @param logging
         *        Returns whether or not logging is enabled for this profile.
         * @see Logging
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Logging
         */
        Builder logging(String logging);

        /**
         * <p>
         * Returns whether or not logging is enabled for this profile.
         * </p>
         * 
         * @param logging
         *        Returns whether or not logging is enabled for this profile.
         * @see Logging
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Logging
         */
        Builder logging(Logging logging);

        /**
         * <p>
         * Returns the name of the logging group.
         * </p>
         * 
         * @param logGroupName
         *        Returns the name of the logging group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);

        /**
         * <p>
         * Returns a timestamp for creation date and time of the transformer.
         * </p>
         * 
         * @param createdAt
         *        Returns a timestamp for creation date and time of the transformer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Returns a timestamp for last time the profile was modified.
         * </p>
         * 
         * @param modifiedAt
         *        Returns a timestamp for last time the profile was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedAt(Instant modifiedAt);
    }

    static final class BuilderImpl extends B2BiResponse.BuilderImpl implements Builder {
        private String profileId;

        private String profileArn;

        private String name;

        private String email;

        private String phone;

        private String businessName;

        private String logging;

        private String logGroupName;

        private Instant createdAt;

        private Instant modifiedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetProfileResponse model) {
            super(model);
            profileId(model.profileId);
            profileArn(model.profileArn);
            name(model.name);
            email(model.email);
            phone(model.phone);
            businessName(model.businessName);
            logging(model.logging);
            logGroupName(model.logGroupName);
            createdAt(model.createdAt);
            modifiedAt(model.modifiedAt);
        }

        public final String getProfileId() {
            return profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final String getProfileArn() {
            return profileArn;
        }

        public final void setProfileArn(String profileArn) {
            this.profileArn = profileArn;
        }

        @Override
        public final Builder profileArn(String profileArn) {
            this.profileArn = profileArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getEmail() {
            return email;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final String getPhone() {
            return phone;
        }

        public final void setPhone(String phone) {
            this.phone = phone;
        }

        @Override
        public final Builder phone(String phone) {
            this.phone = phone;
            return this;
        }

        public final String getBusinessName() {
            return businessName;
        }

        public final void setBusinessName(String businessName) {
            this.businessName = businessName;
        }

        @Override
        public final Builder businessName(String businessName) {
            this.businessName = businessName;
            return this;
        }

        public final String getLogging() {
            return logging;
        }

        public final void setLogging(String logging) {
            this.logging = logging;
        }

        @Override
        public final Builder logging(String logging) {
            this.logging = logging;
            return this;
        }

        @Override
        public final Builder logging(Logging logging) {
            this.logging(logging == null ? null : logging.toString());
            return this;
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        @Override
        public GetProfileResponse build() {
            return new GetProfileResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
