/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the details for a profile. Profiles contain basic information about you and your business.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProfileSummary implements SdkPojo, Serializable, ToCopyableBuilder<ProfileSummary.Builder, ProfileSummary> {
    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("profileId").getter(getter(ProfileSummary::profileId)).setter(setter(Builder::profileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ProfileSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> BUSINESS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("businessName").getter(getter(ProfileSummary::businessName)).setter(setter(Builder::businessName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("businessName").build()).build();

    private static final SdkField<String> LOGGING_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("logging")
            .getter(getter(ProfileSummary::loggingAsString)).setter(setter(Builder::logging))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logging").build()).build();

    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logGroupName").getter(getter(ProfileSummary::logGroupName)).setter(setter(Builder::logGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(ProfileSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("modifiedAt")
            .getter(getter(ProfileSummary::modifiedAt))
            .setter(setter(Builder::modifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_ID_FIELD, NAME_FIELD,
            BUSINESS_NAME_FIELD, LOGGING_FIELD, LOG_GROUP_NAME_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String profileId;

    private final String name;

    private final String businessName;

    private final String logging;

    private final String logGroupName;

    private final Instant createdAt;

    private final Instant modifiedAt;

    private ProfileSummary(BuilderImpl builder) {
        this.profileId = builder.profileId;
        this.name = builder.name;
        this.businessName = builder.businessName;
        this.logging = builder.logging;
        this.logGroupName = builder.logGroupName;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
    }

    /**
     * <p>
     * Returns the unique, system-generated identifier for the profile.
     * </p>
     * 
     * @return Returns the unique, system-generated identifier for the profile.
     */
    public final String profileId() {
        return profileId;
    }

    /**
     * <p>
     * Returns the display name for profile.
     * </p>
     * 
     * @return Returns the display name for profile.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Returns the name for the business associated with this profile.
     * </p>
     * 
     * @return Returns the name for the business associated with this profile.
     */
    public final String businessName() {
        return businessName;
    }

    /**
     * <p>
     * Specifies whether or not logging is enabled for this profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logging} will
     * return {@link Logging#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #loggingAsString}.
     * </p>
     * 
     * @return Specifies whether or not logging is enabled for this profile.
     * @see Logging
     */
    public final Logging logging() {
        return Logging.fromValue(logging);
    }

    /**
     * <p>
     * Specifies whether or not logging is enabled for this profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logging} will
     * return {@link Logging#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #loggingAsString}.
     * </p>
     * 
     * @return Specifies whether or not logging is enabled for this profile.
     * @see Logging
     */
    public final String loggingAsString() {
        return logging;
    }

    /**
     * <p>
     * Returns the name of the logging group.
     * </p>
     * 
     * @return Returns the name of the logging group.
     */
    public final String logGroupName() {
        return logGroupName;
    }

    /**
     * <p>
     * Returns the timestamp for creation date and time of the profile.
     * </p>
     * 
     * @return Returns the timestamp for creation date and time of the profile.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Returns the timestamp that identifies the most recent date and time that the profile was modified.
     * </p>
     * 
     * @return Returns the timestamp that identifies the most recent date and time that the profile was modified.
     */
    public final Instant modifiedAt() {
        return modifiedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(profileId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(businessName());
        hashCode = 31 * hashCode + Objects.hashCode(loggingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProfileSummary)) {
            return false;
        }
        ProfileSummary other = (ProfileSummary) obj;
        return Objects.equals(profileId(), other.profileId()) && Objects.equals(name(), other.name())
                && Objects.equals(businessName(), other.businessName())
                && Objects.equals(loggingAsString(), other.loggingAsString())
                && Objects.equals(logGroupName(), other.logGroupName()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(modifiedAt(), other.modifiedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProfileSummary").add("ProfileId", profileId()).add("Name", name())
                .add("BusinessName", businessName()).add("Logging", loggingAsString()).add("LogGroupName", logGroupName())
                .add("CreatedAt", createdAt()).add("ModifiedAt", modifiedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "profileId":
            return Optional.ofNullable(clazz.cast(profileId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "businessName":
            return Optional.ofNullable(clazz.cast(businessName()));
        case "logging":
            return Optional.ofNullable(clazz.cast(loggingAsString()));
        case "logGroupName":
            return Optional.ofNullable(clazz.cast(logGroupName()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "modifiedAt":
            return Optional.ofNullable(clazz.cast(modifiedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProfileSummary, T> g) {
        return obj -> g.apply((ProfileSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProfileSummary> {
        /**
         * <p>
         * Returns the unique, system-generated identifier for the profile.
         * </p>
         * 
         * @param profileId
         *        Returns the unique, system-generated identifier for the profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileId(String profileId);

        /**
         * <p>
         * Returns the display name for profile.
         * </p>
         * 
         * @param name
         *        Returns the display name for profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Returns the name for the business associated with this profile.
         * </p>
         * 
         * @param businessName
         *        Returns the name for the business associated with this profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder businessName(String businessName);

        /**
         * <p>
         * Specifies whether or not logging is enabled for this profile.
         * </p>
         * 
         * @param logging
         *        Specifies whether or not logging is enabled for this profile.
         * @see Logging
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Logging
         */
        Builder logging(String logging);

        /**
         * <p>
         * Specifies whether or not logging is enabled for this profile.
         * </p>
         * 
         * @param logging
         *        Specifies whether or not logging is enabled for this profile.
         * @see Logging
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Logging
         */
        Builder logging(Logging logging);

        /**
         * <p>
         * Returns the name of the logging group.
         * </p>
         * 
         * @param logGroupName
         *        Returns the name of the logging group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);

        /**
         * <p>
         * Returns the timestamp for creation date and time of the profile.
         * </p>
         * 
         * @param createdAt
         *        Returns the timestamp for creation date and time of the profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Returns the timestamp that identifies the most recent date and time that the profile was modified.
         * </p>
         * 
         * @param modifiedAt
         *        Returns the timestamp that identifies the most recent date and time that the profile was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedAt(Instant modifiedAt);
    }

    static final class BuilderImpl implements Builder {
        private String profileId;

        private String name;

        private String businessName;

        private String logging;

        private String logGroupName;

        private Instant createdAt;

        private Instant modifiedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ProfileSummary model) {
            profileId(model.profileId);
            name(model.name);
            businessName(model.businessName);
            logging(model.logging);
            logGroupName(model.logGroupName);
            createdAt(model.createdAt);
            modifiedAt(model.modifiedAt);
        }

        public final String getProfileId() {
            return profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getBusinessName() {
            return businessName;
        }

        public final void setBusinessName(String businessName) {
            this.businessName = businessName;
        }

        @Override
        public final Builder businessName(String businessName) {
            this.businessName = businessName;
            return this;
        }

        public final String getLogging() {
            return logging;
        }

        public final void setLogging(String logging) {
            this.logging = logging;
        }

        @Override
        public final Builder logging(String logging) {
            this.logging = logging;
            return this;
        }

        @Override
        public final Builder logging(Logging logging) {
            this.logging(logging == null ? null : logging.toString());
            return this;
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        @Override
        public ProfileSummary build() {
            return new ProfileSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
