/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum X12TransactionSet {
    X12_110("X12_110"),
    X12_180("X12_180"),
    X12_204("X12_204"),
    X12_210("X12_210"),
    X12_214("X12_214"),
    X12_215("X12_215"),
    X12_310("X12_310"),
    X12_315("X12_315"),
    X12_322("X12_322"),
    X12_404("X12_404"),
    X12_410("X12_410"),
    X12_820("X12_820"),
    X12_824("X12_824"),
    X12_830("X12_830"),
    X12_846("X12_846"),
    X12_850("X12_850"),
    X12_852("X12_852"),
    X12_855("X12_855"),
    X12_856("X12_856"),
    X12_860("X12_860"),
    X12_861("X12_861"),
    X12_864("X12_864"),
    X12_940("X12_940"),
    X12_990("X12_990"),
    X12_997("X12_997"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, X12TransactionSet> VALUE_MAP;
    private final String value;

    private X12TransactionSet(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static X12TransactionSet fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<X12TransactionSet> knownValues() {
        EnumSet<X12TransactionSet> knownValues = EnumSet.allOf(X12TransactionSet.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(X12TransactionSet.class, X12TransactionSet::toString);
    }
}

