/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum X12TransactionSet {
    X12_110("X12_110"),

    X12_180("X12_180"),

    X12_204("X12_204"),

    X12_210("X12_210"),

    X12_214("X12_214"),

    X12_215("X12_215"),

    X12_310("X12_310"),

    X12_315("X12_315"),

    X12_322("X12_322"),

    X12_404("X12_404"),

    X12_410("X12_410"),

    X12_820("X12_820"),

    X12_824("X12_824"),

    X12_830("X12_830"),

    X12_846("X12_846"),

    X12_850("X12_850"),

    X12_852("X12_852"),

    X12_855("X12_855"),

    X12_856("X12_856"),

    X12_860("X12_860"),

    X12_861("X12_861"),

    X12_864("X12_864"),

    X12_940("X12_940"),

    X12_990("X12_990"),

    X12_997("X12_997"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, X12TransactionSet> VALUE_MAP = EnumUtils.uniqueIndex(X12TransactionSet.class,
            X12TransactionSet::toString);

    private final String value;

    private X12TransactionSet(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return X12TransactionSet corresponding to the value
     */
    public static X12TransactionSet fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link X12TransactionSet}s
     */
    public static Set<X12TransactionSet> knownValues() {
        Set<X12TransactionSet> knownValues = EnumSet.allOf(X12TransactionSet.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
