/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelLegalHoldRequest extends BackupRequest implements
        ToCopyableBuilder<CancelLegalHoldRequest.Builder, CancelLegalHoldRequest> {
    private static final SdkField<String> LEGAL_HOLD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LegalHoldId").getter(getter(CancelLegalHoldRequest::legalHoldId)).setter(setter(Builder::legalHoldId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("legalHoldId").build()).build();

    private static final SdkField<String> CANCEL_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CancelDescription").getter(getter(CancelLegalHoldRequest::cancelDescription))
            .setter(setter(Builder::cancelDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("cancelDescription").build())
            .build();

    private static final SdkField<Long> RETAIN_RECORD_IN_DAYS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("RetainRecordInDays").getter(getter(CancelLegalHoldRequest::retainRecordInDays))
            .setter(setter(Builder::retainRecordInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("retainRecordInDays").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LEGAL_HOLD_ID_FIELD,
            CANCEL_DESCRIPTION_FIELD, RETAIN_RECORD_IN_DAYS_FIELD));

    private final String legalHoldId;

    private final String cancelDescription;

    private final Long retainRecordInDays;

    private CancelLegalHoldRequest(BuilderImpl builder) {
        super(builder);
        this.legalHoldId = builder.legalHoldId;
        this.cancelDescription = builder.cancelDescription;
        this.retainRecordInDays = builder.retainRecordInDays;
    }

    /**
     * <p>
     * Legal hold ID required to remove the specified legal hold on a recovery point.
     * </p>
     * 
     * @return Legal hold ID required to remove the specified legal hold on a recovery point.
     */
    public final String legalHoldId() {
        return legalHoldId;
    }

    /**
     * <p>
     * String describing the reason for removing the legal hold.
     * </p>
     * 
     * @return String describing the reason for removing the legal hold.
     */
    public final String cancelDescription() {
        return cancelDescription;
    }

    /**
     * <p>
     * The integer amount in days specifying amount of days after this API operation to remove legal hold.
     * </p>
     * 
     * @return The integer amount in days specifying amount of days after this API operation to remove legal hold.
     */
    public final Long retainRecordInDays() {
        return retainRecordInDays;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(legalHoldId());
        hashCode = 31 * hashCode + Objects.hashCode(cancelDescription());
        hashCode = 31 * hashCode + Objects.hashCode(retainRecordInDays());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelLegalHoldRequest)) {
            return false;
        }
        CancelLegalHoldRequest other = (CancelLegalHoldRequest) obj;
        return Objects.equals(legalHoldId(), other.legalHoldId())
                && Objects.equals(cancelDescription(), other.cancelDescription())
                && Objects.equals(retainRecordInDays(), other.retainRecordInDays());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CancelLegalHoldRequest").add("LegalHoldId", legalHoldId())
                .add("CancelDescription", cancelDescription()).add("RetainRecordInDays", retainRecordInDays()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LegalHoldId":
            return Optional.ofNullable(clazz.cast(legalHoldId()));
        case "CancelDescription":
            return Optional.ofNullable(clazz.cast(cancelDescription()));
        case "RetainRecordInDays":
            return Optional.ofNullable(clazz.cast(retainRecordInDays()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelLegalHoldRequest, T> g) {
        return obj -> g.apply((CancelLegalHoldRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupRequest.Builder, SdkPojo, CopyableBuilder<Builder, CancelLegalHoldRequest> {
        /**
         * <p>
         * Legal hold ID required to remove the specified legal hold on a recovery point.
         * </p>
         * 
         * @param legalHoldId
         *        Legal hold ID required to remove the specified legal hold on a recovery point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder legalHoldId(String legalHoldId);

        /**
         * <p>
         * String describing the reason for removing the legal hold.
         * </p>
         * 
         * @param cancelDescription
         *        String describing the reason for removing the legal hold.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cancelDescription(String cancelDescription);

        /**
         * <p>
         * The integer amount in days specifying amount of days after this API operation to remove legal hold.
         * </p>
         * 
         * @param retainRecordInDays
         *        The integer amount in days specifying amount of days after this API operation to remove legal hold.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retainRecordInDays(Long retainRecordInDays);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupRequest.BuilderImpl implements Builder {
        private String legalHoldId;

        private String cancelDescription;

        private Long retainRecordInDays;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelLegalHoldRequest model) {
            super(model);
            legalHoldId(model.legalHoldId);
            cancelDescription(model.cancelDescription);
            retainRecordInDays(model.retainRecordInDays);
        }

        public final String getLegalHoldId() {
            return legalHoldId;
        }

        public final void setLegalHoldId(String legalHoldId) {
            this.legalHoldId = legalHoldId;
        }

        @Override
        public final Builder legalHoldId(String legalHoldId) {
            this.legalHoldId = legalHoldId;
            return this;
        }

        public final String getCancelDescription() {
            return cancelDescription;
        }

        public final void setCancelDescription(String cancelDescription) {
            this.cancelDescription = cancelDescription;
        }

        @Override
        public final Builder cancelDescription(String cancelDescription) {
            this.cancelDescription = cancelDescription;
            return this;
        }

        public final Long getRetainRecordInDays() {
            return retainRecordInDays;
        }

        public final void setRetainRecordInDays(Long retainRecordInDays) {
            this.retainRecordInDays = retainRecordInDays;
        }

        @Override
        public final Builder retainRecordInDays(Long retainRecordInDays) {
            this.retainRecordInDays = retainRecordInDays;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CancelLegalHoldRequest build() {
            return new CancelLegalHoldRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
