/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This is a summary of restore jobs created or running within the most recent 30 days.
 * </p>
 * <p>
 * The returned summary may contain the following: Region, Account, State, ResourceType, MessageCategory, StartTime,
 * EndTime, and Count of included jobs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestoreJobSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<RestoreJobSummary.Builder, RestoreJobSummary> {
    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(RestoreJobSummary::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(RestoreJobSummary::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(RestoreJobSummary::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(RestoreJobSummary::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<Integer> COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Count")
            .getter(getter(RestoreJobSummary::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(RestoreJobSummary::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(RestoreJobSummary::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_FIELD,
            ACCOUNT_ID_FIELD, STATE_FIELD, RESOURCE_TYPE_FIELD, COUNT_FIELD, START_TIME_FIELD, END_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String region;

    private final String accountId;

    private final String state;

    private final String resourceType;

    private final Integer count;

    private final Instant startTime;

    private final Instant endTime;

    private RestoreJobSummary(BuilderImpl builder) {
        this.region = builder.region;
        this.accountId = builder.accountId;
        this.state = builder.state;
        this.resourceType = builder.resourceType;
        this.count = builder.count;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    /**
     * <p>
     * The Amazon Web Services Regions within the job summary.
     * </p>
     * 
     * @return The Amazon Web Services Regions within the job summary.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The account ID that owns the jobs within the summary.
     * </p>
     * 
     * @return The account ID that owns the jobs within the summary.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * This value is job count for jobs with the specified state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link RestoreJobState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return This value is job count for jobs with the specified state.
     * @see RestoreJobState
     */
    public final RestoreJobState state() {
        return RestoreJobState.fromValue(state);
    }

    /**
     * <p>
     * This value is job count for jobs with the specified state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link RestoreJobState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return This value is job count for jobs with the specified state.
     * @see RestoreJobState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * This value is the job count for the specified resource type. The request <code>GetSupportedResourceTypes</code>
     * returns strings for supported resource types.
     * </p>
     * 
     * @return This value is the job count for the specified resource type. The request
     *         <code>GetSupportedResourceTypes</code> returns strings for supported resource types.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The value as a number of jobs in a job summary.
     * </p>
     * 
     * @return The value as a number of jobs in a job summary.
     */
    public final Integer count() {
        return count;
    }

    /**
     * <p>
     * The value of time in number format of a job start time.
     * </p>
     * <p>
     * This value is the time in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds. For
     * example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The value of time in number format of a job start time.</p>
     *         <p>
     *         This value is the time in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds.
     *         For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The value of time in number format of a job end time.
     * </p>
     * <p>
     * This value is the time in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds. For
     * example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The value of time in number format of a job end time.</p>
     *         <p>
     *         This value is the time in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds.
     *         For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final Instant endTime() {
        return endTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreJobSummary)) {
            return false;
        }
        RestoreJobSummary other = (RestoreJobSummary) obj;
        return Objects.equals(region(), other.region()) && Objects.equals(accountId(), other.accountId())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(resourceType(), other.resourceType())
                && Objects.equals(count(), other.count()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RestoreJobSummary").add("Region", region()).add("AccountId", accountId())
                .add("State", stateAsString()).add("ResourceType", resourceType()).add("Count", count())
                .add("StartTime", startTime()).add("EndTime", endTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "Count":
            return Optional.ofNullable(clazz.cast(count()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RestoreJobSummary, T> g) {
        return obj -> g.apply((RestoreJobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RestoreJobSummary> {
        /**
         * <p>
         * The Amazon Web Services Regions within the job summary.
         * </p>
         * 
         * @param region
         *        The Amazon Web Services Regions within the job summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The account ID that owns the jobs within the summary.
         * </p>
         * 
         * @param accountId
         *        The account ID that owns the jobs within the summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * This value is job count for jobs with the specified state.
         * </p>
         * 
         * @param state
         *        This value is job count for jobs with the specified state.
         * @see RestoreJobState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RestoreJobState
         */
        Builder state(String state);

        /**
         * <p>
         * This value is job count for jobs with the specified state.
         * </p>
         * 
         * @param state
         *        This value is job count for jobs with the specified state.
         * @see RestoreJobState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RestoreJobState
         */
        Builder state(RestoreJobState state);

        /**
         * <p>
         * This value is the job count for the specified resource type. The request
         * <code>GetSupportedResourceTypes</code> returns strings for supported resource types.
         * </p>
         * 
         * @param resourceType
         *        This value is the job count for the specified resource type. The request
         *        <code>GetSupportedResourceTypes</code> returns strings for supported resource types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The value as a number of jobs in a job summary.
         * </p>
         * 
         * @param count
         *        The value as a number of jobs in a job summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);

        /**
         * <p>
         * The value of time in number format of a job start time.
         * </p>
         * <p>
         * This value is the time in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds. For
         * example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param startTime
         *        The value of time in number format of a job start time.</p>
         *        <p>
         *        This value is the time in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds.
         *        For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The value of time in number format of a job end time.
         * </p>
         * <p>
         * This value is the time in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds. For
         * example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param endTime
         *        The value of time in number format of a job end time.</p>
         *        <p>
         *        This value is the time in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds.
         *        For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);
    }

    static final class BuilderImpl implements Builder {
        private String region;

        private String accountId;

        private String state;

        private String resourceType;

        private Integer count;

        private Instant startTime;

        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreJobSummary model) {
            region(model.region);
            accountId(model.accountId);
            state(model.state);
            resourceType(model.resourceType);
            count(model.count);
            startTime(model.startTime);
            endTime(model.endTime);
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(RestoreJobState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final Integer getCount() {
            return count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        @Override
        public RestoreJobSummary build() {
            return new RestoreJobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
