/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRestoreTestingPlanResponse extends BackupResponse implements
        ToCopyableBuilder<UpdateRestoreTestingPlanResponse.Builder, UpdateRestoreTestingPlanResponse> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(UpdateRestoreTestingPlanResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> RESTORE_TESTING_PLAN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RestoreTestingPlanArn").getter(getter(UpdateRestoreTestingPlanResponse::restoreTestingPlanArn))
            .setter(setter(Builder::restoreTestingPlanArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreTestingPlanArn").build())
            .build();

    private static final SdkField<String> RESTORE_TESTING_PLAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RestoreTestingPlanName").getter(getter(UpdateRestoreTestingPlanResponse::restoreTestingPlanName))
            .setter(setter(Builder::restoreTestingPlanName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreTestingPlanName").build())
            .build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdateTime").getter(getter(UpdateRestoreTestingPlanResponse::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD,
            RESTORE_TESTING_PLAN_ARN_FIELD, RESTORE_TESTING_PLAN_NAME_FIELD, UPDATE_TIME_FIELD));

    private final Instant creationTime;

    private final String restoreTestingPlanArn;

    private final String restoreTestingPlanName;

    private final Instant updateTime;

    private UpdateRestoreTestingPlanResponse(BuilderImpl builder) {
        super(builder);
        this.creationTime = builder.creationTime;
        this.restoreTestingPlanArn = builder.restoreTestingPlanArn;
        this.restoreTestingPlanName = builder.restoreTestingPlanName;
        this.updateTime = builder.updateTime;
    }

    /**
     * <p>
     * This is the time the resource testing plan was created.
     * </p>
     * 
     * @return This is the time the resource testing plan was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * Unique ARN (Amazon Resource Name) of the restore testing plan.
     * </p>
     * 
     * @return Unique ARN (Amazon Resource Name) of the restore testing plan.
     */
    public final String restoreTestingPlanArn() {
        return restoreTestingPlanArn;
    }

    /**
     * <p>
     * The name cannot be changed after creation. The name consists of only alphanumeric characters and underscores.
     * Maximum length is 50.
     * </p>
     * 
     * @return The name cannot be changed after creation. The name consists of only alphanumeric characters and
     *         underscores. Maximum length is 50.
     */
    public final String restoreTestingPlanName() {
        return restoreTestingPlanName;
    }

    /**
     * <p>
     * This is the time the update completed for the restore testing plan.
     * </p>
     * 
     * @return This is the time the update completed for the restore testing plan.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(restoreTestingPlanArn());
        hashCode = 31 * hashCode + Objects.hashCode(restoreTestingPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRestoreTestingPlanResponse)) {
            return false;
        }
        UpdateRestoreTestingPlanResponse other = (UpdateRestoreTestingPlanResponse) obj;
        return Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(restoreTestingPlanArn(), other.restoreTestingPlanArn())
                && Objects.equals(restoreTestingPlanName(), other.restoreTestingPlanName())
                && Objects.equals(updateTime(), other.updateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRestoreTestingPlanResponse").add("CreationTime", creationTime())
                .add("RestoreTestingPlanArn", restoreTestingPlanArn()).add("RestoreTestingPlanName", restoreTestingPlanName())
                .add("UpdateTime", updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "RestoreTestingPlanArn":
            return Optional.ofNullable(clazz.cast(restoreTestingPlanArn()));
        case "RestoreTestingPlanName":
            return Optional.ofNullable(clazz.cast(restoreTestingPlanName()));
        case "UpdateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRestoreTestingPlanResponse, T> g) {
        return obj -> g.apply((UpdateRestoreTestingPlanResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateRestoreTestingPlanResponse> {
        /**
         * <p>
         * This is the time the resource testing plan was created.
         * </p>
         * 
         * @param creationTime
         *        This is the time the resource testing plan was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Unique ARN (Amazon Resource Name) of the restore testing plan.
         * </p>
         * 
         * @param restoreTestingPlanArn
         *        Unique ARN (Amazon Resource Name) of the restore testing plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreTestingPlanArn(String restoreTestingPlanArn);

        /**
         * <p>
         * The name cannot be changed after creation. The name consists of only alphanumeric characters and underscores.
         * Maximum length is 50.
         * </p>
         * 
         * @param restoreTestingPlanName
         *        The name cannot be changed after creation. The name consists of only alphanumeric characters and
         *        underscores. Maximum length is 50.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreTestingPlanName(String restoreTestingPlanName);

        /**
         * <p>
         * This is the time the update completed for the restore testing plan.
         * </p>
         * 
         * @param updateTime
         *        This is the time the update completed for the restore testing plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private Instant creationTime;

        private String restoreTestingPlanArn;

        private String restoreTestingPlanName;

        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRestoreTestingPlanResponse model) {
            super(model);
            creationTime(model.creationTime);
            restoreTestingPlanArn(model.restoreTestingPlanArn);
            restoreTestingPlanName(model.restoreTestingPlanName);
            updateTime(model.updateTime);
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getRestoreTestingPlanArn() {
            return restoreTestingPlanArn;
        }

        public final void setRestoreTestingPlanArn(String restoreTestingPlanArn) {
            this.restoreTestingPlanArn = restoreTestingPlanArn;
        }

        @Override
        public final Builder restoreTestingPlanArn(String restoreTestingPlanArn) {
            this.restoreTestingPlanArn = restoreTestingPlanArn;
            return this;
        }

        public final String getRestoreTestingPlanName() {
            return restoreTestingPlanName;
        }

        public final void setRestoreTestingPlanName(String restoreTestingPlanName) {
            this.restoreTestingPlanName = restoreTestingPlanName;
        }

        @Override
        public final Builder restoreTestingPlanName(String restoreTestingPlanName) {
            this.restoreTestingPlanName = restoreTestingPlanName;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @Override
        public UpdateRestoreTestingPlanResponse build() {
            return new UpdateRestoreTestingPlanResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
