/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupgateway;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.backupgateway.model.AccessDeniedException;
import software.amazon.awssdk.services.backupgateway.model.AssociateGatewayToServerRequest;
import software.amazon.awssdk.services.backupgateway.model.AssociateGatewayToServerResponse;
import software.amazon.awssdk.services.backupgateway.model.BackupGatewayException;
import software.amazon.awssdk.services.backupgateway.model.ConflictException;
import software.amazon.awssdk.services.backupgateway.model.CreateGatewayRequest;
import software.amazon.awssdk.services.backupgateway.model.CreateGatewayResponse;
import software.amazon.awssdk.services.backupgateway.model.DeleteGatewayRequest;
import software.amazon.awssdk.services.backupgateway.model.DeleteGatewayResponse;
import software.amazon.awssdk.services.backupgateway.model.DeleteHypervisorRequest;
import software.amazon.awssdk.services.backupgateway.model.DeleteHypervisorResponse;
import software.amazon.awssdk.services.backupgateway.model.DisassociateGatewayFromServerRequest;
import software.amazon.awssdk.services.backupgateway.model.DisassociateGatewayFromServerResponse;
import software.amazon.awssdk.services.backupgateway.model.GetGatewayRequest;
import software.amazon.awssdk.services.backupgateway.model.GetGatewayResponse;
import software.amazon.awssdk.services.backupgateway.model.GetVirtualMachineRequest;
import software.amazon.awssdk.services.backupgateway.model.GetVirtualMachineResponse;
import software.amazon.awssdk.services.backupgateway.model.ImportHypervisorConfigurationRequest;
import software.amazon.awssdk.services.backupgateway.model.ImportHypervisorConfigurationResponse;
import software.amazon.awssdk.services.backupgateway.model.InternalServerException;
import software.amazon.awssdk.services.backupgateway.model.ListGatewaysRequest;
import software.amazon.awssdk.services.backupgateway.model.ListGatewaysResponse;
import software.amazon.awssdk.services.backupgateway.model.ListHypervisorsRequest;
import software.amazon.awssdk.services.backupgateway.model.ListHypervisorsResponse;
import software.amazon.awssdk.services.backupgateway.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.backupgateway.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.backupgateway.model.ListVirtualMachinesRequest;
import software.amazon.awssdk.services.backupgateway.model.ListVirtualMachinesResponse;
import software.amazon.awssdk.services.backupgateway.model.PutMaintenanceStartTimeRequest;
import software.amazon.awssdk.services.backupgateway.model.PutMaintenanceStartTimeResponse;
import software.amazon.awssdk.services.backupgateway.model.ResourceNotFoundException;
import software.amazon.awssdk.services.backupgateway.model.TagResourceRequest;
import software.amazon.awssdk.services.backupgateway.model.TagResourceResponse;
import software.amazon.awssdk.services.backupgateway.model.TestHypervisorConfigurationRequest;
import software.amazon.awssdk.services.backupgateway.model.TestHypervisorConfigurationResponse;
import software.amazon.awssdk.services.backupgateway.model.ThrottlingException;
import software.amazon.awssdk.services.backupgateway.model.UntagResourceRequest;
import software.amazon.awssdk.services.backupgateway.model.UntagResourceResponse;
import software.amazon.awssdk.services.backupgateway.model.UpdateGatewayInformationRequest;
import software.amazon.awssdk.services.backupgateway.model.UpdateGatewayInformationResponse;
import software.amazon.awssdk.services.backupgateway.model.UpdateGatewaySoftwareNowRequest;
import software.amazon.awssdk.services.backupgateway.model.UpdateGatewaySoftwareNowResponse;
import software.amazon.awssdk.services.backupgateway.model.UpdateHypervisorRequest;
import software.amazon.awssdk.services.backupgateway.model.UpdateHypervisorResponse;
import software.amazon.awssdk.services.backupgateway.model.ValidationException;
import software.amazon.awssdk.services.backupgateway.paginators.ListGatewaysIterable;
import software.amazon.awssdk.services.backupgateway.paginators.ListHypervisorsIterable;
import software.amazon.awssdk.services.backupgateway.paginators.ListVirtualMachinesIterable;

/**
 * Service client for accessing AWS Backup Gateway. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * <fullname>Backup gateway</fullname>
 * <p>
 * Backup gateway connects Backup to your hypervisor, so you can create, store, and restore backups of your virtual
 * machines (VMs) anywhere, whether on-premises or in the VMware Cloud (VMC) on Amazon Web Services.
 * </p>
 * <p>
 * Add on-premises resources by connecting to a hypervisor through a gateway. Backup will automatically discover the
 * resources in your hypervisor.
 * </p>
 * <p>
 * Use Backup to assign virtual or on-premises resources to a backup plan, or run on-demand backups. Once you have
 * backed up your resources, you can view them and restore them like any resource supported by Backup.
 * </p>
 * <p>
 * To download the Amazon Web Services software to get started, navigate to the Backup console, choose <b>Gateways</b>,
 * then choose <b>Create gateway</b>.
 * </p>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface BackupGatewayClient extends SdkClient {
    String SERVICE_NAME = "backup-gateway";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "backup-gateway";

    /**
     * Create a {@link BackupGatewayClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static BackupGatewayClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link BackupGatewayClient}.
     */
    static BackupGatewayClientBuilder builder() {
        return new DefaultBackupGatewayClientBuilder();
    }

    /**
     * <p>
     * Associates a backup gateway with your server. After you complete the association process, you can back up and
     * restore your VMs through the gateway.
     * </p>
     *
     * @param associateGatewayToServerRequest
     * @return Result of the AssociateGatewayToServer operation returned by the service.
     * @throws ValidationException
     *         The operation did not succeed because a validation error occurred.
     * @throws ConflictException
     *         The operation cannot proceed because it is not supported.
     * @throws InternalServerException
     *         The operation did not succeed because an internal error occurred. Try again later.
     * @throws ThrottlingException
     *         TPS has been limited to protect against intentional or unintentional high request volumes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupGatewayClient.AssociateGatewayToServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/AssociateGatewayToServer"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateGatewayToServerResponse associateGatewayToServer(
            AssociateGatewayToServerRequest associateGatewayToServerRequest) throws ValidationException, ConflictException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, BackupGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a backup gateway with your server. After you complete the association process, you can back up and
     * restore your VMs through the gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateGatewayToServerRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateGatewayToServerRequest#builder()}
     * </p>
     *
     * @param associateGatewayToServerRequest
     *        A {@link Consumer} that will call methods on {@link AssociateGatewayToServerInput.Builder} to create a
     *        request.
     * @return Result of the AssociateGatewayToServer operation returned by the service.
     * @throws ValidationException
     *         The operation did not succeed because a validation error occurred.
     * @throws ConflictException
     *         The operation cannot proceed because it is not supported.
     * @throws InternalServerException
     *         The operation did not succeed because an internal error occurred. Try again later.
     * @throws ThrottlingException
     *         TPS has been limited to protect against intentional or unintentional high request volumes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupGatewayClient.AssociateGatewayToServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/AssociateGatewayToServer"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateGatewayToServerResponse associateGatewayToServer(
            Consumer<AssociateGatewayToServerRequest.Builder> associateGatewayToServerRequest) throws ValidationException,
            ConflictException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            BackupGatewayException {
        return associateGatewayToServer(AssociateGatewayToServerRequest.builder().applyMutation(associateGatewayToServerRequest)
                .build());
    }

    /**
     * <p>
     * Creates a backup gateway. After you create a gateway, you can associate it with a server using the
     * <code>AssociateGatewayToServer</code> operation.
     * </p>
     *
     * @param createGatewayRequest
     * @return Result of the CreateGateway operation returned by the service.
     * @throws ValidationException
     *         The operation did not succeed because a validation error occurred.
     * @throws InternalServerException
     *         The operation did not succeed because an internal error occurred. Try again later.
     * @throws ThrottlingException
     *         TPS has been limited to protect against intentional or unintentional high request volumes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupGatewayClient.CreateGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/CreateGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateGatewayResponse createGateway(CreateGatewayRequest createGatewayRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, BackupGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a backup gateway. After you create a gateway, you can associate it with a server using the
     * <code>AssociateGatewayToServer</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGatewayRequest.Builder} avoiding the need to
     * create one manually via {@link CreateGatewayRequest#builder()}
     * </p>
     *
     * @param createGatewayRequest
     *        A {@link Consumer} that will call methods on {@link CreateGatewayInput.Builder} to create a request.
     * @return Result of the CreateGateway operation returned by the service.
     * @throws ValidationException
     *         The operation did not succeed because a validation error occurred.
     * @throws InternalServerException
     *         The operation did not succeed because an internal error occurred. Try again later.
     * @throws ThrottlingException
     *         TPS has been limited to protect against intentional or unintentional high request volumes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupGatewayClient.CreateGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/CreateGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateGatewayResponse createGateway(Consumer<CreateGatewayRequest.Builder> createGatewayRequest)
            throws ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            BackupGatewayException {
        return createGateway(CreateGatewayRequest.builder().applyMutation(createGatewayRequest).build());
    }

    /**
     * <p>
     * Deletes a backup gateway.
     * </p>
     *
     * @param deleteGatewayRequest
     * @return Result of the DeleteGateway operation returned by the service.
     * @throws ValidationException
     *         The operation did not succeed because a validation error occurred.
     * @throws InternalServerException
     *         The operation did not succeed because an internal error occurred. Try again later.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action wasn't found.
     * @throws ThrottlingException
     *         TPS has been limited to protect against intentional or unintentional high request volumes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupGatewayClient.DeleteGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/DeleteGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteGatewayResponse deleteGateway(DeleteGatewayRequest deleteGatewayRequest) throws ValidationException,
            InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            BackupGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a backup gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGatewayRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteGatewayRequest#builder()}
     * </p>
     *
     * @param deleteGatewayRequest
     *        A {@link Consumer} that will call methods on {@link DeleteGatewayInput.Builder} to create a request.
     * @return Result of the DeleteGateway operation returned by the service.
     * @throws ValidationException
     *         The operation did not succeed because a validation error occurred.
     * @throws InternalServerException
     *         The operation did not succeed because an internal error occurred. Try again later.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action wasn't found.
     * @throws ThrottlingException
     *         TPS has been limited to protect against intentional or unintentional high request volumes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupGatewayClient.DeleteGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/DeleteGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteGatewayResponse deleteGateway(Consumer<DeleteGatewayRequest.Builder> deleteGatewayRequest)
            throws ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, BackupGatewayException {
        return deleteGateway(DeleteGatewayRequest.builder().applyMutation(deleteGatewayRequest).build());
    }

    /**
     * <p>
     * Deletes a hypervisor.
     * </p>
     *
     * @param deleteHypervisorRequest
     * @return Result of the DeleteHypervisor operation returned by the service.
     * @throws ValidationException
     *         The operation did not succeed because a validation error occurred.
     * @throws InternalServerException
     *         The operation did not succeed because an internal error occurred. Try again later.
     * @throws AccessDeniedException
     *         The operation cannot proceed because you have insufficient permissions.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action wasn't found.
     * @throws ThrottlingException
     *         TPS has been limited to protect against intentional or unintentional high request volumes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupGatewayClient.DeleteHypervisor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/DeleteHypervisor"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteHypervisorResponse deleteHypervisor(DeleteHypervisorRequest deleteHypervisorRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, BackupGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a hypervisor.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteHypervisorRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteHypervisorRequest#builder()}
     * </p>
     *
     * @param deleteHypervisorRequest
     *        A {@link Consumer} that will call methods on {@link DeleteHypervisorInput.Builder} to create a request.
     * @return Result of the DeleteHypervisor operation returned by the service.
     * @throws ValidationException
     *         The operation did not succeed because a validation error occurred.
     * @throws InternalServerException
     *         The operation did not succeed because an internal error occurred. Try again later.
     * @throws AccessDeniedException
     *         The operation cannot proceed because you have insufficient permissions.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action wasn't found.
     * @throws ThrottlingException
     *         TPS has been limited to protect against intentional or unintentional high request volumes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupGatewayClient.DeleteHypervisor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/DeleteHypervisor"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteHypervisorResponse deleteHypervisor(Consumer<DeleteHypervisorRequest.Builder> deleteHypervisorRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, BackupGatewayException {
        return deleteHypervisor(DeleteHypervisorRequest.builder().applyMutation(deleteHypervisorRequest).build());
    }

    /**
     * <p>
     * Disassociates a backup gateway from the specified server. After the disassociation process finishes, the gateway
     * can no longer access the virtual machines on the server.
     * </p>
     *
     * @param disassociateGatewayFromServerRequest
     * @return Result of the DisassociateGatewayFromServer operation returned by the service.
     * @throws ValidationException
     *         The operation did not succeed because a validation error occurred.
     * @throws ConflictException
     *         The operation cannot proceed because it is not supported.
     * @throws InternalServerException
     *         The operation did not succeed because an internal error occurred. Try again later.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action wasn't found.
     * @throws ThrottlingException
     *         TPS has been limited to protect against intentional or unintentional high request volumes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupGatewayClient.DisassociateGatewayFromServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/DisassociateGatewayFromServer"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateGatewayFromServerResponse disassociateGatewayFromServer(
            DisassociateGatewayFromServerRequest disassociateGatewayFromServerRequest) throws ValidationException,
            ConflictException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, BackupGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a backup gateway from the specified server. After the disassociation process finishes, the gateway
     * can no longer access the virtual machines on the server.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateGatewayFromServerRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateGatewayFromServerRequest#builder()}
     * </p>
     *
     * @param disassociateGatewayFromServerRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateGatewayFromServerInput.Builder} to create
     *        a request.
     * @return Result of the DisassociateGatewayFromServer operation returned by the service.
     * @throws ValidationException
     *         The operation did not succeed because a validation error occurred.
     * @throws ConflictException
     *         The operation cannot proceed because it is not supported.
     * @throws InternalServerException
     *         The operation did not succeed because an internal error occurred. Try again later.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action wasn't found.
     * @throws ThrottlingException
     *         TPS has been limited to protect against intentional or unintentional high request volumes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupGatewayClient.DisassociateGatewayFromServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/DisassociateGatewayFromServer"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateGatewayFromServerResponse disassociateGatewayFromServer(
            Consumer<DisassociateGatewayFromServerRequest.Builder> disassociateGatewayFromServerRequest)
            throws ValidationException, ConflictException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, BackupGatewayException {
        return disassociateGatewayFromServer(DisassociateGatewayFromServerRequest.builder()
                .applyMutation(disassociateGatewayFromServerRequest).build());
    }

    /**
     * <p>
     * By providing the ARN (Amazon Resource Name), this API returns the gateway.
     * </p>
     *
     * @param getGatewayRequest
     * @return Result of the GetGateway operation returned by the service.
     * @throws ValidationException
     *         The operation did not succeed because a validation error occurred.
     * @throws InternalServerException
     *         The operation did not succeed because an internal error occurred. Try again later.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action wasn't found.
     * @throws ThrottlingException
     *         TPS has been limited to protect against intentional or unintentional high request volumes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupGatewayClient.GetGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/GetGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default GetGatewayResponse getGateway(GetGatewayRequest getGatewayRequest) throws ValidationException,
            InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            BackupGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * By providing the ARN (Amazon Resource Name), this API returns the gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGatewayRequest.Builder} avoiding the need to
     * create one manually via {@link GetGatewayRequest#builder()}
     * </p>
     *
     * @param getGatewayRequest
     *        A {@link Consumer} that will call methods on {@link GetGatewayInput.Builder} to create a request.
     * @return Result of the GetGateway operation returned by the service.
     * @throws ValidationException
     *         The operation did not succeed because a validation error occurred.
     * @throws InternalServerException
     *         The operation did not succeed because an internal error occurred. Try again later.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action wasn't found.
     * @throws ThrottlingException
     *         TPS has been limited to protect against intentional or unintentional high request volumes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupGatewayClient.GetGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/GetGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default GetGatewayResponse getGateway(Consumer<GetGatewayRequest.Builder> getGatewayRequest) throws ValidationException,
            InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            BackupGatewayException {
        return getGateway(GetGatewayRequest.builder().applyMutation(getGatewayRequest).build());
    }

    /**
     * <p>
     * By providing the ARN (Amazon Resource Name), this API returns the virtual machine.
     * </p>
     *
     * @param getVirtualMachineRequest
     * @return Result of the GetVirtualMachine operation returned by the service.
     * @throws ValidationException
     *         The operation did not succeed because a validation error occurred.
     * @throws InternalServerException
     *         The operation did not succeed because an internal error occurred. Try again later.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action wasn't found.
     * @throws ThrottlingException
     *         TPS has been limited to protect against intentional or unintentional high request volumes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupGatewayClient.GetVirtualMachine
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/GetVirtualMachine"
     *      target="_top">AWS API Documentation</a>
     */
    default GetVirtualMachineResponse getVirtualMachine(GetVirtualMachineRequest getVirtualMachineRequest)
            throws ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, BackupGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * By providing the ARN (Amazon Resource Name), this API returns the virtual machine.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVirtualMachineRequest.Builder} avoiding the need
     * to create one manually via {@link GetVirtualMachineRequest#builder()}
     * </p>
     *
     * @param getVirtualMachineRequest
     *        A {@link Consumer} that will call methods on {@link GetVirtualMachineInput.Builder} to create a request.
     * @return Result of the GetVirtualMachine operation returned by the service.
     * @throws ValidationException
     *         The operation did not succeed because a validation error occurred.
     * @throws InternalServerException
     *         The operation did not succeed because an internal error occurred. Try again later.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action wasn't found.
     * @throws ThrottlingException
     *         TPS has been limited to protect against intentional or unintentional high request volumes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupGatewayClient.GetVirtualMachine
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/GetVirtualMachine"
     *      target="_top">AWS API Documentation</a>
     */
    default GetVirtualMachineResponse getVirtualMachine(Consumer<GetVirtualMachineRequest.Builder> getVirtualMachineRequest)
            throws ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, BackupGatewayException {
        return getVirtualMachine(GetVirtualMachineRequest.builder().applyMutation(getVirtualMachineRequest).build());
    }

    /**
     * <p>
     * Connect to a hypervisor by importing its configuration.
     * </p>
     *
     * @param importHypervisorConfigurationRequest
     * @return Result of the ImportHypervisorConfiguration operation returned by the service.
     * @throws ValidationException
     *         The operation did not succeed because a validation error occurred.
     * @throws InternalServerException
     *         The operation did not succeed because an internal error occurred. Try again later.
     * @throws AccessDeniedException
     *         The operation cannot proceed because you have insufficient permissions.
     * @throws ThrottlingException
     *         TPS has been limited to protect against intentional or unintentional high request volumes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupGatewayClient.ImportHypervisorConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/ImportHypervisorConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default ImportHypervisorConfigurationResponse importHypervisorConfiguration(
            ImportHypervisorConfigurationRequest importHypervisorConfigurationRequest) throws ValidationException,
            InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            BackupGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Connect to a hypervisor by importing its configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportHypervisorConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link ImportHypervisorConfigurationRequest#builder()}
     * </p>
     *
     * @param importHypervisorConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link ImportHypervisorConfigurationInput.Builder} to create
     *        a request.
     * @return Result of the ImportHypervisorConfiguration operation returned by the service.
     * @throws ValidationException
     *         The operation did not succeed because a validation error occurred.
     * @throws InternalServerException
     *         The operation did not succeed because an internal error occurred. Try again later.
     * @throws AccessDeniedException
     *         The operation cannot proceed because you have insufficient permissions.
     * @throws ThrottlingException
     *         TPS has been limited to protect against intentional or unintentional high request volumes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupGatewayClient.ImportHypervisorConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/ImportHypervisorConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default ImportHypervisorConfigurationResponse importHypervisorConfiguration(
            Consumer<ImportHypervisorConfigurationRequest.Builder> importHypervisorConfigurationRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, BackupGatewayException {
        return importHypervisorConfiguration(ImportHypervisorConfigurationRequest.builder()
                .applyMutation(importHypervisorConfigurationRequest).build());
    }

    /**
     * <p>
     * Lists backup gateways owned by an Amazon Web Services account in an Amazon Web Services Region. The returned list
     * is ordered by gateway Amazon Resource Name (ARN).
     * </p>
     *
     * @param listGatewaysRequest
     * @return Result of the ListGateways operation returned by the service.
     * @throws ValidationException
     *         The operation did not succeed because a validation error occurred.
     * @throws InternalServerException
     *         The operation did not succeed because an internal error occurred. Try again later.
     * @throws ThrottlingException
     *         TPS has been limited to protect against intentional or unintentional high request volumes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupGatewayClient.ListGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/ListGateways" target="_top">AWS
     *      API Documentation</a>
     */
    default ListGatewaysResponse listGateways(ListGatewaysRequest listGatewaysRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, BackupGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists backup gateways owned by an Amazon Web Services account in an Amazon Web Services Region. The returned list
     * is ordered by gateway Amazon Resource Name (ARN).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGatewaysRequest.Builder} avoiding the need to
     * create one manually via {@link ListGatewaysRequest#builder()}
     * </p>
     *
     * @param listGatewaysRequest
     *        A {@link Consumer} that will call methods on {@link ListGatewaysInput.Builder} to create a request.
     * @return Result of the ListGateways operation returned by the service.
     * @throws ValidationException
     *         The operation did not succeed because a validation error occurred.
     * @throws InternalServerException
     *         The operation did not succeed because an internal error occurred. Try again later.
     * @throws ThrottlingException
     *         TPS has been limited to protect against intentional or unintentional high request volumes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupGatewayClient.ListGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/ListGateways" target="_top">AWS
     *      API Documentation</a>
     */
    default ListGatewaysResponse listGateways(Consumer<ListGatewaysRequest.Builder> listGatewaysRequest)
            throws ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            BackupGatewayException {
        return listGateways(ListGatewaysRequest.builder().applyMutation(listGatewaysRequest).build());
    }

    /**
     * <p>
     * Lists backup gateways owned by an Amazon Web Services account in an Amazon Web Services Region. The returned list
     * is ordered by gateway Amazon Resource Name (ARN).
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGateways(software.amazon.awssdk.services.backupgateway.model.ListGatewaysRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backupgateway.paginators.ListGatewaysIterable responses = client.listGatewaysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backupgateway.paginators.ListGatewaysIterable responses = client
     *             .listGatewaysPaginator(request);
     *     for (software.amazon.awssdk.services.backupgateway.model.ListGatewaysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backupgateway.paginators.ListGatewaysIterable responses = client.listGatewaysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGateways(software.amazon.awssdk.services.backupgateway.model.ListGatewaysRequest)} operation.</b>
     * </p>
     *
     * @param listGatewaysRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The operation did not succeed because a validation error occurred.
     * @throws InternalServerException
     *         The operation did not succeed because an internal error occurred. Try again later.
     * @throws ThrottlingException
     *         TPS has been limited to protect against intentional or unintentional high request volumes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupGatewayClient.ListGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/ListGateways" target="_top">AWS
     *      API Documentation</a>
     */
    default ListGatewaysIterable listGatewaysPaginator(ListGatewaysRequest listGatewaysRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, BackupGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists backup gateways owned by an Amazon Web Services account in an Amazon Web Services Region. The returned list
     * is ordered by gateway Amazon Resource Name (ARN).
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGateways(software.amazon.awssdk.services.backupgateway.model.ListGatewaysRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backupgateway.paginators.ListGatewaysIterable responses = client.listGatewaysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backupgateway.paginators.ListGatewaysIterable responses = client
     *             .listGatewaysPaginator(request);
     *     for (software.amazon.awssdk.services.backupgateway.model.ListGatewaysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backupgateway.paginators.ListGatewaysIterable responses = client.listGatewaysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGateways(software.amazon.awssdk.services.backupgateway.model.ListGatewaysRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGatewaysRequest.Builder} avoiding the need to
     * create one manually via {@link ListGatewaysRequest#builder()}
     * </p>
     *
     * @param listGatewaysRequest
     *        A {@link Consumer} that will call methods on {@link ListGatewaysInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The operation did not succeed because a validation error occurred.
     * @throws InternalServerException
     *         The operation did not succeed because an internal error occurred. Try again later.
     * @throws ThrottlingException
     *         TPS has been limited to protect against intentional or unintentional high request volumes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupGatewayClient.ListGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/ListGateways" target="_top">AWS
     *      API Documentation</a>
     */
    default ListGatewaysIterable listGatewaysPaginator(Consumer<ListGatewaysRequest.Builder> listGatewaysRequest)
            throws ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            BackupGatewayException {
        return listGatewaysPaginator(ListGatewaysRequest.builder().applyMutation(listGatewaysRequest).build());
    }

    /**
     * <p>
     * Lists your hypervisors.
     * </p>
     *
     * @param listHypervisorsRequest
     * @return Result of the ListHypervisors operation returned by the service.
     * @throws ValidationException
     *         The operation did not succeed because a validation error occurred.
     * @throws InternalServerException
     *         The operation did not succeed because an internal error occurred. Try again later.
     * @throws ThrottlingException
     *         TPS has been limited to protect against intentional or unintentional high request volumes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupGatewayClient.ListHypervisors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/ListHypervisors"
     *      target="_top">AWS API Documentation</a>
     */
    default ListHypervisorsResponse listHypervisors(ListHypervisorsRequest listHypervisorsRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, BackupGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists your hypervisors.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListHypervisorsRequest.Builder} avoiding the need
     * to create one manually via {@link ListHypervisorsRequest#builder()}
     * </p>
     *
     * @param listHypervisorsRequest
     *        A {@link Consumer} that will call methods on {@link ListHypervisorsInput.Builder} to create a request.
     * @return Result of the ListHypervisors operation returned by the service.
     * @throws ValidationException
     *         The operation did not succeed because a validation error occurred.
     * @throws InternalServerException
     *         The operation did not succeed because an internal error occurred. Try again later.
     * @throws ThrottlingException
     *         TPS has been limited to protect against intentional or unintentional high request volumes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupGatewayClient.ListHypervisors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/ListHypervisors"
     *      target="_top">AWS API Documentation</a>
     */
    default ListHypervisorsResponse listHypervisors(Consumer<ListHypervisorsRequest.Builder> listHypervisorsRequest)
            throws ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            BackupGatewayException {
        return listHypervisors(ListHypervisorsRequest.builder().applyMutation(listHypervisorsRequest).build());
    }

    /**
     * <p>
     * Lists your hypervisors.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listHypervisors(software.amazon.awssdk.services.backupgateway.model.ListHypervisorsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backupgateway.paginators.ListHypervisorsIterable responses = client.listHypervisorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backupgateway.paginators.ListHypervisorsIterable responses = client
     *             .listHypervisorsPaginator(request);
     *     for (software.amazon.awssdk.services.backupgateway.model.ListHypervisorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backupgateway.paginators.ListHypervisorsIterable responses = client.listHypervisorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listHypervisors(software.amazon.awssdk.services.backupgateway.model.ListHypervisorsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listHypervisorsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The operation did not succeed because a validation error occurred.
     * @throws InternalServerException
     *         The operation did not succeed because an internal error occurred. Try again later.
     * @throws ThrottlingException
     *         TPS has been limited to protect against intentional or unintentional high request volumes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupGatewayClient.ListHypervisors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/ListHypervisors"
     *      target="_top">AWS API Documentation</a>
     */
    default ListHypervisorsIterable listHypervisorsPaginator(ListHypervisorsRequest listHypervisorsRequest)
            throws ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            BackupGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists your hypervisors.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listHypervisors(software.amazon.awssdk.services.backupgateway.model.ListHypervisorsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backupgateway.paginators.ListHypervisorsIterable responses = client.listHypervisorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backupgateway.paginators.ListHypervisorsIterable responses = client
     *             .listHypervisorsPaginator(request);
     *     for (software.amazon.awssdk.services.backupgateway.model.ListHypervisorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backupgateway.paginators.ListHypervisorsIterable responses = client.listHypervisorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listHypervisors(software.amazon.awssdk.services.backupgateway.model.ListHypervisorsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListHypervisorsRequest.Builder} avoiding the need
     * to create one manually via {@link ListHypervisorsRequest#builder()}
     * </p>
     *
     * @param listHypervisorsRequest
     *        A {@link Consumer} that will call methods on {@link ListHypervisorsInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The operation did not succeed because a validation error occurred.
     * @throws InternalServerException
     *         The operation did not succeed because an internal error occurred. Try again later.
     * @throws ThrottlingException
     *         TPS has been limited to protect against intentional or unintentional high request volumes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupGatewayClient.ListHypervisors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/ListHypervisors"
     *      target="_top">AWS API Documentation</a>
     */
    default ListHypervisorsIterable listHypervisorsPaginator(Consumer<ListHypervisorsRequest.Builder> listHypervisorsRequest)
            throws ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            BackupGatewayException {
        return listHypervisorsPaginator(ListHypervisorsRequest.builder().applyMutation(listHypervisorsRequest).build());
    }

    /**
     * <p>
     * Lists the tags applied to the resource identified by its Amazon Resource Name (ARN).
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         The operation did not succeed because a validation error occurred.
     * @throws InternalServerException
     *         The operation did not succeed because an internal error occurred. Try again later.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action wasn't found.
     * @throws ThrottlingException
     *         TPS has been limited to protect against intentional or unintentional high request volumes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupGatewayClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, BackupGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags applied to the resource identified by its Amazon Resource Name (ARN).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceInput.Builder} to create a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         The operation did not succeed because a validation error occurred.
     * @throws InternalServerException
     *         The operation did not succeed because an internal error occurred. Try again later.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action wasn't found.
     * @throws ThrottlingException
     *         TPS has been limited to protect against intentional or unintentional high request volumes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupGatewayClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ValidationException,
            InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            BackupGatewayException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists your virtual machines.
     * </p>
     *
     * @param listVirtualMachinesRequest
     * @return Result of the ListVirtualMachines operation returned by the service.
     * @throws ValidationException
     *         The operation did not succeed because a validation error occurred.
     * @throws InternalServerException
     *         The operation did not succeed because an internal error occurred. Try again later.
     * @throws ThrottlingException
     *         TPS has been limited to protect against intentional or unintentional high request volumes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupGatewayClient.ListVirtualMachines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/ListVirtualMachines"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVirtualMachinesResponse listVirtualMachines(ListVirtualMachinesRequest listVirtualMachinesRequest)
            throws ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            BackupGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists your virtual machines.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVirtualMachinesRequest.Builder} avoiding the
     * need to create one manually via {@link ListVirtualMachinesRequest#builder()}
     * </p>
     *
     * @param listVirtualMachinesRequest
     *        A {@link Consumer} that will call methods on {@link ListVirtualMachinesInput.Builder} to create a request.
     * @return Result of the ListVirtualMachines operation returned by the service.
     * @throws ValidationException
     *         The operation did not succeed because a validation error occurred.
     * @throws InternalServerException
     *         The operation did not succeed because an internal error occurred. Try again later.
     * @throws ThrottlingException
     *         TPS has been limited to protect against intentional or unintentional high request volumes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupGatewayClient.ListVirtualMachines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/ListVirtualMachines"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVirtualMachinesResponse listVirtualMachines(
            Consumer<ListVirtualMachinesRequest.Builder> listVirtualMachinesRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, BackupGatewayException {
        return listVirtualMachines(ListVirtualMachinesRequest.builder().applyMutation(listVirtualMachinesRequest).build());
    }

    /**
     * <p>
     * Lists your virtual machines.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVirtualMachines(software.amazon.awssdk.services.backupgateway.model.ListVirtualMachinesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backupgateway.paginators.ListVirtualMachinesIterable responses = client.listVirtualMachinesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backupgateway.paginators.ListVirtualMachinesIterable responses = client
     *             .listVirtualMachinesPaginator(request);
     *     for (software.amazon.awssdk.services.backupgateway.model.ListVirtualMachinesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backupgateway.paginators.ListVirtualMachinesIterable responses = client.listVirtualMachinesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVirtualMachines(software.amazon.awssdk.services.backupgateway.model.ListVirtualMachinesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listVirtualMachinesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The operation did not succeed because a validation error occurred.
     * @throws InternalServerException
     *         The operation did not succeed because an internal error occurred. Try again later.
     * @throws ThrottlingException
     *         TPS has been limited to protect against intentional or unintentional high request volumes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupGatewayClient.ListVirtualMachines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/ListVirtualMachines"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVirtualMachinesIterable listVirtualMachinesPaginator(ListVirtualMachinesRequest listVirtualMachinesRequest)
            throws ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            BackupGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists your virtual machines.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVirtualMachines(software.amazon.awssdk.services.backupgateway.model.ListVirtualMachinesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backupgateway.paginators.ListVirtualMachinesIterable responses = client.listVirtualMachinesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backupgateway.paginators.ListVirtualMachinesIterable responses = client
     *             .listVirtualMachinesPaginator(request);
     *     for (software.amazon.awssdk.services.backupgateway.model.ListVirtualMachinesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backupgateway.paginators.ListVirtualMachinesIterable responses = client.listVirtualMachinesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVirtualMachines(software.amazon.awssdk.services.backupgateway.model.ListVirtualMachinesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVirtualMachinesRequest.Builder} avoiding the
     * need to create one manually via {@link ListVirtualMachinesRequest#builder()}
     * </p>
     *
     * @param listVirtualMachinesRequest
     *        A {@link Consumer} that will call methods on {@link ListVirtualMachinesInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The operation did not succeed because a validation error occurred.
     * @throws InternalServerException
     *         The operation did not succeed because an internal error occurred. Try again later.
     * @throws ThrottlingException
     *         TPS has been limited to protect against intentional or unintentional high request volumes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupGatewayClient.ListVirtualMachines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/ListVirtualMachines"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVirtualMachinesIterable listVirtualMachinesPaginator(
            Consumer<ListVirtualMachinesRequest.Builder> listVirtualMachinesRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, BackupGatewayException {
        return listVirtualMachinesPaginator(ListVirtualMachinesRequest.builder().applyMutation(listVirtualMachinesRequest)
                .build());
    }

    /**
     * <p>
     * Set the maintenance start time for a gateway.
     * </p>
     *
     * @param putMaintenanceStartTimeRequest
     * @return Result of the PutMaintenanceStartTime operation returned by the service.
     * @throws ValidationException
     *         The operation did not succeed because a validation error occurred.
     * @throws ConflictException
     *         The operation cannot proceed because it is not supported.
     * @throws InternalServerException
     *         The operation did not succeed because an internal error occurred. Try again later.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action wasn't found.
     * @throws ThrottlingException
     *         TPS has been limited to protect against intentional or unintentional high request volumes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupGatewayClient.PutMaintenanceStartTime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/PutMaintenanceStartTime"
     *      target="_top">AWS API Documentation</a>
     */
    default PutMaintenanceStartTimeResponse putMaintenanceStartTime(PutMaintenanceStartTimeRequest putMaintenanceStartTimeRequest)
            throws ValidationException, ConflictException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, BackupGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Set the maintenance start time for a gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutMaintenanceStartTimeRequest.Builder} avoiding
     * the need to create one manually via {@link PutMaintenanceStartTimeRequest#builder()}
     * </p>
     *
     * @param putMaintenanceStartTimeRequest
     *        A {@link Consumer} that will call methods on {@link PutMaintenanceStartTimeInput.Builder} to create a
     *        request.
     * @return Result of the PutMaintenanceStartTime operation returned by the service.
     * @throws ValidationException
     *         The operation did not succeed because a validation error occurred.
     * @throws ConflictException
     *         The operation cannot proceed because it is not supported.
     * @throws InternalServerException
     *         The operation did not succeed because an internal error occurred. Try again later.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action wasn't found.
     * @throws ThrottlingException
     *         TPS has been limited to protect against intentional or unintentional high request volumes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupGatewayClient.PutMaintenanceStartTime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/PutMaintenanceStartTime"
     *      target="_top">AWS API Documentation</a>
     */
    default PutMaintenanceStartTimeResponse putMaintenanceStartTime(
            Consumer<PutMaintenanceStartTimeRequest.Builder> putMaintenanceStartTimeRequest) throws ValidationException,
            ConflictException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, BackupGatewayException {
        return putMaintenanceStartTime(PutMaintenanceStartTimeRequest.builder().applyMutation(putMaintenanceStartTimeRequest)
                .build());
    }

    /**
     * <p>
     * Tag the resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         The operation did not succeed because a validation error occurred.
     * @throws InternalServerException
     *         The operation did not succeed because an internal error occurred. Try again later.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action wasn't found.
     * @throws ThrottlingException
     *         TPS has been limited to protect against intentional or unintentional high request volumes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupGatewayClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException,
            InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            BackupGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tag the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceInput.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         The operation did not succeed because a validation error occurred.
     * @throws InternalServerException
     *         The operation did not succeed because an internal error occurred. Try again later.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action wasn't found.
     * @throws ThrottlingException
     *         TPS has been limited to protect against intentional or unintentional high request volumes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupGatewayClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ValidationException,
            InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            BackupGatewayException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Tests your hypervisor configuration to validate that backup gateway can connect with the hypervisor and its
     * resources.
     * </p>
     *
     * @param testHypervisorConfigurationRequest
     * @return Result of the TestHypervisorConfiguration operation returned by the service.
     * @throws ValidationException
     *         The operation did not succeed because a validation error occurred.
     * @throws ConflictException
     *         The operation cannot proceed because it is not supported.
     * @throws InternalServerException
     *         The operation did not succeed because an internal error occurred. Try again later.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action wasn't found.
     * @throws ThrottlingException
     *         TPS has been limited to protect against intentional or unintentional high request volumes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupGatewayClient.TestHypervisorConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/TestHypervisorConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default TestHypervisorConfigurationResponse testHypervisorConfiguration(
            TestHypervisorConfigurationRequest testHypervisorConfigurationRequest) throws ValidationException, ConflictException,
            InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            BackupGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tests your hypervisor configuration to validate that backup gateway can connect with the hypervisor and its
     * resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TestHypervisorConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link TestHypervisorConfigurationRequest#builder()}
     * </p>
     *
     * @param testHypervisorConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link TestHypervisorConfigurationInput.Builder} to create a
     *        request.
     * @return Result of the TestHypervisorConfiguration operation returned by the service.
     * @throws ValidationException
     *         The operation did not succeed because a validation error occurred.
     * @throws ConflictException
     *         The operation cannot proceed because it is not supported.
     * @throws InternalServerException
     *         The operation did not succeed because an internal error occurred. Try again later.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action wasn't found.
     * @throws ThrottlingException
     *         TPS has been limited to protect against intentional or unintentional high request volumes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupGatewayClient.TestHypervisorConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/TestHypervisorConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default TestHypervisorConfigurationResponse testHypervisorConfiguration(
            Consumer<TestHypervisorConfigurationRequest.Builder> testHypervisorConfigurationRequest) throws ValidationException,
            ConflictException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, BackupGatewayException {
        return testHypervisorConfiguration(TestHypervisorConfigurationRequest.builder()
                .applyMutation(testHypervisorConfigurationRequest).build());
    }

    /**
     * <p>
     * Removes tags from the resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The operation did not succeed because a validation error occurred.
     * @throws InternalServerException
     *         The operation did not succeed because an internal error occurred. Try again later.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action wasn't found.
     * @throws ThrottlingException
     *         TPS has been limited to protect against intentional or unintentional high request volumes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupGatewayClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException,
            InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            BackupGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceInput.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The operation did not succeed because a validation error occurred.
     * @throws InternalServerException
     *         The operation did not succeed because an internal error occurred. Try again later.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action wasn't found.
     * @throws ThrottlingException
     *         TPS has been limited to protect against intentional or unintentional high request volumes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupGatewayClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, BackupGatewayException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates a gateway's name. Specify which gateway to update using the Amazon Resource Name (ARN) of the gateway in
     * your request.
     * </p>
     *
     * @param updateGatewayInformationRequest
     * @return Result of the UpdateGatewayInformation operation returned by the service.
     * @throws ValidationException
     *         The operation did not succeed because a validation error occurred.
     * @throws ConflictException
     *         The operation cannot proceed because it is not supported.
     * @throws InternalServerException
     *         The operation did not succeed because an internal error occurred. Try again later.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action wasn't found.
     * @throws ThrottlingException
     *         TPS has been limited to protect against intentional or unintentional high request volumes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupGatewayClient.UpdateGatewayInformation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/UpdateGatewayInformation"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateGatewayInformationResponse updateGatewayInformation(
            UpdateGatewayInformationRequest updateGatewayInformationRequest) throws ValidationException, ConflictException,
            InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            BackupGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a gateway's name. Specify which gateway to update using the Amazon Resource Name (ARN) of the gateway in
     * your request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGatewayInformationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateGatewayInformationRequest#builder()}
     * </p>
     *
     * @param updateGatewayInformationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateGatewayInformationInput.Builder} to create a
     *        request.
     * @return Result of the UpdateGatewayInformation operation returned by the service.
     * @throws ValidationException
     *         The operation did not succeed because a validation error occurred.
     * @throws ConflictException
     *         The operation cannot proceed because it is not supported.
     * @throws InternalServerException
     *         The operation did not succeed because an internal error occurred. Try again later.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action wasn't found.
     * @throws ThrottlingException
     *         TPS has been limited to protect against intentional or unintentional high request volumes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupGatewayClient.UpdateGatewayInformation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/UpdateGatewayInformation"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateGatewayInformationResponse updateGatewayInformation(
            Consumer<UpdateGatewayInformationRequest.Builder> updateGatewayInformationRequest) throws ValidationException,
            ConflictException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, BackupGatewayException {
        return updateGatewayInformation(UpdateGatewayInformationRequest.builder().applyMutation(updateGatewayInformationRequest)
                .build());
    }

    /**
     * <p>
     * Updates the gateway virtual machine (VM) software. The request immediately triggers the software update.
     * </p>
     * <note>
     * <p>
     * When you make this request, you get a <code>200 OK</code> success response immediately. However, it might take
     * some time for the update to complete.
     * </p>
     * </note>
     *
     * @param updateGatewaySoftwareNowRequest
     * @return Result of the UpdateGatewaySoftwareNow operation returned by the service.
     * @throws ValidationException
     *         The operation did not succeed because a validation error occurred.
     * @throws InternalServerException
     *         The operation did not succeed because an internal error occurred. Try again later.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action wasn't found.
     * @throws ThrottlingException
     *         TPS has been limited to protect against intentional or unintentional high request volumes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupGatewayClient.UpdateGatewaySoftwareNow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/UpdateGatewaySoftwareNow"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateGatewaySoftwareNowResponse updateGatewaySoftwareNow(
            UpdateGatewaySoftwareNowRequest updateGatewaySoftwareNowRequest) throws ValidationException, InternalServerException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, BackupGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the gateway virtual machine (VM) software. The request immediately triggers the software update.
     * </p>
     * <note>
     * <p>
     * When you make this request, you get a <code>200 OK</code> success response immediately. However, it might take
     * some time for the update to complete.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGatewaySoftwareNowRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateGatewaySoftwareNowRequest#builder()}
     * </p>
     *
     * @param updateGatewaySoftwareNowRequest
     *        A {@link Consumer} that will call methods on {@link UpdateGatewaySoftwareNowInput.Builder} to create a
     *        request.
     * @return Result of the UpdateGatewaySoftwareNow operation returned by the service.
     * @throws ValidationException
     *         The operation did not succeed because a validation error occurred.
     * @throws InternalServerException
     *         The operation did not succeed because an internal error occurred. Try again later.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action wasn't found.
     * @throws ThrottlingException
     *         TPS has been limited to protect against intentional or unintentional high request volumes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupGatewayClient.UpdateGatewaySoftwareNow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/UpdateGatewaySoftwareNow"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateGatewaySoftwareNowResponse updateGatewaySoftwareNow(
            Consumer<UpdateGatewaySoftwareNowRequest.Builder> updateGatewaySoftwareNowRequest) throws ValidationException,
            InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            BackupGatewayException {
        return updateGatewaySoftwareNow(UpdateGatewaySoftwareNowRequest.builder().applyMutation(updateGatewaySoftwareNowRequest)
                .build());
    }

    /**
     * <p>
     * Updates a hypervisor metadata, including its host, username, and password. Specify which hypervisor to update
     * using the Amazon Resource Name (ARN) of the hypervisor in your request.
     * </p>
     *
     * @param updateHypervisorRequest
     * @return Result of the UpdateHypervisor operation returned by the service.
     * @throws ValidationException
     *         The operation did not succeed because a validation error occurred.
     * @throws InternalServerException
     *         The operation did not succeed because an internal error occurred. Try again later.
     * @throws AccessDeniedException
     *         The operation cannot proceed because you have insufficient permissions.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action wasn't found.
     * @throws ThrottlingException
     *         TPS has been limited to protect against intentional or unintentional high request volumes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupGatewayClient.UpdateHypervisor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/UpdateHypervisor"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateHypervisorResponse updateHypervisor(UpdateHypervisorRequest updateHypervisorRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, BackupGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a hypervisor metadata, including its host, username, and password. Specify which hypervisor to update
     * using the Amazon Resource Name (ARN) of the hypervisor in your request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateHypervisorRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateHypervisorRequest#builder()}
     * </p>
     *
     * @param updateHypervisorRequest
     *        A {@link Consumer} that will call methods on {@link UpdateHypervisorInput.Builder} to create a request.
     * @return Result of the UpdateHypervisor operation returned by the service.
     * @throws ValidationException
     *         The operation did not succeed because a validation error occurred.
     * @throws InternalServerException
     *         The operation did not succeed because an internal error occurred. Try again later.
     * @throws AccessDeniedException
     *         The operation cannot proceed because you have insufficient permissions.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action wasn't found.
     * @throws ThrottlingException
     *         TPS has been limited to protect against intentional or unintentional high request volumes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupGatewayClient.UpdateHypervisor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/UpdateHypervisor"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateHypervisorResponse updateHypervisor(Consumer<UpdateHypervisorRequest.Builder> updateHypervisorRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, BackupGatewayException {
        return updateHypervisor(UpdateHypervisorRequest.builder().applyMutation(updateHypervisorRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }
}
