/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupstorage.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Object
 */
@Generated("software.amazon.awssdk:codegen")
public final class BackupObject implements SdkPojo, Serializable, ToCopyableBuilder<BackupObject.Builder, BackupObject> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(BackupObject::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Long> CHUNKS_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ChunksCount").getter(getter(BackupObject::chunksCount)).setter(setter(Builder::chunksCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChunksCount").build()).build();

    private static final SdkField<String> METADATA_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetadataString").getter(getter(BackupObject::metadataString)).setter(setter(Builder::metadataString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataString").build()).build();

    private static final SdkField<String> OBJECT_CHECKSUM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectChecksum").getter(getter(BackupObject::objectChecksum)).setter(setter(Builder::objectChecksum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectChecksum").build()).build();

    private static final SdkField<String> OBJECT_CHECKSUM_ALGORITHM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectChecksumAlgorithm").getter(getter(BackupObject::objectChecksumAlgorithmAsString))
            .setter(setter(Builder::objectChecksumAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectChecksumAlgorithm").build())
            .build();

    private static final SdkField<String> OBJECT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectToken").getter(getter(BackupObject::objectToken)).setter(setter(Builder::objectToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(NAME_FIELD, CHUNKS_COUNT_FIELD, METADATA_STRING_FIELD, OBJECT_CHECKSUM_FIELD,
                    OBJECT_CHECKSUM_ALGORITHM_FIELD, OBJECT_TOKEN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Long chunksCount;

    private final String metadataString;

    private final String objectChecksum;

    private final String objectChecksumAlgorithm;

    private final String objectToken;

    private BackupObject(BuilderImpl builder) {
        this.name = builder.name;
        this.chunksCount = builder.chunksCount;
        this.metadataString = builder.metadataString;
        this.objectChecksum = builder.objectChecksum;
        this.objectChecksumAlgorithm = builder.objectChecksumAlgorithm;
        this.objectToken = builder.objectToken;
    }

    /**
     * Object name
     * 
     * @return Object name
     */
    public final String name() {
        return name;
    }

    /**
     * Number of chunks in object
     * 
     * @return Number of chunks in object
     */
    public final Long chunksCount() {
        return chunksCount;
    }

    /**
     * Metadata string associated with the Object
     * 
     * @return Metadata string associated with the Object
     */
    public final String metadataString() {
        return metadataString;
    }

    /**
     * Object checksum
     * 
     * @return Object checksum
     */
    public final String objectChecksum() {
        return objectChecksum;
    }

    /**
     * Checksum algorithm
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #objectChecksumAlgorithm} will return {@link SummaryChecksumAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #objectChecksumAlgorithmAsString}.
     * </p>
     * 
     * @return Checksum algorithm
     * @see SummaryChecksumAlgorithm
     */
    public final SummaryChecksumAlgorithm objectChecksumAlgorithm() {
        return SummaryChecksumAlgorithm.fromValue(objectChecksumAlgorithm);
    }

    /**
     * Checksum algorithm
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #objectChecksumAlgorithm} will return {@link SummaryChecksumAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #objectChecksumAlgorithmAsString}.
     * </p>
     * 
     * @return Checksum algorithm
     * @see SummaryChecksumAlgorithm
     */
    public final String objectChecksumAlgorithmAsString() {
        return objectChecksumAlgorithm;
    }

    /**
     * Object token
     * 
     * @return Object token
     */
    public final String objectToken() {
        return objectToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(chunksCount());
        hashCode = 31 * hashCode + Objects.hashCode(metadataString());
        hashCode = 31 * hashCode + Objects.hashCode(objectChecksum());
        hashCode = 31 * hashCode + Objects.hashCode(objectChecksumAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(objectToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackupObject)) {
            return false;
        }
        BackupObject other = (BackupObject) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(chunksCount(), other.chunksCount())
                && Objects.equals(metadataString(), other.metadataString())
                && Objects.equals(objectChecksum(), other.objectChecksum())
                && Objects.equals(objectChecksumAlgorithmAsString(), other.objectChecksumAlgorithmAsString())
                && Objects.equals(objectToken(), other.objectToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BackupObject").add("Name", name()).add("ChunksCount", chunksCount())
                .add("MetadataString", metadataString()).add("ObjectChecksum", objectChecksum())
                .add("ObjectChecksumAlgorithm", objectChecksumAlgorithmAsString()).add("ObjectToken", objectToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ChunksCount":
            return Optional.ofNullable(clazz.cast(chunksCount()));
        case "MetadataString":
            return Optional.ofNullable(clazz.cast(metadataString()));
        case "ObjectChecksum":
            return Optional.ofNullable(clazz.cast(objectChecksum()));
        case "ObjectChecksumAlgorithm":
            return Optional.ofNullable(clazz.cast(objectChecksumAlgorithmAsString()));
        case "ObjectToken":
            return Optional.ofNullable(clazz.cast(objectToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BackupObject, T> g) {
        return obj -> g.apply((BackupObject) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BackupObject> {
        /**
         * Object name
         * 
         * @param name
         *        Object name
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Number of chunks in object
         * 
         * @param chunksCount
         *        Number of chunks in object
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chunksCount(Long chunksCount);

        /**
         * Metadata string associated with the Object
         * 
         * @param metadataString
         *        Metadata string associated with the Object
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataString(String metadataString);

        /**
         * Object checksum
         * 
         * @param objectChecksum
         *        Object checksum
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectChecksum(String objectChecksum);

        /**
         * Checksum algorithm
         * 
         * @param objectChecksumAlgorithm
         *        Checksum algorithm
         * @see SummaryChecksumAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SummaryChecksumAlgorithm
         */
        Builder objectChecksumAlgorithm(String objectChecksumAlgorithm);

        /**
         * Checksum algorithm
         * 
         * @param objectChecksumAlgorithm
         *        Checksum algorithm
         * @see SummaryChecksumAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SummaryChecksumAlgorithm
         */
        Builder objectChecksumAlgorithm(SummaryChecksumAlgorithm objectChecksumAlgorithm);

        /**
         * Object token
         * 
         * @param objectToken
         *        Object token
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectToken(String objectToken);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Long chunksCount;

        private String metadataString;

        private String objectChecksum;

        private String objectChecksumAlgorithm;

        private String objectToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BackupObject model) {
            name(model.name);
            chunksCount(model.chunksCount);
            metadataString(model.metadataString);
            objectChecksum(model.objectChecksum);
            objectChecksumAlgorithm(model.objectChecksumAlgorithm);
            objectToken(model.objectToken);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Long getChunksCount() {
            return chunksCount;
        }

        public final void setChunksCount(Long chunksCount) {
            this.chunksCount = chunksCount;
        }

        @Override
        public final Builder chunksCount(Long chunksCount) {
            this.chunksCount = chunksCount;
            return this;
        }

        public final String getMetadataString() {
            return metadataString;
        }

        public final void setMetadataString(String metadataString) {
            this.metadataString = metadataString;
        }

        @Override
        public final Builder metadataString(String metadataString) {
            this.metadataString = metadataString;
            return this;
        }

        public final String getObjectChecksum() {
            return objectChecksum;
        }

        public final void setObjectChecksum(String objectChecksum) {
            this.objectChecksum = objectChecksum;
        }

        @Override
        public final Builder objectChecksum(String objectChecksum) {
            this.objectChecksum = objectChecksum;
            return this;
        }

        public final String getObjectChecksumAlgorithm() {
            return objectChecksumAlgorithm;
        }

        public final void setObjectChecksumAlgorithm(String objectChecksumAlgorithm) {
            this.objectChecksumAlgorithm = objectChecksumAlgorithm;
        }

        @Override
        public final Builder objectChecksumAlgorithm(String objectChecksumAlgorithm) {
            this.objectChecksumAlgorithm = objectChecksumAlgorithm;
            return this;
        }

        @Override
        public final Builder objectChecksumAlgorithm(SummaryChecksumAlgorithm objectChecksumAlgorithm) {
            this.objectChecksumAlgorithm(objectChecksumAlgorithm == null ? null : objectChecksumAlgorithm.toString());
            return this;
        }

        public final String getObjectToken() {
            return objectToken;
        }

        public final void setObjectToken(String objectToken) {
            this.objectToken = objectToken;
        }

        @Override
        public final Builder objectToken(String objectToken) {
            this.objectToken = objectToken;
            return this;
        }

        @Override
        public BackupObject build() {
            return new BackupObject(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
