/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupstorage.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetChunkRequest extends BackupStorageRequest implements
        ToCopyableBuilder<GetChunkRequest.Builder, GetChunkRequest> {
    private static final SdkField<String> STORAGE_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageJobId").getter(getter(GetChunkRequest::storageJobId)).setter(setter(Builder::storageJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobId").build()).build();

    private static final SdkField<String> CHUNK_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChunkToken").getter(getter(GetChunkRequest::chunkToken)).setter(setter(Builder::chunkToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("chunkToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_JOB_ID_FIELD,
            CHUNK_TOKEN_FIELD));

    private final String storageJobId;

    private final String chunkToken;

    private GetChunkRequest(BuilderImpl builder) {
        super(builder);
        this.storageJobId = builder.storageJobId;
        this.chunkToken = builder.chunkToken;
    }

    /**
     * Storage job id
     * 
     * @return Storage job id
     */
    public final String storageJobId() {
        return storageJobId;
    }

    /**
     * Chunk token
     * 
     * @return Chunk token
     */
    public final String chunkToken() {
        return chunkToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(storageJobId());
        hashCode = 31 * hashCode + Objects.hashCode(chunkToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetChunkRequest)) {
            return false;
        }
        GetChunkRequest other = (GetChunkRequest) obj;
        return Objects.equals(storageJobId(), other.storageJobId()) && Objects.equals(chunkToken(), other.chunkToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetChunkRequest").add("StorageJobId", storageJobId()).add("ChunkToken", chunkToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StorageJobId":
            return Optional.ofNullable(clazz.cast(storageJobId()));
        case "ChunkToken":
            return Optional.ofNullable(clazz.cast(chunkToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetChunkRequest, T> g) {
        return obj -> g.apply((GetChunkRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupStorageRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetChunkRequest> {
        /**
         * Storage job id
         * 
         * @param storageJobId
         *        Storage job id
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageJobId(String storageJobId);

        /**
         * Chunk token
         * 
         * @param chunkToken
         *        Chunk token
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chunkToken(String chunkToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupStorageRequest.BuilderImpl implements Builder {
        private String storageJobId;

        private String chunkToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetChunkRequest model) {
            super(model);
            storageJobId(model.storageJobId);
            chunkToken(model.chunkToken);
        }

        public final String getStorageJobId() {
            return storageJobId;
        }

        public final void setStorageJobId(String storageJobId) {
            this.storageJobId = storageJobId;
        }

        @Override
        public final Builder storageJobId(String storageJobId) {
            this.storageJobId = storageJobId;
            return this;
        }

        public final String getChunkToken() {
            return chunkToken;
        }

        public final void setChunkToken(String chunkToken) {
            this.chunkToken = chunkToken;
        }

        @Override
        public final Builder chunkToken(String chunkToken) {
            this.chunkToken = chunkToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetChunkRequest build() {
            return new GetChunkRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
