/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmdataexports.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The status of the execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecutionStatus implements SdkPojo, Serializable, ToCopyableBuilder<ExecutionStatus.Builder, ExecutionStatus> {
    private static final SdkField<Instant> COMPLETED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CompletedAt")
            .getter(getter(ExecutionStatus::completedAt))
            .setter(setter(Builder::completedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt")
            .getter(getter(ExecutionStatus::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedAt")
            .getter(getter(ExecutionStatus::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusCode").getter(getter(ExecutionStatus::statusCodeAsString)).setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCode").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusReason").getter(getter(ExecutionStatus::statusReasonAsString))
            .setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLETED_AT_FIELD,
            CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, STATUS_CODE_FIELD, STATUS_REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant completedAt;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private final String statusCode;

    private final String statusReason;

    private ExecutionStatus(BuilderImpl builder) {
        this.completedAt = builder.completedAt;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.statusCode = builder.statusCode;
        this.statusReason = builder.statusReason;
    }

    /**
     * <p>
     * The time when the execution was completed.
     * </p>
     * 
     * @return The time when the execution was completed.
     */
    public final Instant completedAt() {
        return completedAt;
    }

    /**
     * <p>
     * The time when the execution was created.
     * </p>
     * 
     * @return The time when the execution was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The time when the execution was last updated.
     * </p>
     * 
     * @return The time when the execution was last updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The code for the status of the execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link ExecutionStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusCodeAsString}.
     * </p>
     * 
     * @return The code for the status of the execution.
     * @see ExecutionStatusCode
     */
    public final ExecutionStatusCode statusCode() {
        return ExecutionStatusCode.fromValue(statusCode);
    }

    /**
     * <p>
     * The code for the status of the execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link ExecutionStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusCodeAsString}.
     * </p>
     * 
     * @return The code for the status of the execution.
     * @see ExecutionStatusCode
     */
    public final String statusCodeAsString() {
        return statusCode;
    }

    /**
     * <p>
     * The reason for the failed status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusReason} will
     * return {@link ExecutionStatusReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusReasonAsString}.
     * </p>
     * 
     * @return The reason for the failed status.
     * @see ExecutionStatusReason
     */
    public final ExecutionStatusReason statusReason() {
        return ExecutionStatusReason.fromValue(statusReason);
    }

    /**
     * <p>
     * The reason for the failed status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusReason} will
     * return {@link ExecutionStatusReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusReasonAsString}.
     * </p>
     * 
     * @return The reason for the failed status.
     * @see ExecutionStatusReason
     */
    public final String statusReasonAsString() {
        return statusReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(completedAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReasonAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionStatus)) {
            return false;
        }
        ExecutionStatus other = (ExecutionStatus) obj;
        return Objects.equals(completedAt(), other.completedAt()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(statusCodeAsString(), other.statusCodeAsString())
                && Objects.equals(statusReasonAsString(), other.statusReasonAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecutionStatus").add("CompletedAt", completedAt()).add("CreatedAt", createdAt())
                .add("LastUpdatedAt", lastUpdatedAt()).add("StatusCode", statusCodeAsString())
                .add("StatusReason", statusReasonAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CompletedAt":
            return Optional.ofNullable(clazz.cast(completedAt()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "LastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "StatusCode":
            return Optional.ofNullable(clazz.cast(statusCodeAsString()));
        case "StatusReason":
            return Optional.ofNullable(clazz.cast(statusReasonAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecutionStatus, T> g) {
        return obj -> g.apply((ExecutionStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExecutionStatus> {
        /**
         * <p>
         * The time when the execution was completed.
         * </p>
         * 
         * @param completedAt
         *        The time when the execution was completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completedAt(Instant completedAt);

        /**
         * <p>
         * The time when the execution was created.
         * </p>
         * 
         * @param createdAt
         *        The time when the execution was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The time when the execution was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The time when the execution was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The code for the status of the execution.
         * </p>
         * 
         * @param statusCode
         *        The code for the status of the execution.
         * @see ExecutionStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatusCode
         */
        Builder statusCode(String statusCode);

        /**
         * <p>
         * The code for the status of the execution.
         * </p>
         * 
         * @param statusCode
         *        The code for the status of the execution.
         * @see ExecutionStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatusCode
         */
        Builder statusCode(ExecutionStatusCode statusCode);

        /**
         * <p>
         * The reason for the failed status.
         * </p>
         * 
         * @param statusReason
         *        The reason for the failed status.
         * @see ExecutionStatusReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatusReason
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The reason for the failed status.
         * </p>
         * 
         * @param statusReason
         *        The reason for the failed status.
         * @see ExecutionStatusReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatusReason
         */
        Builder statusReason(ExecutionStatusReason statusReason);
    }

    static final class BuilderImpl implements Builder {
        private Instant completedAt;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private String statusCode;

        private String statusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionStatus model) {
            completedAt(model.completedAt);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
            statusCode(model.statusCode);
            statusReason(model.statusReason);
        }

        public final Instant getCompletedAt() {
            return completedAt;
        }

        public final void setCompletedAt(Instant completedAt) {
            this.completedAt = completedAt;
        }

        @Override
        public final Builder completedAt(Instant completedAt) {
            this.completedAt = completedAt;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getStatusCode() {
            return statusCode;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public final Builder statusCode(ExecutionStatusCode statusCode) {
            this.statusCode(statusCode == null ? null : statusCode.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        @Override
        public final Builder statusReason(ExecutionStatusReason statusReason) {
            this.statusReason(statusReason == null ? null : statusReason.toString());
            return this;
        }

        @Override
        public ExecutionStatus build() {
            return new ExecutionStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
