/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetProvisionedModelThroughputResponse extends BedrockResponse implements
        ToCopyableBuilder<GetProvisionedModelThroughputResponse.Builder, GetProvisionedModelThroughputResponse> {
    private static final SdkField<Integer> MODEL_UNITS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("modelUnits").getter(getter(GetProvisionedModelThroughputResponse::modelUnits))
            .setter(setter(Builder::modelUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelUnits").build()).build();

    private static final SdkField<Integer> DESIRED_MODEL_UNITS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("desiredModelUnits").getter(getter(GetProvisionedModelThroughputResponse::desiredModelUnits))
            .setter(setter(Builder::desiredModelUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredModelUnits").build()).build();

    private static final SdkField<String> PROVISIONED_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("provisionedModelName").getter(getter(GetProvisionedModelThroughputResponse::provisionedModelName))
            .setter(setter(Builder::provisionedModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisionedModelName").build())
            .build();

    private static final SdkField<String> PROVISIONED_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("provisionedModelArn").getter(getter(GetProvisionedModelThroughputResponse::provisionedModelArn))
            .setter(setter(Builder::provisionedModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisionedModelArn").build())
            .build();

    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelArn").getter(getter(GetProvisionedModelThroughputResponse::modelArn))
            .setter(setter(Builder::modelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelArn").build()).build();

    private static final SdkField<String> DESIRED_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("desiredModelArn").getter(getter(GetProvisionedModelThroughputResponse::desiredModelArn))
            .setter(setter(Builder::desiredModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredModelArn").build()).build();

    private static final SdkField<String> FOUNDATION_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("foundationModelArn").getter(getter(GetProvisionedModelThroughputResponse::foundationModelArn))
            .setter(setter(Builder::foundationModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("foundationModelArn").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetProvisionedModelThroughputResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(GetProvisionedModelThroughputResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedTime")
            .getter(getter(GetProvisionedModelThroughputResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureMessage").getter(getter(GetProvisionedModelThroughputResponse::failureMessage))
            .setter(setter(Builder::failureMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureMessage").build()).build();

    private static final SdkField<String> COMMITMENT_DURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("commitmentDuration").getter(getter(GetProvisionedModelThroughputResponse::commitmentDurationAsString))
            .setter(setter(Builder::commitmentDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitmentDuration").build())
            .build();

    private static final SdkField<Instant> COMMITMENT_EXPIRATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("commitmentExpirationTime")
            .getter(getter(GetProvisionedModelThroughputResponse::commitmentExpirationTime))
            .setter(setter(Builder::commitmentExpirationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitmentExpirationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_UNITS_FIELD,
            DESIRED_MODEL_UNITS_FIELD, PROVISIONED_MODEL_NAME_FIELD, PROVISIONED_MODEL_ARN_FIELD, MODEL_ARN_FIELD,
            DESIRED_MODEL_ARN_FIELD, FOUNDATION_MODEL_ARN_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD,
            FAILURE_MESSAGE_FIELD, COMMITMENT_DURATION_FIELD, COMMITMENT_EXPIRATION_TIME_FIELD));

    private final Integer modelUnits;

    private final Integer desiredModelUnits;

    private final String provisionedModelName;

    private final String provisionedModelArn;

    private final String modelArn;

    private final String desiredModelArn;

    private final String foundationModelArn;

    private final String status;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private final String failureMessage;

    private final String commitmentDuration;

    private final Instant commitmentExpirationTime;

    private GetProvisionedModelThroughputResponse(BuilderImpl builder) {
        super(builder);
        this.modelUnits = builder.modelUnits;
        this.desiredModelUnits = builder.desiredModelUnits;
        this.provisionedModelName = builder.provisionedModelName;
        this.provisionedModelArn = builder.provisionedModelArn;
        this.modelArn = builder.modelArn;
        this.desiredModelArn = builder.desiredModelArn;
        this.foundationModelArn = builder.foundationModelArn;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.failureMessage = builder.failureMessage;
        this.commitmentDuration = builder.commitmentDuration;
        this.commitmentExpirationTime = builder.commitmentExpirationTime;
    }

    /**
     * <p>
     * The current number of model units requested to be available for this provisioned throughput.
     * </p>
     * 
     * @return The current number of model units requested to be available for this provisioned throughput.
     */
    public final Integer modelUnits() {
        return modelUnits;
    }

    /**
     * <p>
     * The desired number of model units that was requested to be available for this provisioned throughput.
     * </p>
     * 
     * @return The desired number of model units that was requested to be available for this provisioned throughput.
     */
    public final Integer desiredModelUnits() {
        return desiredModelUnits;
    }

    /**
     * <p>
     * The name of the provisioned throughput.
     * </p>
     * 
     * @return The name of the provisioned throughput.
     */
    public final String provisionedModelName() {
        return provisionedModelName;
    }

    /**
     * <p>
     * The ARN of the provisioned throughput.
     * </p>
     * 
     * @return The ARN of the provisioned throughput.
     */
    public final String provisionedModelArn() {
        return provisionedModelArn;
    }

    /**
     * <p>
     * The ARN or name of the model associated with this provisioned throughput.
     * </p>
     * 
     * @return The ARN or name of the model associated with this provisioned throughput.
     */
    public final String modelArn() {
        return modelArn;
    }

    /**
     * <p>
     * The ARN of the new model to asssociate with this provisioned throughput.
     * </p>
     * 
     * @return The ARN of the new model to asssociate with this provisioned throughput.
     */
    public final String desiredModelArn() {
        return desiredModelArn;
    }

    /**
     * <p>
     * ARN of the foundation model.
     * </p>
     * 
     * @return ARN of the foundation model.
     */
    public final String foundationModelArn() {
        return foundationModelArn;
    }

    /**
     * <p>
     * Status of the provisioned throughput.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ProvisionedModelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the provisioned throughput.
     * @see ProvisionedModelStatus
     */
    public final ProvisionedModelStatus status() {
        return ProvisionedModelStatus.fromValue(status);
    }

    /**
     * <p>
     * Status of the provisioned throughput.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ProvisionedModelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the provisioned throughput.
     * @see ProvisionedModelStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The timestamp of the creation time for this provisioned throughput.
     * </p>
     * 
     * @return The timestamp of the creation time for this provisioned throughput.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The timestamp of the last modified time of this provisioned throughput.
     * </p>
     * 
     * @return The timestamp of the last modified time of this provisioned throughput.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * Failure message for any issues that the create operation encounters.
     * </p>
     * 
     * @return Failure message for any issues that the create operation encounters.
     */
    public final String failureMessage() {
        return failureMessage;
    }

    /**
     * <p>
     * Commitment duration of the provisioned throughput.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #commitmentDuration} will return {@link CommitmentDuration#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #commitmentDurationAsString}.
     * </p>
     * 
     * @return Commitment duration of the provisioned throughput.
     * @see CommitmentDuration
     */
    public final CommitmentDuration commitmentDuration() {
        return CommitmentDuration.fromValue(commitmentDuration);
    }

    /**
     * <p>
     * Commitment duration of the provisioned throughput.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #commitmentDuration} will return {@link CommitmentDuration#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #commitmentDurationAsString}.
     * </p>
     * 
     * @return Commitment duration of the provisioned throughput.
     * @see CommitmentDuration
     */
    public final String commitmentDurationAsString() {
        return commitmentDuration;
    }

    /**
     * <p>
     * Commitment expiration time for the provisioned throughput.
     * </p>
     * 
     * @return Commitment expiration time for the provisioned throughput.
     */
    public final Instant commitmentExpirationTime() {
        return commitmentExpirationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modelUnits());
        hashCode = 31 * hashCode + Objects.hashCode(desiredModelUnits());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedModelName());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(desiredModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(foundationModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(commitmentDurationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(commitmentExpirationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProvisionedModelThroughputResponse)) {
            return false;
        }
        GetProvisionedModelThroughputResponse other = (GetProvisionedModelThroughputResponse) obj;
        return Objects.equals(modelUnits(), other.modelUnits()) && Objects.equals(desiredModelUnits(), other.desiredModelUnits())
                && Objects.equals(provisionedModelName(), other.provisionedModelName())
                && Objects.equals(provisionedModelArn(), other.provisionedModelArn())
                && Objects.equals(modelArn(), other.modelArn()) && Objects.equals(desiredModelArn(), other.desiredModelArn())
                && Objects.equals(foundationModelArn(), other.foundationModelArn())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(failureMessage(), other.failureMessage())
                && Objects.equals(commitmentDurationAsString(), other.commitmentDurationAsString())
                && Objects.equals(commitmentExpirationTime(), other.commitmentExpirationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetProvisionedModelThroughputResponse").add("ModelUnits", modelUnits())
                .add("DesiredModelUnits", desiredModelUnits()).add("ProvisionedModelName", provisionedModelName())
                .add("ProvisionedModelArn", provisionedModelArn()).add("ModelArn", modelArn())
                .add("DesiredModelArn", desiredModelArn()).add("FoundationModelArn", foundationModelArn())
                .add("Status", statusAsString()).add("CreationTime", creationTime()).add("LastModifiedTime", lastModifiedTime())
                .add("FailureMessage", failureMessage()).add("CommitmentDuration", commitmentDurationAsString())
                .add("CommitmentExpirationTime", commitmentExpirationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "modelUnits":
            return Optional.ofNullable(clazz.cast(modelUnits()));
        case "desiredModelUnits":
            return Optional.ofNullable(clazz.cast(desiredModelUnits()));
        case "provisionedModelName":
            return Optional.ofNullable(clazz.cast(provisionedModelName()));
        case "provisionedModelArn":
            return Optional.ofNullable(clazz.cast(provisionedModelArn()));
        case "modelArn":
            return Optional.ofNullable(clazz.cast(modelArn()));
        case "desiredModelArn":
            return Optional.ofNullable(clazz.cast(desiredModelArn()));
        case "foundationModelArn":
            return Optional.ofNullable(clazz.cast(foundationModelArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "failureMessage":
            return Optional.ofNullable(clazz.cast(failureMessage()));
        case "commitmentDuration":
            return Optional.ofNullable(clazz.cast(commitmentDurationAsString()));
        case "commitmentExpirationTime":
            return Optional.ofNullable(clazz.cast(commitmentExpirationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetProvisionedModelThroughputResponse, T> g) {
        return obj -> g.apply((GetProvisionedModelThroughputResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetProvisionedModelThroughputResponse> {
        /**
         * <p>
         * The current number of model units requested to be available for this provisioned throughput.
         * </p>
         * 
         * @param modelUnits
         *        The current number of model units requested to be available for this provisioned throughput.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelUnits(Integer modelUnits);

        /**
         * <p>
         * The desired number of model units that was requested to be available for this provisioned throughput.
         * </p>
         * 
         * @param desiredModelUnits
         *        The desired number of model units that was requested to be available for this provisioned throughput.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredModelUnits(Integer desiredModelUnits);

        /**
         * <p>
         * The name of the provisioned throughput.
         * </p>
         * 
         * @param provisionedModelName
         *        The name of the provisioned throughput.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedModelName(String provisionedModelName);

        /**
         * <p>
         * The ARN of the provisioned throughput.
         * </p>
         * 
         * @param provisionedModelArn
         *        The ARN of the provisioned throughput.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedModelArn(String provisionedModelArn);

        /**
         * <p>
         * The ARN or name of the model associated with this provisioned throughput.
         * </p>
         * 
         * @param modelArn
         *        The ARN or name of the model associated with this provisioned throughput.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelArn(String modelArn);

        /**
         * <p>
         * The ARN of the new model to asssociate with this provisioned throughput.
         * </p>
         * 
         * @param desiredModelArn
         *        The ARN of the new model to asssociate with this provisioned throughput.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredModelArn(String desiredModelArn);

        /**
         * <p>
         * ARN of the foundation model.
         * </p>
         * 
         * @param foundationModelArn
         *        ARN of the foundation model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder foundationModelArn(String foundationModelArn);

        /**
         * <p>
         * Status of the provisioned throughput.
         * </p>
         * 
         * @param status
         *        Status of the provisioned throughput.
         * @see ProvisionedModelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProvisionedModelStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Status of the provisioned throughput.
         * </p>
         * 
         * @param status
         *        Status of the provisioned throughput.
         * @see ProvisionedModelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProvisionedModelStatus
         */
        Builder status(ProvisionedModelStatus status);

        /**
         * <p>
         * The timestamp of the creation time for this provisioned throughput.
         * </p>
         * 
         * @param creationTime
         *        The timestamp of the creation time for this provisioned throughput.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The timestamp of the last modified time of this provisioned throughput.
         * </p>
         * 
         * @param lastModifiedTime
         *        The timestamp of the last modified time of this provisioned throughput.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * Failure message for any issues that the create operation encounters.
         * </p>
         * 
         * @param failureMessage
         *        Failure message for any issues that the create operation encounters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureMessage(String failureMessage);

        /**
         * <p>
         * Commitment duration of the provisioned throughput.
         * </p>
         * 
         * @param commitmentDuration
         *        Commitment duration of the provisioned throughput.
         * @see CommitmentDuration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommitmentDuration
         */
        Builder commitmentDuration(String commitmentDuration);

        /**
         * <p>
         * Commitment duration of the provisioned throughput.
         * </p>
         * 
         * @param commitmentDuration
         *        Commitment duration of the provisioned throughput.
         * @see CommitmentDuration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommitmentDuration
         */
        Builder commitmentDuration(CommitmentDuration commitmentDuration);

        /**
         * <p>
         * Commitment expiration time for the provisioned throughput.
         * </p>
         * 
         * @param commitmentExpirationTime
         *        Commitment expiration time for the provisioned throughput.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitmentExpirationTime(Instant commitmentExpirationTime);
    }

    static final class BuilderImpl extends BedrockResponse.BuilderImpl implements Builder {
        private Integer modelUnits;

        private Integer desiredModelUnits;

        private String provisionedModelName;

        private String provisionedModelArn;

        private String modelArn;

        private String desiredModelArn;

        private String foundationModelArn;

        private String status;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private String failureMessage;

        private String commitmentDuration;

        private Instant commitmentExpirationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetProvisionedModelThroughputResponse model) {
            super(model);
            modelUnits(model.modelUnits);
            desiredModelUnits(model.desiredModelUnits);
            provisionedModelName(model.provisionedModelName);
            provisionedModelArn(model.provisionedModelArn);
            modelArn(model.modelArn);
            desiredModelArn(model.desiredModelArn);
            foundationModelArn(model.foundationModelArn);
            status(model.status);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            failureMessage(model.failureMessage);
            commitmentDuration(model.commitmentDuration);
            commitmentExpirationTime(model.commitmentExpirationTime);
        }

        public final Integer getModelUnits() {
            return modelUnits;
        }

        public final void setModelUnits(Integer modelUnits) {
            this.modelUnits = modelUnits;
        }

        @Override
        public final Builder modelUnits(Integer modelUnits) {
            this.modelUnits = modelUnits;
            return this;
        }

        public final Integer getDesiredModelUnits() {
            return desiredModelUnits;
        }

        public final void setDesiredModelUnits(Integer desiredModelUnits) {
            this.desiredModelUnits = desiredModelUnits;
        }

        @Override
        public final Builder desiredModelUnits(Integer desiredModelUnits) {
            this.desiredModelUnits = desiredModelUnits;
            return this;
        }

        public final String getProvisionedModelName() {
            return provisionedModelName;
        }

        public final void setProvisionedModelName(String provisionedModelName) {
            this.provisionedModelName = provisionedModelName;
        }

        @Override
        public final Builder provisionedModelName(String provisionedModelName) {
            this.provisionedModelName = provisionedModelName;
            return this;
        }

        public final String getProvisionedModelArn() {
            return provisionedModelArn;
        }

        public final void setProvisionedModelArn(String provisionedModelArn) {
            this.provisionedModelArn = provisionedModelArn;
        }

        @Override
        public final Builder provisionedModelArn(String provisionedModelArn) {
            this.provisionedModelArn = provisionedModelArn;
            return this;
        }

        public final String getModelArn() {
            return modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final String getDesiredModelArn() {
            return desiredModelArn;
        }

        public final void setDesiredModelArn(String desiredModelArn) {
            this.desiredModelArn = desiredModelArn;
        }

        @Override
        public final Builder desiredModelArn(String desiredModelArn) {
            this.desiredModelArn = desiredModelArn;
            return this;
        }

        public final String getFoundationModelArn() {
            return foundationModelArn;
        }

        public final void setFoundationModelArn(String foundationModelArn) {
            this.foundationModelArn = foundationModelArn;
        }

        @Override
        public final Builder foundationModelArn(String foundationModelArn) {
            this.foundationModelArn = foundationModelArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ProvisionedModelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getFailureMessage() {
            return failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final String getCommitmentDuration() {
            return commitmentDuration;
        }

        public final void setCommitmentDuration(String commitmentDuration) {
            this.commitmentDuration = commitmentDuration;
        }

        @Override
        public final Builder commitmentDuration(String commitmentDuration) {
            this.commitmentDuration = commitmentDuration;
            return this;
        }

        @Override
        public final Builder commitmentDuration(CommitmentDuration commitmentDuration) {
            this.commitmentDuration(commitmentDuration == null ? null : commitmentDuration.toString());
            return this;
        }

        public final Instant getCommitmentExpirationTime() {
            return commitmentExpirationTime;
        }

        public final void setCommitmentExpirationTime(Instant commitmentExpirationTime) {
            this.commitmentExpirationTime = commitmentExpirationTime;
        }

        @Override
        public final Builder commitmentExpirationTime(Instant commitmentExpirationTime) {
            this.commitmentExpirationTime = commitmentExpirationTime;
            return this;
        }

        @Override
        public GetProvisionedModelThroughputResponse build() {
            return new GetProvisionedModelThroughputResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
