/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.bedrockagent.model.AssociateAgentKnowledgeBaseRequest;
import software.amazon.awssdk.services.bedrockagent.model.AssociateAgentKnowledgeBaseResponse;
import software.amazon.awssdk.services.bedrockagent.model.CreateAgentActionGroupRequest;
import software.amazon.awssdk.services.bedrockagent.model.CreateAgentActionGroupResponse;
import software.amazon.awssdk.services.bedrockagent.model.CreateAgentAliasRequest;
import software.amazon.awssdk.services.bedrockagent.model.CreateAgentAliasResponse;
import software.amazon.awssdk.services.bedrockagent.model.CreateAgentRequest;
import software.amazon.awssdk.services.bedrockagent.model.CreateAgentResponse;
import software.amazon.awssdk.services.bedrockagent.model.CreateDataSourceRequest;
import software.amazon.awssdk.services.bedrockagent.model.CreateDataSourceResponse;
import software.amazon.awssdk.services.bedrockagent.model.CreateKnowledgeBaseRequest;
import software.amazon.awssdk.services.bedrockagent.model.CreateKnowledgeBaseResponse;
import software.amazon.awssdk.services.bedrockagent.model.DeleteAgentActionGroupRequest;
import software.amazon.awssdk.services.bedrockagent.model.DeleteAgentActionGroupResponse;
import software.amazon.awssdk.services.bedrockagent.model.DeleteAgentAliasRequest;
import software.amazon.awssdk.services.bedrockagent.model.DeleteAgentAliasResponse;
import software.amazon.awssdk.services.bedrockagent.model.DeleteAgentRequest;
import software.amazon.awssdk.services.bedrockagent.model.DeleteAgentResponse;
import software.amazon.awssdk.services.bedrockagent.model.DeleteAgentVersionRequest;
import software.amazon.awssdk.services.bedrockagent.model.DeleteAgentVersionResponse;
import software.amazon.awssdk.services.bedrockagent.model.DeleteDataSourceRequest;
import software.amazon.awssdk.services.bedrockagent.model.DeleteDataSourceResponse;
import software.amazon.awssdk.services.bedrockagent.model.DeleteKnowledgeBaseRequest;
import software.amazon.awssdk.services.bedrockagent.model.DeleteKnowledgeBaseResponse;
import software.amazon.awssdk.services.bedrockagent.model.DisassociateAgentKnowledgeBaseRequest;
import software.amazon.awssdk.services.bedrockagent.model.DisassociateAgentKnowledgeBaseResponse;
import software.amazon.awssdk.services.bedrockagent.model.GetAgentActionGroupRequest;
import software.amazon.awssdk.services.bedrockagent.model.GetAgentActionGroupResponse;
import software.amazon.awssdk.services.bedrockagent.model.GetAgentAliasRequest;
import software.amazon.awssdk.services.bedrockagent.model.GetAgentAliasResponse;
import software.amazon.awssdk.services.bedrockagent.model.GetAgentKnowledgeBaseRequest;
import software.amazon.awssdk.services.bedrockagent.model.GetAgentKnowledgeBaseResponse;
import software.amazon.awssdk.services.bedrockagent.model.GetAgentRequest;
import software.amazon.awssdk.services.bedrockagent.model.GetAgentResponse;
import software.amazon.awssdk.services.bedrockagent.model.GetAgentVersionRequest;
import software.amazon.awssdk.services.bedrockagent.model.GetAgentVersionResponse;
import software.amazon.awssdk.services.bedrockagent.model.GetDataSourceRequest;
import software.amazon.awssdk.services.bedrockagent.model.GetDataSourceResponse;
import software.amazon.awssdk.services.bedrockagent.model.GetIngestionJobRequest;
import software.amazon.awssdk.services.bedrockagent.model.GetIngestionJobResponse;
import software.amazon.awssdk.services.bedrockagent.model.GetKnowledgeBaseRequest;
import software.amazon.awssdk.services.bedrockagent.model.GetKnowledgeBaseResponse;
import software.amazon.awssdk.services.bedrockagent.model.ListAgentActionGroupsRequest;
import software.amazon.awssdk.services.bedrockagent.model.ListAgentActionGroupsResponse;
import software.amazon.awssdk.services.bedrockagent.model.ListAgentAliasesRequest;
import software.amazon.awssdk.services.bedrockagent.model.ListAgentAliasesResponse;
import software.amazon.awssdk.services.bedrockagent.model.ListAgentKnowledgeBasesRequest;
import software.amazon.awssdk.services.bedrockagent.model.ListAgentKnowledgeBasesResponse;
import software.amazon.awssdk.services.bedrockagent.model.ListAgentVersionsRequest;
import software.amazon.awssdk.services.bedrockagent.model.ListAgentVersionsResponse;
import software.amazon.awssdk.services.bedrockagent.model.ListAgentsRequest;
import software.amazon.awssdk.services.bedrockagent.model.ListAgentsResponse;
import software.amazon.awssdk.services.bedrockagent.model.ListDataSourcesRequest;
import software.amazon.awssdk.services.bedrockagent.model.ListDataSourcesResponse;
import software.amazon.awssdk.services.bedrockagent.model.ListIngestionJobsRequest;
import software.amazon.awssdk.services.bedrockagent.model.ListIngestionJobsResponse;
import software.amazon.awssdk.services.bedrockagent.model.ListKnowledgeBasesRequest;
import software.amazon.awssdk.services.bedrockagent.model.ListKnowledgeBasesResponse;
import software.amazon.awssdk.services.bedrockagent.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.bedrockagent.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.bedrockagent.model.PrepareAgentRequest;
import software.amazon.awssdk.services.bedrockagent.model.PrepareAgentResponse;
import software.amazon.awssdk.services.bedrockagent.model.StartIngestionJobRequest;
import software.amazon.awssdk.services.bedrockagent.model.StartIngestionJobResponse;
import software.amazon.awssdk.services.bedrockagent.model.TagResourceRequest;
import software.amazon.awssdk.services.bedrockagent.model.TagResourceResponse;
import software.amazon.awssdk.services.bedrockagent.model.UntagResourceRequest;
import software.amazon.awssdk.services.bedrockagent.model.UntagResourceResponse;
import software.amazon.awssdk.services.bedrockagent.model.UpdateAgentActionGroupRequest;
import software.amazon.awssdk.services.bedrockagent.model.UpdateAgentActionGroupResponse;
import software.amazon.awssdk.services.bedrockagent.model.UpdateAgentAliasRequest;
import software.amazon.awssdk.services.bedrockagent.model.UpdateAgentAliasResponse;
import software.amazon.awssdk.services.bedrockagent.model.UpdateAgentKnowledgeBaseRequest;
import software.amazon.awssdk.services.bedrockagent.model.UpdateAgentKnowledgeBaseResponse;
import software.amazon.awssdk.services.bedrockagent.model.UpdateAgentRequest;
import software.amazon.awssdk.services.bedrockagent.model.UpdateAgentResponse;
import software.amazon.awssdk.services.bedrockagent.model.UpdateDataSourceRequest;
import software.amazon.awssdk.services.bedrockagent.model.UpdateDataSourceResponse;
import software.amazon.awssdk.services.bedrockagent.model.UpdateKnowledgeBaseRequest;
import software.amazon.awssdk.services.bedrockagent.model.UpdateKnowledgeBaseResponse;
import software.amazon.awssdk.services.bedrockagent.paginators.ListAgentActionGroupsPublisher;
import software.amazon.awssdk.services.bedrockagent.paginators.ListAgentAliasesPublisher;
import software.amazon.awssdk.services.bedrockagent.paginators.ListAgentKnowledgeBasesPublisher;
import software.amazon.awssdk.services.bedrockagent.paginators.ListAgentVersionsPublisher;
import software.amazon.awssdk.services.bedrockagent.paginators.ListAgentsPublisher;
import software.amazon.awssdk.services.bedrockagent.paginators.ListDataSourcesPublisher;
import software.amazon.awssdk.services.bedrockagent.paginators.ListIngestionJobsPublisher;
import software.amazon.awssdk.services.bedrockagent.paginators.ListKnowledgeBasesPublisher;

/**
 * Service client for accessing Agents for Amazon Bedrock asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * An example service, deployed with the Octane Service creator, which will echo the string
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface BedrockAgentAsyncClient extends AwsClient {
    String SERVICE_NAME = "bedrock";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "bedrock-agent";

    /**
     * <p>
     * Associate a Knowledge Base to an existing Amazon Bedrock Agent
     * </p>
     *
     * @param associateAgentKnowledgeBaseRequest
     *        Associate Agent Knowledge Base Request
     * @return A Java Future containing the result of the AssociateAgentKnowledgeBase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.AssociateAgentKnowledgeBase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/AssociateAgentKnowledgeBase"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateAgentKnowledgeBaseResponse> associateAgentKnowledgeBase(
            AssociateAgentKnowledgeBaseRequest associateAgentKnowledgeBaseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associate a Knowledge Base to an existing Amazon Bedrock Agent
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateAgentKnowledgeBaseRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateAgentKnowledgeBaseRequest#builder()}
     * </p>
     *
     * @param associateAgentKnowledgeBaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagent.model.AssociateAgentKnowledgeBaseRequest.Builder} to
     *        create a request. Associate Agent Knowledge Base Request
     * @return A Java Future containing the result of the AssociateAgentKnowledgeBase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.AssociateAgentKnowledgeBase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/AssociateAgentKnowledgeBase"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateAgentKnowledgeBaseResponse> associateAgentKnowledgeBase(
            Consumer<AssociateAgentKnowledgeBaseRequest.Builder> associateAgentKnowledgeBaseRequest) {
        return associateAgentKnowledgeBase(AssociateAgentKnowledgeBaseRequest.builder()
                .applyMutation(associateAgentKnowledgeBaseRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Bedrock Agent
     * </p>
     *
     * @param createAgentRequest
     *        Create Agent Request
     * @return A Java Future containing the result of the CreateAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.CreateAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/CreateAgent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAgentResponse> createAgent(CreateAgentRequest createAgentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Bedrock Agent
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAgentRequest.Builder} avoiding the need to
     * create one manually via {@link CreateAgentRequest#builder()}
     * </p>
     *
     * @param createAgentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagent.model.CreateAgentRequest.Builder} to create a request.
     *        Create Agent Request
     * @return A Java Future containing the result of the CreateAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.CreateAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/CreateAgent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAgentResponse> createAgent(Consumer<CreateAgentRequest.Builder> createAgentRequest) {
        return createAgent(CreateAgentRequest.builder().applyMutation(createAgentRequest).build());
    }

    /**
     * <p>
     * Creates an Action Group for existing Amazon Bedrock Agent
     * </p>
     *
     * @param createAgentActionGroupRequest
     *        Create Action Group Request
     * @return A Java Future containing the result of the CreateAgentActionGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.CreateAgentActionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/CreateAgentActionGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAgentActionGroupResponse> createAgentActionGroup(
            CreateAgentActionGroupRequest createAgentActionGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Action Group for existing Amazon Bedrock Agent
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAgentActionGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAgentActionGroupRequest#builder()}
     * </p>
     *
     * @param createAgentActionGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagent.model.CreateAgentActionGroupRequest.Builder} to create
     *        a request. Create Action Group Request
     * @return A Java Future containing the result of the CreateAgentActionGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.CreateAgentActionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/CreateAgentActionGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAgentActionGroupResponse> createAgentActionGroup(
            Consumer<CreateAgentActionGroupRequest.Builder> createAgentActionGroupRequest) {
        return createAgentActionGroup(CreateAgentActionGroupRequest.builder().applyMutation(createAgentActionGroupRequest)
                .build());
    }

    /**
     * <p>
     * Creates an Alias for an existing Amazon Bedrock Agent
     * </p>
     *
     * @param createAgentAliasRequest
     *        Create Agent Alias Request
     * @return A Java Future containing the result of the CreateAgentAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.CreateAgentAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/CreateAgentAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAgentAliasResponse> createAgentAlias(CreateAgentAliasRequest createAgentAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Alias for an existing Amazon Bedrock Agent
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAgentAliasRequest.Builder} avoiding the need
     * to create one manually via {@link CreateAgentAliasRequest#builder()}
     * </p>
     *
     * @param createAgentAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagent.model.CreateAgentAliasRequest.Builder} to create a
     *        request. Create Agent Alias Request
     * @return A Java Future containing the result of the CreateAgentAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.CreateAgentAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/CreateAgentAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAgentAliasResponse> createAgentAlias(
            Consumer<CreateAgentAliasRequest.Builder> createAgentAliasRequest) {
        return createAgentAlias(CreateAgentAliasRequest.builder().applyMutation(createAgentAliasRequest).build());
    }

    /**
     * <p>
     * Create a new data source
     * </p>
     *
     * @param createDataSourceRequest
     * @return A Java Future containing the result of the CreateDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.CreateDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/CreateDataSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDataSourceResponse> createDataSource(CreateDataSourceRequest createDataSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a new data source
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataSourceRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDataSourceRequest#builder()}
     * </p>
     *
     * @param createDataSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagent.model.CreateDataSourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.CreateDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/CreateDataSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDataSourceResponse> createDataSource(
            Consumer<CreateDataSourceRequest.Builder> createDataSourceRequest) {
        return createDataSource(CreateDataSourceRequest.builder().applyMutation(createDataSourceRequest).build());
    }

    /**
     * <p>
     * Create a new knowledge base
     * </p>
     *
     * @param createKnowledgeBaseRequest
     * @return A Java Future containing the result of the CreateKnowledgeBase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.CreateKnowledgeBase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/CreateKnowledgeBase"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateKnowledgeBaseResponse> createKnowledgeBase(
            CreateKnowledgeBaseRequest createKnowledgeBaseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a new knowledge base
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateKnowledgeBaseRequest.Builder} avoiding the
     * need to create one manually via {@link CreateKnowledgeBaseRequest#builder()}
     * </p>
     *
     * @param createKnowledgeBaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagent.model.CreateKnowledgeBaseRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateKnowledgeBase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.CreateKnowledgeBase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/CreateKnowledgeBase"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateKnowledgeBaseResponse> createKnowledgeBase(
            Consumer<CreateKnowledgeBaseRequest.Builder> createKnowledgeBaseRequest) {
        return createKnowledgeBase(CreateKnowledgeBaseRequest.builder().applyMutation(createKnowledgeBaseRequest).build());
    }

    /**
     * <p>
     * Deletes an Agent for existing Amazon Bedrock Agent
     * </p>
     *
     * @param deleteAgentRequest
     *        Delete Agent Request
     * @return A Java Future containing the result of the DeleteAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.DeleteAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DeleteAgent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAgentResponse> deleteAgent(DeleteAgentRequest deleteAgentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Agent for existing Amazon Bedrock Agent
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAgentRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteAgentRequest#builder()}
     * </p>
     *
     * @param deleteAgentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagent.model.DeleteAgentRequest.Builder} to create a request.
     *        Delete Agent Request
     * @return A Java Future containing the result of the DeleteAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.DeleteAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DeleteAgent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAgentResponse> deleteAgent(Consumer<DeleteAgentRequest.Builder> deleteAgentRequest) {
        return deleteAgent(DeleteAgentRequest.builder().applyMutation(deleteAgentRequest).build());
    }

    /**
     * <p>
     * Deletes an Action Group for existing Amazon Bedrock Agent.
     * </p>
     *
     * @param deleteAgentActionGroupRequest
     *        Delete Action Group Request
     * @return A Java Future containing the result of the DeleteAgentActionGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.DeleteAgentActionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DeleteAgentActionGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAgentActionGroupResponse> deleteAgentActionGroup(
            DeleteAgentActionGroupRequest deleteAgentActionGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Action Group for existing Amazon Bedrock Agent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAgentActionGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAgentActionGroupRequest#builder()}
     * </p>
     *
     * @param deleteAgentActionGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagent.model.DeleteAgentActionGroupRequest.Builder} to create
     *        a request. Delete Action Group Request
     * @return A Java Future containing the result of the DeleteAgentActionGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.DeleteAgentActionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DeleteAgentActionGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAgentActionGroupResponse> deleteAgentActionGroup(
            Consumer<DeleteAgentActionGroupRequest.Builder> deleteAgentActionGroupRequest) {
        return deleteAgentActionGroup(DeleteAgentActionGroupRequest.builder().applyMutation(deleteAgentActionGroupRequest)
                .build());
    }

    /**
     * <p>
     * Deletes an Alias for a Amazon Bedrock Agent
     * </p>
     *
     * @param deleteAgentAliasRequest
     *        Delete Agent Alias Request
     * @return A Java Future containing the result of the DeleteAgentAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.DeleteAgentAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DeleteAgentAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAgentAliasResponse> deleteAgentAlias(DeleteAgentAliasRequest deleteAgentAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Alias for a Amazon Bedrock Agent
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAgentAliasRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAgentAliasRequest#builder()}
     * </p>
     *
     * @param deleteAgentAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagent.model.DeleteAgentAliasRequest.Builder} to create a
     *        request. Delete Agent Alias Request
     * @return A Java Future containing the result of the DeleteAgentAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.DeleteAgentAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DeleteAgentAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAgentAliasResponse> deleteAgentAlias(
            Consumer<DeleteAgentAliasRequest.Builder> deleteAgentAliasRequest) {
        return deleteAgentAlias(DeleteAgentAliasRequest.builder().applyMutation(deleteAgentAliasRequest).build());
    }

    /**
     * <p>
     * Deletes an Agent version for existing Amazon Bedrock Agent
     * </p>
     *
     * @param deleteAgentVersionRequest
     *        Delete Agent Version Request
     * @return A Java Future containing the result of the DeleteAgentVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.DeleteAgentVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DeleteAgentVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAgentVersionResponse> deleteAgentVersion(DeleteAgentVersionRequest deleteAgentVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Agent version for existing Amazon Bedrock Agent
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAgentVersionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAgentVersionRequest#builder()}
     * </p>
     *
     * @param deleteAgentVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagent.model.DeleteAgentVersionRequest.Builder} to create a
     *        request. Delete Agent Version Request
     * @return A Java Future containing the result of the DeleteAgentVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.DeleteAgentVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DeleteAgentVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAgentVersionResponse> deleteAgentVersion(
            Consumer<DeleteAgentVersionRequest.Builder> deleteAgentVersionRequest) {
        return deleteAgentVersion(DeleteAgentVersionRequest.builder().applyMutation(deleteAgentVersionRequest).build());
    }

    /**
     * <p>
     * Delete an existing data source
     * </p>
     *
     * @param deleteDataSourceRequest
     * @return A Java Future containing the result of the DeleteDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.DeleteDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DeleteDataSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDataSourceResponse> deleteDataSource(DeleteDataSourceRequest deleteDataSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an existing data source
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDataSourceRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDataSourceRequest#builder()}
     * </p>
     *
     * @param deleteDataSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagent.model.DeleteDataSourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.DeleteDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DeleteDataSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDataSourceResponse> deleteDataSource(
            Consumer<DeleteDataSourceRequest.Builder> deleteDataSourceRequest) {
        return deleteDataSource(DeleteDataSourceRequest.builder().applyMutation(deleteDataSourceRequest).build());
    }

    /**
     * <p>
     * Delete an existing knowledge base
     * </p>
     *
     * @param deleteKnowledgeBaseRequest
     * @return A Java Future containing the result of the DeleteKnowledgeBase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.DeleteKnowledgeBase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DeleteKnowledgeBase"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteKnowledgeBaseResponse> deleteKnowledgeBase(
            DeleteKnowledgeBaseRequest deleteKnowledgeBaseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an existing knowledge base
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteKnowledgeBaseRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteKnowledgeBaseRequest#builder()}
     * </p>
     *
     * @param deleteKnowledgeBaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagent.model.DeleteKnowledgeBaseRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteKnowledgeBase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.DeleteKnowledgeBase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DeleteKnowledgeBase"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteKnowledgeBaseResponse> deleteKnowledgeBase(
            Consumer<DeleteKnowledgeBaseRequest.Builder> deleteKnowledgeBaseRequest) {
        return deleteKnowledgeBase(DeleteKnowledgeBaseRequest.builder().applyMutation(deleteKnowledgeBaseRequest).build());
    }

    /**
     * <p>
     * Disassociate an existing Knowledge Base from an Amazon Bedrock Agent
     * </p>
     *
     * @param disassociateAgentKnowledgeBaseRequest
     *        Disassociate Agent Knowledge Base Request
     * @return A Java Future containing the result of the DisassociateAgentKnowledgeBase operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.DisassociateAgentKnowledgeBase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DisassociateAgentKnowledgeBase"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateAgentKnowledgeBaseResponse> disassociateAgentKnowledgeBase(
            DisassociateAgentKnowledgeBaseRequest disassociateAgentKnowledgeBaseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociate an existing Knowledge Base from an Amazon Bedrock Agent
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateAgentKnowledgeBaseRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateAgentKnowledgeBaseRequest#builder()}
     * </p>
     *
     * @param disassociateAgentKnowledgeBaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagent.model.DisassociateAgentKnowledgeBaseRequest.Builder}
     *        to create a request. Disassociate Agent Knowledge Base Request
     * @return A Java Future containing the result of the DisassociateAgentKnowledgeBase operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.DisassociateAgentKnowledgeBase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DisassociateAgentKnowledgeBase"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateAgentKnowledgeBaseResponse> disassociateAgentKnowledgeBase(
            Consumer<DisassociateAgentKnowledgeBaseRequest.Builder> disassociateAgentKnowledgeBaseRequest) {
        return disassociateAgentKnowledgeBase(DisassociateAgentKnowledgeBaseRequest.builder()
                .applyMutation(disassociateAgentKnowledgeBaseRequest).build());
    }

    /**
     * <p>
     * Gets an Agent for existing Amazon Bedrock Agent
     * </p>
     *
     * @param getAgentRequest
     *        Get Agent Request
     * @return A Java Future containing the result of the GetAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.GetAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetAgent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAgentResponse> getAgent(GetAgentRequest getAgentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an Agent for existing Amazon Bedrock Agent
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAgentRequest.Builder} avoiding the need to
     * create one manually via {@link GetAgentRequest#builder()}
     * </p>
     *
     * @param getAgentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagent.model.GetAgentRequest.Builder} to create a request.
     *        Get Agent Request
     * @return A Java Future containing the result of the GetAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.GetAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetAgent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAgentResponse> getAgent(Consumer<GetAgentRequest.Builder> getAgentRequest) {
        return getAgent(GetAgentRequest.builder().applyMutation(getAgentRequest).build());
    }

    /**
     * <p>
     * Gets an Action Group for existing Amazon Bedrock Agent Version
     * </p>
     *
     * @param getAgentActionGroupRequest
     *        Get Action Group Request
     * @return A Java Future containing the result of the GetAgentActionGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.GetAgentActionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetAgentActionGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAgentActionGroupResponse> getAgentActionGroup(
            GetAgentActionGroupRequest getAgentActionGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an Action Group for existing Amazon Bedrock Agent Version
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAgentActionGroupRequest.Builder} avoiding the
     * need to create one manually via {@link GetAgentActionGroupRequest#builder()}
     * </p>
     *
     * @param getAgentActionGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagent.model.GetAgentActionGroupRequest.Builder} to create a
     *        request. Get Action Group Request
     * @return A Java Future containing the result of the GetAgentActionGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.GetAgentActionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetAgentActionGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAgentActionGroupResponse> getAgentActionGroup(
            Consumer<GetAgentActionGroupRequest.Builder> getAgentActionGroupRequest) {
        return getAgentActionGroup(GetAgentActionGroupRequest.builder().applyMutation(getAgentActionGroupRequest).build());
    }

    /**
     * <p>
     * Describes an Alias for a Amazon Bedrock Agent
     * </p>
     *
     * @param getAgentAliasRequest
     *        Get Agent Alias Request
     * @return A Java Future containing the result of the GetAgentAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.GetAgentAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetAgentAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAgentAliasResponse> getAgentAlias(GetAgentAliasRequest getAgentAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an Alias for a Amazon Bedrock Agent
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAgentAliasRequest.Builder} avoiding the need to
     * create one manually via {@link GetAgentAliasRequest#builder()}
     * </p>
     *
     * @param getAgentAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagent.model.GetAgentAliasRequest.Builder} to create a
     *        request. Get Agent Alias Request
     * @return A Java Future containing the result of the GetAgentAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.GetAgentAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetAgentAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAgentAliasResponse> getAgentAlias(Consumer<GetAgentAliasRequest.Builder> getAgentAliasRequest) {
        return getAgentAlias(GetAgentAliasRequest.builder().applyMutation(getAgentAliasRequest).build());
    }

    /**
     * <p>
     * Gets a knowledge base associated to an existing Amazon Bedrock Agent Version
     * </p>
     *
     * @param getAgentKnowledgeBaseRequest
     *        Get Agent Knowledge Base Request
     * @return A Java Future containing the result of the GetAgentKnowledgeBase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.GetAgentKnowledgeBase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetAgentKnowledgeBase"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAgentKnowledgeBaseResponse> getAgentKnowledgeBase(
            GetAgentKnowledgeBaseRequest getAgentKnowledgeBaseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a knowledge base associated to an existing Amazon Bedrock Agent Version
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAgentKnowledgeBaseRequest.Builder} avoiding the
     * need to create one manually via {@link GetAgentKnowledgeBaseRequest#builder()}
     * </p>
     *
     * @param getAgentKnowledgeBaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagent.model.GetAgentKnowledgeBaseRequest.Builder} to create
     *        a request. Get Agent Knowledge Base Request
     * @return A Java Future containing the result of the GetAgentKnowledgeBase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.GetAgentKnowledgeBase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetAgentKnowledgeBase"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAgentKnowledgeBaseResponse> getAgentKnowledgeBase(
            Consumer<GetAgentKnowledgeBaseRequest.Builder> getAgentKnowledgeBaseRequest) {
        return getAgentKnowledgeBase(GetAgentKnowledgeBaseRequest.builder().applyMutation(getAgentKnowledgeBaseRequest).build());
    }

    /**
     * <p>
     * Gets an Agent version for existing Amazon Bedrock Agent
     * </p>
     *
     * @param getAgentVersionRequest
     *        Get Agent Version Request
     * @return A Java Future containing the result of the GetAgentVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.GetAgentVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetAgentVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAgentVersionResponse> getAgentVersion(GetAgentVersionRequest getAgentVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an Agent version for existing Amazon Bedrock Agent
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAgentVersionRequest.Builder} avoiding the need
     * to create one manually via {@link GetAgentVersionRequest#builder()}
     * </p>
     *
     * @param getAgentVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagent.model.GetAgentVersionRequest.Builder} to create a
     *        request. Get Agent Version Request
     * @return A Java Future containing the result of the GetAgentVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.GetAgentVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetAgentVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAgentVersionResponse> getAgentVersion(
            Consumer<GetAgentVersionRequest.Builder> getAgentVersionRequest) {
        return getAgentVersion(GetAgentVersionRequest.builder().applyMutation(getAgentVersionRequest).build());
    }

    /**
     * <p>
     * Get an existing data source
     * </p>
     *
     * @param getDataSourceRequest
     * @return A Java Future containing the result of the GetDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.GetDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDataSourceResponse> getDataSource(GetDataSourceRequest getDataSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get an existing data source
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataSourceRequest.Builder} avoiding the need to
     * create one manually via {@link GetDataSourceRequest#builder()}
     * </p>
     *
     * @param getDataSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagent.model.GetDataSourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.GetDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDataSourceResponse> getDataSource(Consumer<GetDataSourceRequest.Builder> getDataSourceRequest) {
        return getDataSource(GetDataSourceRequest.builder().applyMutation(getDataSourceRequest).build());
    }

    /**
     * <p>
     * Get an ingestion job
     * </p>
     *
     * @param getIngestionJobRequest
     * @return A Java Future containing the result of the GetIngestionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.GetIngestionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetIngestionJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetIngestionJobResponse> getIngestionJob(GetIngestionJobRequest getIngestionJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get an ingestion job
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIngestionJobRequest.Builder} avoiding the need
     * to create one manually via {@link GetIngestionJobRequest#builder()}
     * </p>
     *
     * @param getIngestionJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagent.model.GetIngestionJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetIngestionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.GetIngestionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetIngestionJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetIngestionJobResponse> getIngestionJob(
            Consumer<GetIngestionJobRequest.Builder> getIngestionJobRequest) {
        return getIngestionJob(GetIngestionJobRequest.builder().applyMutation(getIngestionJobRequest).build());
    }

    /**
     * <p>
     * Get an existing knowledge base
     * </p>
     *
     * @param getKnowledgeBaseRequest
     * @return A Java Future containing the result of the GetKnowledgeBase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.GetKnowledgeBase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetKnowledgeBase"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetKnowledgeBaseResponse> getKnowledgeBase(GetKnowledgeBaseRequest getKnowledgeBaseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get an existing knowledge base
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetKnowledgeBaseRequest.Builder} avoiding the need
     * to create one manually via {@link GetKnowledgeBaseRequest#builder()}
     * </p>
     *
     * @param getKnowledgeBaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagent.model.GetKnowledgeBaseRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetKnowledgeBase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.GetKnowledgeBase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetKnowledgeBase"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetKnowledgeBaseResponse> getKnowledgeBase(
            Consumer<GetKnowledgeBaseRequest.Builder> getKnowledgeBaseRequest) {
        return getKnowledgeBase(GetKnowledgeBaseRequest.builder().applyMutation(getKnowledgeBaseRequest).build());
    }

    /**
     * <p>
     * Lists an Action Group for existing Amazon Bedrock Agent Version
     * </p>
     *
     * @param listAgentActionGroupsRequest
     *        List Action Groups Request
     * @return A Java Future containing the result of the ListAgentActionGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.ListAgentActionGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListAgentActionGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAgentActionGroupsResponse> listAgentActionGroups(
            ListAgentActionGroupsRequest listAgentActionGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists an Action Group for existing Amazon Bedrock Agent Version
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAgentActionGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAgentActionGroupsRequest#builder()}
     * </p>
     *
     * @param listAgentActionGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagent.model.ListAgentActionGroupsRequest.Builder} to create
     *        a request. List Action Groups Request
     * @return A Java Future containing the result of the ListAgentActionGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.ListAgentActionGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListAgentActionGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAgentActionGroupsResponse> listAgentActionGroups(
            Consumer<ListAgentActionGroupsRequest.Builder> listAgentActionGroupsRequest) {
        return listAgentActionGroups(ListAgentActionGroupsRequest.builder().applyMutation(listAgentActionGroupsRequest).build());
    }

    /**
     * <p>
     * Lists an Action Group for existing Amazon Bedrock Agent Version
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAgentActionGroups(software.amazon.awssdk.services.bedrockagent.model.ListAgentActionGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagent.paginators.ListAgentActionGroupsPublisher publisher = client.listAgentActionGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagent.paginators.ListAgentActionGroupsPublisher publisher = client.listAgentActionGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagent.model.ListAgentActionGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagent.model.ListAgentActionGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAgentActionGroups(software.amazon.awssdk.services.bedrockagent.model.ListAgentActionGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAgentActionGroupsRequest
     *        List Action Groups Request
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.ListAgentActionGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListAgentActionGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAgentActionGroupsPublisher listAgentActionGroupsPaginator(
            ListAgentActionGroupsRequest listAgentActionGroupsRequest) {
        return new ListAgentActionGroupsPublisher(this, listAgentActionGroupsRequest);
    }

    /**
     * <p>
     * Lists an Action Group for existing Amazon Bedrock Agent Version
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAgentActionGroups(software.amazon.awssdk.services.bedrockagent.model.ListAgentActionGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagent.paginators.ListAgentActionGroupsPublisher publisher = client.listAgentActionGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagent.paginators.ListAgentActionGroupsPublisher publisher = client.listAgentActionGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagent.model.ListAgentActionGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagent.model.ListAgentActionGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAgentActionGroups(software.amazon.awssdk.services.bedrockagent.model.ListAgentActionGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAgentActionGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAgentActionGroupsRequest#builder()}
     * </p>
     *
     * @param listAgentActionGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagent.model.ListAgentActionGroupsRequest.Builder} to create
     *        a request. List Action Groups Request
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.ListAgentActionGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListAgentActionGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAgentActionGroupsPublisher listAgentActionGroupsPaginator(
            Consumer<ListAgentActionGroupsRequest.Builder> listAgentActionGroupsRequest) {
        return listAgentActionGroupsPaginator(ListAgentActionGroupsRequest.builder().applyMutation(listAgentActionGroupsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all the Aliases for an Amazon Bedrock Agent
     * </p>
     *
     * @param listAgentAliasesRequest
     *        List Agent Aliases Request
     * @return A Java Future containing the result of the ListAgentAliases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.ListAgentAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListAgentAliases"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAgentAliasesResponse> listAgentAliases(ListAgentAliasesRequest listAgentAliasesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the Aliases for an Amazon Bedrock Agent
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAgentAliasesRequest.Builder} avoiding the need
     * to create one manually via {@link ListAgentAliasesRequest#builder()}
     * </p>
     *
     * @param listAgentAliasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagent.model.ListAgentAliasesRequest.Builder} to create a
     *        request. List Agent Aliases Request
     * @return A Java Future containing the result of the ListAgentAliases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.ListAgentAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListAgentAliases"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAgentAliasesResponse> listAgentAliases(
            Consumer<ListAgentAliasesRequest.Builder> listAgentAliasesRequest) {
        return listAgentAliases(ListAgentAliasesRequest.builder().applyMutation(listAgentAliasesRequest).build());
    }

    /**
     * <p>
     * Lists all the Aliases for an Amazon Bedrock Agent
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAgentAliases(software.amazon.awssdk.services.bedrockagent.model.ListAgentAliasesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagent.paginators.ListAgentAliasesPublisher publisher = client.listAgentAliasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagent.paginators.ListAgentAliasesPublisher publisher = client.listAgentAliasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagent.model.ListAgentAliasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagent.model.ListAgentAliasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAgentAliases(software.amazon.awssdk.services.bedrockagent.model.ListAgentAliasesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAgentAliasesRequest
     *        List Agent Aliases Request
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.ListAgentAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListAgentAliases"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAgentAliasesPublisher listAgentAliasesPaginator(ListAgentAliasesRequest listAgentAliasesRequest) {
        return new ListAgentAliasesPublisher(this, listAgentAliasesRequest);
    }

    /**
     * <p>
     * Lists all the Aliases for an Amazon Bedrock Agent
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAgentAliases(software.amazon.awssdk.services.bedrockagent.model.ListAgentAliasesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagent.paginators.ListAgentAliasesPublisher publisher = client.listAgentAliasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagent.paginators.ListAgentAliasesPublisher publisher = client.listAgentAliasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagent.model.ListAgentAliasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagent.model.ListAgentAliasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAgentAliases(software.amazon.awssdk.services.bedrockagent.model.ListAgentAliasesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAgentAliasesRequest.Builder} avoiding the need
     * to create one manually via {@link ListAgentAliasesRequest#builder()}
     * </p>
     *
     * @param listAgentAliasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagent.model.ListAgentAliasesRequest.Builder} to create a
     *        request. List Agent Aliases Request
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.ListAgentAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListAgentAliases"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAgentAliasesPublisher listAgentAliasesPaginator(Consumer<ListAgentAliasesRequest.Builder> listAgentAliasesRequest) {
        return listAgentAliasesPaginator(ListAgentAliasesRequest.builder().applyMutation(listAgentAliasesRequest).build());
    }

    /**
     * <p>
     * List of Knowledge Bases associated to an existing Amazon Bedrock Agent Version
     * </p>
     *
     * @param listAgentKnowledgeBasesRequest
     *        List Agent Knowledge Bases Request
     * @return A Java Future containing the result of the ListAgentKnowledgeBases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.ListAgentKnowledgeBases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListAgentKnowledgeBases"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAgentKnowledgeBasesResponse> listAgentKnowledgeBases(
            ListAgentKnowledgeBasesRequest listAgentKnowledgeBasesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List of Knowledge Bases associated to an existing Amazon Bedrock Agent Version
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAgentKnowledgeBasesRequest.Builder} avoiding
     * the need to create one manually via {@link ListAgentKnowledgeBasesRequest#builder()}
     * </p>
     *
     * @param listAgentKnowledgeBasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagent.model.ListAgentKnowledgeBasesRequest.Builder} to
     *        create a request. List Agent Knowledge Bases Request
     * @return A Java Future containing the result of the ListAgentKnowledgeBases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.ListAgentKnowledgeBases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListAgentKnowledgeBases"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAgentKnowledgeBasesResponse> listAgentKnowledgeBases(
            Consumer<ListAgentKnowledgeBasesRequest.Builder> listAgentKnowledgeBasesRequest) {
        return listAgentKnowledgeBases(ListAgentKnowledgeBasesRequest.builder().applyMutation(listAgentKnowledgeBasesRequest)
                .build());
    }

    /**
     * <p>
     * List of Knowledge Bases associated to an existing Amazon Bedrock Agent Version
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAgentKnowledgeBases(software.amazon.awssdk.services.bedrockagent.model.ListAgentKnowledgeBasesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagent.paginators.ListAgentKnowledgeBasesPublisher publisher = client.listAgentKnowledgeBasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagent.paginators.ListAgentKnowledgeBasesPublisher publisher = client.listAgentKnowledgeBasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagent.model.ListAgentKnowledgeBasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagent.model.ListAgentKnowledgeBasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAgentKnowledgeBases(software.amazon.awssdk.services.bedrockagent.model.ListAgentKnowledgeBasesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAgentKnowledgeBasesRequest
     *        List Agent Knowledge Bases Request
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.ListAgentKnowledgeBases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListAgentKnowledgeBases"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAgentKnowledgeBasesPublisher listAgentKnowledgeBasesPaginator(
            ListAgentKnowledgeBasesRequest listAgentKnowledgeBasesRequest) {
        return new ListAgentKnowledgeBasesPublisher(this, listAgentKnowledgeBasesRequest);
    }

    /**
     * <p>
     * List of Knowledge Bases associated to an existing Amazon Bedrock Agent Version
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAgentKnowledgeBases(software.amazon.awssdk.services.bedrockagent.model.ListAgentKnowledgeBasesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagent.paginators.ListAgentKnowledgeBasesPublisher publisher = client.listAgentKnowledgeBasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagent.paginators.ListAgentKnowledgeBasesPublisher publisher = client.listAgentKnowledgeBasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagent.model.ListAgentKnowledgeBasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagent.model.ListAgentKnowledgeBasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAgentKnowledgeBases(software.amazon.awssdk.services.bedrockagent.model.ListAgentKnowledgeBasesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAgentKnowledgeBasesRequest.Builder} avoiding
     * the need to create one manually via {@link ListAgentKnowledgeBasesRequest#builder()}
     * </p>
     *
     * @param listAgentKnowledgeBasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagent.model.ListAgentKnowledgeBasesRequest.Builder} to
     *        create a request. List Agent Knowledge Bases Request
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.ListAgentKnowledgeBases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListAgentKnowledgeBases"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAgentKnowledgeBasesPublisher listAgentKnowledgeBasesPaginator(
            Consumer<ListAgentKnowledgeBasesRequest.Builder> listAgentKnowledgeBasesRequest) {
        return listAgentKnowledgeBasesPaginator(ListAgentKnowledgeBasesRequest.builder()
                .applyMutation(listAgentKnowledgeBasesRequest).build());
    }

    /**
     * <p>
     * Lists Agent Versions
     * </p>
     *
     * @param listAgentVersionsRequest
     *        List Agent Versions Request
     * @return A Java Future containing the result of the ListAgentVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.ListAgentVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListAgentVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAgentVersionsResponse> listAgentVersions(ListAgentVersionsRequest listAgentVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists Agent Versions
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAgentVersionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListAgentVersionsRequest#builder()}
     * </p>
     *
     * @param listAgentVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagent.model.ListAgentVersionsRequest.Builder} to create a
     *        request. List Agent Versions Request
     * @return A Java Future containing the result of the ListAgentVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.ListAgentVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListAgentVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAgentVersionsResponse> listAgentVersions(
            Consumer<ListAgentVersionsRequest.Builder> listAgentVersionsRequest) {
        return listAgentVersions(ListAgentVersionsRequest.builder().applyMutation(listAgentVersionsRequest).build());
    }

    /**
     * <p>
     * Lists Agent Versions
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAgentVersions(software.amazon.awssdk.services.bedrockagent.model.ListAgentVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagent.paginators.ListAgentVersionsPublisher publisher = client.listAgentVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagent.paginators.ListAgentVersionsPublisher publisher = client.listAgentVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagent.model.ListAgentVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagent.model.ListAgentVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAgentVersions(software.amazon.awssdk.services.bedrockagent.model.ListAgentVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAgentVersionsRequest
     *        List Agent Versions Request
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.ListAgentVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListAgentVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAgentVersionsPublisher listAgentVersionsPaginator(ListAgentVersionsRequest listAgentVersionsRequest) {
        return new ListAgentVersionsPublisher(this, listAgentVersionsRequest);
    }

    /**
     * <p>
     * Lists Agent Versions
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAgentVersions(software.amazon.awssdk.services.bedrockagent.model.ListAgentVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagent.paginators.ListAgentVersionsPublisher publisher = client.listAgentVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagent.paginators.ListAgentVersionsPublisher publisher = client.listAgentVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagent.model.ListAgentVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagent.model.ListAgentVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAgentVersions(software.amazon.awssdk.services.bedrockagent.model.ListAgentVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAgentVersionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListAgentVersionsRequest#builder()}
     * </p>
     *
     * @param listAgentVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagent.model.ListAgentVersionsRequest.Builder} to create a
     *        request. List Agent Versions Request
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.ListAgentVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListAgentVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAgentVersionsPublisher listAgentVersionsPaginator(
            Consumer<ListAgentVersionsRequest.Builder> listAgentVersionsRequest) {
        return listAgentVersionsPaginator(ListAgentVersionsRequest.builder().applyMutation(listAgentVersionsRequest).build());
    }

    /**
     * <p>
     * Lists Agents
     * </p>
     *
     * @param listAgentsRequest
     *        List Agent Request
     * @return A Java Future containing the result of the ListAgents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.ListAgents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListAgents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAgentsResponse> listAgents(ListAgentsRequest listAgentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists Agents
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAgentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAgentsRequest#builder()}
     * </p>
     *
     * @param listAgentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagent.model.ListAgentsRequest.Builder} to create a request.
     *        List Agent Request
     * @return A Java Future containing the result of the ListAgents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.ListAgents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListAgents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAgentsResponse> listAgents(Consumer<ListAgentsRequest.Builder> listAgentsRequest) {
        return listAgents(ListAgentsRequest.builder().applyMutation(listAgentsRequest).build());
    }

    /**
     * <p>
     * Lists Agents
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAgents(software.amazon.awssdk.services.bedrockagent.model.ListAgentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagent.paginators.ListAgentsPublisher publisher = client.listAgentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagent.paginators.ListAgentsPublisher publisher = client.listAgentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagent.model.ListAgentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagent.model.ListAgentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAgents(software.amazon.awssdk.services.bedrockagent.model.ListAgentsRequest)} operation.</b>
     * </p>
     *
     * @param listAgentsRequest
     *        List Agent Request
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.ListAgents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListAgents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAgentsPublisher listAgentsPaginator(ListAgentsRequest listAgentsRequest) {
        return new ListAgentsPublisher(this, listAgentsRequest);
    }

    /**
     * <p>
     * Lists Agents
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAgents(software.amazon.awssdk.services.bedrockagent.model.ListAgentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagent.paginators.ListAgentsPublisher publisher = client.listAgentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagent.paginators.ListAgentsPublisher publisher = client.listAgentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagent.model.ListAgentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagent.model.ListAgentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAgents(software.amazon.awssdk.services.bedrockagent.model.ListAgentsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAgentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAgentsRequest#builder()}
     * </p>
     *
     * @param listAgentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagent.model.ListAgentsRequest.Builder} to create a request.
     *        List Agent Request
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.ListAgents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListAgents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAgentsPublisher listAgentsPaginator(Consumer<ListAgentsRequest.Builder> listAgentsRequest) {
        return listAgentsPaginator(ListAgentsRequest.builder().applyMutation(listAgentsRequest).build());
    }

    /**
     * <p>
     * List data sources
     * </p>
     *
     * @param listDataSourcesRequest
     * @return A Java Future containing the result of the ListDataSources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.ListDataSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListDataSources" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDataSourcesResponse> listDataSources(ListDataSourcesRequest listDataSourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List data sources
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSourcesRequest.Builder} avoiding the need
     * to create one manually via {@link ListDataSourcesRequest#builder()}
     * </p>
     *
     * @param listDataSourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagent.model.ListDataSourcesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListDataSources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.ListDataSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListDataSources" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDataSourcesResponse> listDataSources(
            Consumer<ListDataSourcesRequest.Builder> listDataSourcesRequest) {
        return listDataSources(ListDataSourcesRequest.builder().applyMutation(listDataSourcesRequest).build());
    }

    /**
     * <p>
     * List data sources
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDataSources(software.amazon.awssdk.services.bedrockagent.model.ListDataSourcesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagent.paginators.ListDataSourcesPublisher publisher = client.listDataSourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagent.paginators.ListDataSourcesPublisher publisher = client.listDataSourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagent.model.ListDataSourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagent.model.ListDataSourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSources(software.amazon.awssdk.services.bedrockagent.model.ListDataSourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDataSourcesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.ListDataSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListDataSources" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDataSourcesPublisher listDataSourcesPaginator(ListDataSourcesRequest listDataSourcesRequest) {
        return new ListDataSourcesPublisher(this, listDataSourcesRequest);
    }

    /**
     * <p>
     * List data sources
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDataSources(software.amazon.awssdk.services.bedrockagent.model.ListDataSourcesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagent.paginators.ListDataSourcesPublisher publisher = client.listDataSourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagent.paginators.ListDataSourcesPublisher publisher = client.listDataSourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagent.model.ListDataSourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagent.model.ListDataSourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSources(software.amazon.awssdk.services.bedrockagent.model.ListDataSourcesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSourcesRequest.Builder} avoiding the need
     * to create one manually via {@link ListDataSourcesRequest#builder()}
     * </p>
     *
     * @param listDataSourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagent.model.ListDataSourcesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.ListDataSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListDataSources" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDataSourcesPublisher listDataSourcesPaginator(Consumer<ListDataSourcesRequest.Builder> listDataSourcesRequest) {
        return listDataSourcesPaginator(ListDataSourcesRequest.builder().applyMutation(listDataSourcesRequest).build());
    }

    /**
     * <p>
     * List ingestion jobs
     * </p>
     *
     * @param listIngestionJobsRequest
     * @return A Java Future containing the result of the ListIngestionJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.ListIngestionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListIngestionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListIngestionJobsResponse> listIngestionJobs(ListIngestionJobsRequest listIngestionJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List ingestion jobs
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIngestionJobsRequest.Builder} avoiding the need
     * to create one manually via {@link ListIngestionJobsRequest#builder()}
     * </p>
     *
     * @param listIngestionJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagent.model.ListIngestionJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListIngestionJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.ListIngestionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListIngestionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListIngestionJobsResponse> listIngestionJobs(
            Consumer<ListIngestionJobsRequest.Builder> listIngestionJobsRequest) {
        return listIngestionJobs(ListIngestionJobsRequest.builder().applyMutation(listIngestionJobsRequest).build());
    }

    /**
     * <p>
     * List ingestion jobs
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listIngestionJobs(software.amazon.awssdk.services.bedrockagent.model.ListIngestionJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagent.paginators.ListIngestionJobsPublisher publisher = client.listIngestionJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagent.paginators.ListIngestionJobsPublisher publisher = client.listIngestionJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagent.model.ListIngestionJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagent.model.ListIngestionJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIngestionJobs(software.amazon.awssdk.services.bedrockagent.model.ListIngestionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listIngestionJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.ListIngestionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListIngestionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIngestionJobsPublisher listIngestionJobsPaginator(ListIngestionJobsRequest listIngestionJobsRequest) {
        return new ListIngestionJobsPublisher(this, listIngestionJobsRequest);
    }

    /**
     * <p>
     * List ingestion jobs
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listIngestionJobs(software.amazon.awssdk.services.bedrockagent.model.ListIngestionJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagent.paginators.ListIngestionJobsPublisher publisher = client.listIngestionJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagent.paginators.ListIngestionJobsPublisher publisher = client.listIngestionJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagent.model.ListIngestionJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagent.model.ListIngestionJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIngestionJobs(software.amazon.awssdk.services.bedrockagent.model.ListIngestionJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIngestionJobsRequest.Builder} avoiding the need
     * to create one manually via {@link ListIngestionJobsRequest#builder()}
     * </p>
     *
     * @param listIngestionJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagent.model.ListIngestionJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.ListIngestionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListIngestionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIngestionJobsPublisher listIngestionJobsPaginator(
            Consumer<ListIngestionJobsRequest.Builder> listIngestionJobsRequest) {
        return listIngestionJobsPaginator(ListIngestionJobsRequest.builder().applyMutation(listIngestionJobsRequest).build());
    }

    /**
     * <p>
     * List Knowledge Bases
     * </p>
     *
     * @param listKnowledgeBasesRequest
     * @return A Java Future containing the result of the ListKnowledgeBases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.ListKnowledgeBases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListKnowledgeBases"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListKnowledgeBasesResponse> listKnowledgeBases(ListKnowledgeBasesRequest listKnowledgeBasesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List Knowledge Bases
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListKnowledgeBasesRequest.Builder} avoiding the
     * need to create one manually via {@link ListKnowledgeBasesRequest#builder()}
     * </p>
     *
     * @param listKnowledgeBasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagent.model.ListKnowledgeBasesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListKnowledgeBases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.ListKnowledgeBases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListKnowledgeBases"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListKnowledgeBasesResponse> listKnowledgeBases(
            Consumer<ListKnowledgeBasesRequest.Builder> listKnowledgeBasesRequest) {
        return listKnowledgeBases(ListKnowledgeBasesRequest.builder().applyMutation(listKnowledgeBasesRequest).build());
    }

    /**
     * <p>
     * List Knowledge Bases
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listKnowledgeBases(software.amazon.awssdk.services.bedrockagent.model.ListKnowledgeBasesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagent.paginators.ListKnowledgeBasesPublisher publisher = client.listKnowledgeBasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagent.paginators.ListKnowledgeBasesPublisher publisher = client.listKnowledgeBasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagent.model.ListKnowledgeBasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagent.model.ListKnowledgeBasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listKnowledgeBases(software.amazon.awssdk.services.bedrockagent.model.ListKnowledgeBasesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listKnowledgeBasesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.ListKnowledgeBases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListKnowledgeBases"
     *      target="_top">AWS API Documentation</a>
     */
    default ListKnowledgeBasesPublisher listKnowledgeBasesPaginator(ListKnowledgeBasesRequest listKnowledgeBasesRequest) {
        return new ListKnowledgeBasesPublisher(this, listKnowledgeBasesRequest);
    }

    /**
     * <p>
     * List Knowledge Bases
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listKnowledgeBases(software.amazon.awssdk.services.bedrockagent.model.ListKnowledgeBasesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagent.paginators.ListKnowledgeBasesPublisher publisher = client.listKnowledgeBasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagent.paginators.ListKnowledgeBasesPublisher publisher = client.listKnowledgeBasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagent.model.ListKnowledgeBasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagent.model.ListKnowledgeBasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listKnowledgeBases(software.amazon.awssdk.services.bedrockagent.model.ListKnowledgeBasesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListKnowledgeBasesRequest.Builder} avoiding the
     * need to create one manually via {@link ListKnowledgeBasesRequest#builder()}
     * </p>
     *
     * @param listKnowledgeBasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagent.model.ListKnowledgeBasesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.ListKnowledgeBases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListKnowledgeBases"
     *      target="_top">AWS API Documentation</a>
     */
    default ListKnowledgeBasesPublisher listKnowledgeBasesPaginator(
            Consumer<ListKnowledgeBasesRequest.Builder> listKnowledgeBasesRequest) {
        return listKnowledgeBasesPaginator(ListKnowledgeBasesRequest.builder().applyMutation(listKnowledgeBasesRequest).build());
    }

    /**
     * <p>
     * List tags for a resource
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List tags for a resource
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagent.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Prepares an existing Amazon Bedrock Agent to receive runtime requests
     * </p>
     *
     * @param prepareAgentRequest
     *        PrepareAgent Request
     * @return A Java Future containing the result of the PrepareAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.PrepareAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/PrepareAgent" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PrepareAgentResponse> prepareAgent(PrepareAgentRequest prepareAgentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Prepares an existing Amazon Bedrock Agent to receive runtime requests
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PrepareAgentRequest.Builder} avoiding the need to
     * create one manually via {@link PrepareAgentRequest#builder()}
     * </p>
     *
     * @param prepareAgentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagent.model.PrepareAgentRequest.Builder} to create a
     *        request. PrepareAgent Request
     * @return A Java Future containing the result of the PrepareAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.PrepareAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/PrepareAgent" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PrepareAgentResponse> prepareAgent(Consumer<PrepareAgentRequest.Builder> prepareAgentRequest) {
        return prepareAgent(PrepareAgentRequest.builder().applyMutation(prepareAgentRequest).build());
    }

    /**
     * <p>
     * Start a new ingestion job
     * </p>
     *
     * @param startIngestionJobRequest
     * @return A Java Future containing the result of the StartIngestionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.StartIngestionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/StartIngestionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartIngestionJobResponse> startIngestionJob(StartIngestionJobRequest startIngestionJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Start a new ingestion job
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartIngestionJobRequest.Builder} avoiding the need
     * to create one manually via {@link StartIngestionJobRequest#builder()}
     * </p>
     *
     * @param startIngestionJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagent.model.StartIngestionJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartIngestionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.StartIngestionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/StartIngestionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartIngestionJobResponse> startIngestionJob(
            Consumer<StartIngestionJobRequest.Builder> startIngestionJobRequest) {
        return startIngestionJob(StartIngestionJobRequest.builder().applyMutation(startIngestionJobRequest).build());
    }

    /**
     * <p>
     * Tag a resource
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tag a resource
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagent.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Untag a resource
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Untag a resource
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagent.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an existing Amazon Bedrock Agent
     * </p>
     *
     * @param updateAgentRequest
     *        Update Agent Request
     * @return A Java Future containing the result of the UpdateAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.UpdateAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UpdateAgent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateAgentResponse> updateAgent(UpdateAgentRequest updateAgentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing Amazon Bedrock Agent
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAgentRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateAgentRequest#builder()}
     * </p>
     *
     * @param updateAgentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagent.model.UpdateAgentRequest.Builder} to create a request.
     *        Update Agent Request
     * @return A Java Future containing the result of the UpdateAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.UpdateAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UpdateAgent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateAgentResponse> updateAgent(Consumer<UpdateAgentRequest.Builder> updateAgentRequest) {
        return updateAgent(UpdateAgentRequest.builder().applyMutation(updateAgentRequest).build());
    }

    /**
     * <p>
     * Updates an existing Action Group for Amazon Bedrock Agent
     * </p>
     *
     * @param updateAgentActionGroupRequest
     *        Update Action Group Request
     * @return A Java Future containing the result of the UpdateAgentActionGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.UpdateAgentActionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UpdateAgentActionGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAgentActionGroupResponse> updateAgentActionGroup(
            UpdateAgentActionGroupRequest updateAgentActionGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing Action Group for Amazon Bedrock Agent
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAgentActionGroupRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateAgentActionGroupRequest#builder()}
     * </p>
     *
     * @param updateAgentActionGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagent.model.UpdateAgentActionGroupRequest.Builder} to create
     *        a request. Update Action Group Request
     * @return A Java Future containing the result of the UpdateAgentActionGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.UpdateAgentActionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UpdateAgentActionGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAgentActionGroupResponse> updateAgentActionGroup(
            Consumer<UpdateAgentActionGroupRequest.Builder> updateAgentActionGroupRequest) {
        return updateAgentActionGroup(UpdateAgentActionGroupRequest.builder().applyMutation(updateAgentActionGroupRequest)
                .build());
    }

    /**
     * <p>
     * Updates an existing Alias for an Amazon Bedrock Agent
     * </p>
     *
     * @param updateAgentAliasRequest
     *        Update Agent Alias Request
     * @return A Java Future containing the result of the UpdateAgentAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.UpdateAgentAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UpdateAgentAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAgentAliasResponse> updateAgentAlias(UpdateAgentAliasRequest updateAgentAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing Alias for an Amazon Bedrock Agent
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAgentAliasRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateAgentAliasRequest#builder()}
     * </p>
     *
     * @param updateAgentAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagent.model.UpdateAgentAliasRequest.Builder} to create a
     *        request. Update Agent Alias Request
     * @return A Java Future containing the result of the UpdateAgentAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.UpdateAgentAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UpdateAgentAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAgentAliasResponse> updateAgentAlias(
            Consumer<UpdateAgentAliasRequest.Builder> updateAgentAliasRequest) {
        return updateAgentAlias(UpdateAgentAliasRequest.builder().applyMutation(updateAgentAliasRequest).build());
    }

    /**
     * <p>
     * Updates an existing Knowledge Base associated to an Amazon Bedrock Agent
     * </p>
     *
     * @param updateAgentKnowledgeBaseRequest
     *        Update Agent Knowledge Base Request
     * @return A Java Future containing the result of the UpdateAgentKnowledgeBase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.UpdateAgentKnowledgeBase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UpdateAgentKnowledgeBase"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAgentKnowledgeBaseResponse> updateAgentKnowledgeBase(
            UpdateAgentKnowledgeBaseRequest updateAgentKnowledgeBaseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing Knowledge Base associated to an Amazon Bedrock Agent
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAgentKnowledgeBaseRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateAgentKnowledgeBaseRequest#builder()}
     * </p>
     *
     * @param updateAgentKnowledgeBaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagent.model.UpdateAgentKnowledgeBaseRequest.Builder} to
     *        create a request. Update Agent Knowledge Base Request
     * @return A Java Future containing the result of the UpdateAgentKnowledgeBase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.UpdateAgentKnowledgeBase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UpdateAgentKnowledgeBase"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAgentKnowledgeBaseResponse> updateAgentKnowledgeBase(
            Consumer<UpdateAgentKnowledgeBaseRequest.Builder> updateAgentKnowledgeBaseRequest) {
        return updateAgentKnowledgeBase(UpdateAgentKnowledgeBaseRequest.builder().applyMutation(updateAgentKnowledgeBaseRequest)
                .build());
    }

    /**
     * <p>
     * Update an existing data source
     * </p>
     *
     * @param updateDataSourceRequest
     * @return A Java Future containing the result of the UpdateDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.UpdateDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UpdateDataSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDataSourceResponse> updateDataSource(UpdateDataSourceRequest updateDataSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update an existing data source
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDataSourceRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateDataSourceRequest#builder()}
     * </p>
     *
     * @param updateDataSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagent.model.UpdateDataSourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.UpdateDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UpdateDataSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDataSourceResponse> updateDataSource(
            Consumer<UpdateDataSourceRequest.Builder> updateDataSourceRequest) {
        return updateDataSource(UpdateDataSourceRequest.builder().applyMutation(updateDataSourceRequest).build());
    }

    /**
     * <p>
     * Update an existing knowledge base
     * </p>
     *
     * @param updateKnowledgeBaseRequest
     * @return A Java Future containing the result of the UpdateKnowledgeBase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.UpdateKnowledgeBase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UpdateKnowledgeBase"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateKnowledgeBaseResponse> updateKnowledgeBase(
            UpdateKnowledgeBaseRequest updateKnowledgeBaseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update an existing knowledge base
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateKnowledgeBaseRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateKnowledgeBaseRequest#builder()}
     * </p>
     *
     * @param updateKnowledgeBaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagent.model.UpdateKnowledgeBaseRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateKnowledgeBase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException This exception is thrown when the request's input validation fails</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentAsyncClient.UpdateKnowledgeBase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UpdateKnowledgeBase"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateKnowledgeBaseResponse> updateKnowledgeBase(
            Consumer<UpdateKnowledgeBaseRequest.Builder> updateKnowledgeBaseRequest) {
        return updateKnowledgeBase(UpdateKnowledgeBaseRequest.builder().applyMutation(updateKnowledgeBaseRequest).build());
    }

    @Override
    default BedrockAgentServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link BedrockAgentAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static BedrockAgentAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link BedrockAgentAsyncClient}.
     */
    static BedrockAgentAsyncClientBuilder builder() {
        return new DefaultBedrockAgentAsyncClientBuilder();
    }
}
