/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the information of an agent version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AgentVersion implements SdkPojo, Serializable, ToCopyableBuilder<AgentVersion.Builder, AgentVersion> {
    private static final SdkField<String> AGENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentId").getter(getter(AgentVersion::agentId)).setter(setter(Builder::agentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentId").build()).build();

    private static final SdkField<String> AGENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentName").getter(getter(AgentVersion::agentName)).setter(setter(Builder::agentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentName").build()).build();

    private static final SdkField<String> AGENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentArn").getter(getter(AgentVersion::agentArn)).setter(setter(Builder::agentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentArn").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(AgentVersion::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<String> INSTRUCTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instruction").getter(getter(AgentVersion::instruction)).setter(setter(Builder::instruction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instruction").build()).build();

    private static final SdkField<String> AGENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentStatus").getter(getter(AgentVersion::agentStatusAsString)).setter(setter(Builder::agentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentStatus").build()).build();

    private static final SdkField<String> FOUNDATION_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("foundationModel").getter(getter(AgentVersion::foundationModel)).setter(setter(Builder::foundationModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("foundationModel").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(AgentVersion::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Integer> IDLE_SESSION_TTL_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("idleSessionTTLInSeconds")
            .getter(getter(AgentVersion::idleSessionTTLInSeconds)).setter(setter(Builder::idleSessionTTLInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idleSessionTTLInSeconds").build())
            .build();

    private static final SdkField<String> AGENT_RESOURCE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentResourceRoleArn").getter(getter(AgentVersion::agentResourceRoleArn))
            .setter(setter(Builder::agentResourceRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentResourceRoleArn").build())
            .build();

    private static final SdkField<String> CUSTOMER_ENCRYPTION_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customerEncryptionKeyArn").getter(getter(AgentVersion::customerEncryptionKeyArn))
            .setter(setter(Builder::customerEncryptionKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerEncryptionKeyArn").build())
            .build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(AgentVersion::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(AgentVersion::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<List<String>> FAILURE_REASONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("failureReasons")
            .getter(getter(AgentVersion::failureReasons))
            .setter(setter(Builder::failureReasons))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReasons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> RECOMMENDED_ACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("recommendedActions")
            .getter(getter(AgentVersion::recommendedActions))
            .setter(setter(Builder::recommendedActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendedActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<PromptOverrideConfiguration> PROMPT_OVERRIDE_CONFIGURATION_FIELD = SdkField
            .<PromptOverrideConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("promptOverrideConfiguration")
            .getter(getter(AgentVersion::promptOverrideConfiguration))
            .setter(setter(Builder::promptOverrideConfiguration))
            .constructor(PromptOverrideConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptOverrideConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ID_FIELD,
            AGENT_NAME_FIELD, AGENT_ARN_FIELD, VERSION_FIELD, INSTRUCTION_FIELD, AGENT_STATUS_FIELD, FOUNDATION_MODEL_FIELD,
            DESCRIPTION_FIELD, IDLE_SESSION_TTL_IN_SECONDS_FIELD, AGENT_RESOURCE_ROLE_ARN_FIELD,
            CUSTOMER_ENCRYPTION_KEY_ARN_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, FAILURE_REASONS_FIELD,
            RECOMMENDED_ACTIONS_FIELD, PROMPT_OVERRIDE_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String agentId;

    private final String agentName;

    private final String agentArn;

    private final String version;

    private final String instruction;

    private final String agentStatus;

    private final String foundationModel;

    private final String description;

    private final Integer idleSessionTTLInSeconds;

    private final String agentResourceRoleArn;

    private final String customerEncryptionKeyArn;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final List<String> failureReasons;

    private final List<String> recommendedActions;

    private final PromptOverrideConfiguration promptOverrideConfiguration;

    private AgentVersion(BuilderImpl builder) {
        this.agentId = builder.agentId;
        this.agentName = builder.agentName;
        this.agentArn = builder.agentArn;
        this.version = builder.version;
        this.instruction = builder.instruction;
        this.agentStatus = builder.agentStatus;
        this.foundationModel = builder.foundationModel;
        this.description = builder.description;
        this.idleSessionTTLInSeconds = builder.idleSessionTTLInSeconds;
        this.agentResourceRoleArn = builder.agentResourceRoleArn;
        this.customerEncryptionKeyArn = builder.customerEncryptionKeyArn;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.failureReasons = builder.failureReasons;
        this.recommendedActions = builder.recommendedActions;
        this.promptOverrideConfiguration = builder.promptOverrideConfiguration;
    }

    /**
     * Returns the value of the AgentId property for this object.
     * 
     * @return The value of the AgentId property for this object.
     */
    public final String agentId() {
        return agentId;
    }

    /**
     * Returns the value of the AgentName property for this object.
     * 
     * @return The value of the AgentName property for this object.
     */
    public final String agentName() {
        return agentName;
    }

    /**
     * Returns the value of the AgentArn property for this object.
     * 
     * @return The value of the AgentArn property for this object.
     */
    public final String agentArn() {
        return agentArn;
    }

    /**
     * Returns the value of the Version property for this object.
     * 
     * @return The value of the Version property for this object.
     */
    public final String version() {
        return version;
    }

    /**
     * Returns the value of the Instruction property for this object.
     * 
     * @return The value of the Instruction property for this object.
     */
    public final String instruction() {
        return instruction;
    }

    /**
     * Returns the value of the AgentStatus property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #agentStatus} will
     * return {@link AgentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #agentStatusAsString}.
     * </p>
     * 
     * @return The value of the AgentStatus property for this object.
     * @see AgentStatus
     */
    public final AgentStatus agentStatus() {
        return AgentStatus.fromValue(agentStatus);
    }

    /**
     * Returns the value of the AgentStatus property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #agentStatus} will
     * return {@link AgentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #agentStatusAsString}.
     * </p>
     * 
     * @return The value of the AgentStatus property for this object.
     * @see AgentStatus
     */
    public final String agentStatusAsString() {
        return agentStatus;
    }

    /**
     * Returns the value of the FoundationModel property for this object.
     * 
     * @return The value of the FoundationModel property for this object.
     */
    public final String foundationModel() {
        return foundationModel;
    }

    /**
     * Returns the value of the Description property for this object.
     * 
     * @return The value of the Description property for this object.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns the value of the IdleSessionTTLInSeconds property for this object.
     * 
     * @return The value of the IdleSessionTTLInSeconds property for this object.
     */
    public final Integer idleSessionTTLInSeconds() {
        return idleSessionTTLInSeconds;
    }

    /**
     * Returns the value of the AgentResourceRoleArn property for this object.
     * 
     * @return The value of the AgentResourceRoleArn property for this object.
     */
    public final String agentResourceRoleArn() {
        return agentResourceRoleArn;
    }

    /**
     * Returns the value of the CustomerEncryptionKeyArn property for this object.
     * 
     * @return The value of the CustomerEncryptionKeyArn property for this object.
     */
    public final String customerEncryptionKeyArn() {
        return customerEncryptionKeyArn;
    }

    /**
     * Returns the value of the CreatedAt property for this object.
     * 
     * @return The value of the CreatedAt property for this object.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * Returns the value of the UpdatedAt property for this object.
     * 
     * @return The value of the UpdatedAt property for this object.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailureReasons property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFailureReasons() {
        return failureReasons != null && !(failureReasons instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the FailureReasons property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailureReasons} method.
     * </p>
     * 
     * @return The value of the FailureReasons property for this object.
     */
    public final List<String> failureReasons() {
        return failureReasons;
    }

    /**
     * For responses, this returns true if the service returned a value for the RecommendedActions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRecommendedActions() {
        return recommendedActions != null && !(recommendedActions instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the RecommendedActions property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecommendedActions} method.
     * </p>
     * 
     * @return The value of the RecommendedActions property for this object.
     */
    public final List<String> recommendedActions() {
        return recommendedActions;
    }

    /**
     * Returns the value of the PromptOverrideConfiguration property for this object.
     * 
     * @return The value of the PromptOverrideConfiguration property for this object.
     */
    public final PromptOverrideConfiguration promptOverrideConfiguration() {
        return promptOverrideConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agentId());
        hashCode = 31 * hashCode + Objects.hashCode(agentName());
        hashCode = 31 * hashCode + Objects.hashCode(agentArn());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(instruction());
        hashCode = 31 * hashCode + Objects.hashCode(agentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(foundationModel());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(idleSessionTTLInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(agentResourceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(customerEncryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasFailureReasons() ? failureReasons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRecommendedActions() ? recommendedActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(promptOverrideConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentVersion)) {
            return false;
        }
        AgentVersion other = (AgentVersion) obj;
        return Objects.equals(agentId(), other.agentId()) && Objects.equals(agentName(), other.agentName())
                && Objects.equals(agentArn(), other.agentArn()) && Objects.equals(version(), other.version())
                && Objects.equals(instruction(), other.instruction())
                && Objects.equals(agentStatusAsString(), other.agentStatusAsString())
                && Objects.equals(foundationModel(), other.foundationModel())
                && Objects.equals(description(), other.description())
                && Objects.equals(idleSessionTTLInSeconds(), other.idleSessionTTLInSeconds())
                && Objects.equals(agentResourceRoleArn(), other.agentResourceRoleArn())
                && Objects.equals(customerEncryptionKeyArn(), other.customerEncryptionKeyArn())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(updatedAt(), other.updatedAt())
                && hasFailureReasons() == other.hasFailureReasons() && Objects.equals(failureReasons(), other.failureReasons())
                && hasRecommendedActions() == other.hasRecommendedActions()
                && Objects.equals(recommendedActions(), other.recommendedActions())
                && Objects.equals(promptOverrideConfiguration(), other.promptOverrideConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("AgentVersion")
                .add("AgentId", agentId())
                .add("AgentName", agentName())
                .add("AgentArn", agentArn())
                .add("Version", version())
                .add("Instruction", instruction() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AgentStatus", agentStatusAsString())
                .add("FoundationModel", foundationModel())
                .add("Description", description())
                .add("IdleSessionTTLInSeconds", idleSessionTTLInSeconds())
                .add("AgentResourceRoleArn", agentResourceRoleArn())
                .add("CustomerEncryptionKeyArn", customerEncryptionKeyArn())
                .add("CreatedAt", createdAt())
                .add("UpdatedAt", updatedAt())
                .add("FailureReasons", hasFailureReasons() ? failureReasons() : null)
                .add("RecommendedActions", hasRecommendedActions() ? recommendedActions() : null)
                .add("PromptOverrideConfiguration",
                        promptOverrideConfiguration() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentId":
            return Optional.ofNullable(clazz.cast(agentId()));
        case "agentName":
            return Optional.ofNullable(clazz.cast(agentName()));
        case "agentArn":
            return Optional.ofNullable(clazz.cast(agentArn()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "instruction":
            return Optional.ofNullable(clazz.cast(instruction()));
        case "agentStatus":
            return Optional.ofNullable(clazz.cast(agentStatusAsString()));
        case "foundationModel":
            return Optional.ofNullable(clazz.cast(foundationModel()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "idleSessionTTLInSeconds":
            return Optional.ofNullable(clazz.cast(idleSessionTTLInSeconds()));
        case "agentResourceRoleArn":
            return Optional.ofNullable(clazz.cast(agentResourceRoleArn()));
        case "customerEncryptionKeyArn":
            return Optional.ofNullable(clazz.cast(customerEncryptionKeyArn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "failureReasons":
            return Optional.ofNullable(clazz.cast(failureReasons()));
        case "recommendedActions":
            return Optional.ofNullable(clazz.cast(recommendedActions()));
        case "promptOverrideConfiguration":
            return Optional.ofNullable(clazz.cast(promptOverrideConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AgentVersion, T> g) {
        return obj -> g.apply((AgentVersion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AgentVersion> {
        /**
         * Sets the value of the AgentId property for this object.
         *
         * @param agentId
         *        The new value for the AgentId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentId(String agentId);

        /**
         * Sets the value of the AgentName property for this object.
         *
         * @param agentName
         *        The new value for the AgentName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentName(String agentName);

        /**
         * Sets the value of the AgentArn property for this object.
         *
         * @param agentArn
         *        The new value for the AgentArn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentArn(String agentArn);

        /**
         * Sets the value of the Version property for this object.
         *
         * @param version
         *        The new value for the Version property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * Sets the value of the Instruction property for this object.
         *
         * @param instruction
         *        The new value for the Instruction property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instruction(String instruction);

        /**
         * Sets the value of the AgentStatus property for this object.
         *
         * @param agentStatus
         *        The new value for the AgentStatus property for this object.
         * @see AgentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentStatus
         */
        Builder agentStatus(String agentStatus);

        /**
         * Sets the value of the AgentStatus property for this object.
         *
         * @param agentStatus
         *        The new value for the AgentStatus property for this object.
         * @see AgentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentStatus
         */
        Builder agentStatus(AgentStatus agentStatus);

        /**
         * Sets the value of the FoundationModel property for this object.
         *
         * @param foundationModel
         *        The new value for the FoundationModel property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder foundationModel(String foundationModel);

        /**
         * Sets the value of the Description property for this object.
         *
         * @param description
         *        The new value for the Description property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * Sets the value of the IdleSessionTTLInSeconds property for this object.
         *
         * @param idleSessionTTLInSeconds
         *        The new value for the IdleSessionTTLInSeconds property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idleSessionTTLInSeconds(Integer idleSessionTTLInSeconds);

        /**
         * Sets the value of the AgentResourceRoleArn property for this object.
         *
         * @param agentResourceRoleArn
         *        The new value for the AgentResourceRoleArn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentResourceRoleArn(String agentResourceRoleArn);

        /**
         * Sets the value of the CustomerEncryptionKeyArn property for this object.
         *
         * @param customerEncryptionKeyArn
         *        The new value for the CustomerEncryptionKeyArn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerEncryptionKeyArn(String customerEncryptionKeyArn);

        /**
         * Sets the value of the CreatedAt property for this object.
         *
         * @param createdAt
         *        The new value for the CreatedAt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * Sets the value of the UpdatedAt property for this object.
         *
         * @param updatedAt
         *        The new value for the UpdatedAt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * Sets the value of the FailureReasons property for this object.
         *
         * @param failureReasons
         *        The new value for the FailureReasons property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReasons(Collection<String> failureReasons);

        /**
         * Sets the value of the FailureReasons property for this object.
         *
         * @param failureReasons
         *        The new value for the FailureReasons property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReasons(String... failureReasons);

        /**
         * Sets the value of the RecommendedActions property for this object.
         *
         * @param recommendedActions
         *        The new value for the RecommendedActions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendedActions(Collection<String> recommendedActions);

        /**
         * Sets the value of the RecommendedActions property for this object.
         *
         * @param recommendedActions
         *        The new value for the RecommendedActions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendedActions(String... recommendedActions);

        /**
         * Sets the value of the PromptOverrideConfiguration property for this object.
         *
         * @param promptOverrideConfiguration
         *        The new value for the PromptOverrideConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promptOverrideConfiguration(PromptOverrideConfiguration promptOverrideConfiguration);

        /**
         * Sets the value of the PromptOverrideConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link PromptOverrideConfiguration.Builder}
         * avoiding the need to create one manually via {@link PromptOverrideConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PromptOverrideConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #promptOverrideConfiguration(PromptOverrideConfiguration)}.
         * 
         * @param promptOverrideConfiguration
         *        a consumer that will call methods on {@link PromptOverrideConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #promptOverrideConfiguration(PromptOverrideConfiguration)
         */
        default Builder promptOverrideConfiguration(Consumer<PromptOverrideConfiguration.Builder> promptOverrideConfiguration) {
            return promptOverrideConfiguration(PromptOverrideConfiguration.builder().applyMutation(promptOverrideConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String agentId;

        private String agentName;

        private String agentArn;

        private String version;

        private String instruction;

        private String agentStatus;

        private String foundationModel;

        private String description;

        private Integer idleSessionTTLInSeconds;

        private String agentResourceRoleArn;

        private String customerEncryptionKeyArn;

        private Instant createdAt;

        private Instant updatedAt;

        private List<String> failureReasons = DefaultSdkAutoConstructList.getInstance();

        private List<String> recommendedActions = DefaultSdkAutoConstructList.getInstance();

        private PromptOverrideConfiguration promptOverrideConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentVersion model) {
            agentId(model.agentId);
            agentName(model.agentName);
            agentArn(model.agentArn);
            version(model.version);
            instruction(model.instruction);
            agentStatus(model.agentStatus);
            foundationModel(model.foundationModel);
            description(model.description);
            idleSessionTTLInSeconds(model.idleSessionTTLInSeconds);
            agentResourceRoleArn(model.agentResourceRoleArn);
            customerEncryptionKeyArn(model.customerEncryptionKeyArn);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            failureReasons(model.failureReasons);
            recommendedActions(model.recommendedActions);
            promptOverrideConfiguration(model.promptOverrideConfiguration);
        }

        public final String getAgentId() {
            return agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final String getAgentName() {
            return agentName;
        }

        public final void setAgentName(String agentName) {
            this.agentName = agentName;
        }

        @Override
        public final Builder agentName(String agentName) {
            this.agentName = agentName;
            return this;
        }

        public final String getAgentArn() {
            return agentArn;
        }

        public final void setAgentArn(String agentArn) {
            this.agentArn = agentArn;
        }

        @Override
        public final Builder agentArn(String agentArn) {
            this.agentArn = agentArn;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getInstruction() {
            return instruction;
        }

        public final void setInstruction(String instruction) {
            this.instruction = instruction;
        }

        @Override
        public final Builder instruction(String instruction) {
            this.instruction = instruction;
            return this;
        }

        public final String getAgentStatus() {
            return agentStatus;
        }

        public final void setAgentStatus(String agentStatus) {
            this.agentStatus = agentStatus;
        }

        @Override
        public final Builder agentStatus(String agentStatus) {
            this.agentStatus = agentStatus;
            return this;
        }

        @Override
        public final Builder agentStatus(AgentStatus agentStatus) {
            this.agentStatus(agentStatus == null ? null : agentStatus.toString());
            return this;
        }

        public final String getFoundationModel() {
            return foundationModel;
        }

        public final void setFoundationModel(String foundationModel) {
            this.foundationModel = foundationModel;
        }

        @Override
        public final Builder foundationModel(String foundationModel) {
            this.foundationModel = foundationModel;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getIdleSessionTTLInSeconds() {
            return idleSessionTTLInSeconds;
        }

        public final void setIdleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
        }

        @Override
        public final Builder idleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
            return this;
        }

        public final String getAgentResourceRoleArn() {
            return agentResourceRoleArn;
        }

        public final void setAgentResourceRoleArn(String agentResourceRoleArn) {
            this.agentResourceRoleArn = agentResourceRoleArn;
        }

        @Override
        public final Builder agentResourceRoleArn(String agentResourceRoleArn) {
            this.agentResourceRoleArn = agentResourceRoleArn;
            return this;
        }

        public final String getCustomerEncryptionKeyArn() {
            return customerEncryptionKeyArn;
        }

        public final void setCustomerEncryptionKeyArn(String customerEncryptionKeyArn) {
            this.customerEncryptionKeyArn = customerEncryptionKeyArn;
        }

        @Override
        public final Builder customerEncryptionKeyArn(String customerEncryptionKeyArn) {
            this.customerEncryptionKeyArn = customerEncryptionKeyArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Collection<String> getFailureReasons() {
            if (failureReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return failureReasons;
        }

        public final void setFailureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
        }

        @Override
        public final Builder failureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failureReasons(String... failureReasons) {
            failureReasons(Arrays.asList(failureReasons));
            return this;
        }

        public final Collection<String> getRecommendedActions() {
            if (recommendedActions instanceof SdkAutoConstructList) {
                return null;
            }
            return recommendedActions;
        }

        public final void setRecommendedActions(Collection<String> recommendedActions) {
            this.recommendedActions = RecommendedActionsCopier.copy(recommendedActions);
        }

        @Override
        public final Builder recommendedActions(Collection<String> recommendedActions) {
            this.recommendedActions = RecommendedActionsCopier.copy(recommendedActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendedActions(String... recommendedActions) {
            recommendedActions(Arrays.asList(recommendedActions));
            return this;
        }

        public final PromptOverrideConfiguration.Builder getPromptOverrideConfiguration() {
            return promptOverrideConfiguration != null ? promptOverrideConfiguration.toBuilder() : null;
        }

        public final void setPromptOverrideConfiguration(PromptOverrideConfiguration.BuilderImpl promptOverrideConfiguration) {
            this.promptOverrideConfiguration = promptOverrideConfiguration != null ? promptOverrideConfiguration.build() : null;
        }

        @Override
        public final Builder promptOverrideConfiguration(PromptOverrideConfiguration promptOverrideConfiguration) {
            this.promptOverrideConfiguration = promptOverrideConfiguration;
            return this;
        }

        @Override
        public AgentVersion build() {
            return new AgentVersion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
