/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A mapping of Bedrock Knowledge Base fields to Pinecone field names
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PineconeFieldMapping implements SdkPojo, Serializable,
        ToCopyableBuilder<PineconeFieldMapping.Builder, PineconeFieldMapping> {
    private static final SdkField<String> TEXT_FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("textField").getter(getter(PineconeFieldMapping::textField)).setter(setter(Builder::textField))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("textField").build()).build();

    private static final SdkField<String> METADATA_FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metadataField").getter(getter(PineconeFieldMapping::metadataField))
            .setter(setter(Builder::metadataField))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataField").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_FIELD_FIELD,
            METADATA_FIELD_FIELD));

    private static final long serialVersionUID = 1L;

    private final String textField;

    private final String metadataField;

    private PineconeFieldMapping(BuilderImpl builder) {
        this.textField = builder.textField;
        this.metadataField = builder.metadataField;
    }

    /**
     * Returns the value of the TextField property for this object.
     * 
     * @return The value of the TextField property for this object.
     */
    public final String textField() {
        return textField;
    }

    /**
     * Returns the value of the MetadataField property for this object.
     * 
     * @return The value of the MetadataField property for this object.
     */
    public final String metadataField() {
        return metadataField;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(textField());
        hashCode = 31 * hashCode + Objects.hashCode(metadataField());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PineconeFieldMapping)) {
            return false;
        }
        PineconeFieldMapping other = (PineconeFieldMapping) obj;
        return Objects.equals(textField(), other.textField()) && Objects.equals(metadataField(), other.metadataField());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PineconeFieldMapping").add("TextField", textField()).add("MetadataField", metadataField())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "textField":
            return Optional.ofNullable(clazz.cast(textField()));
        case "metadataField":
            return Optional.ofNullable(clazz.cast(metadataField()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PineconeFieldMapping, T> g) {
        return obj -> g.apply((PineconeFieldMapping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PineconeFieldMapping> {
        /**
         * Sets the value of the TextField property for this object.
         *
         * @param textField
         *        The new value for the TextField property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textField(String textField);

        /**
         * Sets the value of the MetadataField property for this object.
         *
         * @param metadataField
         *        The new value for the MetadataField property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataField(String metadataField);
    }

    static final class BuilderImpl implements Builder {
        private String textField;

        private String metadataField;

        private BuilderImpl() {
        }

        private BuilderImpl(PineconeFieldMapping model) {
            textField(model.textField);
            metadataField(model.metadataField);
        }

        public final String getTextField() {
            return textField;
        }

        public final void setTextField(String textField) {
            this.textField = textField;
        }

        @Override
        public final Builder textField(String textField) {
            this.textField = textField;
            return this;
        }

        public final String getMetadataField() {
            return metadataField;
        }

        public final void setMetadataField(String metadataField) {
            this.metadataField = metadataField;
        }

        @Override
        public final Builder metadataField(String metadataField) {
            this.metadataField = metadataField;
            return this;
        }

        @Override
        public PineconeFieldMapping build() {
            return new PineconeFieldMapping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
