/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configures the physical storage of ingested data in a knowledge base.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StorageConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<StorageConfiguration.Builder, StorageConfiguration> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(StorageConfiguration::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<OpenSearchServerlessConfiguration> OPENSEARCH_SERVERLESS_CONFIGURATION_FIELD = SdkField
            .<OpenSearchServerlessConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("opensearchServerlessConfiguration")
            .getter(getter(StorageConfiguration::opensearchServerlessConfiguration))
            .setter(setter(Builder::opensearchServerlessConfiguration))
            .constructor(OpenSearchServerlessConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("opensearchServerlessConfiguration")
                    .build()).build();

    private static final SdkField<PineconeConfiguration> PINECONE_CONFIGURATION_FIELD = SdkField
            .<PineconeConfiguration> builder(MarshallingType.SDK_POJO).memberName("pineconeConfiguration")
            .getter(getter(StorageConfiguration::pineconeConfiguration)).setter(setter(Builder::pineconeConfiguration))
            .constructor(PineconeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pineconeConfiguration").build())
            .build();

    private static final SdkField<RedisEnterpriseCloudConfiguration> REDIS_ENTERPRISE_CLOUD_CONFIGURATION_FIELD = SdkField
            .<RedisEnterpriseCloudConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("redisEnterpriseCloudConfiguration")
            .getter(getter(StorageConfiguration::redisEnterpriseCloudConfiguration))
            .setter(setter(Builder::redisEnterpriseCloudConfiguration))
            .constructor(RedisEnterpriseCloudConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redisEnterpriseCloudConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            OPENSEARCH_SERVERLESS_CONFIGURATION_FIELD, PINECONE_CONFIGURATION_FIELD, REDIS_ENTERPRISE_CLOUD_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final OpenSearchServerlessConfiguration opensearchServerlessConfiguration;

    private final PineconeConfiguration pineconeConfiguration;

    private final RedisEnterpriseCloudConfiguration redisEnterpriseCloudConfiguration;

    private StorageConfiguration(BuilderImpl builder) {
        this.type = builder.type;
        this.opensearchServerlessConfiguration = builder.opensearchServerlessConfiguration;
        this.pineconeConfiguration = builder.pineconeConfiguration;
        this.redisEnterpriseCloudConfiguration = builder.redisEnterpriseCloudConfiguration;
    }

    /**
     * Returns the value of the Type property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link KnowledgeBaseStorageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The value of the Type property for this object.
     * @see KnowledgeBaseStorageType
     */
    public final KnowledgeBaseStorageType type() {
        return KnowledgeBaseStorageType.fromValue(type);
    }

    /**
     * Returns the value of the Type property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link KnowledgeBaseStorageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The value of the Type property for this object.
     * @see KnowledgeBaseStorageType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * Returns the value of the OpensearchServerlessConfiguration property for this object.
     * 
     * @return The value of the OpensearchServerlessConfiguration property for this object.
     */
    public final OpenSearchServerlessConfiguration opensearchServerlessConfiguration() {
        return opensearchServerlessConfiguration;
    }

    /**
     * Returns the value of the PineconeConfiguration property for this object.
     * 
     * @return The value of the PineconeConfiguration property for this object.
     */
    public final PineconeConfiguration pineconeConfiguration() {
        return pineconeConfiguration;
    }

    /**
     * Returns the value of the RedisEnterpriseCloudConfiguration property for this object.
     * 
     * @return The value of the RedisEnterpriseCloudConfiguration property for this object.
     */
    public final RedisEnterpriseCloudConfiguration redisEnterpriseCloudConfiguration() {
        return redisEnterpriseCloudConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(opensearchServerlessConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(pineconeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(redisEnterpriseCloudConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageConfiguration)) {
            return false;
        }
        StorageConfiguration other = (StorageConfiguration) obj;
        return Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(opensearchServerlessConfiguration(), other.opensearchServerlessConfiguration())
                && Objects.equals(pineconeConfiguration(), other.pineconeConfiguration())
                && Objects.equals(redisEnterpriseCloudConfiguration(), other.redisEnterpriseCloudConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StorageConfiguration").add("Type", typeAsString())
                .add("OpensearchServerlessConfiguration", opensearchServerlessConfiguration())
                .add("PineconeConfiguration", pineconeConfiguration())
                .add("RedisEnterpriseCloudConfiguration", redisEnterpriseCloudConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "opensearchServerlessConfiguration":
            return Optional.ofNullable(clazz.cast(opensearchServerlessConfiguration()));
        case "pineconeConfiguration":
            return Optional.ofNullable(clazz.cast(pineconeConfiguration()));
        case "redisEnterpriseCloudConfiguration":
            return Optional.ofNullable(clazz.cast(redisEnterpriseCloudConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StorageConfiguration, T> g) {
        return obj -> g.apply((StorageConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StorageConfiguration> {
        /**
         * Sets the value of the Type property for this object.
         *
         * @param type
         *        The new value for the Type property for this object.
         * @see KnowledgeBaseStorageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KnowledgeBaseStorageType
         */
        Builder type(String type);

        /**
         * Sets the value of the Type property for this object.
         *
         * @param type
         *        The new value for the Type property for this object.
         * @see KnowledgeBaseStorageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KnowledgeBaseStorageType
         */
        Builder type(KnowledgeBaseStorageType type);

        /**
         * Sets the value of the OpensearchServerlessConfiguration property for this object.
         *
         * @param opensearchServerlessConfiguration
         *        The new value for the OpensearchServerlessConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opensearchServerlessConfiguration(OpenSearchServerlessConfiguration opensearchServerlessConfiguration);

        /**
         * Sets the value of the OpensearchServerlessConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link OpenSearchServerlessConfiguration.Builder} avoiding the need to create one manually via
         * {@link OpenSearchServerlessConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OpenSearchServerlessConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #opensearchServerlessConfiguration(OpenSearchServerlessConfiguration)}.
         * 
         * @param opensearchServerlessConfiguration
         *        a consumer that will call methods on {@link OpenSearchServerlessConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #opensearchServerlessConfiguration(OpenSearchServerlessConfiguration)
         */
        default Builder opensearchServerlessConfiguration(
                Consumer<OpenSearchServerlessConfiguration.Builder> opensearchServerlessConfiguration) {
            return opensearchServerlessConfiguration(OpenSearchServerlessConfiguration.builder()
                    .applyMutation(opensearchServerlessConfiguration).build());
        }

        /**
         * Sets the value of the PineconeConfiguration property for this object.
         *
         * @param pineconeConfiguration
         *        The new value for the PineconeConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pineconeConfiguration(PineconeConfiguration pineconeConfiguration);

        /**
         * Sets the value of the PineconeConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link PineconeConfiguration.Builder} avoiding
         * the need to create one manually via {@link PineconeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PineconeConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #pineconeConfiguration(PineconeConfiguration)}.
         * 
         * @param pineconeConfiguration
         *        a consumer that will call methods on {@link PineconeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pineconeConfiguration(PineconeConfiguration)
         */
        default Builder pineconeConfiguration(Consumer<PineconeConfiguration.Builder> pineconeConfiguration) {
            return pineconeConfiguration(PineconeConfiguration.builder().applyMutation(pineconeConfiguration).build());
        }

        /**
         * Sets the value of the RedisEnterpriseCloudConfiguration property for this object.
         *
         * @param redisEnterpriseCloudConfiguration
         *        The new value for the RedisEnterpriseCloudConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redisEnterpriseCloudConfiguration(RedisEnterpriseCloudConfiguration redisEnterpriseCloudConfiguration);

        /**
         * Sets the value of the RedisEnterpriseCloudConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link RedisEnterpriseCloudConfiguration.Builder} avoiding the need to create one manually via
         * {@link RedisEnterpriseCloudConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RedisEnterpriseCloudConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #redisEnterpriseCloudConfiguration(RedisEnterpriseCloudConfiguration)}.
         * 
         * @param redisEnterpriseCloudConfiguration
         *        a consumer that will call methods on {@link RedisEnterpriseCloudConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #redisEnterpriseCloudConfiguration(RedisEnterpriseCloudConfiguration)
         */
        default Builder redisEnterpriseCloudConfiguration(
                Consumer<RedisEnterpriseCloudConfiguration.Builder> redisEnterpriseCloudConfiguration) {
            return redisEnterpriseCloudConfiguration(RedisEnterpriseCloudConfiguration.builder()
                    .applyMutation(redisEnterpriseCloudConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private OpenSearchServerlessConfiguration opensearchServerlessConfiguration;

        private PineconeConfiguration pineconeConfiguration;

        private RedisEnterpriseCloudConfiguration redisEnterpriseCloudConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(StorageConfiguration model) {
            type(model.type);
            opensearchServerlessConfiguration(model.opensearchServerlessConfiguration);
            pineconeConfiguration(model.pineconeConfiguration);
            redisEnterpriseCloudConfiguration(model.redisEnterpriseCloudConfiguration);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(KnowledgeBaseStorageType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final OpenSearchServerlessConfiguration.Builder getOpensearchServerlessConfiguration() {
            return opensearchServerlessConfiguration != null ? opensearchServerlessConfiguration.toBuilder() : null;
        }

        public final void setOpensearchServerlessConfiguration(
                OpenSearchServerlessConfiguration.BuilderImpl opensearchServerlessConfiguration) {
            this.opensearchServerlessConfiguration = opensearchServerlessConfiguration != null ? opensearchServerlessConfiguration
                    .build() : null;
        }

        @Override
        public final Builder opensearchServerlessConfiguration(OpenSearchServerlessConfiguration opensearchServerlessConfiguration) {
            this.opensearchServerlessConfiguration = opensearchServerlessConfiguration;
            return this;
        }

        public final PineconeConfiguration.Builder getPineconeConfiguration() {
            return pineconeConfiguration != null ? pineconeConfiguration.toBuilder() : null;
        }

        public final void setPineconeConfiguration(PineconeConfiguration.BuilderImpl pineconeConfiguration) {
            this.pineconeConfiguration = pineconeConfiguration != null ? pineconeConfiguration.build() : null;
        }

        @Override
        public final Builder pineconeConfiguration(PineconeConfiguration pineconeConfiguration) {
            this.pineconeConfiguration = pineconeConfiguration;
            return this;
        }

        public final RedisEnterpriseCloudConfiguration.Builder getRedisEnterpriseCloudConfiguration() {
            return redisEnterpriseCloudConfiguration != null ? redisEnterpriseCloudConfiguration.toBuilder() : null;
        }

        public final void setRedisEnterpriseCloudConfiguration(
                RedisEnterpriseCloudConfiguration.BuilderImpl redisEnterpriseCloudConfiguration) {
            this.redisEnterpriseCloudConfiguration = redisEnterpriseCloudConfiguration != null ? redisEnterpriseCloudConfiguration
                    .build() : null;
        }

        @Override
        public final Builder redisEnterpriseCloudConfiguration(RedisEnterpriseCloudConfiguration redisEnterpriseCloudConfiguration) {
            this.redisEnterpriseCloudConfiguration = redisEnterpriseCloudConfiguration;
            return this;
        }

        @Override
        public StorageConfiguration build() {
            return new StorageConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
