/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDataSourceRequest extends BedrockAgentRequest implements
        ToCopyableBuilder<UpdateDataSourceRequest.Builder, UpdateDataSourceRequest> {
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseId").getter(getter(UpdateDataSourceRequest::knowledgeBaseId))
            .setter(setter(Builder::knowledgeBaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("knowledgeBaseId").build()).build();

    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSourceId").getter(getter(UpdateDataSourceRequest::dataSourceId))
            .setter(setter(Builder::dataSourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("dataSourceId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateDataSourceRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateDataSourceRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<DataSourceConfiguration> DATA_SOURCE_CONFIGURATION_FIELD = SdkField
            .<DataSourceConfiguration> builder(MarshallingType.SDK_POJO).memberName("dataSourceConfiguration")
            .getter(getter(UpdateDataSourceRequest::dataSourceConfiguration)).setter(setter(Builder::dataSourceConfiguration))
            .constructor(DataSourceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceConfiguration").build())
            .build();

    private static final SdkField<ServerSideEncryptionConfiguration> SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<ServerSideEncryptionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("serverSideEncryptionConfiguration")
            .getter(getter(UpdateDataSourceRequest::serverSideEncryptionConfiguration))
            .setter(setter(Builder::serverSideEncryptionConfiguration))
            .constructor(ServerSideEncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverSideEncryptionConfiguration")
                    .build()).build();

    private static final SdkField<VectorIngestionConfiguration> VECTOR_INGESTION_CONFIGURATION_FIELD = SdkField
            .<VectorIngestionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("vectorIngestionConfiguration")
            .getter(getter(UpdateDataSourceRequest::vectorIngestionConfiguration))
            .setter(setter(Builder::vectorIngestionConfiguration))
            .constructor(VectorIngestionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectorIngestionConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KNOWLEDGE_BASE_ID_FIELD,
            DATA_SOURCE_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, DATA_SOURCE_CONFIGURATION_FIELD,
            SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD, VECTOR_INGESTION_CONFIGURATION_FIELD));

    private final String knowledgeBaseId;

    private final String dataSourceId;

    private final String name;

    private final String description;

    private final DataSourceConfiguration dataSourceConfiguration;

    private final ServerSideEncryptionConfiguration serverSideEncryptionConfiguration;

    private final VectorIngestionConfiguration vectorIngestionConfiguration;

    private UpdateDataSourceRequest(BuilderImpl builder) {
        super(builder);
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.dataSourceId = builder.dataSourceId;
        this.name = builder.name;
        this.description = builder.description;
        this.dataSourceConfiguration = builder.dataSourceConfiguration;
        this.serverSideEncryptionConfiguration = builder.serverSideEncryptionConfiguration;
        this.vectorIngestionConfiguration = builder.vectorIngestionConfiguration;
    }

    /**
     * Returns the value of the KnowledgeBaseId property for this object.
     * 
     * @return The value of the KnowledgeBaseId property for this object.
     */
    public final String knowledgeBaseId() {
        return knowledgeBaseId;
    }

    /**
     * Returns the value of the DataSourceId property for this object.
     * 
     * @return The value of the DataSourceId property for this object.
     */
    public final String dataSourceId() {
        return dataSourceId;
    }

    /**
     * Returns the value of the Name property for this object.
     * 
     * @return The value of the Name property for this object.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns the value of the Description property for this object.
     * 
     * @return The value of the Description property for this object.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns the value of the DataSourceConfiguration property for this object.
     * 
     * @return The value of the DataSourceConfiguration property for this object.
     */
    public final DataSourceConfiguration dataSourceConfiguration() {
        return dataSourceConfiguration;
    }

    /**
     * Returns the value of the ServerSideEncryptionConfiguration property for this object.
     * 
     * @return The value of the ServerSideEncryptionConfiguration property for this object.
     */
    public final ServerSideEncryptionConfiguration serverSideEncryptionConfiguration() {
        return serverSideEncryptionConfiguration;
    }

    /**
     * Returns the value of the VectorIngestionConfiguration property for this object.
     * 
     * @return The value of the VectorIngestionConfiguration property for this object.
     */
    public final VectorIngestionConfiguration vectorIngestionConfiguration() {
        return vectorIngestionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(serverSideEncryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(vectorIngestionConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDataSourceRequest)) {
            return false;
        }
        UpdateDataSourceRequest other = (UpdateDataSourceRequest) obj;
        return Objects.equals(knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(dataSourceId(), other.dataSourceId())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(dataSourceConfiguration(), other.dataSourceConfiguration())
                && Objects.equals(serverSideEncryptionConfiguration(), other.serverSideEncryptionConfiguration())
                && Objects.equals(vectorIngestionConfiguration(), other.vectorIngestionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDataSourceRequest").add("KnowledgeBaseId", knowledgeBaseId())
                .add("DataSourceId", dataSourceId()).add("Name", name()).add("Description", description())
                .add("DataSourceConfiguration", dataSourceConfiguration())
                .add("ServerSideEncryptionConfiguration", serverSideEncryptionConfiguration())
                .add("VectorIngestionConfiguration", vectorIngestionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "knowledgeBaseId":
            return Optional.ofNullable(clazz.cast(knowledgeBaseId()));
        case "dataSourceId":
            return Optional.ofNullable(clazz.cast(dataSourceId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "dataSourceConfiguration":
            return Optional.ofNullable(clazz.cast(dataSourceConfiguration()));
        case "serverSideEncryptionConfiguration":
            return Optional.ofNullable(clazz.cast(serverSideEncryptionConfiguration()));
        case "vectorIngestionConfiguration":
            return Optional.ofNullable(clazz.cast(vectorIngestionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDataSourceRequest, T> g) {
        return obj -> g.apply((UpdateDataSourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockAgentRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDataSourceRequest> {
        /**
         * Sets the value of the KnowledgeBaseId property for this object.
         *
         * @param knowledgeBaseId
         *        The new value for the KnowledgeBaseId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseId(String knowledgeBaseId);

        /**
         * Sets the value of the DataSourceId property for this object.
         *
         * @param dataSourceId
         *        The new value for the DataSourceId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceId(String dataSourceId);

        /**
         * Sets the value of the Name property for this object.
         *
         * @param name
         *        The new value for the Name property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the Description property for this object.
         *
         * @param description
         *        The new value for the Description property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * Sets the value of the DataSourceConfiguration property for this object.
         *
         * @param dataSourceConfiguration
         *        The new value for the DataSourceConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceConfiguration(DataSourceConfiguration dataSourceConfiguration);

        /**
         * Sets the value of the DataSourceConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DataSourceConfiguration.Builder} avoiding
         * the need to create one manually via {@link DataSourceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSourceConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #dataSourceConfiguration(DataSourceConfiguration)}.
         * 
         * @param dataSourceConfiguration
         *        a consumer that will call methods on {@link DataSourceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSourceConfiguration(DataSourceConfiguration)
         */
        default Builder dataSourceConfiguration(Consumer<DataSourceConfiguration.Builder> dataSourceConfiguration) {
            return dataSourceConfiguration(DataSourceConfiguration.builder().applyMutation(dataSourceConfiguration).build());
        }

        /**
         * Sets the value of the ServerSideEncryptionConfiguration property for this object.
         *
         * @param serverSideEncryptionConfiguration
         *        The new value for the ServerSideEncryptionConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration serverSideEncryptionConfiguration);

        /**
         * Sets the value of the ServerSideEncryptionConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link ServerSideEncryptionConfiguration.Builder} avoiding the need to create one manually via
         * {@link ServerSideEncryptionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServerSideEncryptionConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration)}.
         * 
         * @param serverSideEncryptionConfiguration
         *        a consumer that will call methods on {@link ServerSideEncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration)
         */
        default Builder serverSideEncryptionConfiguration(
                Consumer<ServerSideEncryptionConfiguration.Builder> serverSideEncryptionConfiguration) {
            return serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration.builder()
                    .applyMutation(serverSideEncryptionConfiguration).build());
        }

        /**
         * Sets the value of the VectorIngestionConfiguration property for this object.
         *
         * @param vectorIngestionConfiguration
         *        The new value for the VectorIngestionConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vectorIngestionConfiguration(VectorIngestionConfiguration vectorIngestionConfiguration);

        /**
         * Sets the value of the VectorIngestionConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link VectorIngestionConfiguration.Builder}
         * avoiding the need to create one manually via {@link VectorIngestionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VectorIngestionConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #vectorIngestionConfiguration(VectorIngestionConfiguration)}.
         * 
         * @param vectorIngestionConfiguration
         *        a consumer that will call methods on {@link VectorIngestionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vectorIngestionConfiguration(VectorIngestionConfiguration)
         */
        default Builder vectorIngestionConfiguration(Consumer<VectorIngestionConfiguration.Builder> vectorIngestionConfiguration) {
            return vectorIngestionConfiguration(VectorIngestionConfiguration.builder()
                    .applyMutation(vectorIngestionConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentRequest.BuilderImpl implements Builder {
        private String knowledgeBaseId;

        private String dataSourceId;

        private String name;

        private String description;

        private DataSourceConfiguration dataSourceConfiguration;

        private ServerSideEncryptionConfiguration serverSideEncryptionConfiguration;

        private VectorIngestionConfiguration vectorIngestionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDataSourceRequest model) {
            super(model);
            knowledgeBaseId(model.knowledgeBaseId);
            dataSourceId(model.dataSourceId);
            name(model.name);
            description(model.description);
            dataSourceConfiguration(model.dataSourceConfiguration);
            serverSideEncryptionConfiguration(model.serverSideEncryptionConfiguration);
            vectorIngestionConfiguration(model.vectorIngestionConfiguration);
        }

        public final String getKnowledgeBaseId() {
            return knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getDataSourceId() {
            return dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final DataSourceConfiguration.Builder getDataSourceConfiguration() {
            return dataSourceConfiguration != null ? dataSourceConfiguration.toBuilder() : null;
        }

        public final void setDataSourceConfiguration(DataSourceConfiguration.BuilderImpl dataSourceConfiguration) {
            this.dataSourceConfiguration = dataSourceConfiguration != null ? dataSourceConfiguration.build() : null;
        }

        @Override
        public final Builder dataSourceConfiguration(DataSourceConfiguration dataSourceConfiguration) {
            this.dataSourceConfiguration = dataSourceConfiguration;
            return this;
        }

        public final ServerSideEncryptionConfiguration.Builder getServerSideEncryptionConfiguration() {
            return serverSideEncryptionConfiguration != null ? serverSideEncryptionConfiguration.toBuilder() : null;
        }

        public final void setServerSideEncryptionConfiguration(
                ServerSideEncryptionConfiguration.BuilderImpl serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration != null ? serverSideEncryptionConfiguration
                    .build() : null;
        }

        @Override
        public final Builder serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration;
            return this;
        }

        public final VectorIngestionConfiguration.Builder getVectorIngestionConfiguration() {
            return vectorIngestionConfiguration != null ? vectorIngestionConfiguration.toBuilder() : null;
        }

        public final void setVectorIngestionConfiguration(VectorIngestionConfiguration.BuilderImpl vectorIngestionConfiguration) {
            this.vectorIngestionConfiguration = vectorIngestionConfiguration != null ? vectorIngestionConfiguration.build()
                    : null;
        }

        @Override
        public final Builder vectorIngestionConfiguration(VectorIngestionConfiguration vectorIngestionConfiguration) {
            this.vectorIngestionConfiguration = vectorIngestionConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDataSourceRequest build() {
            return new UpdateDataSourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
