/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for inference in prompt configuration
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InferenceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<InferenceConfiguration.Builder, InferenceConfiguration> {
    private static final SdkField<Float> TEMPERATURE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("temperature").getter(getter(InferenceConfiguration::temperature)).setter(setter(Builder::temperature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("temperature").build()).build();

    private static final SdkField<Float> TOPP_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("topP")
            .getter(getter(InferenceConfiguration::topP)).setter(setter(Builder::topP))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topP").build()).build();

    private static final SdkField<Integer> TOPK_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("topK")
            .getter(getter(InferenceConfiguration::topK)).setter(setter(Builder::topK))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topK").build()).build();

    private static final SdkField<Integer> MAXIMUM_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maximumLength").getter(getter(InferenceConfiguration::maximumLength))
            .setter(setter(Builder::maximumLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumLength").build()).build();

    private static final SdkField<List<String>> STOP_SEQUENCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("stopSequences")
            .getter(getter(InferenceConfiguration::stopSequences))
            .setter(setter(Builder::stopSequences))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopSequences").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPERATURE_FIELD, TOPP_FIELD,
            TOPK_FIELD, MAXIMUM_LENGTH_FIELD, STOP_SEQUENCES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Float temperature;

    private final Float topP;

    private final Integer topK;

    private final Integer maximumLength;

    private final List<String> stopSequences;

    private InferenceConfiguration(BuilderImpl builder) {
        this.temperature = builder.temperature;
        this.topP = builder.topP;
        this.topK = builder.topK;
        this.maximumLength = builder.maximumLength;
        this.stopSequences = builder.stopSequences;
    }

    /**
     * Returns the value of the Temperature property for this object.
     * 
     * @return The value of the Temperature property for this object.
     */
    public final Float temperature() {
        return temperature;
    }

    /**
     * Returns the value of the TopP property for this object.
     * 
     * @return The value of the TopP property for this object.
     */
    public final Float topP() {
        return topP;
    }

    /**
     * Returns the value of the TopK property for this object.
     * 
     * @return The value of the TopK property for this object.
     */
    public final Integer topK() {
        return topK;
    }

    /**
     * Returns the value of the MaximumLength property for this object.
     * 
     * @return The value of the MaximumLength property for this object.
     */
    public final Integer maximumLength() {
        return maximumLength;
    }

    /**
     * For responses, this returns true if the service returned a value for the StopSequences property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStopSequences() {
        return stopSequences != null && !(stopSequences instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the StopSequences property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStopSequences} method.
     * </p>
     * 
     * @return The value of the StopSequences property for this object.
     */
    public final List<String> stopSequences() {
        return stopSequences;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(temperature());
        hashCode = 31 * hashCode + Objects.hashCode(topP());
        hashCode = 31 * hashCode + Objects.hashCode(topK());
        hashCode = 31 * hashCode + Objects.hashCode(maximumLength());
        hashCode = 31 * hashCode + Objects.hashCode(hasStopSequences() ? stopSequences() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceConfiguration)) {
            return false;
        }
        InferenceConfiguration other = (InferenceConfiguration) obj;
        return Objects.equals(temperature(), other.temperature()) && Objects.equals(topP(), other.topP())
                && Objects.equals(topK(), other.topK()) && Objects.equals(maximumLength(), other.maximumLength())
                && hasStopSequences() == other.hasStopSequences() && Objects.equals(stopSequences(), other.stopSequences());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InferenceConfiguration").add("Temperature", temperature()).add("TopP", topP())
                .add("TopK", topK()).add("MaximumLength", maximumLength())
                .add("StopSequences", hasStopSequences() ? stopSequences() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "temperature":
            return Optional.ofNullable(clazz.cast(temperature()));
        case "topP":
            return Optional.ofNullable(clazz.cast(topP()));
        case "topK":
            return Optional.ofNullable(clazz.cast(topK()));
        case "maximumLength":
            return Optional.ofNullable(clazz.cast(maximumLength()));
        case "stopSequences":
            return Optional.ofNullable(clazz.cast(stopSequences()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InferenceConfiguration, T> g) {
        return obj -> g.apply((InferenceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InferenceConfiguration> {
        /**
         * Sets the value of the Temperature property for this object.
         *
         * @param temperature
         *        The new value for the Temperature property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder temperature(Float temperature);

        /**
         * Sets the value of the TopP property for this object.
         *
         * @param topP
         *        The new value for the TopP property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topP(Float topP);

        /**
         * Sets the value of the TopK property for this object.
         *
         * @param topK
         *        The new value for the TopK property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topK(Integer topK);

        /**
         * Sets the value of the MaximumLength property for this object.
         *
         * @param maximumLength
         *        The new value for the MaximumLength property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumLength(Integer maximumLength);

        /**
         * Sets the value of the StopSequences property for this object.
         *
         * @param stopSequences
         *        The new value for the StopSequences property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopSequences(Collection<String> stopSequences);

        /**
         * Sets the value of the StopSequences property for this object.
         *
         * @param stopSequences
         *        The new value for the StopSequences property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopSequences(String... stopSequences);
    }

    static final class BuilderImpl implements Builder {
        private Float temperature;

        private Float topP;

        private Integer topK;

        private Integer maximumLength;

        private List<String> stopSequences = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceConfiguration model) {
            temperature(model.temperature);
            topP(model.topP);
            topK(model.topK);
            maximumLength(model.maximumLength);
            stopSequences(model.stopSequences);
        }

        public final Float getTemperature() {
            return temperature;
        }

        public final void setTemperature(Float temperature) {
            this.temperature = temperature;
        }

        @Override
        public final Builder temperature(Float temperature) {
            this.temperature = temperature;
            return this;
        }

        public final Float getTopP() {
            return topP;
        }

        public final void setTopP(Float topP) {
            this.topP = topP;
        }

        @Override
        public final Builder topP(Float topP) {
            this.topP = topP;
            return this;
        }

        public final Integer getTopK() {
            return topK;
        }

        public final void setTopK(Integer topK) {
            this.topK = topK;
        }

        @Override
        public final Builder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        public final Integer getMaximumLength() {
            return maximumLength;
        }

        public final void setMaximumLength(Integer maximumLength) {
            this.maximumLength = maximumLength;
        }

        @Override
        public final Builder maximumLength(Integer maximumLength) {
            this.maximumLength = maximumLength;
            return this;
        }

        public final Collection<String> getStopSequences() {
            if (stopSequences instanceof SdkAutoConstructList) {
                return null;
            }
            return stopSequences;
        }

        public final void setStopSequences(Collection<String> stopSequences) {
            this.stopSequences = StopSequencesCopier.copy(stopSequences);
        }

        @Override
        public final Builder stopSequences(Collection<String> stopSequences) {
            this.stopSequences = StopSequencesCopier.copy(stopSequences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stopSequences(String... stopSequences) {
            stopSequences(Arrays.asList(stopSequences));
            return this;
        }

        @Override
        public InferenceConfiguration build() {
            return new InferenceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
