/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Trace Part which contains information used to call Invoke Model
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelInvocationInput implements SdkPojo, Serializable,
        ToCopyableBuilder<ModelInvocationInput.Builder, ModelInvocationInput> {
    private static final SdkField<String> TRACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("traceId").getter(getter(ModelInvocationInput::traceId)).setter(setter(Builder::traceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("traceId").build()).build();

    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("text")
            .getter(getter(ModelInvocationInput::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(ModelInvocationInput::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<InferenceConfiguration> INFERENCE_CONFIGURATION_FIELD = SdkField
            .<InferenceConfiguration> builder(MarshallingType.SDK_POJO).memberName("inferenceConfiguration")
            .getter(getter(ModelInvocationInput::inferenceConfiguration)).setter(setter(Builder::inferenceConfiguration))
            .constructor(InferenceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceConfiguration").build())
            .build();

    private static final SdkField<String> OVERRIDE_LAMBDA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("overrideLambda").getter(getter(ModelInvocationInput::overrideLambda))
            .setter(setter(Builder::overrideLambda))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrideLambda").build()).build();

    private static final SdkField<String> PROMPT_CREATION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("promptCreationMode").getter(getter(ModelInvocationInput::promptCreationModeAsString))
            .setter(setter(Builder::promptCreationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptCreationMode").build())
            .build();

    private static final SdkField<String> PARSER_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parserMode").getter(getter(ModelInvocationInput::parserModeAsString))
            .setter(setter(Builder::parserMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parserMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACE_ID_FIELD, TEXT_FIELD,
            TYPE_FIELD, INFERENCE_CONFIGURATION_FIELD, OVERRIDE_LAMBDA_FIELD, PROMPT_CREATION_MODE_FIELD, PARSER_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String traceId;

    private final String text;

    private final String type;

    private final InferenceConfiguration inferenceConfiguration;

    private final String overrideLambda;

    private final String promptCreationMode;

    private final String parserMode;

    private ModelInvocationInput(BuilderImpl builder) {
        this.traceId = builder.traceId;
        this.text = builder.text;
        this.type = builder.type;
        this.inferenceConfiguration = builder.inferenceConfiguration;
        this.overrideLambda = builder.overrideLambda;
        this.promptCreationMode = builder.promptCreationMode;
        this.parserMode = builder.parserMode;
    }

    /**
     * Returns the value of the TraceId property for this object.
     * 
     * @return The value of the TraceId property for this object.
     */
    public final String traceId() {
        return traceId;
    }

    /**
     * Returns the value of the Text property for this object.
     * 
     * @return The value of the Text property for this object.
     */
    public final String text() {
        return text;
    }

    /**
     * Returns the value of the Type property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PromptType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The value of the Type property for this object.
     * @see PromptType
     */
    public final PromptType type() {
        return PromptType.fromValue(type);
    }

    /**
     * Returns the value of the Type property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PromptType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The value of the Type property for this object.
     * @see PromptType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * Returns the value of the InferenceConfiguration property for this object.
     * 
     * @return The value of the InferenceConfiguration property for this object.
     */
    public final InferenceConfiguration inferenceConfiguration() {
        return inferenceConfiguration;
    }

    /**
     * Returns the value of the OverrideLambda property for this object.
     * 
     * @return The value of the OverrideLambda property for this object.
     */
    public final String overrideLambda() {
        return overrideLambda;
    }

    /**
     * Returns the value of the PromptCreationMode property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #promptCreationMode} will return {@link CreationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #promptCreationModeAsString}.
     * </p>
     * 
     * @return The value of the PromptCreationMode property for this object.
     * @see CreationMode
     */
    public final CreationMode promptCreationMode() {
        return CreationMode.fromValue(promptCreationMode);
    }

    /**
     * Returns the value of the PromptCreationMode property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #promptCreationMode} will return {@link CreationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #promptCreationModeAsString}.
     * </p>
     * 
     * @return The value of the PromptCreationMode property for this object.
     * @see CreationMode
     */
    public final String promptCreationModeAsString() {
        return promptCreationMode;
    }

    /**
     * Returns the value of the ParserMode property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #parserMode} will
     * return {@link CreationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #parserModeAsString}.
     * </p>
     * 
     * @return The value of the ParserMode property for this object.
     * @see CreationMode
     */
    public final CreationMode parserMode() {
        return CreationMode.fromValue(parserMode);
    }

    /**
     * Returns the value of the ParserMode property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #parserMode} will
     * return {@link CreationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #parserModeAsString}.
     * </p>
     * 
     * @return The value of the ParserMode property for this object.
     * @see CreationMode
     */
    public final String parserModeAsString() {
        return parserMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(traceId());
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(inferenceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(overrideLambda());
        hashCode = 31 * hashCode + Objects.hashCode(promptCreationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(parserModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelInvocationInput)) {
            return false;
        }
        ModelInvocationInput other = (ModelInvocationInput) obj;
        return Objects.equals(traceId(), other.traceId()) && Objects.equals(text(), other.text())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(inferenceConfiguration(), other.inferenceConfiguration())
                && Objects.equals(overrideLambda(), other.overrideLambda())
                && Objects.equals(promptCreationModeAsString(), other.promptCreationModeAsString())
                && Objects.equals(parserModeAsString(), other.parserModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelInvocationInput").add("TraceId", traceId())
                .add("Text", text() == null ? null : "*** Sensitive Data Redacted ***").add("Type", typeAsString())
                .add("InferenceConfiguration", inferenceConfiguration()).add("OverrideLambda", overrideLambda())
                .add("PromptCreationMode", promptCreationModeAsString()).add("ParserMode", parserModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "traceId":
            return Optional.ofNullable(clazz.cast(traceId()));
        case "text":
            return Optional.ofNullable(clazz.cast(text()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "inferenceConfiguration":
            return Optional.ofNullable(clazz.cast(inferenceConfiguration()));
        case "overrideLambda":
            return Optional.ofNullable(clazz.cast(overrideLambda()));
        case "promptCreationMode":
            return Optional.ofNullable(clazz.cast(promptCreationModeAsString()));
        case "parserMode":
            return Optional.ofNullable(clazz.cast(parserModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelInvocationInput, T> g) {
        return obj -> g.apply((ModelInvocationInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelInvocationInput> {
        /**
         * Sets the value of the TraceId property for this object.
         *
         * @param traceId
         *        The new value for the TraceId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traceId(String traceId);

        /**
         * Sets the value of the Text property for this object.
         *
         * @param text
         *        The new value for the Text property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);

        /**
         * Sets the value of the Type property for this object.
         *
         * @param type
         *        The new value for the Type property for this object.
         * @see PromptType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PromptType
         */
        Builder type(String type);

        /**
         * Sets the value of the Type property for this object.
         *
         * @param type
         *        The new value for the Type property for this object.
         * @see PromptType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PromptType
         */
        Builder type(PromptType type);

        /**
         * Sets the value of the InferenceConfiguration property for this object.
         *
         * @param inferenceConfiguration
         *        The new value for the InferenceConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceConfiguration(InferenceConfiguration inferenceConfiguration);

        /**
         * Sets the value of the InferenceConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link InferenceConfiguration.Builder} avoiding
         * the need to create one manually via {@link InferenceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InferenceConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #inferenceConfiguration(InferenceConfiguration)}.
         * 
         * @param inferenceConfiguration
         *        a consumer that will call methods on {@link InferenceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inferenceConfiguration(InferenceConfiguration)
         */
        default Builder inferenceConfiguration(Consumer<InferenceConfiguration.Builder> inferenceConfiguration) {
            return inferenceConfiguration(InferenceConfiguration.builder().applyMutation(inferenceConfiguration).build());
        }

        /**
         * Sets the value of the OverrideLambda property for this object.
         *
         * @param overrideLambda
         *        The new value for the OverrideLambda property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrideLambda(String overrideLambda);

        /**
         * Sets the value of the PromptCreationMode property for this object.
         *
         * @param promptCreationMode
         *        The new value for the PromptCreationMode property for this object.
         * @see CreationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CreationMode
         */
        Builder promptCreationMode(String promptCreationMode);

        /**
         * Sets the value of the PromptCreationMode property for this object.
         *
         * @param promptCreationMode
         *        The new value for the PromptCreationMode property for this object.
         * @see CreationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CreationMode
         */
        Builder promptCreationMode(CreationMode promptCreationMode);

        /**
         * Sets the value of the ParserMode property for this object.
         *
         * @param parserMode
         *        The new value for the ParserMode property for this object.
         * @see CreationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CreationMode
         */
        Builder parserMode(String parserMode);

        /**
         * Sets the value of the ParserMode property for this object.
         *
         * @param parserMode
         *        The new value for the ParserMode property for this object.
         * @see CreationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CreationMode
         */
        Builder parserMode(CreationMode parserMode);
    }

    static final class BuilderImpl implements Builder {
        private String traceId;

        private String text;

        private String type;

        private InferenceConfiguration inferenceConfiguration;

        private String overrideLambda;

        private String promptCreationMode;

        private String parserMode;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelInvocationInput model) {
            traceId(model.traceId);
            text(model.text);
            type(model.type);
            inferenceConfiguration(model.inferenceConfiguration);
            overrideLambda(model.overrideLambda);
            promptCreationMode(model.promptCreationMode);
            parserMode(model.parserMode);
        }

        public final String getTraceId() {
            return traceId;
        }

        public final void setTraceId(String traceId) {
            this.traceId = traceId;
        }

        @Override
        public final Builder traceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PromptType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final InferenceConfiguration.Builder getInferenceConfiguration() {
            return inferenceConfiguration != null ? inferenceConfiguration.toBuilder() : null;
        }

        public final void setInferenceConfiguration(InferenceConfiguration.BuilderImpl inferenceConfiguration) {
            this.inferenceConfiguration = inferenceConfiguration != null ? inferenceConfiguration.build() : null;
        }

        @Override
        public final Builder inferenceConfiguration(InferenceConfiguration inferenceConfiguration) {
            this.inferenceConfiguration = inferenceConfiguration;
            return this;
        }

        public final String getOverrideLambda() {
            return overrideLambda;
        }

        public final void setOverrideLambda(String overrideLambda) {
            this.overrideLambda = overrideLambda;
        }

        @Override
        public final Builder overrideLambda(String overrideLambda) {
            this.overrideLambda = overrideLambda;
            return this;
        }

        public final String getPromptCreationMode() {
            return promptCreationMode;
        }

        public final void setPromptCreationMode(String promptCreationMode) {
            this.promptCreationMode = promptCreationMode;
        }

        @Override
        public final Builder promptCreationMode(String promptCreationMode) {
            this.promptCreationMode = promptCreationMode;
            return this;
        }

        @Override
        public final Builder promptCreationMode(CreationMode promptCreationMode) {
            this.promptCreationMode(promptCreationMode == null ? null : promptCreationMode.toString());
            return this;
        }

        public final String getParserMode() {
            return parserMode;
        }

        public final void setParserMode(String parserMode) {
            this.parserMode = parserMode;
        }

        @Override
        public final Builder parserMode(String parserMode) {
            this.parserMode = parserMode;
            return this;
        }

        @Override
        public final Builder parserMode(CreationMode parserMode) {
            this.parserMode(parserMode == null ? null : parserMode.toString());
            return this;
        }

        @Override
        public ModelInvocationInput build() {
            return new ModelInvocationInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
