/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Trace Part which contains information related to post processing step
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PostProcessingTrace implements SdkPojo, Serializable,
        ToCopyableBuilder<PostProcessingTrace.Builder, PostProcessingTrace> {
    private static final SdkField<ModelInvocationInput> MODEL_INVOCATION_INPUT_FIELD = SdkField
            .<ModelInvocationInput> builder(MarshallingType.SDK_POJO).memberName("modelInvocationInput")
            .getter(getter(PostProcessingTrace::modelInvocationInput)).setter(setter(Builder::modelInvocationInput))
            .constructor(ModelInvocationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelInvocationInput").build())
            .build();

    private static final SdkField<PostProcessingModelInvocationOutput> MODEL_INVOCATION_OUTPUT_FIELD = SdkField
            .<PostProcessingModelInvocationOutput> builder(MarshallingType.SDK_POJO).memberName("modelInvocationOutput")
            .getter(getter(PostProcessingTrace::modelInvocationOutput)).setter(setter(Builder::modelInvocationOutput))
            .constructor(PostProcessingModelInvocationOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelInvocationOutput").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_INVOCATION_INPUT_FIELD,
            MODEL_INVOCATION_OUTPUT_FIELD));

    private static final long serialVersionUID = 1L;

    private final ModelInvocationInput modelInvocationInput;

    private final PostProcessingModelInvocationOutput modelInvocationOutput;

    private final Type type;

    private PostProcessingTrace(BuilderImpl builder) {
        this.modelInvocationInput = builder.modelInvocationInput;
        this.modelInvocationOutput = builder.modelInvocationOutput;
        this.type = builder.type;
    }

    /**
     * Returns the value of the ModelInvocationInput property for this object.
     * 
     * @return The value of the ModelInvocationInput property for this object.
     */
    public final ModelInvocationInput modelInvocationInput() {
        return modelInvocationInput;
    }

    /**
     * Returns the value of the ModelInvocationOutput property for this object.
     * 
     * @return The value of the ModelInvocationOutput property for this object.
     */
    public final PostProcessingModelInvocationOutput modelInvocationOutput() {
        return modelInvocationOutput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelInvocationInput());
        hashCode = 31 * hashCode + Objects.hashCode(modelInvocationOutput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PostProcessingTrace)) {
            return false;
        }
        PostProcessingTrace other = (PostProcessingTrace) obj;
        return Objects.equals(modelInvocationInput(), other.modelInvocationInput())
                && Objects.equals(modelInvocationOutput(), other.modelInvocationOutput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PostProcessingTrace")
                .add("ModelInvocationInput", modelInvocationInput() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ModelInvocationOutput", modelInvocationOutput() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "modelInvocationInput":
            return Optional.ofNullable(clazz.cast(modelInvocationInput()));
        case "modelInvocationOutput":
            return Optional.ofNullable(clazz.cast(modelInvocationOutput()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #modelInvocationInput()} initialized to the given value.
     *
     * Sets the value of the ModelInvocationInput property for this object.
     *
     * @param modelInvocationInput
     *        The new value for the ModelInvocationInput property for this object.
     */
    public static PostProcessingTrace fromModelInvocationInput(ModelInvocationInput modelInvocationInput) {
        return builder().modelInvocationInput(modelInvocationInput).build();
    }

    /**
     * Create an instance of this class with {@link #modelInvocationInput()} initialized to the given value.
     *
     * Sets the value of the ModelInvocationInput property for this object.
     *
     * @param modelInvocationInput
     *        The new value for the ModelInvocationInput property for this object.
     */
    public static PostProcessingTrace fromModelInvocationInput(Consumer<ModelInvocationInput.Builder> modelInvocationInput) {
        ModelInvocationInput.Builder builder = ModelInvocationInput.builder();
        modelInvocationInput.accept(builder);
        return fromModelInvocationInput(builder.build());
    }

    /**
     * Create an instance of this class with {@link #modelInvocationOutput()} initialized to the given value.
     *
     * Sets the value of the ModelInvocationOutput property for this object.
     *
     * @param modelInvocationOutput
     *        The new value for the ModelInvocationOutput property for this object.
     */
    public static PostProcessingTrace fromModelInvocationOutput(PostProcessingModelInvocationOutput modelInvocationOutput) {
        return builder().modelInvocationOutput(modelInvocationOutput).build();
    }

    /**
     * Create an instance of this class with {@link #modelInvocationOutput()} initialized to the given value.
     *
     * Sets the value of the ModelInvocationOutput property for this object.
     *
     * @param modelInvocationOutput
     *        The new value for the ModelInvocationOutput property for this object.
     */
    public static PostProcessingTrace fromModelInvocationOutput(
            Consumer<PostProcessingModelInvocationOutput.Builder> modelInvocationOutput) {
        PostProcessingModelInvocationOutput.Builder builder = PostProcessingModelInvocationOutput.builder();
        modelInvocationOutput.accept(builder);
        return fromModelInvocationOutput(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PostProcessingTrace, T> g) {
        return obj -> g.apply((PostProcessingTrace) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PostProcessingTrace> {
        /**
         * Sets the value of the ModelInvocationInput property for this object.
         *
         * @param modelInvocationInput
         *        The new value for the ModelInvocationInput property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelInvocationInput(ModelInvocationInput modelInvocationInput);

        /**
         * Sets the value of the ModelInvocationInput property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ModelInvocationInput.Builder} avoiding
         * the need to create one manually via {@link ModelInvocationInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelInvocationInput.Builder#build()} is called immediately and
         * its result is passed to {@link #modelInvocationInput(ModelInvocationInput)}.
         * 
         * @param modelInvocationInput
         *        a consumer that will call methods on {@link ModelInvocationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelInvocationInput(ModelInvocationInput)
         */
        default Builder modelInvocationInput(Consumer<ModelInvocationInput.Builder> modelInvocationInput) {
            return modelInvocationInput(ModelInvocationInput.builder().applyMutation(modelInvocationInput).build());
        }

        /**
         * Sets the value of the ModelInvocationOutput property for this object.
         *
         * @param modelInvocationOutput
         *        The new value for the ModelInvocationOutput property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelInvocationOutput(PostProcessingModelInvocationOutput modelInvocationOutput);

        /**
         * Sets the value of the ModelInvocationOutput property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link PostProcessingModelInvocationOutput.Builder} avoiding the need to create one manually via
         * {@link PostProcessingModelInvocationOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PostProcessingModelInvocationOutput.Builder#build()} is called
         * immediately and its result is passed to {@link #modelInvocationOutput(PostProcessingModelInvocationOutput)}.
         * 
         * @param modelInvocationOutput
         *        a consumer that will call methods on {@link PostProcessingModelInvocationOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelInvocationOutput(PostProcessingModelInvocationOutput)
         */
        default Builder modelInvocationOutput(Consumer<PostProcessingModelInvocationOutput.Builder> modelInvocationOutput) {
            return modelInvocationOutput(PostProcessingModelInvocationOutput.builder().applyMutation(modelInvocationOutput)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ModelInvocationInput modelInvocationInput;

        private PostProcessingModelInvocationOutput modelInvocationOutput;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(PostProcessingTrace model) {
            modelInvocationInput(model.modelInvocationInput);
            modelInvocationOutput(model.modelInvocationOutput);
        }

        public final ModelInvocationInput.Builder getModelInvocationInput() {
            return modelInvocationInput != null ? modelInvocationInput.toBuilder() : null;
        }

        public final void setModelInvocationInput(ModelInvocationInput.BuilderImpl modelInvocationInput) {
            Object oldValue = this.modelInvocationInput;
            this.modelInvocationInput = modelInvocationInput != null ? modelInvocationInput.build() : null;
            handleUnionValueChange(Type.MODEL_INVOCATION_INPUT, oldValue, this.modelInvocationInput);
        }

        @Override
        public final Builder modelInvocationInput(ModelInvocationInput modelInvocationInput) {
            Object oldValue = this.modelInvocationInput;
            this.modelInvocationInput = modelInvocationInput;
            handleUnionValueChange(Type.MODEL_INVOCATION_INPUT, oldValue, this.modelInvocationInput);
            return this;
        }

        public final PostProcessingModelInvocationOutput.Builder getModelInvocationOutput() {
            return modelInvocationOutput != null ? modelInvocationOutput.toBuilder() : null;
        }

        public final void setModelInvocationOutput(PostProcessingModelInvocationOutput.BuilderImpl modelInvocationOutput) {
            Object oldValue = this.modelInvocationOutput;
            this.modelInvocationOutput = modelInvocationOutput != null ? modelInvocationOutput.build() : null;
            handleUnionValueChange(Type.MODEL_INVOCATION_OUTPUT, oldValue, this.modelInvocationOutput);
        }

        @Override
        public final Builder modelInvocationOutput(PostProcessingModelInvocationOutput modelInvocationOutput) {
            Object oldValue = this.modelInvocationOutput;
            this.modelInvocationOutput = modelInvocationOutput;
            handleUnionValueChange(Type.MODEL_INVOCATION_OUTPUT, oldValue, this.modelInvocationOutput);
            return this;
        }

        @Override
        public PostProcessingTrace build() {
            return new PostProcessingTrace(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see PostProcessingTrace#type()
     */
    public enum Type {
        MODEL_INVOCATION_INPUT,

        MODEL_INVOCATION_OUTPUT,

        UNKNOWN_TO_SDK_VERSION
    }
}
