/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.billingconductor.model.AssociateAccountsRequest;
import software.amazon.awssdk.services.billingconductor.model.AssociateAccountsResponse;
import software.amazon.awssdk.services.billingconductor.model.AssociatePricingRulesRequest;
import software.amazon.awssdk.services.billingconductor.model.AssociatePricingRulesResponse;
import software.amazon.awssdk.services.billingconductor.model.BatchAssociateResourcesToCustomLineItemRequest;
import software.amazon.awssdk.services.billingconductor.model.BatchAssociateResourcesToCustomLineItemResponse;
import software.amazon.awssdk.services.billingconductor.model.BatchDisassociateResourcesFromCustomLineItemRequest;
import software.amazon.awssdk.services.billingconductor.model.BatchDisassociateResourcesFromCustomLineItemResponse;
import software.amazon.awssdk.services.billingconductor.model.CreateBillingGroupRequest;
import software.amazon.awssdk.services.billingconductor.model.CreateBillingGroupResponse;
import software.amazon.awssdk.services.billingconductor.model.CreateCustomLineItemRequest;
import software.amazon.awssdk.services.billingconductor.model.CreateCustomLineItemResponse;
import software.amazon.awssdk.services.billingconductor.model.CreatePricingPlanRequest;
import software.amazon.awssdk.services.billingconductor.model.CreatePricingPlanResponse;
import software.amazon.awssdk.services.billingconductor.model.CreatePricingRuleRequest;
import software.amazon.awssdk.services.billingconductor.model.CreatePricingRuleResponse;
import software.amazon.awssdk.services.billingconductor.model.DeleteBillingGroupRequest;
import software.amazon.awssdk.services.billingconductor.model.DeleteBillingGroupResponse;
import software.amazon.awssdk.services.billingconductor.model.DeleteCustomLineItemRequest;
import software.amazon.awssdk.services.billingconductor.model.DeleteCustomLineItemResponse;
import software.amazon.awssdk.services.billingconductor.model.DeletePricingPlanRequest;
import software.amazon.awssdk.services.billingconductor.model.DeletePricingPlanResponse;
import software.amazon.awssdk.services.billingconductor.model.DeletePricingRuleRequest;
import software.amazon.awssdk.services.billingconductor.model.DeletePricingRuleResponse;
import software.amazon.awssdk.services.billingconductor.model.DisassociateAccountsRequest;
import software.amazon.awssdk.services.billingconductor.model.DisassociateAccountsResponse;
import software.amazon.awssdk.services.billingconductor.model.DisassociatePricingRulesRequest;
import software.amazon.awssdk.services.billingconductor.model.DisassociatePricingRulesResponse;
import software.amazon.awssdk.services.billingconductor.model.ListAccountAssociationsRequest;
import software.amazon.awssdk.services.billingconductor.model.ListAccountAssociationsResponse;
import software.amazon.awssdk.services.billingconductor.model.ListBillingGroupCostReportsRequest;
import software.amazon.awssdk.services.billingconductor.model.ListBillingGroupCostReportsResponse;
import software.amazon.awssdk.services.billingconductor.model.ListBillingGroupsRequest;
import software.amazon.awssdk.services.billingconductor.model.ListBillingGroupsResponse;
import software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemVersionsRequest;
import software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemVersionsResponse;
import software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemsRequest;
import software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemsResponse;
import software.amazon.awssdk.services.billingconductor.model.ListPricingPlansAssociatedWithPricingRuleRequest;
import software.amazon.awssdk.services.billingconductor.model.ListPricingPlansAssociatedWithPricingRuleResponse;
import software.amazon.awssdk.services.billingconductor.model.ListPricingPlansRequest;
import software.amazon.awssdk.services.billingconductor.model.ListPricingPlansResponse;
import software.amazon.awssdk.services.billingconductor.model.ListPricingRulesAssociatedToPricingPlanRequest;
import software.amazon.awssdk.services.billingconductor.model.ListPricingRulesAssociatedToPricingPlanResponse;
import software.amazon.awssdk.services.billingconductor.model.ListPricingRulesRequest;
import software.amazon.awssdk.services.billingconductor.model.ListPricingRulesResponse;
import software.amazon.awssdk.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemRequest;
import software.amazon.awssdk.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemResponse;
import software.amazon.awssdk.services.billingconductor.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.billingconductor.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.billingconductor.model.TagResourceRequest;
import software.amazon.awssdk.services.billingconductor.model.TagResourceResponse;
import software.amazon.awssdk.services.billingconductor.model.UntagResourceRequest;
import software.amazon.awssdk.services.billingconductor.model.UntagResourceResponse;
import software.amazon.awssdk.services.billingconductor.model.UpdateBillingGroupRequest;
import software.amazon.awssdk.services.billingconductor.model.UpdateBillingGroupResponse;
import software.amazon.awssdk.services.billingconductor.model.UpdateCustomLineItemRequest;
import software.amazon.awssdk.services.billingconductor.model.UpdateCustomLineItemResponse;
import software.amazon.awssdk.services.billingconductor.model.UpdatePricingPlanRequest;
import software.amazon.awssdk.services.billingconductor.model.UpdatePricingPlanResponse;
import software.amazon.awssdk.services.billingconductor.model.UpdatePricingRuleRequest;
import software.amazon.awssdk.services.billingconductor.model.UpdatePricingRuleResponse;
import software.amazon.awssdk.services.billingconductor.paginators.ListAccountAssociationsPublisher;
import software.amazon.awssdk.services.billingconductor.paginators.ListBillingGroupCostReportsPublisher;
import software.amazon.awssdk.services.billingconductor.paginators.ListBillingGroupsPublisher;
import software.amazon.awssdk.services.billingconductor.paginators.ListCustomLineItemVersionsPublisher;
import software.amazon.awssdk.services.billingconductor.paginators.ListCustomLineItemsPublisher;
import software.amazon.awssdk.services.billingconductor.paginators.ListPricingPlansAssociatedWithPricingRulePublisher;
import software.amazon.awssdk.services.billingconductor.paginators.ListPricingPlansPublisher;
import software.amazon.awssdk.services.billingconductor.paginators.ListPricingRulesAssociatedToPricingPlanPublisher;
import software.amazon.awssdk.services.billingconductor.paginators.ListPricingRulesPublisher;
import software.amazon.awssdk.services.billingconductor.paginators.ListResourcesAssociatedToCustomLineItemPublisher;

/**
 * Service client for accessing AWSBillingConductor asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * Amazon Web Services Billing Conductor is a fully managed service that you can use to customize a <a
 * href="https://docs.aws.amazon.com/billingconductor/latest/userguide/understanding-eb.html#eb-other-definitions">pro
 * forma</a> version of your billing data each month, to accurately show or chargeback your end customers. Amazon Web
 * Services Billing Conductor doesn't change the way you're billed by Amazon Web Services each month by design. Instead,
 * it provides you with a mechanism to configure, generate, and display rates to certain customers over a given billing
 * period. You can also analyze the difference between the rates you apply to your accounting groupings relative to your
 * actual rates from Amazon Web Services. As a result of your Amazon Web Services Billing Conductor configuration, the
 * payer account can also see the custom rate applied on the billing details page of the <a
 * href="https://console.aws.amazon.com/billing">Amazon Web Services Billing console</a>, or configure a cost and usage
 * report per billing group.
 * </p>
 * <p>
 * This documentation shows how you can configure Amazon Web Services Billing Conductor using its API. For more
 * information about using the <a href="https://console.aws.amazon.com/billingconductor/">Amazon Web Services Billing
 * Conductor</a> user interface, see the <a
 * href="https://docs.aws.amazon.com/billingconductor/latest/userguide/what-is-billingconductor.html"> Amazon Web
 * Services Billing Conductor User Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface BillingconductorAsyncClient extends SdkClient {
    String SERVICE_NAME = "billingconductor";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "billingconductor";

    /**
     * Create a {@link BillingconductorAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static BillingconductorAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link BillingconductorAsyncClient}.
     */
    static BillingconductorAsyncClientBuilder builder() {
        return new DefaultBillingconductorAsyncClientBuilder();
    }

    /**
     * <p>
     * Connects an array of account IDs in a consolidated billing family to a predefined billing group. The account IDs
     * must be a part of the consolidated billing family during the current month, and not already associated with
     * another billing group. The maximum number of accounts that can be associated in one call is 30.
     * </p>
     *
     * @param associateAccountsRequest
     * @return A Java Future containing the result of the AssociateAccounts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException You can cause an inconsistent state by updating or deleting a resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>ServiceLimitExceededException The request would cause a service limit to exceed.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.AssociateAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/AssociateAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateAccountsResponse> associateAccounts(AssociateAccountsRequest associateAccountsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Connects an array of account IDs in a consolidated billing family to a predefined billing group. The account IDs
     * must be a part of the consolidated billing family during the current month, and not already associated with
     * another billing group. The maximum number of accounts that can be associated in one call is 30.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateAccountsRequest.Builder} avoiding the need
     * to create one manually via {@link AssociateAccountsRequest#builder()}
     * </p>
     *
     * @param associateAccountsRequest
     *        A {@link Consumer} that will call methods on {@link AssociateAccountsInput.Builder} to create a request.
     * @return A Java Future containing the result of the AssociateAccounts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException You can cause an inconsistent state by updating or deleting a resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>ServiceLimitExceededException The request would cause a service limit to exceed.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.AssociateAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/AssociateAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateAccountsResponse> associateAccounts(
            Consumer<AssociateAccountsRequest.Builder> associateAccountsRequest) {
        return associateAccounts(AssociateAccountsRequest.builder().applyMutation(associateAccountsRequest).build());
    }

    /**
     * <p>
     * Connects an array of <code>PricingRuleArns</code> to a defined <code>PricingPlan</code>. The maximum number
     * <code>PricingRuleArn</code> that can be associated in one call is 30.
     * </p>
     *
     * @param associatePricingRulesRequest
     * @return A Java Future containing the result of the AssociatePricingRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException You can cause an inconsistent state by updating or deleting a resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>ServiceLimitExceededException The request would cause a service limit to exceed.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.AssociatePricingRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/AssociatePricingRules"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociatePricingRulesResponse> associatePricingRules(
            AssociatePricingRulesRequest associatePricingRulesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Connects an array of <code>PricingRuleArns</code> to a defined <code>PricingPlan</code>. The maximum number
     * <code>PricingRuleArn</code> that can be associated in one call is 30.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociatePricingRulesRequest.Builder} avoiding the
     * need to create one manually via {@link AssociatePricingRulesRequest#builder()}
     * </p>
     *
     * @param associatePricingRulesRequest
     *        A {@link Consumer} that will call methods on {@link AssociatePricingRulesInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociatePricingRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException You can cause an inconsistent state by updating or deleting a resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>ServiceLimitExceededException The request would cause a service limit to exceed.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.AssociatePricingRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/AssociatePricingRules"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociatePricingRulesResponse> associatePricingRules(
            Consumer<AssociatePricingRulesRequest.Builder> associatePricingRulesRequest) {
        return associatePricingRules(AssociatePricingRulesRequest.builder().applyMutation(associatePricingRulesRequest).build());
    }

    /**
     * <p>
     * Associates a batch of resources to a percentage custom line item.
     * </p>
     *
     * @param batchAssociateResourcesToCustomLineItemRequest
     * @return A Java Future containing the result of the BatchAssociateResourcesToCustomLineItem operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException You can cause an inconsistent state by updating or deleting a resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>ServiceLimitExceededException The request would cause a service limit to exceed.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.BatchAssociateResourcesToCustomLineItem
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/BatchAssociateResourcesToCustomLineItem"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchAssociateResourcesToCustomLineItemResponse> batchAssociateResourcesToCustomLineItem(
            BatchAssociateResourcesToCustomLineItemRequest batchAssociateResourcesToCustomLineItemRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a batch of resources to a percentage custom line item.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link BatchAssociateResourcesToCustomLineItemRequest.Builder} avoiding the need to create one manually via
     * {@link BatchAssociateResourcesToCustomLineItemRequest#builder()}
     * </p>
     *
     * @param batchAssociateResourcesToCustomLineItemRequest
     *        A {@link Consumer} that will call methods on {@link BatchAssociateResourcesToCustomLineItemInput.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the BatchAssociateResourcesToCustomLineItem operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException You can cause an inconsistent state by updating or deleting a resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>ServiceLimitExceededException The request would cause a service limit to exceed.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.BatchAssociateResourcesToCustomLineItem
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/BatchAssociateResourcesToCustomLineItem"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchAssociateResourcesToCustomLineItemResponse> batchAssociateResourcesToCustomLineItem(
            Consumer<BatchAssociateResourcesToCustomLineItemRequest.Builder> batchAssociateResourcesToCustomLineItemRequest) {
        return batchAssociateResourcesToCustomLineItem(BatchAssociateResourcesToCustomLineItemRequest.builder()
                .applyMutation(batchAssociateResourcesToCustomLineItemRequest).build());
    }

    /**
     * <p>
     * Disassociates a batch of resources from a percentage custom line item.
     * </p>
     *
     * @param batchDisassociateResourcesFromCustomLineItemRequest
     * @return A Java Future containing the result of the BatchDisassociateResourcesFromCustomLineItem operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException You can cause an inconsistent state by updating or deleting a resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.BatchDisassociateResourcesFromCustomLineItem
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/BatchDisassociateResourcesFromCustomLineItem"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDisassociateResourcesFromCustomLineItemResponse> batchDisassociateResourcesFromCustomLineItem(
            BatchDisassociateResourcesFromCustomLineItemRequest batchDisassociateResourcesFromCustomLineItemRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a batch of resources from a percentage custom line item.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link BatchDisassociateResourcesFromCustomLineItemRequest.Builder} avoiding the need to create one manually via
     * {@link BatchDisassociateResourcesFromCustomLineItemRequest#builder()}
     * </p>
     *
     * @param batchDisassociateResourcesFromCustomLineItemRequest
     *        A {@link Consumer} that will call methods on
     *        {@link BatchDisassociateResourcesFromCustomLineItemInput.Builder} to create a request.
     * @return A Java Future containing the result of the BatchDisassociateResourcesFromCustomLineItem operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException You can cause an inconsistent state by updating or deleting a resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.BatchDisassociateResourcesFromCustomLineItem
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/BatchDisassociateResourcesFromCustomLineItem"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDisassociateResourcesFromCustomLineItemResponse> batchDisassociateResourcesFromCustomLineItem(
            Consumer<BatchDisassociateResourcesFromCustomLineItemRequest.Builder> batchDisassociateResourcesFromCustomLineItemRequest) {
        return batchDisassociateResourcesFromCustomLineItem(BatchDisassociateResourcesFromCustomLineItemRequest.builder()
                .applyMutation(batchDisassociateResourcesFromCustomLineItemRequest).build());
    }

    /**
     * <p>
     * Creates a billing group that resembles a consolidated billing family that Amazon Web Services charges, based off
     * of the predefined pricing plan computation.
     * </p>
     *
     * @param createBillingGroupRequest
     * @return A Java Future containing the result of the CreateBillingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException You can cause an inconsistent state by updating or deleting a resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>ServiceLimitExceededException The request would cause a service limit to exceed.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.CreateBillingGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/CreateBillingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateBillingGroupResponse> createBillingGroup(CreateBillingGroupRequest createBillingGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a billing group that resembles a consolidated billing family that Amazon Web Services charges, based off
     * of the predefined pricing plan computation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBillingGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateBillingGroupRequest#builder()}
     * </p>
     *
     * @param createBillingGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateBillingGroupInput.Builder} to create a request.
     * @return A Java Future containing the result of the CreateBillingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException You can cause an inconsistent state by updating or deleting a resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>ServiceLimitExceededException The request would cause a service limit to exceed.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.CreateBillingGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/CreateBillingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateBillingGroupResponse> createBillingGroup(
            Consumer<CreateBillingGroupRequest.Builder> createBillingGroupRequest) {
        return createBillingGroup(CreateBillingGroupRequest.builder().applyMutation(createBillingGroupRequest).build());
    }

    /**
     * <p>
     * Creates a custom line item that can be used to create a one-time fixed charge that can be applied to a single
     * billing group for the current or previous billing period. The one-time fixed charge is either a fee or discount.
     * </p>
     *
     * @param createCustomLineItemRequest
     * @return A Java Future containing the result of the CreateCustomLineItem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException You can cause an inconsistent state by updating or deleting a resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>ServiceLimitExceededException The request would cause a service limit to exceed.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.CreateCustomLineItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/CreateCustomLineItem"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCustomLineItemResponse> createCustomLineItem(
            CreateCustomLineItemRequest createCustomLineItemRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a custom line item that can be used to create a one-time fixed charge that can be applied to a single
     * billing group for the current or previous billing period. The one-time fixed charge is either a fee or discount.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCustomLineItemRequest.Builder} avoiding the
     * need to create one manually via {@link CreateCustomLineItemRequest#builder()}
     * </p>
     *
     * @param createCustomLineItemRequest
     *        A {@link Consumer} that will call methods on {@link CreateCustomLineItemInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateCustomLineItem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException You can cause an inconsistent state by updating or deleting a resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>ServiceLimitExceededException The request would cause a service limit to exceed.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.CreateCustomLineItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/CreateCustomLineItem"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCustomLineItemResponse> createCustomLineItem(
            Consumer<CreateCustomLineItemRequest.Builder> createCustomLineItemRequest) {
        return createCustomLineItem(CreateCustomLineItemRequest.builder().applyMutation(createCustomLineItemRequest).build());
    }

    /**
     * <p>
     * Creates a pricing plan that is used for computing Amazon Web Services charges for billing groups.
     * </p>
     *
     * @param createPricingPlanRequest
     * @return A Java Future containing the result of the CreatePricingPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException You can cause an inconsistent state by updating or deleting a resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>ServiceLimitExceededException The request would cause a service limit to exceed.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.CreatePricingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/CreatePricingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePricingPlanResponse> createPricingPlan(CreatePricingPlanRequest createPricingPlanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a pricing plan that is used for computing Amazon Web Services charges for billing groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePricingPlanRequest.Builder} avoiding the need
     * to create one manually via {@link CreatePricingPlanRequest#builder()}
     * </p>
     *
     * @param createPricingPlanRequest
     *        A {@link Consumer} that will call methods on {@link CreatePricingPlanInput.Builder} to create a request.
     * @return A Java Future containing the result of the CreatePricingPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException You can cause an inconsistent state by updating or deleting a resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>ServiceLimitExceededException The request would cause a service limit to exceed.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.CreatePricingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/CreatePricingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePricingPlanResponse> createPricingPlan(
            Consumer<CreatePricingPlanRequest.Builder> createPricingPlanRequest) {
        return createPricingPlan(CreatePricingPlanRequest.builder().applyMutation(createPricingPlanRequest).build());
    }

    /**
     * <p>
     * Creates a pricing rule can be associated to a pricing plan, or a set of pricing plans.
     * </p>
     *
     * @param createPricingRuleRequest
     * @return A Java Future containing the result of the CreatePricingRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException You can cause an inconsistent state by updating or deleting a resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>ServiceLimitExceededException The request would cause a service limit to exceed.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.CreatePricingRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/CreatePricingRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePricingRuleResponse> createPricingRule(CreatePricingRuleRequest createPricingRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a pricing rule can be associated to a pricing plan, or a set of pricing plans.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePricingRuleRequest.Builder} avoiding the need
     * to create one manually via {@link CreatePricingRuleRequest#builder()}
     * </p>
     *
     * @param createPricingRuleRequest
     *        A {@link Consumer} that will call methods on {@link CreatePricingRuleInput.Builder} to create a request.
     * @return A Java Future containing the result of the CreatePricingRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException You can cause an inconsistent state by updating or deleting a resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>ServiceLimitExceededException The request would cause a service limit to exceed.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.CreatePricingRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/CreatePricingRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePricingRuleResponse> createPricingRule(
            Consumer<CreatePricingRuleRequest.Builder> createPricingRuleRequest) {
        return createPricingRule(CreatePricingRuleRequest.builder().applyMutation(createPricingRuleRequest).build());
    }

    /**
     * <p>
     * Deletes a billing group.
     * </p>
     *
     * @param deleteBillingGroupRequest
     * @return A Java Future containing the result of the DeleteBillingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.DeleteBillingGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/DeleteBillingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteBillingGroupResponse> deleteBillingGroup(DeleteBillingGroupRequest deleteBillingGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a billing group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBillingGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteBillingGroupRequest#builder()}
     * </p>
     *
     * @param deleteBillingGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteBillingGroupInput.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteBillingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.DeleteBillingGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/DeleteBillingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteBillingGroupResponse> deleteBillingGroup(
            Consumer<DeleteBillingGroupRequest.Builder> deleteBillingGroupRequest) {
        return deleteBillingGroup(DeleteBillingGroupRequest.builder().applyMutation(deleteBillingGroupRequest).build());
    }

    /**
     * <p>
     * Deletes the custom line item identified by the given ARN in the current, or previous billing period.
     * </p>
     *
     * @param deleteCustomLineItemRequest
     * @return A Java Future containing the result of the DeleteCustomLineItem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException You can cause an inconsistent state by updating or deleting a resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.DeleteCustomLineItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/DeleteCustomLineItem"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCustomLineItemResponse> deleteCustomLineItem(
            DeleteCustomLineItemRequest deleteCustomLineItemRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the custom line item identified by the given ARN in the current, or previous billing period.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCustomLineItemRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteCustomLineItemRequest#builder()}
     * </p>
     *
     * @param deleteCustomLineItemRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCustomLineItemInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteCustomLineItem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException You can cause an inconsistent state by updating or deleting a resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.DeleteCustomLineItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/DeleteCustomLineItem"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCustomLineItemResponse> deleteCustomLineItem(
            Consumer<DeleteCustomLineItemRequest.Builder> deleteCustomLineItemRequest) {
        return deleteCustomLineItem(DeleteCustomLineItemRequest.builder().applyMutation(deleteCustomLineItemRequest).build());
    }

    /**
     * <p>
     * Deletes a pricing plan. The pricing plan must not be associated with any billing groups to delete successfully.
     * </p>
     *
     * @param deletePricingPlanRequest
     * @return A Java Future containing the result of the DeletePricingPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException You can cause an inconsistent state by updating or deleting a resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.DeletePricingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/DeletePricingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeletePricingPlanResponse> deletePricingPlan(DeletePricingPlanRequest deletePricingPlanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a pricing plan. The pricing plan must not be associated with any billing groups to delete successfully.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePricingPlanRequest.Builder} avoiding the need
     * to create one manually via {@link DeletePricingPlanRequest#builder()}
     * </p>
     *
     * @param deletePricingPlanRequest
     *        A {@link Consumer} that will call methods on {@link DeletePricingPlanInput.Builder} to create a request.
     * @return A Java Future containing the result of the DeletePricingPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException You can cause an inconsistent state by updating or deleting a resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.DeletePricingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/DeletePricingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeletePricingPlanResponse> deletePricingPlan(
            Consumer<DeletePricingPlanRequest.Builder> deletePricingPlanRequest) {
        return deletePricingPlan(DeletePricingPlanRequest.builder().applyMutation(deletePricingPlanRequest).build());
    }

    /**
     * <p>
     * Deletes the pricing rule that's identified by the input Amazon Resource Name (ARN).
     * </p>
     *
     * @param deletePricingRuleRequest
     * @return A Java Future containing the result of the DeletePricingRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException You can cause an inconsistent state by updating or deleting a resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.DeletePricingRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/DeletePricingRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeletePricingRuleResponse> deletePricingRule(DeletePricingRuleRequest deletePricingRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the pricing rule that's identified by the input Amazon Resource Name (ARN).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePricingRuleRequest.Builder} avoiding the need
     * to create one manually via {@link DeletePricingRuleRequest#builder()}
     * </p>
     *
     * @param deletePricingRuleRequest
     *        A {@link Consumer} that will call methods on {@link DeletePricingRuleInput.Builder} to create a request.
     * @return A Java Future containing the result of the DeletePricingRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException You can cause an inconsistent state by updating or deleting a resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.DeletePricingRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/DeletePricingRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeletePricingRuleResponse> deletePricingRule(
            Consumer<DeletePricingRuleRequest.Builder> deletePricingRuleRequest) {
        return deletePricingRule(DeletePricingRuleRequest.builder().applyMutation(deletePricingRuleRequest).build());
    }

    /**
     * <p>
     * Removes the specified list of account IDs from the given billing group.
     * </p>
     *
     * @param disassociateAccountsRequest
     * @return A Java Future containing the result of the DisassociateAccounts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException You can cause an inconsistent state by updating or deleting a resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.DisassociateAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/DisassociateAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateAccountsResponse> disassociateAccounts(
            DisassociateAccountsRequest disassociateAccountsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified list of account IDs from the given billing group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateAccountsRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateAccountsRequest#builder()}
     * </p>
     *
     * @param disassociateAccountsRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateAccountsInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisassociateAccounts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException You can cause an inconsistent state by updating or deleting a resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.DisassociateAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/DisassociateAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateAccountsResponse> disassociateAccounts(
            Consumer<DisassociateAccountsRequest.Builder> disassociateAccountsRequest) {
        return disassociateAccounts(DisassociateAccountsRequest.builder().applyMutation(disassociateAccountsRequest).build());
    }

    /**
     * <p>
     * Disassociates a list of pricing rules from a pricing plan.
     * </p>
     *
     * @param disassociatePricingRulesRequest
     * @return A Java Future containing the result of the DisassociatePricingRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException You can cause an inconsistent state by updating or deleting a resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.DisassociatePricingRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/DisassociatePricingRules"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociatePricingRulesResponse> disassociatePricingRules(
            DisassociatePricingRulesRequest disassociatePricingRulesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a list of pricing rules from a pricing plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociatePricingRulesRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociatePricingRulesRequest#builder()}
     * </p>
     *
     * @param disassociatePricingRulesRequest
     *        A {@link Consumer} that will call methods on {@link DisassociatePricingRulesInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisassociatePricingRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException You can cause an inconsistent state by updating or deleting a resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.DisassociatePricingRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/DisassociatePricingRules"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociatePricingRulesResponse> disassociatePricingRules(
            Consumer<DisassociatePricingRulesRequest.Builder> disassociatePricingRulesRequest) {
        return disassociatePricingRules(DisassociatePricingRulesRequest.builder().applyMutation(disassociatePricingRulesRequest)
                .build());
    }

    /**
     * <p>
     * This is a paginated call to list linked accounts that are linked to the payer account for the specified time
     * period. If no information is provided, the current billing period is used. The response will optionally include
     * the billing group that's associated with the linked account.
     * </p>
     *
     * @param listAccountAssociationsRequest
     * @return A Java Future containing the result of the ListAccountAssociations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListAccountAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListAccountAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAccountAssociationsResponse> listAccountAssociations(
            ListAccountAssociationsRequest listAccountAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This is a paginated call to list linked accounts that are linked to the payer account for the specified time
     * period. If no information is provided, the current billing period is used. The response will optionally include
     * the billing group that's associated with the linked account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountAssociationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAccountAssociationsRequest#builder()}
     * </p>
     *
     * @param listAccountAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link ListAccountAssociationsInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAccountAssociations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListAccountAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListAccountAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAccountAssociationsResponse> listAccountAssociations(
            Consumer<ListAccountAssociationsRequest.Builder> listAccountAssociationsRequest) {
        return listAccountAssociations(ListAccountAssociationsRequest.builder().applyMutation(listAccountAssociationsRequest)
                .build());
    }

    /**
     * <p>
     * This is a paginated call to list linked accounts that are linked to the payer account for the specified time
     * period. If no information is provided, the current billing period is used. The response will optionally include
     * the billing group that's associated with the linked account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccountAssociations(software.amazon.awssdk.services.billingconductor.model.ListAccountAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListAccountAssociationsPublisher publisher = client.listAccountAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListAccountAssociationsPublisher publisher = client.listAccountAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.billingconductor.model.ListAccountAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.billingconductor.model.ListAccountAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountAssociations(software.amazon.awssdk.services.billingconductor.model.ListAccountAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAccountAssociationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListAccountAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListAccountAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountAssociationsPublisher listAccountAssociationsPaginator(
            ListAccountAssociationsRequest listAccountAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This is a paginated call to list linked accounts that are linked to the payer account for the specified time
     * period. If no information is provided, the current billing period is used. The response will optionally include
     * the billing group that's associated with the linked account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccountAssociations(software.amazon.awssdk.services.billingconductor.model.ListAccountAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListAccountAssociationsPublisher publisher = client.listAccountAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListAccountAssociationsPublisher publisher = client.listAccountAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.billingconductor.model.ListAccountAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.billingconductor.model.ListAccountAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountAssociations(software.amazon.awssdk.services.billingconductor.model.ListAccountAssociationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountAssociationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAccountAssociationsRequest#builder()}
     * </p>
     *
     * @param listAccountAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link ListAccountAssociationsInput.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListAccountAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListAccountAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountAssociationsPublisher listAccountAssociationsPaginator(
            Consumer<ListAccountAssociationsRequest.Builder> listAccountAssociationsRequest) {
        return listAccountAssociationsPaginator(ListAccountAssociationsRequest.builder()
                .applyMutation(listAccountAssociationsRequest).build());
    }

    /**
     * <p>
     * A paginated call to retrieve a summary report of actual Amazon Web Services charges and the calculated Amazon Web
     * Services charges based on the associated pricing plan of a billing group.
     * </p>
     *
     * @param listBillingGroupCostReportsRequest
     * @return A Java Future containing the result of the ListBillingGroupCostReports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListBillingGroupCostReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListBillingGroupCostReports"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBillingGroupCostReportsResponse> listBillingGroupCostReports(
            ListBillingGroupCostReportsRequest listBillingGroupCostReportsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A paginated call to retrieve a summary report of actual Amazon Web Services charges and the calculated Amazon Web
     * Services charges based on the associated pricing plan of a billing group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBillingGroupCostReportsRequest.Builder}
     * avoiding the need to create one manually via {@link ListBillingGroupCostReportsRequest#builder()}
     * </p>
     *
     * @param listBillingGroupCostReportsRequest
     *        A {@link Consumer} that will call methods on {@link ListBillingGroupCostReportsInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListBillingGroupCostReports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListBillingGroupCostReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListBillingGroupCostReports"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBillingGroupCostReportsResponse> listBillingGroupCostReports(
            Consumer<ListBillingGroupCostReportsRequest.Builder> listBillingGroupCostReportsRequest) {
        return listBillingGroupCostReports(ListBillingGroupCostReportsRequest.builder()
                .applyMutation(listBillingGroupCostReportsRequest).build());
    }

    /**
     * <p>
     * A paginated call to retrieve a summary report of actual Amazon Web Services charges and the calculated Amazon Web
     * Services charges based on the associated pricing plan of a billing group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBillingGroupCostReports(software.amazon.awssdk.services.billingconductor.model.ListBillingGroupCostReportsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListBillingGroupCostReportsPublisher publisher = client.listBillingGroupCostReportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListBillingGroupCostReportsPublisher publisher = client.listBillingGroupCostReportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.billingconductor.model.ListBillingGroupCostReportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.billingconductor.model.ListBillingGroupCostReportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillingGroupCostReports(software.amazon.awssdk.services.billingconductor.model.ListBillingGroupCostReportsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBillingGroupCostReportsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListBillingGroupCostReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListBillingGroupCostReports"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillingGroupCostReportsPublisher listBillingGroupCostReportsPaginator(
            ListBillingGroupCostReportsRequest listBillingGroupCostReportsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A paginated call to retrieve a summary report of actual Amazon Web Services charges and the calculated Amazon Web
     * Services charges based on the associated pricing plan of a billing group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBillingGroupCostReports(software.amazon.awssdk.services.billingconductor.model.ListBillingGroupCostReportsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListBillingGroupCostReportsPublisher publisher = client.listBillingGroupCostReportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListBillingGroupCostReportsPublisher publisher = client.listBillingGroupCostReportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.billingconductor.model.ListBillingGroupCostReportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.billingconductor.model.ListBillingGroupCostReportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillingGroupCostReports(software.amazon.awssdk.services.billingconductor.model.ListBillingGroupCostReportsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBillingGroupCostReportsRequest.Builder}
     * avoiding the need to create one manually via {@link ListBillingGroupCostReportsRequest#builder()}
     * </p>
     *
     * @param listBillingGroupCostReportsRequest
     *        A {@link Consumer} that will call methods on {@link ListBillingGroupCostReportsInput.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListBillingGroupCostReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListBillingGroupCostReports"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillingGroupCostReportsPublisher listBillingGroupCostReportsPaginator(
            Consumer<ListBillingGroupCostReportsRequest.Builder> listBillingGroupCostReportsRequest) {
        return listBillingGroupCostReportsPaginator(ListBillingGroupCostReportsRequest.builder()
                .applyMutation(listBillingGroupCostReportsRequest).build());
    }

    /**
     * <p>
     * A paginated call to retrieve a list of billing groups for the given billing period. If you don't provide a
     * billing group, the current billing period is used.
     * </p>
     *
     * @param listBillingGroupsRequest
     * @return A Java Future containing the result of the ListBillingGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListBillingGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListBillingGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBillingGroupsResponse> listBillingGroups(ListBillingGroupsRequest listBillingGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A paginated call to retrieve a list of billing groups for the given billing period. If you don't provide a
     * billing group, the current billing period is used.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBillingGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link ListBillingGroupsRequest#builder()}
     * </p>
     *
     * @param listBillingGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListBillingGroupsInput.Builder} to create a request.
     * @return A Java Future containing the result of the ListBillingGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListBillingGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListBillingGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBillingGroupsResponse> listBillingGroups(
            Consumer<ListBillingGroupsRequest.Builder> listBillingGroupsRequest) {
        return listBillingGroups(ListBillingGroupsRequest.builder().applyMutation(listBillingGroupsRequest).build());
    }

    /**
     * <p>
     * A paginated call to retrieve a list of billing groups for the given billing period. If you don't provide a
     * billing group, the current billing period is used.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBillingGroups(software.amazon.awssdk.services.billingconductor.model.ListBillingGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListBillingGroupsPublisher publisher = client.listBillingGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListBillingGroupsPublisher publisher = client.listBillingGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.billingconductor.model.ListBillingGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.billingconductor.model.ListBillingGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillingGroups(software.amazon.awssdk.services.billingconductor.model.ListBillingGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBillingGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListBillingGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListBillingGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillingGroupsPublisher listBillingGroupsPaginator(ListBillingGroupsRequest listBillingGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A paginated call to retrieve a list of billing groups for the given billing period. If you don't provide a
     * billing group, the current billing period is used.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBillingGroups(software.amazon.awssdk.services.billingconductor.model.ListBillingGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListBillingGroupsPublisher publisher = client.listBillingGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListBillingGroupsPublisher publisher = client.listBillingGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.billingconductor.model.ListBillingGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.billingconductor.model.ListBillingGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillingGroups(software.amazon.awssdk.services.billingconductor.model.ListBillingGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBillingGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link ListBillingGroupsRequest#builder()}
     * </p>
     *
     * @param listBillingGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListBillingGroupsInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListBillingGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListBillingGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillingGroupsPublisher listBillingGroupsPaginator(
            Consumer<ListBillingGroupsRequest.Builder> listBillingGroupsRequest) {
        return listBillingGroupsPaginator(ListBillingGroupsRequest.builder().applyMutation(listBillingGroupsRequest).build());
    }

    /**
     * <p>
     * A paginated call to get a list of all custom line item versions.
     * </p>
     *
     * @param listCustomLineItemVersionsRequest
     * @return A Java Future containing the result of the ListCustomLineItemVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListCustomLineItemVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListCustomLineItemVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCustomLineItemVersionsResponse> listCustomLineItemVersions(
            ListCustomLineItemVersionsRequest listCustomLineItemVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A paginated call to get a list of all custom line item versions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCustomLineItemVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListCustomLineItemVersionsRequest#builder()}
     * </p>
     *
     * @param listCustomLineItemVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListCustomLineItemVersionsInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListCustomLineItemVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListCustomLineItemVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListCustomLineItemVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCustomLineItemVersionsResponse> listCustomLineItemVersions(
            Consumer<ListCustomLineItemVersionsRequest.Builder> listCustomLineItemVersionsRequest) {
        return listCustomLineItemVersions(ListCustomLineItemVersionsRequest.builder()
                .applyMutation(listCustomLineItemVersionsRequest).build());
    }

    /**
     * <p>
     * A paginated call to get a list of all custom line item versions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomLineItemVersions(software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListCustomLineItemVersionsPublisher publisher = client.listCustomLineItemVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListCustomLineItemVersionsPublisher publisher = client.listCustomLineItemVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomLineItemVersions(software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCustomLineItemVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListCustomLineItemVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListCustomLineItemVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomLineItemVersionsPublisher listCustomLineItemVersionsPaginator(
            ListCustomLineItemVersionsRequest listCustomLineItemVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A paginated call to get a list of all custom line item versions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomLineItemVersions(software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListCustomLineItemVersionsPublisher publisher = client.listCustomLineItemVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListCustomLineItemVersionsPublisher publisher = client.listCustomLineItemVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomLineItemVersions(software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCustomLineItemVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListCustomLineItemVersionsRequest#builder()}
     * </p>
     *
     * @param listCustomLineItemVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListCustomLineItemVersionsInput.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListCustomLineItemVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListCustomLineItemVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomLineItemVersionsPublisher listCustomLineItemVersionsPaginator(
            Consumer<ListCustomLineItemVersionsRequest.Builder> listCustomLineItemVersionsRequest) {
        return listCustomLineItemVersionsPaginator(ListCustomLineItemVersionsRequest.builder()
                .applyMutation(listCustomLineItemVersionsRequest).build());
    }

    /**
     * <p>
     * A paginated call to get a list of all custom line items (FFLIs) for the given billing period. If you don't
     * provide a billing period, the current billing period is used.
     * </p>
     *
     * @param listCustomLineItemsRequest
     * @return A Java Future containing the result of the ListCustomLineItems operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListCustomLineItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListCustomLineItems"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCustomLineItemsResponse> listCustomLineItems(
            ListCustomLineItemsRequest listCustomLineItemsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A paginated call to get a list of all custom line items (FFLIs) for the given billing period. If you don't
     * provide a billing period, the current billing period is used.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCustomLineItemsRequest.Builder} avoiding the
     * need to create one manually via {@link ListCustomLineItemsRequest#builder()}
     * </p>
     *
     * @param listCustomLineItemsRequest
     *        A {@link Consumer} that will call methods on {@link ListCustomLineItemsInput.Builder} to create a request.
     * @return A Java Future containing the result of the ListCustomLineItems operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListCustomLineItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListCustomLineItems"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCustomLineItemsResponse> listCustomLineItems(
            Consumer<ListCustomLineItemsRequest.Builder> listCustomLineItemsRequest) {
        return listCustomLineItems(ListCustomLineItemsRequest.builder().applyMutation(listCustomLineItemsRequest).build());
    }

    /**
     * <p>
     * A paginated call to get a list of all custom line items (FFLIs) for the given billing period. If you don't
     * provide a billing period, the current billing period is used.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomLineItems(software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListCustomLineItemsPublisher publisher = client.listCustomLineItemsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListCustomLineItemsPublisher publisher = client.listCustomLineItemsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomLineItems(software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCustomLineItemsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListCustomLineItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListCustomLineItems"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomLineItemsPublisher listCustomLineItemsPaginator(ListCustomLineItemsRequest listCustomLineItemsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A paginated call to get a list of all custom line items (FFLIs) for the given billing period. If you don't
     * provide a billing period, the current billing period is used.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomLineItems(software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListCustomLineItemsPublisher publisher = client.listCustomLineItemsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListCustomLineItemsPublisher publisher = client.listCustomLineItemsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomLineItems(software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCustomLineItemsRequest.Builder} avoiding the
     * need to create one manually via {@link ListCustomLineItemsRequest#builder()}
     * </p>
     *
     * @param listCustomLineItemsRequest
     *        A {@link Consumer} that will call methods on {@link ListCustomLineItemsInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListCustomLineItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListCustomLineItems"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomLineItemsPublisher listCustomLineItemsPaginator(
            Consumer<ListCustomLineItemsRequest.Builder> listCustomLineItemsRequest) {
        return listCustomLineItemsPaginator(ListCustomLineItemsRequest.builder().applyMutation(listCustomLineItemsRequest)
                .build());
    }

    /**
     * <p>
     * A paginated call to get pricing plans for the given billing period. If you don't provide a billing period, the
     * current billing period is used.
     * </p>
     *
     * @param listPricingPlansRequest
     * @return A Java Future containing the result of the ListPricingPlans operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListPricingPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingPlans"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPricingPlansResponse> listPricingPlans(ListPricingPlansRequest listPricingPlansRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A paginated call to get pricing plans for the given billing period. If you don't provide a billing period, the
     * current billing period is used.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPricingPlansRequest.Builder} avoiding the need
     * to create one manually via {@link ListPricingPlansRequest#builder()}
     * </p>
     *
     * @param listPricingPlansRequest
     *        A {@link Consumer} that will call methods on {@link ListPricingPlansInput.Builder} to create a request.
     * @return A Java Future containing the result of the ListPricingPlans operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListPricingPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingPlans"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPricingPlansResponse> listPricingPlans(
            Consumer<ListPricingPlansRequest.Builder> listPricingPlansRequest) {
        return listPricingPlans(ListPricingPlansRequest.builder().applyMutation(listPricingPlansRequest).build());
    }

    /**
     * <p>
     * A list of the pricing plans that are associated with a pricing rule.
     * </p>
     *
     * @param listPricingPlansAssociatedWithPricingRuleRequest
     * @return A Java Future containing the result of the ListPricingPlansAssociatedWithPricingRule operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListPricingPlansAssociatedWithPricingRule
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingPlansAssociatedWithPricingRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPricingPlansAssociatedWithPricingRuleResponse> listPricingPlansAssociatedWithPricingRule(
            ListPricingPlansAssociatedWithPricingRuleRequest listPricingPlansAssociatedWithPricingRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A list of the pricing plans that are associated with a pricing rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListPricingPlansAssociatedWithPricingRuleRequest.Builder} avoiding the need to create one manually via
     * {@link ListPricingPlansAssociatedWithPricingRuleRequest#builder()}
     * </p>
     *
     * @param listPricingPlansAssociatedWithPricingRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link ListPricingPlansAssociatedWithPricingRuleInput.Builder} to create a request.
     * @return A Java Future containing the result of the ListPricingPlansAssociatedWithPricingRule operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListPricingPlansAssociatedWithPricingRule
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingPlansAssociatedWithPricingRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPricingPlansAssociatedWithPricingRuleResponse> listPricingPlansAssociatedWithPricingRule(
            Consumer<ListPricingPlansAssociatedWithPricingRuleRequest.Builder> listPricingPlansAssociatedWithPricingRuleRequest) {
        return listPricingPlansAssociatedWithPricingRule(ListPricingPlansAssociatedWithPricingRuleRequest.builder()
                .applyMutation(listPricingPlansAssociatedWithPricingRuleRequest).build());
    }

    /**
     * <p>
     * A list of the pricing plans that are associated with a pricing rule.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPricingPlansAssociatedWithPricingRule(software.amazon.awssdk.services.billingconductor.model.ListPricingPlansAssociatedWithPricingRuleRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListPricingPlansAssociatedWithPricingRulePublisher publisher = client.listPricingPlansAssociatedWithPricingRulePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListPricingPlansAssociatedWithPricingRulePublisher publisher = client.listPricingPlansAssociatedWithPricingRulePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.billingconductor.model.ListPricingPlansAssociatedWithPricingRuleResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.billingconductor.model.ListPricingPlansAssociatedWithPricingRuleResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPricingPlansAssociatedWithPricingRule(software.amazon.awssdk.services.billingconductor.model.ListPricingPlansAssociatedWithPricingRuleRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPricingPlansAssociatedWithPricingRuleRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListPricingPlansAssociatedWithPricingRule
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingPlansAssociatedWithPricingRule"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPricingPlansAssociatedWithPricingRulePublisher listPricingPlansAssociatedWithPricingRulePaginator(
            ListPricingPlansAssociatedWithPricingRuleRequest listPricingPlansAssociatedWithPricingRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A list of the pricing plans that are associated with a pricing rule.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPricingPlansAssociatedWithPricingRule(software.amazon.awssdk.services.billingconductor.model.ListPricingPlansAssociatedWithPricingRuleRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListPricingPlansAssociatedWithPricingRulePublisher publisher = client.listPricingPlansAssociatedWithPricingRulePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListPricingPlansAssociatedWithPricingRulePublisher publisher = client.listPricingPlansAssociatedWithPricingRulePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.billingconductor.model.ListPricingPlansAssociatedWithPricingRuleResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.billingconductor.model.ListPricingPlansAssociatedWithPricingRuleResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPricingPlansAssociatedWithPricingRule(software.amazon.awssdk.services.billingconductor.model.ListPricingPlansAssociatedWithPricingRuleRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListPricingPlansAssociatedWithPricingRuleRequest.Builder} avoiding the need to create one manually via
     * {@link ListPricingPlansAssociatedWithPricingRuleRequest#builder()}
     * </p>
     *
     * @param listPricingPlansAssociatedWithPricingRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link ListPricingPlansAssociatedWithPricingRuleInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListPricingPlansAssociatedWithPricingRule
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingPlansAssociatedWithPricingRule"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPricingPlansAssociatedWithPricingRulePublisher listPricingPlansAssociatedWithPricingRulePaginator(
            Consumer<ListPricingPlansAssociatedWithPricingRuleRequest.Builder> listPricingPlansAssociatedWithPricingRuleRequest) {
        return listPricingPlansAssociatedWithPricingRulePaginator(ListPricingPlansAssociatedWithPricingRuleRequest.builder()
                .applyMutation(listPricingPlansAssociatedWithPricingRuleRequest).build());
    }

    /**
     * <p>
     * A paginated call to get pricing plans for the given billing period. If you don't provide a billing period, the
     * current billing period is used.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPricingPlans(software.amazon.awssdk.services.billingconductor.model.ListPricingPlansRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListPricingPlansPublisher publisher = client.listPricingPlansPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListPricingPlansPublisher publisher = client.listPricingPlansPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.billingconductor.model.ListPricingPlansResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.billingconductor.model.ListPricingPlansResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPricingPlans(software.amazon.awssdk.services.billingconductor.model.ListPricingPlansRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPricingPlansRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListPricingPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingPlans"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPricingPlansPublisher listPricingPlansPaginator(ListPricingPlansRequest listPricingPlansRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A paginated call to get pricing plans for the given billing period. If you don't provide a billing period, the
     * current billing period is used.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPricingPlans(software.amazon.awssdk.services.billingconductor.model.ListPricingPlansRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListPricingPlansPublisher publisher = client.listPricingPlansPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListPricingPlansPublisher publisher = client.listPricingPlansPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.billingconductor.model.ListPricingPlansResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.billingconductor.model.ListPricingPlansResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPricingPlans(software.amazon.awssdk.services.billingconductor.model.ListPricingPlansRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPricingPlansRequest.Builder} avoiding the need
     * to create one manually via {@link ListPricingPlansRequest#builder()}
     * </p>
     *
     * @param listPricingPlansRequest
     *        A {@link Consumer} that will call methods on {@link ListPricingPlansInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListPricingPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingPlans"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPricingPlansPublisher listPricingPlansPaginator(Consumer<ListPricingPlansRequest.Builder> listPricingPlansRequest) {
        return listPricingPlansPaginator(ListPricingPlansRequest.builder().applyMutation(listPricingPlansRequest).build());
    }

    /**
     * <p>
     * Describes a pricing rule that can be associated to a pricing plan, or set of pricing plans.
     * </p>
     *
     * @param listPricingRulesRequest
     * @return A Java Future containing the result of the ListPricingRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListPricingRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingRules"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPricingRulesResponse> listPricingRules(ListPricingRulesRequest listPricingRulesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a pricing rule that can be associated to a pricing plan, or set of pricing plans.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPricingRulesRequest.Builder} avoiding the need
     * to create one manually via {@link ListPricingRulesRequest#builder()}
     * </p>
     *
     * @param listPricingRulesRequest
     *        A {@link Consumer} that will call methods on {@link ListPricingRulesInput.Builder} to create a request.
     * @return A Java Future containing the result of the ListPricingRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListPricingRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingRules"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPricingRulesResponse> listPricingRules(
            Consumer<ListPricingRulesRequest.Builder> listPricingRulesRequest) {
        return listPricingRules(ListPricingRulesRequest.builder().applyMutation(listPricingRulesRequest).build());
    }

    /**
     * <p>
     * Lists the pricing rules that are associated with a pricing plan.
     * </p>
     *
     * @param listPricingRulesAssociatedToPricingPlanRequest
     * @return A Java Future containing the result of the ListPricingRulesAssociatedToPricingPlan operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListPricingRulesAssociatedToPricingPlan
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingRulesAssociatedToPricingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPricingRulesAssociatedToPricingPlanResponse> listPricingRulesAssociatedToPricingPlan(
            ListPricingRulesAssociatedToPricingPlanRequest listPricingRulesAssociatedToPricingPlanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the pricing rules that are associated with a pricing plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListPricingRulesAssociatedToPricingPlanRequest.Builder} avoiding the need to create one manually via
     * {@link ListPricingRulesAssociatedToPricingPlanRequest#builder()}
     * </p>
     *
     * @param listPricingRulesAssociatedToPricingPlanRequest
     *        A {@link Consumer} that will call methods on {@link ListPricingRulesAssociatedToPricingPlanInput.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListPricingRulesAssociatedToPricingPlan operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListPricingRulesAssociatedToPricingPlan
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingRulesAssociatedToPricingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPricingRulesAssociatedToPricingPlanResponse> listPricingRulesAssociatedToPricingPlan(
            Consumer<ListPricingRulesAssociatedToPricingPlanRequest.Builder> listPricingRulesAssociatedToPricingPlanRequest) {
        return listPricingRulesAssociatedToPricingPlan(ListPricingRulesAssociatedToPricingPlanRequest.builder()
                .applyMutation(listPricingRulesAssociatedToPricingPlanRequest).build());
    }

    /**
     * <p>
     * Lists the pricing rules that are associated with a pricing plan.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPricingRulesAssociatedToPricingPlan(software.amazon.awssdk.services.billingconductor.model.ListPricingRulesAssociatedToPricingPlanRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListPricingRulesAssociatedToPricingPlanPublisher publisher = client.listPricingRulesAssociatedToPricingPlanPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListPricingRulesAssociatedToPricingPlanPublisher publisher = client.listPricingRulesAssociatedToPricingPlanPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.billingconductor.model.ListPricingRulesAssociatedToPricingPlanResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.billingconductor.model.ListPricingRulesAssociatedToPricingPlanResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPricingRulesAssociatedToPricingPlan(software.amazon.awssdk.services.billingconductor.model.ListPricingRulesAssociatedToPricingPlanRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPricingRulesAssociatedToPricingPlanRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListPricingRulesAssociatedToPricingPlan
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingRulesAssociatedToPricingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPricingRulesAssociatedToPricingPlanPublisher listPricingRulesAssociatedToPricingPlanPaginator(
            ListPricingRulesAssociatedToPricingPlanRequest listPricingRulesAssociatedToPricingPlanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the pricing rules that are associated with a pricing plan.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPricingRulesAssociatedToPricingPlan(software.amazon.awssdk.services.billingconductor.model.ListPricingRulesAssociatedToPricingPlanRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListPricingRulesAssociatedToPricingPlanPublisher publisher = client.listPricingRulesAssociatedToPricingPlanPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListPricingRulesAssociatedToPricingPlanPublisher publisher = client.listPricingRulesAssociatedToPricingPlanPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.billingconductor.model.ListPricingRulesAssociatedToPricingPlanResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.billingconductor.model.ListPricingRulesAssociatedToPricingPlanResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPricingRulesAssociatedToPricingPlan(software.amazon.awssdk.services.billingconductor.model.ListPricingRulesAssociatedToPricingPlanRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListPricingRulesAssociatedToPricingPlanRequest.Builder} avoiding the need to create one manually via
     * {@link ListPricingRulesAssociatedToPricingPlanRequest#builder()}
     * </p>
     *
     * @param listPricingRulesAssociatedToPricingPlanRequest
     *        A {@link Consumer} that will call methods on {@link ListPricingRulesAssociatedToPricingPlanInput.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListPricingRulesAssociatedToPricingPlan
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingRulesAssociatedToPricingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPricingRulesAssociatedToPricingPlanPublisher listPricingRulesAssociatedToPricingPlanPaginator(
            Consumer<ListPricingRulesAssociatedToPricingPlanRequest.Builder> listPricingRulesAssociatedToPricingPlanRequest) {
        return listPricingRulesAssociatedToPricingPlanPaginator(ListPricingRulesAssociatedToPricingPlanRequest.builder()
                .applyMutation(listPricingRulesAssociatedToPricingPlanRequest).build());
    }

    /**
     * <p>
     * Describes a pricing rule that can be associated to a pricing plan, or set of pricing plans.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPricingRules(software.amazon.awssdk.services.billingconductor.model.ListPricingRulesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListPricingRulesPublisher publisher = client.listPricingRulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListPricingRulesPublisher publisher = client.listPricingRulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.billingconductor.model.ListPricingRulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.billingconductor.model.ListPricingRulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPricingRules(software.amazon.awssdk.services.billingconductor.model.ListPricingRulesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPricingRulesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListPricingRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingRules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPricingRulesPublisher listPricingRulesPaginator(ListPricingRulesRequest listPricingRulesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a pricing rule that can be associated to a pricing plan, or set of pricing plans.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPricingRules(software.amazon.awssdk.services.billingconductor.model.ListPricingRulesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListPricingRulesPublisher publisher = client.listPricingRulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListPricingRulesPublisher publisher = client.listPricingRulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.billingconductor.model.ListPricingRulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.billingconductor.model.ListPricingRulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPricingRules(software.amazon.awssdk.services.billingconductor.model.ListPricingRulesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPricingRulesRequest.Builder} avoiding the need
     * to create one manually via {@link ListPricingRulesRequest#builder()}
     * </p>
     *
     * @param listPricingRulesRequest
     *        A {@link Consumer} that will call methods on {@link ListPricingRulesInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListPricingRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingRules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPricingRulesPublisher listPricingRulesPaginator(Consumer<ListPricingRulesRequest.Builder> listPricingRulesRequest) {
        return listPricingRulesPaginator(ListPricingRulesRequest.builder().applyMutation(listPricingRulesRequest).build());
    }

    /**
     * <p>
     * List the resources that are associated to a custom line item.
     * </p>
     *
     * @param listResourcesAssociatedToCustomLineItemRequest
     * @return A Java Future containing the result of the ListResourcesAssociatedToCustomLineItem operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListResourcesAssociatedToCustomLineItem
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListResourcesAssociatedToCustomLineItem"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResourcesAssociatedToCustomLineItemResponse> listResourcesAssociatedToCustomLineItem(
            ListResourcesAssociatedToCustomLineItemRequest listResourcesAssociatedToCustomLineItemRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the resources that are associated to a custom line item.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListResourcesAssociatedToCustomLineItemRequest.Builder} avoiding the need to create one manually via
     * {@link ListResourcesAssociatedToCustomLineItemRequest#builder()}
     * </p>
     *
     * @param listResourcesAssociatedToCustomLineItemRequest
     *        A {@link Consumer} that will call methods on {@link ListResourcesAssociatedToCustomLineItemInput.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListResourcesAssociatedToCustomLineItem operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListResourcesAssociatedToCustomLineItem
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListResourcesAssociatedToCustomLineItem"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResourcesAssociatedToCustomLineItemResponse> listResourcesAssociatedToCustomLineItem(
            Consumer<ListResourcesAssociatedToCustomLineItemRequest.Builder> listResourcesAssociatedToCustomLineItemRequest) {
        return listResourcesAssociatedToCustomLineItem(ListResourcesAssociatedToCustomLineItemRequest.builder()
                .applyMutation(listResourcesAssociatedToCustomLineItemRequest).build());
    }

    /**
     * <p>
     * List the resources that are associated to a custom line item.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourcesAssociatedToCustomLineItem(software.amazon.awssdk.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListResourcesAssociatedToCustomLineItemPublisher publisher = client.listResourcesAssociatedToCustomLineItemPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListResourcesAssociatedToCustomLineItemPublisher publisher = client.listResourcesAssociatedToCustomLineItemPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourcesAssociatedToCustomLineItem(software.amazon.awssdk.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResourcesAssociatedToCustomLineItemRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListResourcesAssociatedToCustomLineItem
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListResourcesAssociatedToCustomLineItem"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourcesAssociatedToCustomLineItemPublisher listResourcesAssociatedToCustomLineItemPaginator(
            ListResourcesAssociatedToCustomLineItemRequest listResourcesAssociatedToCustomLineItemRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the resources that are associated to a custom line item.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourcesAssociatedToCustomLineItem(software.amazon.awssdk.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListResourcesAssociatedToCustomLineItemPublisher publisher = client.listResourcesAssociatedToCustomLineItemPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListResourcesAssociatedToCustomLineItemPublisher publisher = client.listResourcesAssociatedToCustomLineItemPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourcesAssociatedToCustomLineItem(software.amazon.awssdk.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListResourcesAssociatedToCustomLineItemRequest.Builder} avoiding the need to create one manually via
     * {@link ListResourcesAssociatedToCustomLineItemRequest#builder()}
     * </p>
     *
     * @param listResourcesAssociatedToCustomLineItemRequest
     *        A {@link Consumer} that will call methods on {@link ListResourcesAssociatedToCustomLineItemInput.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListResourcesAssociatedToCustomLineItem
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListResourcesAssociatedToCustomLineItem"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourcesAssociatedToCustomLineItemPublisher listResourcesAssociatedToCustomLineItemPaginator(
            Consumer<ListResourcesAssociatedToCustomLineItemRequest.Builder> listResourcesAssociatedToCustomLineItemRequest) {
        return listResourcesAssociatedToCustomLineItemPaginator(ListResourcesAssociatedToCustomLineItemRequest.builder()
                .applyMutation(listResourcesAssociatedToCustomLineItemRequest).build());
    }

    /**
     * <p>
     * A list the tags for a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A list the tags for a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Associates the specified tags to a resource with the specified <code>resourceArn</code>. If existing tags on a
     * resource are not specified in the request parameters, they are not changed.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified tags to a resource with the specified <code>resourceArn</code>. If existing tags on a
     * resource are not specified in the request parameters, they are not changed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Deletes specified tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes specified tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * This updates an existing billing group.
     * </p>
     *
     * @param updateBillingGroupRequest
     * @return A Java Future containing the result of the UpdateBillingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException You can cause an inconsistent state by updating or deleting a resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.UpdateBillingGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/UpdateBillingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateBillingGroupResponse> updateBillingGroup(UpdateBillingGroupRequest updateBillingGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This updates an existing billing group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBillingGroupRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateBillingGroupRequest#builder()}
     * </p>
     *
     * @param updateBillingGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateBillingGroupInput.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateBillingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException You can cause an inconsistent state by updating or deleting a resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.UpdateBillingGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/UpdateBillingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateBillingGroupResponse> updateBillingGroup(
            Consumer<UpdateBillingGroupRequest.Builder> updateBillingGroupRequest) {
        return updateBillingGroup(UpdateBillingGroupRequest.builder().applyMutation(updateBillingGroupRequest).build());
    }

    /**
     * <p>
     * Update an existing custom line item in the current or previous billing period.
     * </p>
     *
     * @param updateCustomLineItemRequest
     * @return A Java Future containing the result of the UpdateCustomLineItem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.UpdateCustomLineItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/UpdateCustomLineItem"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCustomLineItemResponse> updateCustomLineItem(
            UpdateCustomLineItemRequest updateCustomLineItemRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update an existing custom line item in the current or previous billing period.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCustomLineItemRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateCustomLineItemRequest#builder()}
     * </p>
     *
     * @param updateCustomLineItemRequest
     *        A {@link Consumer} that will call methods on {@link UpdateCustomLineItemInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateCustomLineItem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.UpdateCustomLineItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/UpdateCustomLineItem"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCustomLineItemResponse> updateCustomLineItem(
            Consumer<UpdateCustomLineItemRequest.Builder> updateCustomLineItemRequest) {
        return updateCustomLineItem(UpdateCustomLineItemRequest.builder().applyMutation(updateCustomLineItemRequest).build());
    }

    /**
     * <p>
     * This updates an existing pricing plan.
     * </p>
     *
     * @param updatePricingPlanRequest
     * @return A Java Future containing the result of the UpdatePricingPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException You can cause an inconsistent state by updating or deleting a resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.UpdatePricingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/UpdatePricingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePricingPlanResponse> updatePricingPlan(UpdatePricingPlanRequest updatePricingPlanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This updates an existing pricing plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePricingPlanRequest.Builder} avoiding the need
     * to create one manually via {@link UpdatePricingPlanRequest#builder()}
     * </p>
     *
     * @param updatePricingPlanRequest
     *        A {@link Consumer} that will call methods on {@link UpdatePricingPlanInput.Builder} to create a request.
     * @return A Java Future containing the result of the UpdatePricingPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException You can cause an inconsistent state by updating or deleting a resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.UpdatePricingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/UpdatePricingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePricingPlanResponse> updatePricingPlan(
            Consumer<UpdatePricingPlanRequest.Builder> updatePricingPlanRequest) {
        return updatePricingPlan(UpdatePricingPlanRequest.builder().applyMutation(updatePricingPlanRequest).build());
    }

    /**
     * <p>
     * Updates an existing pricing rule.
     * </p>
     *
     * @param updatePricingRuleRequest
     * @return A Java Future containing the result of the UpdatePricingRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException You can cause an inconsistent state by updating or deleting a resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.UpdatePricingRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/UpdatePricingRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePricingRuleResponse> updatePricingRule(UpdatePricingRuleRequest updatePricingRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing pricing rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePricingRuleRequest.Builder} avoiding the need
     * to create one manually via {@link UpdatePricingRuleRequest#builder()}
     * </p>
     *
     * @param updatePricingRuleRequest
     *        A {@link Consumer} that will call methods on {@link UpdatePricingRuleInput.Builder} to create a request.
     * @return A Java Future containing the result of the UpdatePricingRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException You can cause an inconsistent state by updating or deleting a resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.UpdatePricingRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/UpdatePricingRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePricingRuleResponse> updatePricingRule(
            Consumer<UpdatePricingRuleRequest.Builder> updatePricingRuleRequest) {
        return updatePricingRule(UpdatePricingRuleRequest.builder().applyMutation(updatePricingRuleRequest).build());
    }
}
