/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.billingconductor.model.AccessDeniedException;
import software.amazon.awssdk.services.billingconductor.model.AssociateAccountsRequest;
import software.amazon.awssdk.services.billingconductor.model.AssociateAccountsResponse;
import software.amazon.awssdk.services.billingconductor.model.AssociatePricingRulesRequest;
import software.amazon.awssdk.services.billingconductor.model.AssociatePricingRulesResponse;
import software.amazon.awssdk.services.billingconductor.model.BatchAssociateResourcesToCustomLineItemRequest;
import software.amazon.awssdk.services.billingconductor.model.BatchAssociateResourcesToCustomLineItemResponse;
import software.amazon.awssdk.services.billingconductor.model.BatchDisassociateResourcesFromCustomLineItemRequest;
import software.amazon.awssdk.services.billingconductor.model.BatchDisassociateResourcesFromCustomLineItemResponse;
import software.amazon.awssdk.services.billingconductor.model.BillingconductorException;
import software.amazon.awssdk.services.billingconductor.model.BillingconductorRequest;
import software.amazon.awssdk.services.billingconductor.model.ConflictException;
import software.amazon.awssdk.services.billingconductor.model.CreateBillingGroupRequest;
import software.amazon.awssdk.services.billingconductor.model.CreateBillingGroupResponse;
import software.amazon.awssdk.services.billingconductor.model.CreateCustomLineItemRequest;
import software.amazon.awssdk.services.billingconductor.model.CreateCustomLineItemResponse;
import software.amazon.awssdk.services.billingconductor.model.CreatePricingPlanRequest;
import software.amazon.awssdk.services.billingconductor.model.CreatePricingPlanResponse;
import software.amazon.awssdk.services.billingconductor.model.CreatePricingRuleRequest;
import software.amazon.awssdk.services.billingconductor.model.CreatePricingRuleResponse;
import software.amazon.awssdk.services.billingconductor.model.DeleteBillingGroupRequest;
import software.amazon.awssdk.services.billingconductor.model.DeleteBillingGroupResponse;
import software.amazon.awssdk.services.billingconductor.model.DeleteCustomLineItemRequest;
import software.amazon.awssdk.services.billingconductor.model.DeleteCustomLineItemResponse;
import software.amazon.awssdk.services.billingconductor.model.DeletePricingPlanRequest;
import software.amazon.awssdk.services.billingconductor.model.DeletePricingPlanResponse;
import software.amazon.awssdk.services.billingconductor.model.DeletePricingRuleRequest;
import software.amazon.awssdk.services.billingconductor.model.DeletePricingRuleResponse;
import software.amazon.awssdk.services.billingconductor.model.DisassociateAccountsRequest;
import software.amazon.awssdk.services.billingconductor.model.DisassociateAccountsResponse;
import software.amazon.awssdk.services.billingconductor.model.DisassociatePricingRulesRequest;
import software.amazon.awssdk.services.billingconductor.model.DisassociatePricingRulesResponse;
import software.amazon.awssdk.services.billingconductor.model.InternalServerException;
import software.amazon.awssdk.services.billingconductor.model.ListAccountAssociationsRequest;
import software.amazon.awssdk.services.billingconductor.model.ListAccountAssociationsResponse;
import software.amazon.awssdk.services.billingconductor.model.ListBillingGroupCostReportsRequest;
import software.amazon.awssdk.services.billingconductor.model.ListBillingGroupCostReportsResponse;
import software.amazon.awssdk.services.billingconductor.model.ListBillingGroupsRequest;
import software.amazon.awssdk.services.billingconductor.model.ListBillingGroupsResponse;
import software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemVersionsRequest;
import software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemVersionsResponse;
import software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemsRequest;
import software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemsResponse;
import software.amazon.awssdk.services.billingconductor.model.ListPricingPlansAssociatedWithPricingRuleRequest;
import software.amazon.awssdk.services.billingconductor.model.ListPricingPlansAssociatedWithPricingRuleResponse;
import software.amazon.awssdk.services.billingconductor.model.ListPricingPlansRequest;
import software.amazon.awssdk.services.billingconductor.model.ListPricingPlansResponse;
import software.amazon.awssdk.services.billingconductor.model.ListPricingRulesAssociatedToPricingPlanRequest;
import software.amazon.awssdk.services.billingconductor.model.ListPricingRulesAssociatedToPricingPlanResponse;
import software.amazon.awssdk.services.billingconductor.model.ListPricingRulesRequest;
import software.amazon.awssdk.services.billingconductor.model.ListPricingRulesResponse;
import software.amazon.awssdk.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemRequest;
import software.amazon.awssdk.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemResponse;
import software.amazon.awssdk.services.billingconductor.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.billingconductor.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.billingconductor.model.ResourceNotFoundException;
import software.amazon.awssdk.services.billingconductor.model.ServiceLimitExceededException;
import software.amazon.awssdk.services.billingconductor.model.TagResourceRequest;
import software.amazon.awssdk.services.billingconductor.model.TagResourceResponse;
import software.amazon.awssdk.services.billingconductor.model.ThrottlingException;
import software.amazon.awssdk.services.billingconductor.model.UntagResourceRequest;
import software.amazon.awssdk.services.billingconductor.model.UntagResourceResponse;
import software.amazon.awssdk.services.billingconductor.model.UpdateBillingGroupRequest;
import software.amazon.awssdk.services.billingconductor.model.UpdateBillingGroupResponse;
import software.amazon.awssdk.services.billingconductor.model.UpdateCustomLineItemRequest;
import software.amazon.awssdk.services.billingconductor.model.UpdateCustomLineItemResponse;
import software.amazon.awssdk.services.billingconductor.model.UpdatePricingPlanRequest;
import software.amazon.awssdk.services.billingconductor.model.UpdatePricingPlanResponse;
import software.amazon.awssdk.services.billingconductor.model.UpdatePricingRuleRequest;
import software.amazon.awssdk.services.billingconductor.model.UpdatePricingRuleResponse;
import software.amazon.awssdk.services.billingconductor.model.ValidationException;
import software.amazon.awssdk.services.billingconductor.paginators.ListAccountAssociationsPublisher;
import software.amazon.awssdk.services.billingconductor.paginators.ListBillingGroupCostReportsPublisher;
import software.amazon.awssdk.services.billingconductor.paginators.ListBillingGroupsPublisher;
import software.amazon.awssdk.services.billingconductor.paginators.ListCustomLineItemVersionsPublisher;
import software.amazon.awssdk.services.billingconductor.paginators.ListCustomLineItemsPublisher;
import software.amazon.awssdk.services.billingconductor.paginators.ListPricingPlansAssociatedWithPricingRulePublisher;
import software.amazon.awssdk.services.billingconductor.paginators.ListPricingPlansPublisher;
import software.amazon.awssdk.services.billingconductor.paginators.ListPricingRulesAssociatedToPricingPlanPublisher;
import software.amazon.awssdk.services.billingconductor.paginators.ListPricingRulesPublisher;
import software.amazon.awssdk.services.billingconductor.paginators.ListResourcesAssociatedToCustomLineItemPublisher;
import software.amazon.awssdk.services.billingconductor.transform.AssociateAccountsRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.AssociatePricingRulesRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.BatchAssociateResourcesToCustomLineItemRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.BatchDisassociateResourcesFromCustomLineItemRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.CreateBillingGroupRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.CreateCustomLineItemRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.CreatePricingPlanRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.CreatePricingRuleRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.DeleteBillingGroupRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.DeleteCustomLineItemRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.DeletePricingPlanRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.DeletePricingRuleRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.DisassociateAccountsRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.DisassociatePricingRulesRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.ListAccountAssociationsRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.ListBillingGroupCostReportsRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.ListBillingGroupsRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.ListCustomLineItemVersionsRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.ListCustomLineItemsRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.ListPricingPlansAssociatedWithPricingRuleRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.ListPricingPlansRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.ListPricingRulesAssociatedToPricingPlanRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.ListPricingRulesRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.ListResourcesAssociatedToCustomLineItemRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.UpdateBillingGroupRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.UpdateCustomLineItemRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.UpdatePricingPlanRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.UpdatePricingRuleRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link BillingconductorAsyncClient}.
 *
 * @see BillingconductorAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultBillingconductorAsyncClient implements BillingconductorAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultBillingconductorAsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultBillingconductorAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Connects an array of account IDs in a consolidated billing family to a predefined billing group. The account IDs
     * must be a part of the consolidated billing family during the current month, and not already associated with
     * another billing group. The maximum number of accounts that can be associated in one call is 30.
     * </p>
     *
     * @param associateAccountsRequest
     * @return A Java Future containing the result of the AssociateAccounts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException You can cause an inconsistent state by updating or deleting a resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>ServiceLimitExceededException The request would cause a service limit to exceed.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.AssociateAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/AssociateAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateAccountsResponse> associateAccounts(AssociateAccountsRequest associateAccountsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateAccountsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateAccounts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateAccountsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateAccountsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateAccountsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateAccountsRequest, AssociateAccountsResponse>()
                            .withOperationName("AssociateAccounts")
                            .withMarshaller(new AssociateAccountsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(associateAccountsRequest));
            CompletableFuture<AssociateAccountsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Connects an array of <code>PricingRuleArns</code> to a defined <code>PricingPlan</code>. The maximum number
     * <code>PricingRuleArn</code> that can be associated in one call is 30.
     * </p>
     *
     * @param associatePricingRulesRequest
     * @return A Java Future containing the result of the AssociatePricingRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException You can cause an inconsistent state by updating or deleting a resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>ServiceLimitExceededException The request would cause a service limit to exceed.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.AssociatePricingRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/AssociatePricingRules"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociatePricingRulesResponse> associatePricingRules(
            AssociatePricingRulesRequest associatePricingRulesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associatePricingRulesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociatePricingRules");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociatePricingRulesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociatePricingRulesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociatePricingRulesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociatePricingRulesRequest, AssociatePricingRulesResponse>()
                            .withOperationName("AssociatePricingRules")
                            .withMarshaller(new AssociatePricingRulesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(associatePricingRulesRequest));
            CompletableFuture<AssociatePricingRulesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a batch of resources to a percentage custom line item.
     * </p>
     *
     * @param batchAssociateResourcesToCustomLineItemRequest
     * @return A Java Future containing the result of the BatchAssociateResourcesToCustomLineItem operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException You can cause an inconsistent state by updating or deleting a resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>ServiceLimitExceededException The request would cause a service limit to exceed.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.BatchAssociateResourcesToCustomLineItem
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/BatchAssociateResourcesToCustomLineItem"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchAssociateResourcesToCustomLineItemResponse> batchAssociateResourcesToCustomLineItem(
            BatchAssociateResourcesToCustomLineItemRequest batchAssociateResourcesToCustomLineItemRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchAssociateResourcesToCustomLineItemRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchAssociateResourcesToCustomLineItem");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchAssociateResourcesToCustomLineItemResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, BatchAssociateResourcesToCustomLineItemResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchAssociateResourcesToCustomLineItemResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchAssociateResourcesToCustomLineItemRequest, BatchAssociateResourcesToCustomLineItemResponse>()
                            .withOperationName("BatchAssociateResourcesToCustomLineItem")
                            .withMarshaller(new BatchAssociateResourcesToCustomLineItemRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(batchAssociateResourcesToCustomLineItemRequest));
            CompletableFuture<BatchAssociateResourcesToCustomLineItemResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates a batch of resources from a percentage custom line item.
     * </p>
     *
     * @param batchDisassociateResourcesFromCustomLineItemRequest
     * @return A Java Future containing the result of the BatchDisassociateResourcesFromCustomLineItem operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException You can cause an inconsistent state by updating or deleting a resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.BatchDisassociateResourcesFromCustomLineItem
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/BatchDisassociateResourcesFromCustomLineItem"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchDisassociateResourcesFromCustomLineItemResponse> batchDisassociateResourcesFromCustomLineItem(
            BatchDisassociateResourcesFromCustomLineItemRequest batchDisassociateResourcesFromCustomLineItemRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchDisassociateResourcesFromCustomLineItemRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDisassociateResourcesFromCustomLineItem");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchDisassociateResourcesFromCustomLineItemResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, BatchDisassociateResourcesFromCustomLineItemResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchDisassociateResourcesFromCustomLineItemResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchDisassociateResourcesFromCustomLineItemRequest, BatchDisassociateResourcesFromCustomLineItemResponse>()
                            .withOperationName("BatchDisassociateResourcesFromCustomLineItem")
                            .withMarshaller(new BatchDisassociateResourcesFromCustomLineItemRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(batchDisassociateResourcesFromCustomLineItemRequest));
            CompletableFuture<BatchDisassociateResourcesFromCustomLineItemResponse> whenCompleted = executeFuture.whenComplete((
                    r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a billing group that resembles a consolidated billing family that Amazon Web Services charges, based off
     * of the predefined pricing plan computation.
     * </p>
     *
     * @param createBillingGroupRequest
     * @return A Java Future containing the result of the CreateBillingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException You can cause an inconsistent state by updating or deleting a resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>ServiceLimitExceededException The request would cause a service limit to exceed.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.CreateBillingGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/CreateBillingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateBillingGroupResponse> createBillingGroup(CreateBillingGroupRequest createBillingGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBillingGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBillingGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateBillingGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateBillingGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateBillingGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateBillingGroupRequest, CreateBillingGroupResponse>()
                            .withOperationName("CreateBillingGroup")
                            .withMarshaller(new CreateBillingGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createBillingGroupRequest));
            CompletableFuture<CreateBillingGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a custom line item that can be used to create a one-time fixed charge that can be applied to a single
     * billing group for the current or previous billing period. The one-time fixed charge is either a fee or discount.
     * </p>
     *
     * @param createCustomLineItemRequest
     * @return A Java Future containing the result of the CreateCustomLineItem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException You can cause an inconsistent state by updating or deleting a resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>ServiceLimitExceededException The request would cause a service limit to exceed.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.CreateCustomLineItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/CreateCustomLineItem"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCustomLineItemResponse> createCustomLineItem(
            CreateCustomLineItemRequest createCustomLineItemRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCustomLineItemRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCustomLineItem");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateCustomLineItemResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateCustomLineItemResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateCustomLineItemResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCustomLineItemRequest, CreateCustomLineItemResponse>()
                            .withOperationName("CreateCustomLineItem")
                            .withMarshaller(new CreateCustomLineItemRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createCustomLineItemRequest));
            CompletableFuture<CreateCustomLineItemResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a pricing plan that is used for computing Amazon Web Services charges for billing groups.
     * </p>
     *
     * @param createPricingPlanRequest
     * @return A Java Future containing the result of the CreatePricingPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException You can cause an inconsistent state by updating or deleting a resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>ServiceLimitExceededException The request would cause a service limit to exceed.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.CreatePricingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/CreatePricingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreatePricingPlanResponse> createPricingPlan(CreatePricingPlanRequest createPricingPlanRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPricingPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePricingPlan");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreatePricingPlanResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreatePricingPlanResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreatePricingPlanResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreatePricingPlanRequest, CreatePricingPlanResponse>()
                            .withOperationName("CreatePricingPlan")
                            .withMarshaller(new CreatePricingPlanRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createPricingPlanRequest));
            CompletableFuture<CreatePricingPlanResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a pricing rule can be associated to a pricing plan, or a set of pricing plans.
     * </p>
     *
     * @param createPricingRuleRequest
     * @return A Java Future containing the result of the CreatePricingRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException You can cause an inconsistent state by updating or deleting a resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>ServiceLimitExceededException The request would cause a service limit to exceed.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.CreatePricingRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/CreatePricingRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreatePricingRuleResponse> createPricingRule(CreatePricingRuleRequest createPricingRuleRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPricingRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePricingRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreatePricingRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreatePricingRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreatePricingRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreatePricingRuleRequest, CreatePricingRuleResponse>()
                            .withOperationName("CreatePricingRule")
                            .withMarshaller(new CreatePricingRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createPricingRuleRequest));
            CompletableFuture<CreatePricingRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a billing group.
     * </p>
     *
     * @param deleteBillingGroupRequest
     * @return A Java Future containing the result of the DeleteBillingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.DeleteBillingGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/DeleteBillingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteBillingGroupResponse> deleteBillingGroup(DeleteBillingGroupRequest deleteBillingGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBillingGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBillingGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteBillingGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteBillingGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteBillingGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteBillingGroupRequest, DeleteBillingGroupResponse>()
                            .withOperationName("DeleteBillingGroup")
                            .withMarshaller(new DeleteBillingGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteBillingGroupRequest));
            CompletableFuture<DeleteBillingGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the custom line item identified by the given ARN in the current, or previous billing period.
     * </p>
     *
     * @param deleteCustomLineItemRequest
     * @return A Java Future containing the result of the DeleteCustomLineItem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException You can cause an inconsistent state by updating or deleting a resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.DeleteCustomLineItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/DeleteCustomLineItem"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteCustomLineItemResponse> deleteCustomLineItem(
            DeleteCustomLineItemRequest deleteCustomLineItemRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCustomLineItemRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCustomLineItem");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteCustomLineItemResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteCustomLineItemResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteCustomLineItemResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteCustomLineItemRequest, DeleteCustomLineItemResponse>()
                            .withOperationName("DeleteCustomLineItem")
                            .withMarshaller(new DeleteCustomLineItemRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteCustomLineItemRequest));
            CompletableFuture<DeleteCustomLineItemResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a pricing plan. The pricing plan must not be associated with any billing groups to delete successfully.
     * </p>
     *
     * @param deletePricingPlanRequest
     * @return A Java Future containing the result of the DeletePricingPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException You can cause an inconsistent state by updating or deleting a resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.DeletePricingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/DeletePricingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeletePricingPlanResponse> deletePricingPlan(DeletePricingPlanRequest deletePricingPlanRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePricingPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePricingPlan");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeletePricingPlanResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeletePricingPlanResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeletePricingPlanResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeletePricingPlanRequest, DeletePricingPlanResponse>()
                            .withOperationName("DeletePricingPlan")
                            .withMarshaller(new DeletePricingPlanRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deletePricingPlanRequest));
            CompletableFuture<DeletePricingPlanResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the pricing rule that's identified by the input Amazon Resource Name (ARN).
     * </p>
     *
     * @param deletePricingRuleRequest
     * @return A Java Future containing the result of the DeletePricingRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException You can cause an inconsistent state by updating or deleting a resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.DeletePricingRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/DeletePricingRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeletePricingRuleResponse> deletePricingRule(DeletePricingRuleRequest deletePricingRuleRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePricingRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePricingRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeletePricingRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeletePricingRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeletePricingRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeletePricingRuleRequest, DeletePricingRuleResponse>()
                            .withOperationName("DeletePricingRule")
                            .withMarshaller(new DeletePricingRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deletePricingRuleRequest));
            CompletableFuture<DeletePricingRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the specified list of account IDs from the given billing group.
     * </p>
     *
     * @param disassociateAccountsRequest
     * @return A Java Future containing the result of the DisassociateAccounts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException You can cause an inconsistent state by updating or deleting a resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.DisassociateAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/DisassociateAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateAccountsResponse> disassociateAccounts(
            DisassociateAccountsRequest disassociateAccountsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateAccountsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateAccounts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateAccountsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisassociateAccountsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateAccountsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateAccountsRequest, DisassociateAccountsResponse>()
                            .withOperationName("DisassociateAccounts")
                            .withMarshaller(new DisassociateAccountsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(disassociateAccountsRequest));
            CompletableFuture<DisassociateAccountsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates a list of pricing rules from a pricing plan.
     * </p>
     *
     * @param disassociatePricingRulesRequest
     * @return A Java Future containing the result of the DisassociatePricingRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException You can cause an inconsistent state by updating or deleting a resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.DisassociatePricingRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/DisassociatePricingRules"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociatePricingRulesResponse> disassociatePricingRules(
            DisassociatePricingRulesRequest disassociatePricingRulesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociatePricingRulesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociatePricingRules");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociatePricingRulesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisassociatePricingRulesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociatePricingRulesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociatePricingRulesRequest, DisassociatePricingRulesResponse>()
                            .withOperationName("DisassociatePricingRules")
                            .withMarshaller(new DisassociatePricingRulesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(disassociatePricingRulesRequest));
            CompletableFuture<DisassociatePricingRulesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This is a paginated call to list linked accounts that are linked to the payer account for the specified time
     * period. If no information is provided, the current billing period is used. The response will optionally include
     * the billing group that's associated with the linked account.
     * </p>
     *
     * @param listAccountAssociationsRequest
     * @return A Java Future containing the result of the ListAccountAssociations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListAccountAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListAccountAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAccountAssociationsResponse> listAccountAssociations(
            ListAccountAssociationsRequest listAccountAssociationsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAccountAssociationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAccountAssociations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAccountAssociationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAccountAssociationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAccountAssociationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAccountAssociationsRequest, ListAccountAssociationsResponse>()
                            .withOperationName("ListAccountAssociations")
                            .withMarshaller(new ListAccountAssociationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listAccountAssociationsRequest));
            CompletableFuture<ListAccountAssociationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This is a paginated call to list linked accounts that are linked to the payer account for the specified time
     * period. If no information is provided, the current billing period is used. The response will optionally include
     * the billing group that's associated with the linked account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccountAssociations(software.amazon.awssdk.services.billingconductor.model.ListAccountAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListAccountAssociationsPublisher publisher = client.listAccountAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListAccountAssociationsPublisher publisher = client.listAccountAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.billingconductor.model.ListAccountAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.billingconductor.model.ListAccountAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountAssociations(software.amazon.awssdk.services.billingconductor.model.ListAccountAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAccountAssociationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListAccountAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListAccountAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    public ListAccountAssociationsPublisher listAccountAssociationsPaginator(
            ListAccountAssociationsRequest listAccountAssociationsRequest) {
        return new ListAccountAssociationsPublisher(this, applyPaginatorUserAgent(listAccountAssociationsRequest));
    }

    /**
     * <p>
     * A paginated call to retrieve a summary report of actual Amazon Web Services charges and the calculated Amazon Web
     * Services charges based on the associated pricing plan of a billing group.
     * </p>
     *
     * @param listBillingGroupCostReportsRequest
     * @return A Java Future containing the result of the ListBillingGroupCostReports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListBillingGroupCostReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListBillingGroupCostReports"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListBillingGroupCostReportsResponse> listBillingGroupCostReports(
            ListBillingGroupCostReportsRequest listBillingGroupCostReportsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBillingGroupCostReportsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBillingGroupCostReports");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListBillingGroupCostReportsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListBillingGroupCostReportsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListBillingGroupCostReportsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListBillingGroupCostReportsRequest, ListBillingGroupCostReportsResponse>()
                            .withOperationName("ListBillingGroupCostReports")
                            .withMarshaller(new ListBillingGroupCostReportsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listBillingGroupCostReportsRequest));
            CompletableFuture<ListBillingGroupCostReportsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * A paginated call to retrieve a summary report of actual Amazon Web Services charges and the calculated Amazon Web
     * Services charges based on the associated pricing plan of a billing group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBillingGroupCostReports(software.amazon.awssdk.services.billingconductor.model.ListBillingGroupCostReportsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListBillingGroupCostReportsPublisher publisher = client.listBillingGroupCostReportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListBillingGroupCostReportsPublisher publisher = client.listBillingGroupCostReportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.billingconductor.model.ListBillingGroupCostReportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.billingconductor.model.ListBillingGroupCostReportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillingGroupCostReports(software.amazon.awssdk.services.billingconductor.model.ListBillingGroupCostReportsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBillingGroupCostReportsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListBillingGroupCostReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListBillingGroupCostReports"
     *      target="_top">AWS API Documentation</a>
     */
    public ListBillingGroupCostReportsPublisher listBillingGroupCostReportsPaginator(
            ListBillingGroupCostReportsRequest listBillingGroupCostReportsRequest) {
        return new ListBillingGroupCostReportsPublisher(this, applyPaginatorUserAgent(listBillingGroupCostReportsRequest));
    }

    /**
     * <p>
     * A paginated call to retrieve a list of billing groups for the given billing period. If you don't provide a
     * billing group, the current billing period is used.
     * </p>
     *
     * @param listBillingGroupsRequest
     * @return A Java Future containing the result of the ListBillingGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListBillingGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListBillingGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListBillingGroupsResponse> listBillingGroups(ListBillingGroupsRequest listBillingGroupsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBillingGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBillingGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListBillingGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListBillingGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListBillingGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListBillingGroupsRequest, ListBillingGroupsResponse>()
                            .withOperationName("ListBillingGroups")
                            .withMarshaller(new ListBillingGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listBillingGroupsRequest));
            CompletableFuture<ListBillingGroupsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * A paginated call to retrieve a list of billing groups for the given billing period. If you don't provide a
     * billing group, the current billing period is used.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBillingGroups(software.amazon.awssdk.services.billingconductor.model.ListBillingGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListBillingGroupsPublisher publisher = client.listBillingGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListBillingGroupsPublisher publisher = client.listBillingGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.billingconductor.model.ListBillingGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.billingconductor.model.ListBillingGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillingGroups(software.amazon.awssdk.services.billingconductor.model.ListBillingGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBillingGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListBillingGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListBillingGroups"
     *      target="_top">AWS API Documentation</a>
     */
    public ListBillingGroupsPublisher listBillingGroupsPaginator(ListBillingGroupsRequest listBillingGroupsRequest) {
        return new ListBillingGroupsPublisher(this, applyPaginatorUserAgent(listBillingGroupsRequest));
    }

    /**
     * <p>
     * A paginated call to get a list of all custom line item versions.
     * </p>
     *
     * @param listCustomLineItemVersionsRequest
     * @return A Java Future containing the result of the ListCustomLineItemVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListCustomLineItemVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListCustomLineItemVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCustomLineItemVersionsResponse> listCustomLineItemVersions(
            ListCustomLineItemVersionsRequest listCustomLineItemVersionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCustomLineItemVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCustomLineItemVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCustomLineItemVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListCustomLineItemVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCustomLineItemVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCustomLineItemVersionsRequest, ListCustomLineItemVersionsResponse>()
                            .withOperationName("ListCustomLineItemVersions")
                            .withMarshaller(new ListCustomLineItemVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listCustomLineItemVersionsRequest));
            CompletableFuture<ListCustomLineItemVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * A paginated call to get a list of all custom line item versions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomLineItemVersions(software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListCustomLineItemVersionsPublisher publisher = client.listCustomLineItemVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListCustomLineItemVersionsPublisher publisher = client.listCustomLineItemVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomLineItemVersions(software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCustomLineItemVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListCustomLineItemVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListCustomLineItemVersions"
     *      target="_top">AWS API Documentation</a>
     */
    public ListCustomLineItemVersionsPublisher listCustomLineItemVersionsPaginator(
            ListCustomLineItemVersionsRequest listCustomLineItemVersionsRequest) {
        return new ListCustomLineItemVersionsPublisher(this, applyPaginatorUserAgent(listCustomLineItemVersionsRequest));
    }

    /**
     * <p>
     * A paginated call to get a list of all custom line items (FFLIs) for the given billing period. If you don't
     * provide a billing period, the current billing period is used.
     * </p>
     *
     * @param listCustomLineItemsRequest
     * @return A Java Future containing the result of the ListCustomLineItems operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListCustomLineItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListCustomLineItems"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCustomLineItemsResponse> listCustomLineItems(
            ListCustomLineItemsRequest listCustomLineItemsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCustomLineItemsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCustomLineItems");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCustomLineItemsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListCustomLineItemsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCustomLineItemsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCustomLineItemsRequest, ListCustomLineItemsResponse>()
                            .withOperationName("ListCustomLineItems")
                            .withMarshaller(new ListCustomLineItemsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listCustomLineItemsRequest));
            CompletableFuture<ListCustomLineItemsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * A paginated call to get a list of all custom line items (FFLIs) for the given billing period. If you don't
     * provide a billing period, the current billing period is used.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomLineItems(software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListCustomLineItemsPublisher publisher = client.listCustomLineItemsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListCustomLineItemsPublisher publisher = client.listCustomLineItemsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomLineItems(software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCustomLineItemsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListCustomLineItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListCustomLineItems"
     *      target="_top">AWS API Documentation</a>
     */
    public ListCustomLineItemsPublisher listCustomLineItemsPaginator(ListCustomLineItemsRequest listCustomLineItemsRequest) {
        return new ListCustomLineItemsPublisher(this, applyPaginatorUserAgent(listCustomLineItemsRequest));
    }

    /**
     * <p>
     * A paginated call to get pricing plans for the given billing period. If you don't provide a billing period, the
     * current billing period is used.
     * </p>
     *
     * @param listPricingPlansRequest
     * @return A Java Future containing the result of the ListPricingPlans operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListPricingPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingPlans"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListPricingPlansResponse> listPricingPlans(ListPricingPlansRequest listPricingPlansRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPricingPlansRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPricingPlans");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListPricingPlansResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListPricingPlansResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListPricingPlansResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListPricingPlansRequest, ListPricingPlansResponse>()
                            .withOperationName("ListPricingPlans")
                            .withMarshaller(new ListPricingPlansRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listPricingPlansRequest));
            CompletableFuture<ListPricingPlansResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * A list of the pricing plans that are associated with a pricing rule.
     * </p>
     *
     * @param listPricingPlansAssociatedWithPricingRuleRequest
     * @return A Java Future containing the result of the ListPricingPlansAssociatedWithPricingRule operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListPricingPlansAssociatedWithPricingRule
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingPlansAssociatedWithPricingRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListPricingPlansAssociatedWithPricingRuleResponse> listPricingPlansAssociatedWithPricingRule(
            ListPricingPlansAssociatedWithPricingRuleRequest listPricingPlansAssociatedWithPricingRuleRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listPricingPlansAssociatedWithPricingRuleRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPricingPlansAssociatedWithPricingRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListPricingPlansAssociatedWithPricingRuleResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListPricingPlansAssociatedWithPricingRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListPricingPlansAssociatedWithPricingRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListPricingPlansAssociatedWithPricingRuleRequest, ListPricingPlansAssociatedWithPricingRuleResponse>()
                            .withOperationName("ListPricingPlansAssociatedWithPricingRule")
                            .withMarshaller(new ListPricingPlansAssociatedWithPricingRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(listPricingPlansAssociatedWithPricingRuleRequest));
            CompletableFuture<ListPricingPlansAssociatedWithPricingRuleResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * A list of the pricing plans that are associated with a pricing rule.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPricingPlansAssociatedWithPricingRule(software.amazon.awssdk.services.billingconductor.model.ListPricingPlansAssociatedWithPricingRuleRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListPricingPlansAssociatedWithPricingRulePublisher publisher = client.listPricingPlansAssociatedWithPricingRulePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListPricingPlansAssociatedWithPricingRulePublisher publisher = client.listPricingPlansAssociatedWithPricingRulePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.billingconductor.model.ListPricingPlansAssociatedWithPricingRuleResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.billingconductor.model.ListPricingPlansAssociatedWithPricingRuleResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPricingPlansAssociatedWithPricingRule(software.amazon.awssdk.services.billingconductor.model.ListPricingPlansAssociatedWithPricingRuleRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPricingPlansAssociatedWithPricingRuleRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListPricingPlansAssociatedWithPricingRule
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingPlansAssociatedWithPricingRule"
     *      target="_top">AWS API Documentation</a>
     */
    public ListPricingPlansAssociatedWithPricingRulePublisher listPricingPlansAssociatedWithPricingRulePaginator(
            ListPricingPlansAssociatedWithPricingRuleRequest listPricingPlansAssociatedWithPricingRuleRequest) {
        return new ListPricingPlansAssociatedWithPricingRulePublisher(this,
                applyPaginatorUserAgent(listPricingPlansAssociatedWithPricingRuleRequest));
    }

    /**
     * <p>
     * A paginated call to get pricing plans for the given billing period. If you don't provide a billing period, the
     * current billing period is used.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPricingPlans(software.amazon.awssdk.services.billingconductor.model.ListPricingPlansRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListPricingPlansPublisher publisher = client.listPricingPlansPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListPricingPlansPublisher publisher = client.listPricingPlansPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.billingconductor.model.ListPricingPlansResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.billingconductor.model.ListPricingPlansResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPricingPlans(software.amazon.awssdk.services.billingconductor.model.ListPricingPlansRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPricingPlansRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListPricingPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingPlans"
     *      target="_top">AWS API Documentation</a>
     */
    public ListPricingPlansPublisher listPricingPlansPaginator(ListPricingPlansRequest listPricingPlansRequest) {
        return new ListPricingPlansPublisher(this, applyPaginatorUserAgent(listPricingPlansRequest));
    }

    /**
     * <p>
     * Describes a pricing rule that can be associated to a pricing plan, or set of pricing plans.
     * </p>
     *
     * @param listPricingRulesRequest
     * @return A Java Future containing the result of the ListPricingRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListPricingRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingRules"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListPricingRulesResponse> listPricingRules(ListPricingRulesRequest listPricingRulesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPricingRulesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPricingRules");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListPricingRulesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListPricingRulesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListPricingRulesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListPricingRulesRequest, ListPricingRulesResponse>()
                            .withOperationName("ListPricingRules")
                            .withMarshaller(new ListPricingRulesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listPricingRulesRequest));
            CompletableFuture<ListPricingRulesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the pricing rules that are associated with a pricing plan.
     * </p>
     *
     * @param listPricingRulesAssociatedToPricingPlanRequest
     * @return A Java Future containing the result of the ListPricingRulesAssociatedToPricingPlan operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListPricingRulesAssociatedToPricingPlan
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingRulesAssociatedToPricingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListPricingRulesAssociatedToPricingPlanResponse> listPricingRulesAssociatedToPricingPlan(
            ListPricingRulesAssociatedToPricingPlanRequest listPricingRulesAssociatedToPricingPlanRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listPricingRulesAssociatedToPricingPlanRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPricingRulesAssociatedToPricingPlan");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListPricingRulesAssociatedToPricingPlanResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListPricingRulesAssociatedToPricingPlanResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListPricingRulesAssociatedToPricingPlanResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListPricingRulesAssociatedToPricingPlanRequest, ListPricingRulesAssociatedToPricingPlanResponse>()
                            .withOperationName("ListPricingRulesAssociatedToPricingPlan")
                            .withMarshaller(new ListPricingRulesAssociatedToPricingPlanRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(listPricingRulesAssociatedToPricingPlanRequest));
            CompletableFuture<ListPricingRulesAssociatedToPricingPlanResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the pricing rules that are associated with a pricing plan.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPricingRulesAssociatedToPricingPlan(software.amazon.awssdk.services.billingconductor.model.ListPricingRulesAssociatedToPricingPlanRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListPricingRulesAssociatedToPricingPlanPublisher publisher = client.listPricingRulesAssociatedToPricingPlanPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListPricingRulesAssociatedToPricingPlanPublisher publisher = client.listPricingRulesAssociatedToPricingPlanPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.billingconductor.model.ListPricingRulesAssociatedToPricingPlanResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.billingconductor.model.ListPricingRulesAssociatedToPricingPlanResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPricingRulesAssociatedToPricingPlan(software.amazon.awssdk.services.billingconductor.model.ListPricingRulesAssociatedToPricingPlanRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPricingRulesAssociatedToPricingPlanRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListPricingRulesAssociatedToPricingPlan
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingRulesAssociatedToPricingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    public ListPricingRulesAssociatedToPricingPlanPublisher listPricingRulesAssociatedToPricingPlanPaginator(
            ListPricingRulesAssociatedToPricingPlanRequest listPricingRulesAssociatedToPricingPlanRequest) {
        return new ListPricingRulesAssociatedToPricingPlanPublisher(this,
                applyPaginatorUserAgent(listPricingRulesAssociatedToPricingPlanRequest));
    }

    /**
     * <p>
     * Describes a pricing rule that can be associated to a pricing plan, or set of pricing plans.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPricingRules(software.amazon.awssdk.services.billingconductor.model.ListPricingRulesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListPricingRulesPublisher publisher = client.listPricingRulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListPricingRulesPublisher publisher = client.listPricingRulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.billingconductor.model.ListPricingRulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.billingconductor.model.ListPricingRulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPricingRules(software.amazon.awssdk.services.billingconductor.model.ListPricingRulesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPricingRulesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListPricingRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingRules"
     *      target="_top">AWS API Documentation</a>
     */
    public ListPricingRulesPublisher listPricingRulesPaginator(ListPricingRulesRequest listPricingRulesRequest) {
        return new ListPricingRulesPublisher(this, applyPaginatorUserAgent(listPricingRulesRequest));
    }

    /**
     * <p>
     * List the resources that are associated to a custom line item.
     * </p>
     *
     * @param listResourcesAssociatedToCustomLineItemRequest
     * @return A Java Future containing the result of the ListResourcesAssociatedToCustomLineItem operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListResourcesAssociatedToCustomLineItem
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListResourcesAssociatedToCustomLineItem"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListResourcesAssociatedToCustomLineItemResponse> listResourcesAssociatedToCustomLineItem(
            ListResourcesAssociatedToCustomLineItemRequest listResourcesAssociatedToCustomLineItemRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listResourcesAssociatedToCustomLineItemRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResourcesAssociatedToCustomLineItem");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListResourcesAssociatedToCustomLineItemResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListResourcesAssociatedToCustomLineItemResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListResourcesAssociatedToCustomLineItemResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListResourcesAssociatedToCustomLineItemRequest, ListResourcesAssociatedToCustomLineItemResponse>()
                            .withOperationName("ListResourcesAssociatedToCustomLineItem")
                            .withMarshaller(new ListResourcesAssociatedToCustomLineItemRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(listResourcesAssociatedToCustomLineItemRequest));
            CompletableFuture<ListResourcesAssociatedToCustomLineItemResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List the resources that are associated to a custom line item.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourcesAssociatedToCustomLineItem(software.amazon.awssdk.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListResourcesAssociatedToCustomLineItemPublisher publisher = client.listResourcesAssociatedToCustomLineItemPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListResourcesAssociatedToCustomLineItemPublisher publisher = client.listResourcesAssociatedToCustomLineItemPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourcesAssociatedToCustomLineItem(software.amazon.awssdk.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResourcesAssociatedToCustomLineItemRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListResourcesAssociatedToCustomLineItem
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListResourcesAssociatedToCustomLineItem"
     *      target="_top">AWS API Documentation</a>
     */
    public ListResourcesAssociatedToCustomLineItemPublisher listResourcesAssociatedToCustomLineItemPaginator(
            ListResourcesAssociatedToCustomLineItemRequest listResourcesAssociatedToCustomLineItemRequest) {
        return new ListResourcesAssociatedToCustomLineItemPublisher(this,
                applyPaginatorUserAgent(listResourcesAssociatedToCustomLineItemRequest));
    }

    /**
     * <p>
     * A list the tags for a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource")
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates the specified tags to a resource with the specified <code>resourceArn</code>. If existing tags on a
     * resource are not specified in the request parameters, they are not changed.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes specified tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource")
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This updates an existing billing group.
     * </p>
     *
     * @param updateBillingGroupRequest
     * @return A Java Future containing the result of the UpdateBillingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException You can cause an inconsistent state by updating or deleting a resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.UpdateBillingGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/UpdateBillingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateBillingGroupResponse> updateBillingGroup(UpdateBillingGroupRequest updateBillingGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateBillingGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBillingGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateBillingGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateBillingGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateBillingGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateBillingGroupRequest, UpdateBillingGroupResponse>()
                            .withOperationName("UpdateBillingGroup")
                            .withMarshaller(new UpdateBillingGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateBillingGroupRequest));
            CompletableFuture<UpdateBillingGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Update an existing custom line item in the current or previous billing period.
     * </p>
     *
     * @param updateCustomLineItemRequest
     * @return A Java Future containing the result of the UpdateCustomLineItem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.UpdateCustomLineItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/UpdateCustomLineItem"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateCustomLineItemResponse> updateCustomLineItem(
            UpdateCustomLineItemRequest updateCustomLineItemRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateCustomLineItemRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCustomLineItem");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateCustomLineItemResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateCustomLineItemResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateCustomLineItemResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateCustomLineItemRequest, UpdateCustomLineItemResponse>()
                            .withOperationName("UpdateCustomLineItem")
                            .withMarshaller(new UpdateCustomLineItemRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateCustomLineItemRequest));
            CompletableFuture<UpdateCustomLineItemResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This updates an existing pricing plan.
     * </p>
     *
     * @param updatePricingPlanRequest
     * @return A Java Future containing the result of the UpdatePricingPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException You can cause an inconsistent state by updating or deleting a resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.UpdatePricingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/UpdatePricingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdatePricingPlanResponse> updatePricingPlan(UpdatePricingPlanRequest updatePricingPlanRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePricingPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePricingPlan");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdatePricingPlanResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdatePricingPlanResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdatePricingPlanResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdatePricingPlanRequest, UpdatePricingPlanResponse>()
                            .withOperationName("UpdatePricingPlan")
                            .withMarshaller(new UpdatePricingPlanRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updatePricingPlanRequest));
            CompletableFuture<UpdatePricingPlanResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing pricing rule.
     * </p>
     *
     * @param updatePricingRuleRequest
     * @return A Java Future containing the result of the UpdatePricingRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ConflictException You can cause an inconsistent state by updating or deleting a resource.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input doesn't match with the constraints specified by Amazon Web Services
     *         services.</li>
     *         <li>InternalServerException An unexpected error occurred while processing a request.</li>
     *         <li>ResourceNotFoundException The request references a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingconductorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample BillingconductorAsyncClient.UpdatePricingRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/UpdatePricingRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdatePricingRuleResponse> updatePricingRule(UpdatePricingRuleRequest updatePricingRuleRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePricingRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePricingRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdatePricingRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdatePricingRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdatePricingRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdatePricingRuleRequest, UpdatePricingRuleResponse>()
                            .withOperationName("UpdatePricingRule")
                            .withMarshaller(new UpdatePricingRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updatePricingRuleRequest));
            CompletableFuture<UpdatePricingRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(BillingconductorException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceLimitExceededException")
                                .exceptionBuilderSupplier(ServiceLimitExceededException::builder).httpStatusCode(402).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private <T extends BillingconductorRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }
}
