/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The filter on the account ID of the linked account, or any of the following:
 * </p>
 * <p>
 * <code>MONITORED</code>: linked accounts that are associated to billing groups.
 * </p>
 * <p>
 * <code>UNMONITORED</code>: linked accounts that are not associated to billing groups.
 * </p>
 * <p>
 * <code>Billing Group Arn</code>: linked accounts that are associated to the provided Billing Group Arn.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAccountAssociationsFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<ListAccountAssociationsFilter.Builder, ListAccountAssociationsFilter> {
    private static final SdkField<String> ASSOCIATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Association").getter(getter(ListAccountAssociationsFilter::association))
            .setter(setter(Builder::association))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Association").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(ListAccountAssociationsFilter::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_FIELD,
            ACCOUNT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String association;

    private final String accountId;

    private ListAccountAssociationsFilter(BuilderImpl builder) {
        this.association = builder.association;
        this.accountId = builder.accountId;
    }

    /**
     * <p>
     * <code>MONITORED</code>: linked accounts that are associated to billing groups.
     * </p>
     * <p>
     * <code>UNMONITORED</code>: linked accounts that are not associated to billing groups.
     * </p>
     * <p>
     * <code>Billing Group Arn</code>: linked accounts that are associated to the provided Billing Group Arn.
     * </p>
     * 
     * @return <code>MONITORED</code>: linked accounts that are associated to billing groups.</p>
     *         <p>
     *         <code>UNMONITORED</code>: linked accounts that are not associated to billing groups.
     *         </p>
     *         <p>
     *         <code>Billing Group Arn</code>: linked accounts that are associated to the provided Billing Group Arn.
     */
    public final String association() {
        return association;
    }

    /**
     * <p>
     * The Amazon Web Services account ID to filter on.
     * </p>
     * 
     * @return The Amazon Web Services account ID to filter on.
     */
    public final String accountId() {
        return accountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(association());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccountAssociationsFilter)) {
            return false;
        }
        ListAccountAssociationsFilter other = (ListAccountAssociationsFilter) obj;
        return Objects.equals(association(), other.association()) && Objects.equals(accountId(), other.accountId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAccountAssociationsFilter").add("Association", association()).add("AccountId", accountId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Association":
            return Optional.ofNullable(clazz.cast(association()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAccountAssociationsFilter, T> g) {
        return obj -> g.apply((ListAccountAssociationsFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListAccountAssociationsFilter> {
        /**
         * <p>
         * <code>MONITORED</code>: linked accounts that are associated to billing groups.
         * </p>
         * <p>
         * <code>UNMONITORED</code>: linked accounts that are not associated to billing groups.
         * </p>
         * <p>
         * <code>Billing Group Arn</code>: linked accounts that are associated to the provided Billing Group Arn.
         * </p>
         * 
         * @param association
         *        <code>MONITORED</code>: linked accounts that are associated to billing groups.</p>
         *        <p>
         *        <code>UNMONITORED</code>: linked accounts that are not associated to billing groups.
         *        </p>
         *        <p>
         *        <code>Billing Group Arn</code>: linked accounts that are associated to the provided Billing Group Arn.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder association(String association);

        /**
         * <p>
         * The Amazon Web Services account ID to filter on.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID to filter on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);
    }

    static final class BuilderImpl implements Builder {
        private String association;

        private String accountId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccountAssociationsFilter model) {
            association(model.association);
            accountId(model.accountId);
        }

        public final String getAssociation() {
            return association;
        }

        public final void setAssociation(String association) {
            this.association = association;
        }

        @Override
        public final Builder association(String association) {
            this.association = association;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        @Override
        public ListAccountAssociationsFilter build() {
            return new ListAccountAssociationsFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
