/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A representation of a pricing rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PricingRuleListElement implements SdkPojo, Serializable,
        ToCopyableBuilder<PricingRuleListElement.Builder, PricingRuleListElement> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(PricingRuleListElement::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(PricingRuleListElement::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(PricingRuleListElement::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Scope")
            .getter(getter(PricingRuleListElement::scopeAsString)).setter(setter(Builder::scope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(PricingRuleListElement::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Double> MODIFIER_PERCENTAGE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("ModifierPercentage").getter(getter(PricingRuleListElement::modifierPercentage))
            .setter(setter(Builder::modifierPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifierPercentage").build())
            .build();

    private static final SdkField<String> SERVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Service")
            .getter(getter(PricingRuleListElement::service)).setter(setter(Builder::service))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Service").build()).build();

    private static final SdkField<Long> ASSOCIATED_PRICING_PLAN_COUNT_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("AssociatedPricingPlanCount")
            .getter(getter(PricingRuleListElement::associatedPricingPlanCount))
            .setter(setter(Builder::associatedPricingPlanCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedPricingPlanCount").build())
            .build();

    private static final SdkField<Long> CREATION_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("CreationTime").getter(getter(PricingRuleListElement::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Long> LAST_MODIFIED_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("LastModifiedTime").getter(getter(PricingRuleListElement::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD,
            DESCRIPTION_FIELD, SCOPE_FIELD, TYPE_FIELD, MODIFIER_PERCENTAGE_FIELD, SERVICE_FIELD,
            ASSOCIATED_PRICING_PLAN_COUNT_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String arn;

    private final String description;

    private final String scope;

    private final String type;

    private final Double modifierPercentage;

    private final String service;

    private final Long associatedPricingPlanCount;

    private final Long creationTime;

    private final Long lastModifiedTime;

    private PricingRuleListElement(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.description = builder.description;
        this.scope = builder.scope;
        this.type = builder.type;
        this.modifierPercentage = builder.modifierPercentage;
        this.service = builder.service;
        this.associatedPricingPlanCount = builder.associatedPricingPlanCount;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    /**
     * <p>
     * The name of a pricing rule.
     * </p>
     * 
     * @return The name of a pricing rule.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) used to uniquely identify a pricing rule.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) used to uniquely identify a pricing rule.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The pricing rule description.
     * </p>
     * 
     * @return The pricing rule description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The scope of pricing rule that indicates if it is globally applicable, or if it is service-specific.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link PricingRuleScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return The scope of pricing rule that indicates if it is globally applicable, or if it is service-specific.
     * @see PricingRuleScope
     */
    public final PricingRuleScope scope() {
        return PricingRuleScope.fromValue(scope);
    }

    /**
     * <p>
     * The scope of pricing rule that indicates if it is globally applicable, or if it is service-specific.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link PricingRuleScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return The scope of pricing rule that indicates if it is globally applicable, or if it is service-specific.
     * @see PricingRuleScope
     */
    public final String scopeAsString() {
        return scope;
    }

    /**
     * <p>
     * The type of pricing rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PricingRuleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of pricing rule.
     * @see PricingRuleType
     */
    public final PricingRuleType type() {
        return PricingRuleType.fromValue(type);
    }

    /**
     * <p>
     * The type of pricing rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PricingRuleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of pricing rule.
     * @see PricingRuleType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * A percentage modifier applied on the public pricing rates.
     * </p>
     * 
     * @return A percentage modifier applied on the public pricing rates.
     */
    public final Double modifierPercentage() {
        return modifierPercentage;
    }

    /**
     * <p>
     * If the <code>Scope</code> attribute is <code>SERVICE</code>, this attribute indicates which service the
     * <code>PricingRule</code> is applicable for.
     * </p>
     * 
     * @return If the <code>Scope</code> attribute is <code>SERVICE</code>, this attribute indicates which service the
     *         <code>PricingRule</code> is applicable for.
     */
    public final String service() {
        return service;
    }

    /**
     * <p>
     * The pricing plans count that this pricing rule is associated with.
     * </p>
     * 
     * @return The pricing plans count that this pricing rule is associated with.
     */
    public final Long associatedPricingPlanCount() {
        return associatedPricingPlanCount;
    }

    /**
     * <p>
     * The time when the pricing rule was created.
     * </p>
     * 
     * @return The time when the pricing rule was created.
     */
    public final Long creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The most recent time when the pricing rule was modified.
     * </p>
     * 
     * @return The most recent time when the pricing rule was modified.
     */
    public final Long lastModifiedTime() {
        return lastModifiedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(scopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(modifierPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(service());
        hashCode = 31 * hashCode + Objects.hashCode(associatedPricingPlanCount());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PricingRuleListElement)) {
            return false;
        }
        PricingRuleListElement other = (PricingRuleListElement) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(description(), other.description()) && Objects.equals(scopeAsString(), other.scopeAsString())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(modifierPercentage(), other.modifierPercentage()) && Objects.equals(service(), other.service())
                && Objects.equals(associatedPricingPlanCount(), other.associatedPricingPlanCount())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PricingRuleListElement").add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Arn", arn()).add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Scope", scopeAsString()).add("Type", typeAsString()).add("ModifierPercentage", modifierPercentage())
                .add("Service", service()).add("AssociatedPricingPlanCount", associatedPricingPlanCount())
                .add("CreationTime", creationTime()).add("LastModifiedTime", lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Scope":
            return Optional.ofNullable(clazz.cast(scopeAsString()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "ModifierPercentage":
            return Optional.ofNullable(clazz.cast(modifierPercentage()));
        case "Service":
            return Optional.ofNullable(clazz.cast(service()));
        case "AssociatedPricingPlanCount":
            return Optional.ofNullable(clazz.cast(associatedPricingPlanCount()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PricingRuleListElement, T> g) {
        return obj -> g.apply((PricingRuleListElement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PricingRuleListElement> {
        /**
         * <p>
         * The name of a pricing rule.
         * </p>
         * 
         * @param name
         *        The name of a pricing rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) used to uniquely identify a pricing rule.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) used to uniquely identify a pricing rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The pricing rule description.
         * </p>
         * 
         * @param description
         *        The pricing rule description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The scope of pricing rule that indicates if it is globally applicable, or if it is service-specific.
         * </p>
         * 
         * @param scope
         *        The scope of pricing rule that indicates if it is globally applicable, or if it is service-specific.
         * @see PricingRuleScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingRuleScope
         */
        Builder scope(String scope);

        /**
         * <p>
         * The scope of pricing rule that indicates if it is globally applicable, or if it is service-specific.
         * </p>
         * 
         * @param scope
         *        The scope of pricing rule that indicates if it is globally applicable, or if it is service-specific.
         * @see PricingRuleScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingRuleScope
         */
        Builder scope(PricingRuleScope scope);

        /**
         * <p>
         * The type of pricing rule.
         * </p>
         * 
         * @param type
         *        The type of pricing rule.
         * @see PricingRuleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingRuleType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of pricing rule.
         * </p>
         * 
         * @param type
         *        The type of pricing rule.
         * @see PricingRuleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingRuleType
         */
        Builder type(PricingRuleType type);

        /**
         * <p>
         * A percentage modifier applied on the public pricing rates.
         * </p>
         * 
         * @param modifierPercentage
         *        A percentage modifier applied on the public pricing rates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifierPercentage(Double modifierPercentage);

        /**
         * <p>
         * If the <code>Scope</code> attribute is <code>SERVICE</code>, this attribute indicates which service the
         * <code>PricingRule</code> is applicable for.
         * </p>
         * 
         * @param service
         *        If the <code>Scope</code> attribute is <code>SERVICE</code>, this attribute indicates which service
         *        the <code>PricingRule</code> is applicable for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder service(String service);

        /**
         * <p>
         * The pricing plans count that this pricing rule is associated with.
         * </p>
         * 
         * @param associatedPricingPlanCount
         *        The pricing plans count that this pricing rule is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedPricingPlanCount(Long associatedPricingPlanCount);

        /**
         * <p>
         * The time when the pricing rule was created.
         * </p>
         * 
         * @param creationTime
         *        The time when the pricing rule was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Long creationTime);

        /**
         * <p>
         * The most recent time when the pricing rule was modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The most recent time when the pricing rule was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Long lastModifiedTime);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String arn;

        private String description;

        private String scope;

        private String type;

        private Double modifierPercentage;

        private String service;

        private Long associatedPricingPlanCount;

        private Long creationTime;

        private Long lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(PricingRuleListElement model) {
            name(model.name);
            arn(model.arn);
            description(model.description);
            scope(model.scope);
            type(model.type);
            modifierPercentage(model.modifierPercentage);
            service(model.service);
            associatedPricingPlanCount(model.associatedPricingPlanCount);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getScope() {
            return scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(PricingRuleScope scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PricingRuleType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Double getModifierPercentage() {
            return modifierPercentage;
        }

        public final void setModifierPercentage(Double modifierPercentage) {
            this.modifierPercentage = modifierPercentage;
        }

        @Override
        public final Builder modifierPercentage(Double modifierPercentage) {
            this.modifierPercentage = modifierPercentage;
            return this;
        }

        public final String getService() {
            return service;
        }

        public final void setService(String service) {
            this.service = service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final Long getAssociatedPricingPlanCount() {
            return associatedPricingPlanCount;
        }

        public final void setAssociatedPricingPlanCount(Long associatedPricingPlanCount) {
            this.associatedPricingPlanCount = associatedPricingPlanCount;
        }

        @Override
        public final Builder associatedPricingPlanCount(Long associatedPricingPlanCount) {
            this.associatedPricingPlanCount = associatedPricingPlanCount;
            return this;
        }

        public final Long getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Long creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Long getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        @Override
        public PricingRuleListElement build() {
            return new PricingRuleListElement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
