/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A paginated call to retrieve a list of summary reports of actual Amazon Web Services charges and the calculated
 * Amazon Web Services charges, broken down by attributes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BillingGroupCostReportResultElement implements SdkPojo, Serializable,
        ToCopyableBuilder<BillingGroupCostReportResultElement.Builder, BillingGroupCostReportResultElement> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(BillingGroupCostReportResultElement::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> AWS_COST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AWSCost").getter(getter(BillingGroupCostReportResultElement::awsCost)).setter(setter(Builder::awsCost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AWSCost").build()).build();

    private static final SdkField<String> PROFORMA_COST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProformaCost").getter(getter(BillingGroupCostReportResultElement::proformaCost))
            .setter(setter(Builder::proformaCost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProformaCost").build()).build();

    private static final SdkField<String> MARGIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Margin")
            .getter(getter(BillingGroupCostReportResultElement::margin)).setter(setter(Builder::margin))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Margin").build()).build();

    private static final SdkField<String> MARGIN_PERCENTAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MarginPercentage").getter(getter(BillingGroupCostReportResultElement::marginPercentage))
            .setter(setter(Builder::marginPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MarginPercentage").build()).build();

    private static final SdkField<String> CURRENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Currency").getter(getter(BillingGroupCostReportResultElement::currency))
            .setter(setter(Builder::currency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Currency").build()).build();

    private static final SdkField<List<Attribute>> ATTRIBUTES_FIELD = SdkField
            .<List<Attribute>> builder(MarshallingType.LIST)
            .memberName("Attributes")
            .getter(getter(BillingGroupCostReportResultElement::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Attribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(Attribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, AWS_COST_FIELD,
            PROFORMA_COST_FIELD, MARGIN_FIELD, MARGIN_PERCENTAGE_FIELD, CURRENCY_FIELD, ATTRIBUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String awsCost;

    private final String proformaCost;

    private final String margin;

    private final String marginPercentage;

    private final String currency;

    private final List<Attribute> attributes;

    private BillingGroupCostReportResultElement(BuilderImpl builder) {
        this.arn = builder.arn;
        this.awsCost = builder.awsCost;
        this.proformaCost = builder.proformaCost;
        this.margin = builder.margin;
        this.marginPercentage = builder.marginPercentage;
        this.currency = builder.currency;
        this.attributes = builder.attributes;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) that uniquely identifies the billing group.
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) that uniquely identifies the billing group.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The actual Amazon Web Services charges for the billing group.
     * </p>
     * 
     * @return The actual Amazon Web Services charges for the billing group.
     */
    public final String awsCost() {
        return awsCost;
    }

    /**
     * <p>
     * The hypothetical Amazon Web Services charges based on the associated pricing plan of a billing group.
     * </p>
     * 
     * @return The hypothetical Amazon Web Services charges based on the associated pricing plan of a billing group.
     */
    public final String proformaCost() {
        return proformaCost;
    }

    /**
     * <p>
     * The billing group margin.
     * </p>
     * 
     * @return The billing group margin.
     */
    public final String margin() {
        return margin;
    }

    /**
     * <p>
     * The percentage of the billing group margin.
     * </p>
     * 
     * @return The percentage of the billing group margin.
     */
    public final String marginPercentage() {
        return marginPercentage;
    }

    /**
     * <p>
     * The displayed currency.
     * </p>
     * 
     * @return The displayed currency.
     */
    public final String currency() {
        return currency;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of key-value pairs that represent the attributes by which the <code>BillingGroupCostReportResults</code>
     * are grouped. For example, if you want the Amazon S3 service-level breakdown of a billing group for November 2023,
     * the attributes list will contain a key-value pair of <code>"PRODUCT_NAME"</code> and <code>"S3"</code> and a
     * key-value pair of <code>"BILLING_PERIOD"</code> and <code>"Nov 2023"</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return The list of key-value pairs that represent the attributes by which the
     *         <code>BillingGroupCostReportResults</code> are grouped. For example, if you want the Amazon S3
     *         service-level breakdown of a billing group for November 2023, the attributes list will contain a
     *         key-value pair of <code>"PRODUCT_NAME"</code> and <code>"S3"</code> and a key-value pair of
     *         <code>"BILLING_PERIOD"</code> and <code>"Nov 2023"</code>.
     */
    public final List<Attribute> attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(awsCost());
        hashCode = 31 * hashCode + Objects.hashCode(proformaCost());
        hashCode = 31 * hashCode + Objects.hashCode(margin());
        hashCode = 31 * hashCode + Objects.hashCode(marginPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(currency());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BillingGroupCostReportResultElement)) {
            return false;
        }
        BillingGroupCostReportResultElement other = (BillingGroupCostReportResultElement) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(awsCost(), other.awsCost())
                && Objects.equals(proformaCost(), other.proformaCost()) && Objects.equals(margin(), other.margin())
                && Objects.equals(marginPercentage(), other.marginPercentage()) && Objects.equals(currency(), other.currency())
                && hasAttributes() == other.hasAttributes() && Objects.equals(attributes(), other.attributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BillingGroupCostReportResultElement").add("Arn", arn()).add("AWSCost", awsCost())
                .add("ProformaCost", proformaCost()).add("Margin", margin()).add("MarginPercentage", marginPercentage())
                .add("Currency", currency()).add("Attributes", hasAttributes() ? attributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "AWSCost":
            return Optional.ofNullable(clazz.cast(awsCost()));
        case "ProformaCost":
            return Optional.ofNullable(clazz.cast(proformaCost()));
        case "Margin":
            return Optional.ofNullable(clazz.cast(margin()));
        case "MarginPercentage":
            return Optional.ofNullable(clazz.cast(marginPercentage()));
        case "Currency":
            return Optional.ofNullable(clazz.cast(currency()));
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BillingGroupCostReportResultElement, T> g) {
        return obj -> g.apply((BillingGroupCostReportResultElement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BillingGroupCostReportResultElement> {
        /**
         * <p>
         * The Amazon Resource Number (ARN) that uniquely identifies the billing group.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Number (ARN) that uniquely identifies the billing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The actual Amazon Web Services charges for the billing group.
         * </p>
         * 
         * @param awsCost
         *        The actual Amazon Web Services charges for the billing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsCost(String awsCost);

        /**
         * <p>
         * The hypothetical Amazon Web Services charges based on the associated pricing plan of a billing group.
         * </p>
         * 
         * @param proformaCost
         *        The hypothetical Amazon Web Services charges based on the associated pricing plan of a billing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proformaCost(String proformaCost);

        /**
         * <p>
         * The billing group margin.
         * </p>
         * 
         * @param margin
         *        The billing group margin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder margin(String margin);

        /**
         * <p>
         * The percentage of the billing group margin.
         * </p>
         * 
         * @param marginPercentage
         *        The percentage of the billing group margin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marginPercentage(String marginPercentage);

        /**
         * <p>
         * The displayed currency.
         * </p>
         * 
         * @param currency
         *        The displayed currency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currency(String currency);

        /**
         * <p>
         * The list of key-value pairs that represent the attributes by which the
         * <code>BillingGroupCostReportResults</code> are grouped. For example, if you want the Amazon S3 service-level
         * breakdown of a billing group for November 2023, the attributes list will contain a key-value pair of
         * <code>"PRODUCT_NAME"</code> and <code>"S3"</code> and a key-value pair of <code>"BILLING_PERIOD"</code> and
         * <code>"Nov 2023"</code>.
         * </p>
         * 
         * @param attributes
         *        The list of key-value pairs that represent the attributes by which the
         *        <code>BillingGroupCostReportResults</code> are grouped. For example, if you want the Amazon S3
         *        service-level breakdown of a billing group for November 2023, the attributes list will contain a
         *        key-value pair of <code>"PRODUCT_NAME"</code> and <code>"S3"</code> and a key-value pair of
         *        <code>"BILLING_PERIOD"</code> and <code>"Nov 2023"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Collection<Attribute> attributes);

        /**
         * <p>
         * The list of key-value pairs that represent the attributes by which the
         * <code>BillingGroupCostReportResults</code> are grouped. For example, if you want the Amazon S3 service-level
         * breakdown of a billing group for November 2023, the attributes list will contain a key-value pair of
         * <code>"PRODUCT_NAME"</code> and <code>"S3"</code> and a key-value pair of <code>"BILLING_PERIOD"</code> and
         * <code>"Nov 2023"</code>.
         * </p>
         * 
         * @param attributes
         *        The list of key-value pairs that represent the attributes by which the
         *        <code>BillingGroupCostReportResults</code> are grouped. For example, if you want the Amazon S3
         *        service-level breakdown of a billing group for November 2023, the attributes list will contain a
         *        key-value pair of <code>"PRODUCT_NAME"</code> and <code>"S3"</code> and a key-value pair of
         *        <code>"BILLING_PERIOD"</code> and <code>"Nov 2023"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Attribute... attributes);

        /**
         * <p>
         * The list of key-value pairs that represent the attributes by which the
         * <code>BillingGroupCostReportResults</code> are grouped. For example, if you want the Amazon S3 service-level
         * breakdown of a billing group for November 2023, the attributes list will contain a key-value pair of
         * <code>"PRODUCT_NAME"</code> and <code>"S3"</code> and a key-value pair of <code>"BILLING_PERIOD"</code> and
         * <code>"Nov 2023"</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.billingconductor.model.Attribute.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.billingconductor.model.Attribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.billingconductor.model.Attribute.Builder#build()} is called
         * immediately and its result is passed to {@link #attributes(List<Attribute>)}.
         * 
         * @param attributes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.billingconductor.model.Attribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributes(java.util.Collection<Attribute>)
         */
        Builder attributes(Consumer<Attribute.Builder>... attributes);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String awsCost;

        private String proformaCost;

        private String margin;

        private String marginPercentage;

        private String currency;

        private List<Attribute> attributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BillingGroupCostReportResultElement model) {
            arn(model.arn);
            awsCost(model.awsCost);
            proformaCost(model.proformaCost);
            margin(model.margin);
            marginPercentage(model.marginPercentage);
            currency(model.currency);
            attributes(model.attributes);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getAwsCost() {
            return awsCost;
        }

        public final void setAwsCost(String awsCost) {
            this.awsCost = awsCost;
        }

        @Override
        public final Builder awsCost(String awsCost) {
            this.awsCost = awsCost;
            return this;
        }

        public final String getProformaCost() {
            return proformaCost;
        }

        public final void setProformaCost(String proformaCost) {
            this.proformaCost = proformaCost;
        }

        @Override
        public final Builder proformaCost(String proformaCost) {
            this.proformaCost = proformaCost;
            return this;
        }

        public final String getMargin() {
            return margin;
        }

        public final void setMargin(String margin) {
            this.margin = margin;
        }

        @Override
        public final Builder margin(String margin) {
            this.margin = margin;
            return this;
        }

        public final String getMarginPercentage() {
            return marginPercentage;
        }

        public final void setMarginPercentage(String marginPercentage) {
            this.marginPercentage = marginPercentage;
        }

        @Override
        public final Builder marginPercentage(String marginPercentage) {
            this.marginPercentage = marginPercentage;
            return this;
        }

        public final String getCurrency() {
            return currency;
        }

        public final void setCurrency(String currency) {
            this.currency = currency;
        }

        @Override
        public final Builder currency(String currency) {
            this.currency = currency;
            return this;
        }

        public final List<Attribute.Builder> getAttributes() {
            List<Attribute.Builder> result = AttributesListCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributes(Collection<Attribute.BuilderImpl> attributes) {
            this.attributes = AttributesListCopier.copyFromBuilder(attributes);
        }

        @Override
        public final Builder attributes(Collection<Attribute> attributes) {
            this.attributes = AttributesListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Attribute... attributes) {
            attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<Attribute.Builder>... attributes) {
            attributes(Stream.of(attributes).map(c -> Attribute.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BillingGroupCostReportResultElement build() {
            return new BillingGroupCostReportResultElement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
