/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies if the billing group has the following features enabled.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBillingGroupAccountGrouping implements SdkPojo, Serializable,
        ToCopyableBuilder<ListBillingGroupAccountGrouping.Builder, ListBillingGroupAccountGrouping> {
    private static final SdkField<Boolean> AUTO_ASSOCIATE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoAssociate").getter(getter(ListBillingGroupAccountGrouping::autoAssociate))
            .setter(setter(Builder::autoAssociate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoAssociate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_ASSOCIATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean autoAssociate;

    private ListBillingGroupAccountGrouping(BuilderImpl builder) {
        this.autoAssociate = builder.autoAssociate;
    }

    /**
     * <p>
     * Specifies if this billing group will automatically associate newly added Amazon Web Services accounts that join
     * your consolidated billing family.
     * </p>
     * 
     * @return Specifies if this billing group will automatically associate newly added Amazon Web Services accounts
     *         that join your consolidated billing family.
     */
    public final Boolean autoAssociate() {
        return autoAssociate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoAssociate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBillingGroupAccountGrouping)) {
            return false;
        }
        ListBillingGroupAccountGrouping other = (ListBillingGroupAccountGrouping) obj;
        return Objects.equals(autoAssociate(), other.autoAssociate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBillingGroupAccountGrouping").add("AutoAssociate", autoAssociate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoAssociate":
            return Optional.ofNullable(clazz.cast(autoAssociate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBillingGroupAccountGrouping, T> g) {
        return obj -> g.apply((ListBillingGroupAccountGrouping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListBillingGroupAccountGrouping> {
        /**
         * <p>
         * Specifies if this billing group will automatically associate newly added Amazon Web Services accounts that
         * join your consolidated billing family.
         * </p>
         * 
         * @param autoAssociate
         *        Specifies if this billing group will automatically associate newly added Amazon Web Services accounts
         *        that join your consolidated billing family.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoAssociate(Boolean autoAssociate);
    }

    static final class BuilderImpl implements Builder {
        private Boolean autoAssociate;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBillingGroupAccountGrouping model) {
            autoAssociate(model.autoAssociate);
        }

        public final Boolean getAutoAssociate() {
            return autoAssociate;
        }

        public final void setAutoAssociate(Boolean autoAssociate) {
            this.autoAssociate = autoAssociate;
        }

        @Override
        public final Builder autoAssociate(Boolean autoAssociate) {
            this.autoAssociate = autoAssociate;
            return this;
        }

        @Override
        public ListBillingGroupAccountGrouping build() {
            return new ListBillingGroupAccountGrouping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
