/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateBillingGroupResponse extends BillingconductorResponse implements
        ToCopyableBuilder<UpdateBillingGroupResponse.Builder, UpdateBillingGroupResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(UpdateBillingGroupResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateBillingGroupResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateBillingGroupResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> PRIMARY_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrimaryAccountId").getter(getter(UpdateBillingGroupResponse::primaryAccountId))
            .setter(setter(Builder::primaryAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryAccountId").build()).build();

    private static final SdkField<String> PRICING_PLAN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PricingPlanArn").getter(getter(UpdateBillingGroupResponse::pricingPlanArn))
            .setter(setter(Builder::pricingPlanArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlanArn").build()).build();

    private static final SdkField<Long> SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Size")
            .getter(getter(UpdateBillingGroupResponse::size)).setter(setter(Builder::size))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").build()).build();

    private static final SdkField<Long> LAST_MODIFIED_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("LastModifiedTime").getter(getter(UpdateBillingGroupResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(UpdateBillingGroupResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusReason").getter(getter(UpdateBillingGroupResponse::statusReason))
            .setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()).build();

    private static final SdkField<UpdateBillingGroupAccountGrouping> ACCOUNT_GROUPING_FIELD = SdkField
            .<UpdateBillingGroupAccountGrouping> builder(MarshallingType.SDK_POJO).memberName("AccountGrouping")
            .getter(getter(UpdateBillingGroupResponse::accountGrouping)).setter(setter(Builder::accountGrouping))
            .constructor(UpdateBillingGroupAccountGrouping::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountGrouping").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, PRIMARY_ACCOUNT_ID_FIELD, PRICING_PLAN_ARN_FIELD, SIZE_FIELD, LAST_MODIFIED_TIME_FIELD,
            STATUS_FIELD, STATUS_REASON_FIELD, ACCOUNT_GROUPING_FIELD));

    private final String arn;

    private final String name;

    private final String description;

    private final String primaryAccountId;

    private final String pricingPlanArn;

    private final Long size;

    private final Long lastModifiedTime;

    private final String status;

    private final String statusReason;

    private final UpdateBillingGroupAccountGrouping accountGrouping;

    private UpdateBillingGroupResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.primaryAccountId = builder.primaryAccountId;
        this.pricingPlanArn = builder.pricingPlanArn;
        this.size = builder.size;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.accountGrouping = builder.accountGrouping;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the billing group that was updated.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the billing group that was updated.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the billing group. The names must be unique to each billing group.
     * </p>
     * 
     * @return The name of the billing group. The names must be unique to each billing group.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the billing group.
     * </p>
     * 
     * @return A description of the billing group.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The account ID that serves as the main account in a billing group.
     * </p>
     * 
     * @return The account ID that serves as the main account in a billing group.
     */
    public final String primaryAccountId() {
        return primaryAccountId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the pricing plan to compute Amazon Web Services charges for the billing group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the pricing plan to compute Amazon Web Services charges for the billing
     *         group.
     */
    public final String pricingPlanArn() {
        return pricingPlanArn;
    }

    /**
     * <p>
     * The number of accounts in the particular billing group.
     * </p>
     * 
     * @return The number of accounts in the particular billing group.
     */
    public final Long size() {
        return size;
    }

    /**
     * <p>
     * The most recent time when the billing group was modified.
     * </p>
     * 
     * @return The most recent time when the billing group was modified.
     */
    public final Long lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The status of the billing group. Only one of the valid values can be used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BillingGroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the billing group. Only one of the valid values can be used.
     * @see BillingGroupStatus
     */
    public final BillingGroupStatus status() {
        return BillingGroupStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the billing group. Only one of the valid values can be used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BillingGroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the billing group. Only one of the valid values can be used.
     * @see BillingGroupStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The reason why the billing group is in its current status.
     * </p>
     * 
     * @return The reason why the billing group is in its current status.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * Specifies if the billing group has automatic account association (<code>AutoAssociate</code>) enabled.
     * </p>
     * 
     * @return Specifies if the billing group has automatic account association (<code>AutoAssociate</code>) enabled.
     */
    public final UpdateBillingGroupAccountGrouping accountGrouping() {
        return accountGrouping;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(primaryAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(pricingPlanArn());
        hashCode = 31 * hashCode + Objects.hashCode(size());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(accountGrouping());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBillingGroupResponse)) {
            return false;
        }
        UpdateBillingGroupResponse other = (UpdateBillingGroupResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(primaryAccountId(), other.primaryAccountId())
                && Objects.equals(pricingPlanArn(), other.pricingPlanArn()) && Objects.equals(size(), other.size())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason())
                && Objects.equals(accountGrouping(), other.accountGrouping());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateBillingGroupResponse").add("Arn", arn())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PrimaryAccountId", primaryAccountId()).add("PricingPlanArn", pricingPlanArn()).add("Size", size())
                .add("LastModifiedTime", lastModifiedTime()).add("Status", statusAsString()).add("StatusReason", statusReason())
                .add("AccountGrouping", accountGrouping()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "PrimaryAccountId":
            return Optional.ofNullable(clazz.cast(primaryAccountId()));
        case "PricingPlanArn":
            return Optional.ofNullable(clazz.cast(pricingPlanArn()));
        case "Size":
            return Optional.ofNullable(clazz.cast(size()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "AccountGrouping":
            return Optional.ofNullable(clazz.cast(accountGrouping()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBillingGroupResponse, T> g) {
        return obj -> g.apply((UpdateBillingGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BillingconductorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateBillingGroupResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the billing group that was updated.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the billing group that was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the billing group. The names must be unique to each billing group.
         * </p>
         * 
         * @param name
         *        The name of the billing group. The names must be unique to each billing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the billing group.
         * </p>
         * 
         * @param description
         *        A description of the billing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The account ID that serves as the main account in a billing group.
         * </p>
         * 
         * @param primaryAccountId
         *        The account ID that serves as the main account in a billing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryAccountId(String primaryAccountId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the pricing plan to compute Amazon Web Services charges for the billing
         * group.
         * </p>
         * 
         * @param pricingPlanArn
         *        The Amazon Resource Name (ARN) of the pricing plan to compute Amazon Web Services charges for the
         *        billing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pricingPlanArn(String pricingPlanArn);

        /**
         * <p>
         * The number of accounts in the particular billing group.
         * </p>
         * 
         * @param size
         *        The number of accounts in the particular billing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Long size);

        /**
         * <p>
         * The most recent time when the billing group was modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The most recent time when the billing group was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Long lastModifiedTime);

        /**
         * <p>
         * The status of the billing group. Only one of the valid values can be used.
         * </p>
         * 
         * @param status
         *        The status of the billing group. Only one of the valid values can be used.
         * @see BillingGroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingGroupStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the billing group. Only one of the valid values can be used.
         * </p>
         * 
         * @param status
         *        The status of the billing group. Only one of the valid values can be used.
         * @see BillingGroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingGroupStatus
         */
        Builder status(BillingGroupStatus status);

        /**
         * <p>
         * The reason why the billing group is in its current status.
         * </p>
         * 
         * @param statusReason
         *        The reason why the billing group is in its current status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * Specifies if the billing group has automatic account association (<code>AutoAssociate</code>) enabled.
         * </p>
         * 
         * @param accountGrouping
         *        Specifies if the billing group has automatic account association (<code>AutoAssociate</code>) enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountGrouping(UpdateBillingGroupAccountGrouping accountGrouping);

        /**
         * <p>
         * Specifies if the billing group has automatic account association (<code>AutoAssociate</code>) enabled.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UpdateBillingGroupAccountGrouping.Builder} avoiding the need to create one manually via
         * {@link UpdateBillingGroupAccountGrouping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateBillingGroupAccountGrouping.Builder#build()} is called
         * immediately and its result is passed to {@link #accountGrouping(UpdateBillingGroupAccountGrouping)}.
         * 
         * @param accountGrouping
         *        a consumer that will call methods on {@link UpdateBillingGroupAccountGrouping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountGrouping(UpdateBillingGroupAccountGrouping)
         */
        default Builder accountGrouping(Consumer<UpdateBillingGroupAccountGrouping.Builder> accountGrouping) {
            return accountGrouping(UpdateBillingGroupAccountGrouping.builder().applyMutation(accountGrouping).build());
        }
    }

    static final class BuilderImpl extends BillingconductorResponse.BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String description;

        private String primaryAccountId;

        private String pricingPlanArn;

        private Long size;

        private Long lastModifiedTime;

        private String status;

        private String statusReason;

        private UpdateBillingGroupAccountGrouping accountGrouping;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBillingGroupResponse model) {
            super(model);
            arn(model.arn);
            name(model.name);
            description(model.description);
            primaryAccountId(model.primaryAccountId);
            pricingPlanArn(model.pricingPlanArn);
            size(model.size);
            lastModifiedTime(model.lastModifiedTime);
            status(model.status);
            statusReason(model.statusReason);
            accountGrouping(model.accountGrouping);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getPrimaryAccountId() {
            return primaryAccountId;
        }

        public final void setPrimaryAccountId(String primaryAccountId) {
            this.primaryAccountId = primaryAccountId;
        }

        @Override
        public final Builder primaryAccountId(String primaryAccountId) {
            this.primaryAccountId = primaryAccountId;
            return this;
        }

        public final String getPricingPlanArn() {
            return pricingPlanArn;
        }

        public final void setPricingPlanArn(String pricingPlanArn) {
            this.pricingPlanArn = pricingPlanArn;
        }

        @Override
        public final Builder pricingPlanArn(String pricingPlanArn) {
            this.pricingPlanArn = pricingPlanArn;
            return this;
        }

        public final Long getSize() {
            return size;
        }

        public final void setSize(Long size) {
            this.size = size;
        }

        @Override
        public final Builder size(Long size) {
            this.size = size;
            return this;
        }

        public final Long getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BillingGroupStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final UpdateBillingGroupAccountGrouping.Builder getAccountGrouping() {
            return accountGrouping != null ? accountGrouping.toBuilder() : null;
        }

        public final void setAccountGrouping(UpdateBillingGroupAccountGrouping.BuilderImpl accountGrouping) {
            this.accountGrouping = accountGrouping != null ? accountGrouping.build() : null;
        }

        @Override
        public final Builder accountGrouping(UpdateBillingGroupAccountGrouping accountGrouping) {
            this.accountGrouping = accountGrouping;
            return this;
        }

        @Override
        public UpdateBillingGroupResponse build() {
            return new UpdateBillingGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
