/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.braket.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum JobEventType {
    WAITING_FOR_PRIORITY("WAITING_FOR_PRIORITY"),
    QUEUED_FOR_EXECUTION("QUEUED_FOR_EXECUTION"),
    STARTING_INSTANCE("STARTING_INSTANCE"),
    DOWNLOADING_DATA("DOWNLOADING_DATA"),
    RUNNING("RUNNING"),
    DEPRIORITIZED_DUE_TO_INACTIVITY("DEPRIORITIZED_DUE_TO_INACTIVITY"),
    UPLOADING_RESULTS("UPLOADING_RESULTS"),
    COMPLETED("COMPLETED"),
    FAILED("FAILED"),
    MAX_RUNTIME_EXCEEDED("MAX_RUNTIME_EXCEEDED"),
    CANCELLED("CANCELLED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, JobEventType> VALUE_MAP;
    private final String value;

    private JobEventType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static JobEventType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<JobEventType> knownValues() {
        EnumSet<JobEventType> knownValues = EnumSet.allOf(JobEventType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(JobEventType.class, JobEventType::toString);
    }
}

