/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkidentity.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAppInstanceAdminResponse extends ChimeSdkIdentityResponse implements
        ToCopyableBuilder<DescribeAppInstanceAdminResponse.Builder, DescribeAppInstanceAdminResponse> {
    private static final SdkField<AppInstanceAdmin> APP_INSTANCE_ADMIN_FIELD = SdkField
            .<AppInstanceAdmin> builder(MarshallingType.SDK_POJO).memberName("AppInstanceAdmin")
            .getter(getter(DescribeAppInstanceAdminResponse::appInstanceAdmin)).setter(setter(Builder::appInstanceAdmin))
            .constructor(AppInstanceAdmin::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppInstanceAdmin").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_INSTANCE_ADMIN_FIELD));

    private final AppInstanceAdmin appInstanceAdmin;

    private DescribeAppInstanceAdminResponse(BuilderImpl builder) {
        super(builder);
        this.appInstanceAdmin = builder.appInstanceAdmin;
    }

    /**
     * <p>
     * The ARN and name of the <code>AppInstanceUser</code>, the ARN of the <code>AppInstance</code>, and the created
     * and last-updated timestamps. All timestamps use epoch milliseconds.
     * </p>
     * 
     * @return The ARN and name of the <code>AppInstanceUser</code>, the ARN of the <code>AppInstance</code>, and the
     *         created and last-updated timestamps. All timestamps use epoch milliseconds.
     */
    public final AppInstanceAdmin appInstanceAdmin() {
        return appInstanceAdmin;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appInstanceAdmin());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAppInstanceAdminResponse)) {
            return false;
        }
        DescribeAppInstanceAdminResponse other = (DescribeAppInstanceAdminResponse) obj;
        return Objects.equals(appInstanceAdmin(), other.appInstanceAdmin());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAppInstanceAdminResponse").add("AppInstanceAdmin", appInstanceAdmin()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppInstanceAdmin":
            return Optional.ofNullable(clazz.cast(appInstanceAdmin()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAppInstanceAdminResponse, T> g) {
        return obj -> g.apply((DescribeAppInstanceAdminResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkIdentityResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAppInstanceAdminResponse> {
        /**
         * <p>
         * The ARN and name of the <code>AppInstanceUser</code>, the ARN of the <code>AppInstance</code>, and the
         * created and last-updated timestamps. All timestamps use epoch milliseconds.
         * </p>
         * 
         * @param appInstanceAdmin
         *        The ARN and name of the <code>AppInstanceUser</code>, the ARN of the <code>AppInstance</code>, and the
         *        created and last-updated timestamps. All timestamps use epoch milliseconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appInstanceAdmin(AppInstanceAdmin appInstanceAdmin);

        /**
         * <p>
         * The ARN and name of the <code>AppInstanceUser</code>, the ARN of the <code>AppInstance</code>, and the
         * created and last-updated timestamps. All timestamps use epoch milliseconds.
         * </p>
         * This is a convenience method that creates an instance of the {@link AppInstanceAdmin.Builder} avoiding the
         * need to create one manually via {@link AppInstanceAdmin#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AppInstanceAdmin.Builder#build()} is called immediately and its
         * result is passed to {@link #appInstanceAdmin(AppInstanceAdmin)}.
         * 
         * @param appInstanceAdmin
         *        a consumer that will call methods on {@link AppInstanceAdmin.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appInstanceAdmin(AppInstanceAdmin)
         */
        default Builder appInstanceAdmin(Consumer<AppInstanceAdmin.Builder> appInstanceAdmin) {
            return appInstanceAdmin(AppInstanceAdmin.builder().applyMutation(appInstanceAdmin).build());
        }
    }

    static final class BuilderImpl extends ChimeSdkIdentityResponse.BuilderImpl implements Builder {
        private AppInstanceAdmin appInstanceAdmin;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAppInstanceAdminResponse model) {
            super(model);
            appInstanceAdmin(model.appInstanceAdmin);
        }

        public final AppInstanceAdmin.Builder getAppInstanceAdmin() {
            return appInstanceAdmin != null ? appInstanceAdmin.toBuilder() : null;
        }

        public final void setAppInstanceAdmin(AppInstanceAdmin.BuilderImpl appInstanceAdmin) {
            this.appInstanceAdmin = appInstanceAdmin != null ? appInstanceAdmin.build() : null;
        }

        @Override
        public final Builder appInstanceAdmin(AppInstanceAdmin appInstanceAdmin) {
            this.appInstanceAdmin = appInstanceAdmin;
            return this;
        }

        @Override
        public DescribeAppInstanceAdminResponse build() {
            return new DescribeAppInstanceAdminResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
