/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of an Kinesis video stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KinesisVideoStreamConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<KinesisVideoStreamConfiguration.Builder, KinesisVideoStreamConfiguration> {
    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(KinesisVideoStreamConfiguration::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<Integer> DATA_RETENTION_IN_HOURS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DataRetentionInHours").getter(getter(KinesisVideoStreamConfiguration::dataRetentionInHours))
            .setter(setter(Builder::dataRetentionInHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataRetentionInHours").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_FIELD,
            DATA_RETENTION_IN_HOURS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String region;

    private final Integer dataRetentionInHours;

    private KinesisVideoStreamConfiguration(BuilderImpl builder) {
        this.region = builder.region;
        this.dataRetentionInHours = builder.dataRetentionInHours;
    }

    /**
     * <p>
     * The Amazon Web Services Region of the video stream.
     * </p>
     * 
     * @return The Amazon Web Services Region of the video stream.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The amount of time that data is retained.
     * </p>
     * 
     * @return The amount of time that data is retained.
     */
    public final Integer dataRetentionInHours() {
        return dataRetentionInHours;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(dataRetentionInHours());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisVideoStreamConfiguration)) {
            return false;
        }
        KinesisVideoStreamConfiguration other = (KinesisVideoStreamConfiguration) obj;
        return Objects.equals(region(), other.region()) && Objects.equals(dataRetentionInHours(), other.dataRetentionInHours());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KinesisVideoStreamConfiguration").add("Region", region())
                .add("DataRetentionInHours", dataRetentionInHours()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "DataRetentionInHours":
            return Optional.ofNullable(clazz.cast(dataRetentionInHours()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KinesisVideoStreamConfiguration, T> g) {
        return obj -> g.apply((KinesisVideoStreamConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KinesisVideoStreamConfiguration> {
        /**
         * <p>
         * The Amazon Web Services Region of the video stream.
         * </p>
         * 
         * @param region
         *        The Amazon Web Services Region of the video stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The amount of time that data is retained.
         * </p>
         * 
         * @param dataRetentionInHours
         *        The amount of time that data is retained.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataRetentionInHours(Integer dataRetentionInHours);
    }

    static final class BuilderImpl implements Builder {
        private String region;

        private Integer dataRetentionInHours;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisVideoStreamConfiguration model) {
            region(model.region);
            dataRetentionInHours(model.dataRetentionInHours);
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final Integer getDataRetentionInHours() {
            return dataRetentionInHours;
        }

        public final void setDataRetentionInHours(Integer dataRetentionInHours) {
            this.dataRetentionInHours = dataRetentionInHours;
        }

        @Override
        public final Builder dataRetentionInHours(Integer dataRetentionInHours) {
            this.dataRetentionInHours = dataRetentionInHours;
            return this;
        }

        @Override
        public KinesisVideoStreamConfiguration build() {
            return new KinesisVideoStreamConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
