/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the configuration for an <code>ActiveSpeakerOnly</code> video tile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActiveSpeakerOnlyConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ActiveSpeakerOnlyConfiguration.Builder, ActiveSpeakerOnlyConfiguration> {
    private static final SdkField<String> ACTIVE_SPEAKER_POSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActiveSpeakerPosition").getter(getter(ActiveSpeakerOnlyConfiguration::activeSpeakerPositionAsString))
            .setter(setter(Builder::activeSpeakerPosition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveSpeakerPosition").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ACTIVE_SPEAKER_POSITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String activeSpeakerPosition;

    private ActiveSpeakerOnlyConfiguration(BuilderImpl builder) {
        this.activeSpeakerPosition = builder.activeSpeakerPosition;
    }

    /**
     * <p>
     * The position of the <code>ActiveSpeakerOnly</code> video tile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #activeSpeakerPosition} will return {@link ActiveSpeakerPosition#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #activeSpeakerPositionAsString}.
     * </p>
     * 
     * @return The position of the <code>ActiveSpeakerOnly</code> video tile.
     * @see ActiveSpeakerPosition
     */
    public final ActiveSpeakerPosition activeSpeakerPosition() {
        return ActiveSpeakerPosition.fromValue(activeSpeakerPosition);
    }

    /**
     * <p>
     * The position of the <code>ActiveSpeakerOnly</code> video tile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #activeSpeakerPosition} will return {@link ActiveSpeakerPosition#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #activeSpeakerPositionAsString}.
     * </p>
     * 
     * @return The position of the <code>ActiveSpeakerOnly</code> video tile.
     * @see ActiveSpeakerPosition
     */
    public final String activeSpeakerPositionAsString() {
        return activeSpeakerPosition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activeSpeakerPositionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActiveSpeakerOnlyConfiguration)) {
            return false;
        }
        ActiveSpeakerOnlyConfiguration other = (ActiveSpeakerOnlyConfiguration) obj;
        return Objects.equals(activeSpeakerPositionAsString(), other.activeSpeakerPositionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActiveSpeakerOnlyConfiguration").add("ActiveSpeakerPosition", activeSpeakerPositionAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActiveSpeakerPosition":
            return Optional.ofNullable(clazz.cast(activeSpeakerPositionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActiveSpeakerOnlyConfiguration, T> g) {
        return obj -> g.apply((ActiveSpeakerOnlyConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActiveSpeakerOnlyConfiguration> {
        /**
         * <p>
         * The position of the <code>ActiveSpeakerOnly</code> video tile.
         * </p>
         * 
         * @param activeSpeakerPosition
         *        The position of the <code>ActiveSpeakerOnly</code> video tile.
         * @see ActiveSpeakerPosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActiveSpeakerPosition
         */
        Builder activeSpeakerPosition(String activeSpeakerPosition);

        /**
         * <p>
         * The position of the <code>ActiveSpeakerOnly</code> video tile.
         * </p>
         * 
         * @param activeSpeakerPosition
         *        The position of the <code>ActiveSpeakerOnly</code> video tile.
         * @see ActiveSpeakerPosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActiveSpeakerPosition
         */
        Builder activeSpeakerPosition(ActiveSpeakerPosition activeSpeakerPosition);
    }

    static final class BuilderImpl implements Builder {
        private String activeSpeakerPosition;

        private BuilderImpl() {
        }

        private BuilderImpl(ActiveSpeakerOnlyConfiguration model) {
            activeSpeakerPosition(model.activeSpeakerPosition);
        }

        public final String getActiveSpeakerPosition() {
            return activeSpeakerPosition;
        }

        public final void setActiveSpeakerPosition(String activeSpeakerPosition) {
            this.activeSpeakerPosition = activeSpeakerPosition;
        }

        @Override
        public final Builder activeSpeakerPosition(String activeSpeakerPosition) {
            this.activeSpeakerPosition = activeSpeakerPosition;
            return this;
        }

        @Override
        public final Builder activeSpeakerPosition(ActiveSpeakerPosition activeSpeakerPosition) {
            this.activeSpeakerPosition(activeSpeakerPosition == null ? null : activeSpeakerPosition.toString());
            return this;
        }

        @Override
        public ActiveSpeakerOnlyConfiguration build() {
            return new ActiveSpeakerOnlyConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
