/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetVoiceToneAnalysisTaskRequest extends ChimeSdkMediaPipelinesRequest implements
        ToCopyableBuilder<GetVoiceToneAnalysisTaskRequest.Builder, GetVoiceToneAnalysisTaskRequest> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(GetVoiceToneAnalysisTaskRequest::identifier))
            .setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("identifier").build()).build();

    private static final SdkField<String> VOICE_TONE_ANALYSIS_TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VoiceToneAnalysisTaskId").getter(getter(GetVoiceToneAnalysisTaskRequest::voiceToneAnalysisTaskId))
            .setter(setter(Builder::voiceToneAnalysisTaskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("voiceToneAnalysisTaskId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD,
            VOICE_TONE_ANALYSIS_TASK_ID_FIELD));

    private final String identifier;

    private final String voiceToneAnalysisTaskId;

    private GetVoiceToneAnalysisTaskRequest(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.voiceToneAnalysisTaskId = builder.voiceToneAnalysisTaskId;
    }

    /**
     * <p>
     * The unique identifier of the resource to be updated. Valid values include the ID and ARN of the media insights
     * pipeline.
     * </p>
     * 
     * @return The unique identifier of the resource to be updated. Valid values include the ID and ARN of the media
     *         insights pipeline.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The ID of the voice tone analysis task.
     * </p>
     * 
     * @return The ID of the voice tone analysis task.
     */
    public final String voiceToneAnalysisTaskId() {
        return voiceToneAnalysisTaskId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(voiceToneAnalysisTaskId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetVoiceToneAnalysisTaskRequest)) {
            return false;
        }
        GetVoiceToneAnalysisTaskRequest other = (GetVoiceToneAnalysisTaskRequest) obj;
        return Objects.equals(identifier(), other.identifier())
                && Objects.equals(voiceToneAnalysisTaskId(), other.voiceToneAnalysisTaskId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetVoiceToneAnalysisTaskRequest").add("Identifier", identifier())
                .add("VoiceToneAnalysisTaskId", voiceToneAnalysisTaskId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "VoiceToneAnalysisTaskId":
            return Optional.ofNullable(clazz.cast(voiceToneAnalysisTaskId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetVoiceToneAnalysisTaskRequest, T> g) {
        return obj -> g.apply((GetVoiceToneAnalysisTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkMediaPipelinesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetVoiceToneAnalysisTaskRequest> {
        /**
         * <p>
         * The unique identifier of the resource to be updated. Valid values include the ID and ARN of the media
         * insights pipeline.
         * </p>
         * 
         * @param identifier
         *        The unique identifier of the resource to be updated. Valid values include the ID and ARN of the media
         *        insights pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The ID of the voice tone analysis task.
         * </p>
         * 
         * @param voiceToneAnalysisTaskId
         *        The ID of the voice tone analysis task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceToneAnalysisTaskId(String voiceToneAnalysisTaskId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeSdkMediaPipelinesRequest.BuilderImpl implements Builder {
        private String identifier;

        private String voiceToneAnalysisTaskId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetVoiceToneAnalysisTaskRequest model) {
            super(model);
            identifier(model.identifier);
            voiceToneAnalysisTaskId(model.voiceToneAnalysisTaskId);
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getVoiceToneAnalysisTaskId() {
            return voiceToneAnalysisTaskId;
        }

        public final void setVoiceToneAnalysisTaskId(String voiceToneAnalysisTaskId) {
            this.voiceToneAnalysisTaskId = voiceToneAnalysisTaskId;
        }

        @Override
        public final Builder voiceToneAnalysisTaskId(String voiceToneAnalysisTaskId) {
            this.voiceToneAnalysisTaskId = voiceToneAnalysisTaskId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetVoiceToneAnalysisTaskRequest build() {
            return new GetVoiceToneAnalysisTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
