/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmeetings.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAttendeeRequest extends ChimeSdkMeetingsRequest implements
        ToCopyableBuilder<CreateAttendeeRequest.Builder, CreateAttendeeRequest> {
    private static final SdkField<String> MEETING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MeetingId").getter(getter(CreateAttendeeRequest::meetingId)).setter(setter(Builder::meetingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("MeetingId").build()).build();

    private static final SdkField<String> EXTERNAL_USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExternalUserId").getter(getter(CreateAttendeeRequest::externalUserId))
            .setter(setter(Builder::externalUserId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalUserId").build()).build();

    private static final SdkField<AttendeeCapabilities> CAPABILITIES_FIELD = SdkField
            .<AttendeeCapabilities> builder(MarshallingType.SDK_POJO).memberName("Capabilities")
            .getter(getter(CreateAttendeeRequest::capabilities)).setter(setter(Builder::capabilities))
            .constructor(AttendeeCapabilities::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capabilities").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEETING_ID_FIELD,
            EXTERNAL_USER_ID_FIELD, CAPABILITIES_FIELD));

    private final String meetingId;

    private final String externalUserId;

    private final AttendeeCapabilities capabilities;

    private CreateAttendeeRequest(BuilderImpl builder) {
        super(builder);
        this.meetingId = builder.meetingId;
        this.externalUserId = builder.externalUserId;
        this.capabilities = builder.capabilities;
    }

    /**
     * <p>
     * The unique ID of the meeting.
     * </p>
     * 
     * @return The unique ID of the meeting.
     */
    public final String meetingId() {
        return meetingId;
    }

    /**
     * <p>
     * The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a
     * builder application.
     * </p>
     * 
     * @return The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by
     *         a builder application.
     */
    public final String externalUserId() {
        return externalUserId;
    }

    /**
     * <p>
     * The capabilities (<code>audio</code>, <code>video</code>, or <code>content</code>) that you want to grant an
     * attendee. If you don't specify capabilities, all users have send and receive capabilities on all media channels
     * by default.
     * </p>
     * <note>
     * <p>
     * You use the capabilities with a set of values that control what the capabilities can do, such as
     * <code>SendReceive</code> data. For more information about those values, see .
     * </p>
     * </note>
     * <p>
     * When using capabilities, be aware of these corner cases:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can't set <code>content</code> capabilities to <code>SendReceive</code> or <code>Receive</code> unless you
     * also set <code>video</code> capabilities to <code>SendReceive</code> or <code>Receive</code>. If you don't set
     * the <code>video</code> capability to receive, the response will contain an HTTP 400 Bad Request status code.
     * However, you can set your <code>video</code> capability to receive and you set your <code>content</code>
     * capability to not receive.
     * </p>
     * </li>
     * <li>
     * <p>
     * When you change an <code>audio</code> capability from <code>None</code> or <code>Receive</code> to
     * <code>Send</code> or <code>SendReceive</code> , and if the attendee left their microphone unmuted, audio will
     * flow from the attendee to the other meeting participants.
     * </p>
     * </li>
     * <li>
     * <p>
     * When you change a <code>video</code> or <code>content</code> capability from <code>None</code> or
     * <code>Receive</code> to <code>Send</code> or <code>SendReceive</code> , and if the attendee turned on their video
     * or content streams, remote attendess can receive those streams, but only after media renegotiation between the
     * client and the Amazon Chime back-end server.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The capabilities (<code>audio</code>, <code>video</code>, or <code>content</code>) that you want to grant
     *         an attendee. If you don't specify capabilities, all users have send and receive capabilities on all media
     *         channels by default.</p> <note>
     *         <p>
     *         You use the capabilities with a set of values that control what the capabilities can do, such as
     *         <code>SendReceive</code> data. For more information about those values, see .
     *         </p>
     *         </note>
     *         <p>
     *         When using capabilities, be aware of these corner cases:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You can't set <code>content</code> capabilities to <code>SendReceive</code> or <code>Receive</code>
     *         unless you also set <code>video</code> capabilities to <code>SendReceive</code> or <code>Receive</code>.
     *         If you don't set the <code>video</code> capability to receive, the response will contain an HTTP 400 Bad
     *         Request status code. However, you can set your <code>video</code> capability to receive and you set your
     *         <code>content</code> capability to not receive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         When you change an <code>audio</code> capability from <code>None</code> or <code>Receive</code> to
     *         <code>Send</code> or <code>SendReceive</code> , and if the attendee left their microphone unmuted, audio
     *         will flow from the attendee to the other meeting participants.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         When you change a <code>video</code> or <code>content</code> capability from <code>None</code> or
     *         <code>Receive</code> to <code>Send</code> or <code>SendReceive</code> , and if the attendee turned on
     *         their video or content streams, remote attendess can receive those streams, but only after media
     *         renegotiation between the client and the Amazon Chime back-end server.
     *         </p>
     *         </li>
     */
    public final AttendeeCapabilities capabilities() {
        return capabilities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(meetingId());
        hashCode = 31 * hashCode + Objects.hashCode(externalUserId());
        hashCode = 31 * hashCode + Objects.hashCode(capabilities());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAttendeeRequest)) {
            return false;
        }
        CreateAttendeeRequest other = (CreateAttendeeRequest) obj;
        return Objects.equals(meetingId(), other.meetingId()) && Objects.equals(externalUserId(), other.externalUserId())
                && Objects.equals(capabilities(), other.capabilities());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAttendeeRequest").add("MeetingId", meetingId())
                .add("ExternalUserId", externalUserId() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Capabilities", capabilities()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MeetingId":
            return Optional.ofNullable(clazz.cast(meetingId()));
        case "ExternalUserId":
            return Optional.ofNullable(clazz.cast(externalUserId()));
        case "Capabilities":
            return Optional.ofNullable(clazz.cast(capabilities()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAttendeeRequest, T> g) {
        return obj -> g.apply((CreateAttendeeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkMeetingsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAttendeeRequest> {
        /**
         * <p>
         * The unique ID of the meeting.
         * </p>
         * 
         * @param meetingId
         *        The unique ID of the meeting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meetingId(String meetingId);

        /**
         * <p>
         * The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a
         * builder application.
         * </p>
         * 
         * @param externalUserId
         *        The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed
         *        by a builder application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalUserId(String externalUserId);

        /**
         * <p>
         * The capabilities (<code>audio</code>, <code>video</code>, or <code>content</code>) that you want to grant an
         * attendee. If you don't specify capabilities, all users have send and receive capabilities on all media
         * channels by default.
         * </p>
         * <note>
         * <p>
         * You use the capabilities with a set of values that control what the capabilities can do, such as
         * <code>SendReceive</code> data. For more information about those values, see .
         * </p>
         * </note>
         * <p>
         * When using capabilities, be aware of these corner cases:
         * </p>
         * <ul>
         * <li>
         * <p>
         * You can't set <code>content</code> capabilities to <code>SendReceive</code> or <code>Receive</code> unless
         * you also set <code>video</code> capabilities to <code>SendReceive</code> or <code>Receive</code>. If you
         * don't set the <code>video</code> capability to receive, the response will contain an HTTP 400 Bad Request
         * status code. However, you can set your <code>video</code> capability to receive and you set your
         * <code>content</code> capability to not receive.
         * </p>
         * </li>
         * <li>
         * <p>
         * When you change an <code>audio</code> capability from <code>None</code> or <code>Receive</code> to
         * <code>Send</code> or <code>SendReceive</code> , and if the attendee left their microphone unmuted, audio will
         * flow from the attendee to the other meeting participants.
         * </p>
         * </li>
         * <li>
         * <p>
         * When you change a <code>video</code> or <code>content</code> capability from <code>None</code> or
         * <code>Receive</code> to <code>Send</code> or <code>SendReceive</code> , and if the attendee turned on their
         * video or content streams, remote attendess can receive those streams, but only after media renegotiation
         * between the client and the Amazon Chime back-end server.
         * </p>
         * </li>
         * </ul>
         * 
         * @param capabilities
         *        The capabilities (<code>audio</code>, <code>video</code>, or <code>content</code>) that you want to
         *        grant an attendee. If you don't specify capabilities, all users have send and receive capabilities on
         *        all media channels by default.</p> <note>
         *        <p>
         *        You use the capabilities with a set of values that control what the capabilities can do, such as
         *        <code>SendReceive</code> data. For more information about those values, see .
         *        </p>
         *        </note>
         *        <p>
         *        When using capabilities, be aware of these corner cases:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        You can't set <code>content</code> capabilities to <code>SendReceive</code> or <code>Receive</code>
         *        unless you also set <code>video</code> capabilities to <code>SendReceive</code> or
         *        <code>Receive</code>. If you don't set the <code>video</code> capability to receive, the response will
         *        contain an HTTP 400 Bad Request status code. However, you can set your <code>video</code> capability
         *        to receive and you set your <code>content</code> capability to not receive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        When you change an <code>audio</code> capability from <code>None</code> or <code>Receive</code> to
         *        <code>Send</code> or <code>SendReceive</code> , and if the attendee left their microphone unmuted,
         *        audio will flow from the attendee to the other meeting participants.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        When you change a <code>video</code> or <code>content</code> capability from <code>None</code> or
         *        <code>Receive</code> to <code>Send</code> or <code>SendReceive</code> , and if the attendee turned on
         *        their video or content streams, remote attendess can receive those streams, but only after media
         *        renegotiation between the client and the Amazon Chime back-end server.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(AttendeeCapabilities capabilities);

        /**
         * <p>
         * The capabilities (<code>audio</code>, <code>video</code>, or <code>content</code>) that you want to grant an
         * attendee. If you don't specify capabilities, all users have send and receive capabilities on all media
         * channels by default.
         * </p>
         * <note>
         * <p>
         * You use the capabilities with a set of values that control what the capabilities can do, such as
         * <code>SendReceive</code> data. For more information about those values, see .
         * </p>
         * </note>
         * <p>
         * When using capabilities, be aware of these corner cases:
         * </p>
         * <ul>
         * <li>
         * <p>
         * You can't set <code>content</code> capabilities to <code>SendReceive</code> or <code>Receive</code> unless
         * you also set <code>video</code> capabilities to <code>SendReceive</code> or <code>Receive</code>. If you
         * don't set the <code>video</code> capability to receive, the response will contain an HTTP 400 Bad Request
         * status code. However, you can set your <code>video</code> capability to receive and you set your
         * <code>content</code> capability to not receive.
         * </p>
         * </li>
         * <li>
         * <p>
         * When you change an <code>audio</code> capability from <code>None</code> or <code>Receive</code> to
         * <code>Send</code> or <code>SendReceive</code> , and if the attendee left their microphone unmuted, audio will
         * flow from the attendee to the other meeting participants.
         * </p>
         * </li>
         * <li>
         * <p>
         * When you change a <code>video</code> or <code>content</code> capability from <code>None</code> or
         * <code>Receive</code> to <code>Send</code> or <code>SendReceive</code> , and if the attendee turned on their
         * video or content streams, remote attendess can receive those streams, but only after media renegotiation
         * between the client and the Amazon Chime back-end server.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link AttendeeCapabilities.Builder} avoiding
         * the need to create one manually via {@link AttendeeCapabilities#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttendeeCapabilities.Builder#build()} is called immediately and
         * its result is passed to {@link #capabilities(AttendeeCapabilities)}.
         * 
         * @param capabilities
         *        a consumer that will call methods on {@link AttendeeCapabilities.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capabilities(AttendeeCapabilities)
         */
        default Builder capabilities(Consumer<AttendeeCapabilities.Builder> capabilities) {
            return capabilities(AttendeeCapabilities.builder().applyMutation(capabilities).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeSdkMeetingsRequest.BuilderImpl implements Builder {
        private String meetingId;

        private String externalUserId;

        private AttendeeCapabilities capabilities;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAttendeeRequest model) {
            super(model);
            meetingId(model.meetingId);
            externalUserId(model.externalUserId);
            capabilities(model.capabilities);
        }

        public final String getMeetingId() {
            return meetingId;
        }

        public final void setMeetingId(String meetingId) {
            this.meetingId = meetingId;
        }

        @Override
        public final Builder meetingId(String meetingId) {
            this.meetingId = meetingId;
            return this;
        }

        public final String getExternalUserId() {
            return externalUserId;
        }

        public final void setExternalUserId(String externalUserId) {
            this.externalUserId = externalUserId;
        }

        @Override
        public final Builder externalUserId(String externalUserId) {
            this.externalUserId = externalUserId;
            return this;
        }

        public final AttendeeCapabilities.Builder getCapabilities() {
            return capabilities != null ? capabilities.toBuilder() : null;
        }

        public final void setCapabilities(AttendeeCapabilities.BuilderImpl capabilities) {
            this.capabilities = capabilities != null ? capabilities.build() : null;
        }

        @Override
        public final Builder capabilities(AttendeeCapabilities capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAttendeeRequest build() {
            return new CreateAttendeeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
