/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmeetings.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMeetingRequest extends ChimeSdkMeetingsRequest implements
        ToCopyableBuilder<CreateMeetingRequest.Builder, CreateMeetingRequest> {
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(CreateMeetingRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> MEDIA_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MediaRegion").getter(getter(CreateMeetingRequest::mediaRegion)).setter(setter(Builder::mediaRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaRegion").build()).build();

    private static final SdkField<String> MEETING_HOST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MeetingHostId").getter(getter(CreateMeetingRequest::meetingHostId))
            .setter(setter(Builder::meetingHostId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeetingHostId").build()).build();

    private static final SdkField<String> EXTERNAL_MEETING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExternalMeetingId").getter(getter(CreateMeetingRequest::externalMeetingId))
            .setter(setter(Builder::externalMeetingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalMeetingId").build()).build();

    private static final SdkField<NotificationsConfiguration> NOTIFICATIONS_CONFIGURATION_FIELD = SdkField
            .<NotificationsConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("NotificationsConfiguration")
            .getter(getter(CreateMeetingRequest::notificationsConfiguration))
            .setter(setter(Builder::notificationsConfiguration))
            .constructor(NotificationsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationsConfiguration").build())
            .build();

    private static final SdkField<MeetingFeaturesConfiguration> MEETING_FEATURES_FIELD = SdkField
            .<MeetingFeaturesConfiguration> builder(MarshallingType.SDK_POJO).memberName("MeetingFeatures")
            .getter(getter(CreateMeetingRequest::meetingFeatures)).setter(setter(Builder::meetingFeatures))
            .constructor(MeetingFeaturesConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeetingFeatures").build()).build();

    private static final SdkField<String> PRIMARY_MEETING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrimaryMeetingId").getter(getter(CreateMeetingRequest::primaryMeetingId))
            .setter(setter(Builder::primaryMeetingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryMeetingId").build()).build();

    private static final SdkField<List<String>> TENANT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TenantIds")
            .getter(getter(CreateMeetingRequest::tenantIds))
            .setter(setter(Builder::tenantIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateMeetingRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_TOKEN_FIELD,
            MEDIA_REGION_FIELD, MEETING_HOST_ID_FIELD, EXTERNAL_MEETING_ID_FIELD, NOTIFICATIONS_CONFIGURATION_FIELD,
            MEETING_FEATURES_FIELD, PRIMARY_MEETING_ID_FIELD, TENANT_IDS_FIELD, TAGS_FIELD));

    private final String clientRequestToken;

    private final String mediaRegion;

    private final String meetingHostId;

    private final String externalMeetingId;

    private final NotificationsConfiguration notificationsConfiguration;

    private final MeetingFeaturesConfiguration meetingFeatures;

    private final String primaryMeetingId;

    private final List<String> tenantIds;

    private final List<Tag> tags;

    private CreateMeetingRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.mediaRegion = builder.mediaRegion;
        this.meetingHostId = builder.meetingHostId;
        this.externalMeetingId = builder.externalMeetingId;
        this.notificationsConfiguration = builder.notificationsConfiguration;
        this.meetingFeatures = builder.meetingFeatures;
        this.primaryMeetingId = builder.primaryMeetingId;
        this.tenantIds = builder.tenantIds;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The unique identifier for the client request. Use a different token for different meetings.
     * </p>
     * 
     * @return The unique identifier for the client request. Use a different token for different meetings.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The Region in which to create the meeting.
     * </p>
     * <p>
     * Available values: <code>af-south-1</code>, <code>ap-northeast-1</code>, <code>ap-northeast-2</code>,
     * <code>ap-south-1</code>, <code>ap-southeast-1</code>, <code>ap-southeast-2</code>, <code>ca-central-1</code>,
     * <code>eu-central-1</code>, <code>eu-north-1</code>, <code>eu-south-1</code>, <code>eu-west-1</code>,
     * <code>eu-west-2</code>, <code>eu-west-3</code>, <code>sa-east-1</code>, <code>us-east-1</code>,
     * <code>us-east-2</code>, <code>us-west-1</code>, <code>us-west-2</code>.
     * </p>
     * <p>
     * Available values in Amazon Web Services GovCloud (US) Regions: <code>us-gov-east-1</code>,
     * <code>us-gov-west-1</code>.
     * </p>
     * 
     * @return The Region in which to create the meeting.</p>
     *         <p>
     *         Available values: <code>af-south-1</code>, <code>ap-northeast-1</code>, <code>ap-northeast-2</code>,
     *         <code>ap-south-1</code>, <code>ap-southeast-1</code>, <code>ap-southeast-2</code>,
     *         <code>ca-central-1</code>, <code>eu-central-1</code>, <code>eu-north-1</code>, <code>eu-south-1</code>,
     *         <code>eu-west-1</code>, <code>eu-west-2</code>, <code>eu-west-3</code>, <code>sa-east-1</code>,
     *         <code>us-east-1</code>, <code>us-east-2</code>, <code>us-west-1</code>, <code>us-west-2</code>.
     *         </p>
     *         <p>
     *         Available values in Amazon Web Services GovCloud (US) Regions: <code>us-gov-east-1</code>,
     *         <code>us-gov-west-1</code>.
     */
    public final String mediaRegion() {
        return mediaRegion;
    }

    /**
     * <p>
     * Reserved.
     * </p>
     * 
     * @return Reserved.
     */
    public final String meetingHostId() {
        return meetingHostId;
    }

    /**
     * <p>
     * The external meeting ID.
     * </p>
     * <p>
     * Pattern: <code>[-_&amp;@+=,(){}\[\]\/«».:|'"#a-zA-Z0-9À-ÿ\s]*</code>
     * </p>
     * <p>
     * Values that begin with <code>aws:</code> are reserved. You can't configure a value that uses this prefix. Case
     * insensitive.
     * </p>
     * 
     * @return The external meeting ID.</p>
     *         <p>
     *         Pattern: <code>[-_&amp;@+=,(){}\[\]\/«».:|'"#a-zA-Z0-9À-ÿ\s]*</code>
     *         </p>
     *         <p>
     *         Values that begin with <code>aws:</code> are reserved. You can't configure a value that uses this prefix.
     *         Case insensitive.
     */
    public final String externalMeetingId() {
        return externalMeetingId;
    }

    /**
     * <p>
     * The configuration for resource targets to receive notifications when meeting and attendee events occur.
     * </p>
     * 
     * @return The configuration for resource targets to receive notifications when meeting and attendee events occur.
     */
    public final NotificationsConfiguration notificationsConfiguration() {
        return notificationsConfiguration;
    }

    /**
     * <p>
     * Lists the audio and video features enabled for a meeting, such as echo reduction.
     * </p>
     * 
     * @return Lists the audio and video features enabled for a meeting, such as echo reduction.
     */
    public final MeetingFeaturesConfiguration meetingFeatures() {
        return meetingFeatures;
    }

    /**
     * <p>
     * When specified, replicates the media from the primary meeting to the new meeting.
     * </p>
     * 
     * @return When specified, replicates the media from the primary meeting to the new meeting.
     */
    public final String primaryMeetingId() {
        return primaryMeetingId;
    }

    /**
     * For responses, this returns true if the service returned a value for the TenantIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTenantIds() {
        return tenantIds != null && !(tenantIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A consistent and opaque identifier, created and maintained by the builder to represent a segment of their users.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTenantIds} method.
     * </p>
     * 
     * @return A consistent and opaque identifier, created and maintained by the builder to represent a segment of their
     *         users.
     */
    public final List<String> tenantIds() {
        return tenantIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Applies one or more tags to an Amazon Chime SDK meeting. Note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Not all resources have tags. For a list of services with resources that support tagging using this operation, see
     * <a href="https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/supported-services.html">Services
     * that support the Resource Groups Tagging API</a>. If the resource doesn't yet support this operation, the
     * resource's service might support tagging using its own API operations. For more information, refer to the
     * documentation for that service.
     * </p>
     * </li>
     * <li>
     * <p>
     * Each resource can have up to 50 tags. For other limits, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html#tag-conventions">Tag Naming and Usage
     * Conventions</a> in the <i>AWS General Reference</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can only tag resources that are located in the specified Amazon Web Services Region for the Amazon Web
     * Services account.
     * </p>
     * </li>
     * <li>
     * <p>
     * To add tags to a resource, you need the necessary permissions for the service that the resource belongs to as
     * well as permissions for adding tags. For more information, see the documentation for each service.
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * Do not store personally identifiable information (PII) or other confidential or sensitive information in tags. We
     * use tags to provide you with billing and administration services. Tags are not intended to be used for private or
     * sensitive data.
     * </p>
     * </important>
     * <p>
     * <b>Minimum permissions</b>
     * </p>
     * <p>
     * In addition to the <code>tag:TagResources</code> permission required by this operation, you must also have the
     * tagging permission defined by the service that created the resource. For example, to tag a
     * <code>ChimeSDKMeetings</code> instance using the <code>TagResources</code> operation, you must have both of the
     * following permissions:
     * </p>
     * <p>
     * <code>tag:TagResources</code>
     * </p>
     * <p>
     * <code>ChimeSDKMeetings:CreateTags</code>
     * </p>
     * <note>
     * <p>
     * Some services might have specific requirements for tagging some resources. For example, to tag an Amazon S3
     * bucket, you must also have the <code>s3:GetBucketTagging</code> permission. If the expected minimum permissions
     * don't work, check the documentation for that service's tagging APIs for more information.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Applies one or more tags to an Amazon Chime SDK meeting. Note the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Not all resources have tags. For a list of services with resources that support tagging using this
     *         operation, see <a
     *         href="https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/supported-services.html"
     *         >Services that support the Resource Groups Tagging API</a>. If the resource doesn't yet support this
     *         operation, the resource's service might support tagging using its own API operations. For more
     *         information, refer to the documentation for that service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Each resource can have up to 50 tags. For other limits, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html#tag-conventions">Tag Naming and
     *         Usage Conventions</a> in the <i>AWS General Reference</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You can only tag resources that are located in the specified Amazon Web Services Region for the Amazon
     *         Web Services account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To add tags to a resource, you need the necessary permissions for the service that the resource belongs
     *         to as well as permissions for adding tags. For more information, see the documentation for each service.
     *         </p>
     *         </li>
     *         </ul>
     *         <important>
     *         <p>
     *         Do not store personally identifiable information (PII) or other confidential or sensitive information in
     *         tags. We use tags to provide you with billing and administration services. Tags are not intended to be
     *         used for private or sensitive data.
     *         </p>
     *         </important>
     *         <p>
     *         <b>Minimum permissions</b>
     *         </p>
     *         <p>
     *         In addition to the <code>tag:TagResources</code> permission required by this operation, you must also
     *         have the tagging permission defined by the service that created the resource. For example, to tag a
     *         <code>ChimeSDKMeetings</code> instance using the <code>TagResources</code> operation, you must have both
     *         of the following permissions:
     *         </p>
     *         <p>
     *         <code>tag:TagResources</code>
     *         </p>
     *         <p>
     *         <code>ChimeSDKMeetings:CreateTags</code>
     *         </p>
     *         <note>
     *         <p>
     *         Some services might have specific requirements for tagging some resources. For example, to tag an Amazon
     *         S3 bucket, you must also have the <code>s3:GetBucketTagging</code> permission. If the expected minimum
     *         permissions don't work, check the documentation for that service's tagging APIs for more information.
     *         </p>
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(mediaRegion());
        hashCode = 31 * hashCode + Objects.hashCode(meetingHostId());
        hashCode = 31 * hashCode + Objects.hashCode(externalMeetingId());
        hashCode = 31 * hashCode + Objects.hashCode(notificationsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(meetingFeatures());
        hashCode = 31 * hashCode + Objects.hashCode(primaryMeetingId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTenantIds() ? tenantIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMeetingRequest)) {
            return false;
        }
        CreateMeetingRequest other = (CreateMeetingRequest) obj;
        return Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(mediaRegion(), other.mediaRegion()) && Objects.equals(meetingHostId(), other.meetingHostId())
                && Objects.equals(externalMeetingId(), other.externalMeetingId())
                && Objects.equals(notificationsConfiguration(), other.notificationsConfiguration())
                && Objects.equals(meetingFeatures(), other.meetingFeatures())
                && Objects.equals(primaryMeetingId(), other.primaryMeetingId()) && hasTenantIds() == other.hasTenantIds()
                && Objects.equals(tenantIds(), other.tenantIds()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMeetingRequest")
                .add("ClientRequestToken", clientRequestToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MediaRegion", mediaRegion())
                .add("MeetingHostId", meetingHostId() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ExternalMeetingId", externalMeetingId() == null ? null : "*** Sensitive Data Redacted ***")
                .add("NotificationsConfiguration", notificationsConfiguration()).add("MeetingFeatures", meetingFeatures())
                .add("PrimaryMeetingId", primaryMeetingId()).add("TenantIds", hasTenantIds() ? tenantIds() : null)
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "MediaRegion":
            return Optional.ofNullable(clazz.cast(mediaRegion()));
        case "MeetingHostId":
            return Optional.ofNullable(clazz.cast(meetingHostId()));
        case "ExternalMeetingId":
            return Optional.ofNullable(clazz.cast(externalMeetingId()));
        case "NotificationsConfiguration":
            return Optional.ofNullable(clazz.cast(notificationsConfiguration()));
        case "MeetingFeatures":
            return Optional.ofNullable(clazz.cast(meetingFeatures()));
        case "PrimaryMeetingId":
            return Optional.ofNullable(clazz.cast(primaryMeetingId()));
        case "TenantIds":
            return Optional.ofNullable(clazz.cast(tenantIds()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMeetingRequest, T> g) {
        return obj -> g.apply((CreateMeetingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkMeetingsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateMeetingRequest> {
        /**
         * <p>
         * The unique identifier for the client request. Use a different token for different meetings.
         * </p>
         * 
         * @param clientRequestToken
         *        The unique identifier for the client request. Use a different token for different meetings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The Region in which to create the meeting.
         * </p>
         * <p>
         * Available values: <code>af-south-1</code>, <code>ap-northeast-1</code>, <code>ap-northeast-2</code>,
         * <code>ap-south-1</code>, <code>ap-southeast-1</code>, <code>ap-southeast-2</code>, <code>ca-central-1</code>,
         * <code>eu-central-1</code>, <code>eu-north-1</code>, <code>eu-south-1</code>, <code>eu-west-1</code>,
         * <code>eu-west-2</code>, <code>eu-west-3</code>, <code>sa-east-1</code>, <code>us-east-1</code>,
         * <code>us-east-2</code>, <code>us-west-1</code>, <code>us-west-2</code>.
         * </p>
         * <p>
         * Available values in Amazon Web Services GovCloud (US) Regions: <code>us-gov-east-1</code>,
         * <code>us-gov-west-1</code>.
         * </p>
         * 
         * @param mediaRegion
         *        The Region in which to create the meeting.</p>
         *        <p>
         *        Available values: <code>af-south-1</code>, <code>ap-northeast-1</code>, <code>ap-northeast-2</code>,
         *        <code>ap-south-1</code>, <code>ap-southeast-1</code>, <code>ap-southeast-2</code>,
         *        <code>ca-central-1</code>, <code>eu-central-1</code>, <code>eu-north-1</code>, <code>eu-south-1</code>, <code>eu-west-1</code>, <code>eu-west-2</code>, <code>eu-west-3</code>, <code>sa-east-1</code>,
         *        <code>us-east-1</code>, <code>us-east-2</code>, <code>us-west-1</code>, <code>us-west-2</code>.
         *        </p>
         *        <p>
         *        Available values in Amazon Web Services GovCloud (US) Regions: <code>us-gov-east-1</code>,
         *        <code>us-gov-west-1</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaRegion(String mediaRegion);

        /**
         * <p>
         * Reserved.
         * </p>
         * 
         * @param meetingHostId
         *        Reserved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meetingHostId(String meetingHostId);

        /**
         * <p>
         * The external meeting ID.
         * </p>
         * <p>
         * Pattern: <code>[-_&amp;@+=,(){}\[\]\/«».:|'"#a-zA-Z0-9À-ÿ\s]*</code>
         * </p>
         * <p>
         * Values that begin with <code>aws:</code> are reserved. You can't configure a value that uses this prefix.
         * Case insensitive.
         * </p>
         * 
         * @param externalMeetingId
         *        The external meeting ID.</p>
         *        <p>
         *        Pattern: <code>[-_&amp;@+=,(){}\[\]\/«».:|'"#a-zA-Z0-9À-ÿ\s]*</code>
         *        </p>
         *        <p>
         *        Values that begin with <code>aws:</code> are reserved. You can't configure a value that uses this
         *        prefix. Case insensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalMeetingId(String externalMeetingId);

        /**
         * <p>
         * The configuration for resource targets to receive notifications when meeting and attendee events occur.
         * </p>
         * 
         * @param notificationsConfiguration
         *        The configuration for resource targets to receive notifications when meeting and attendee events
         *        occur.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationsConfiguration(NotificationsConfiguration notificationsConfiguration);

        /**
         * <p>
         * The configuration for resource targets to receive notifications when meeting and attendee events occur.
         * </p>
         * This is a convenience method that creates an instance of the {@link NotificationsConfiguration.Builder}
         * avoiding the need to create one manually via {@link NotificationsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NotificationsConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #notificationsConfiguration(NotificationsConfiguration)}.
         * 
         * @param notificationsConfiguration
         *        a consumer that will call methods on {@link NotificationsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notificationsConfiguration(NotificationsConfiguration)
         */
        default Builder notificationsConfiguration(Consumer<NotificationsConfiguration.Builder> notificationsConfiguration) {
            return notificationsConfiguration(NotificationsConfiguration.builder().applyMutation(notificationsConfiguration)
                    .build());
        }

        /**
         * <p>
         * Lists the audio and video features enabled for a meeting, such as echo reduction.
         * </p>
         * 
         * @param meetingFeatures
         *        Lists the audio and video features enabled for a meeting, such as echo reduction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meetingFeatures(MeetingFeaturesConfiguration meetingFeatures);

        /**
         * <p>
         * Lists the audio and video features enabled for a meeting, such as echo reduction.
         * </p>
         * This is a convenience method that creates an instance of the {@link MeetingFeaturesConfiguration.Builder}
         * avoiding the need to create one manually via {@link MeetingFeaturesConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MeetingFeaturesConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #meetingFeatures(MeetingFeaturesConfiguration)}.
         * 
         * @param meetingFeatures
         *        a consumer that will call methods on {@link MeetingFeaturesConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #meetingFeatures(MeetingFeaturesConfiguration)
         */
        default Builder meetingFeatures(Consumer<MeetingFeaturesConfiguration.Builder> meetingFeatures) {
            return meetingFeatures(MeetingFeaturesConfiguration.builder().applyMutation(meetingFeatures).build());
        }

        /**
         * <p>
         * When specified, replicates the media from the primary meeting to the new meeting.
         * </p>
         * 
         * @param primaryMeetingId
         *        When specified, replicates the media from the primary meeting to the new meeting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryMeetingId(String primaryMeetingId);

        /**
         * <p>
         * A consistent and opaque identifier, created and maintained by the builder to represent a segment of their
         * users.
         * </p>
         * 
         * @param tenantIds
         *        A consistent and opaque identifier, created and maintained by the builder to represent a segment of
         *        their users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenantIds(Collection<String> tenantIds);

        /**
         * <p>
         * A consistent and opaque identifier, created and maintained by the builder to represent a segment of their
         * users.
         * </p>
         * 
         * @param tenantIds
         *        A consistent and opaque identifier, created and maintained by the builder to represent a segment of
         *        their users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenantIds(String... tenantIds);

        /**
         * <p>
         * Applies one or more tags to an Amazon Chime SDK meeting. Note the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Not all resources have tags. For a list of services with resources that support tagging using this operation,
         * see <a href="https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/supported-services.html">
         * Services that support the Resource Groups Tagging API</a>. If the resource doesn't yet support this
         * operation, the resource's service might support tagging using its own API operations. For more information,
         * refer to the documentation for that service.
         * </p>
         * </li>
         * <li>
         * <p>
         * Each resource can have up to 50 tags. For other limits, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html#tag-conventions">Tag Naming and Usage
         * Conventions</a> in the <i>AWS General Reference</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * You can only tag resources that are located in the specified Amazon Web Services Region for the Amazon Web
         * Services account.
         * </p>
         * </li>
         * <li>
         * <p>
         * To add tags to a resource, you need the necessary permissions for the service that the resource belongs to as
         * well as permissions for adding tags. For more information, see the documentation for each service.
         * </p>
         * </li>
         * </ul>
         * <important>
         * <p>
         * Do not store personally identifiable information (PII) or other confidential or sensitive information in
         * tags. We use tags to provide you with billing and administration services. Tags are not intended to be used
         * for private or sensitive data.
         * </p>
         * </important>
         * <p>
         * <b>Minimum permissions</b>
         * </p>
         * <p>
         * In addition to the <code>tag:TagResources</code> permission required by this operation, you must also have
         * the tagging permission defined by the service that created the resource. For example, to tag a
         * <code>ChimeSDKMeetings</code> instance using the <code>TagResources</code> operation, you must have both of
         * the following permissions:
         * </p>
         * <p>
         * <code>tag:TagResources</code>
         * </p>
         * <p>
         * <code>ChimeSDKMeetings:CreateTags</code>
         * </p>
         * <note>
         * <p>
         * Some services might have specific requirements for tagging some resources. For example, to tag an Amazon S3
         * bucket, you must also have the <code>s3:GetBucketTagging</code> permission. If the expected minimum
         * permissions don't work, check the documentation for that service's tagging APIs for more information.
         * </p>
         * </note>
         * 
         * @param tags
         *        Applies one or more tags to an Amazon Chime SDK meeting. Note the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Not all resources have tags. For a list of services with resources that support tagging using this
         *        operation, see <a
         *        href="https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/supported-services.html"
         *        >Services that support the Resource Groups Tagging API</a>. If the resource doesn't yet support this
         *        operation, the resource's service might support tagging using its own API operations. For more
         *        information, refer to the documentation for that service.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Each resource can have up to 50 tags. For other limits, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html#tag-conventions">Tag Naming and
         *        Usage Conventions</a> in the <i>AWS General Reference</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You can only tag resources that are located in the specified Amazon Web Services Region for the Amazon
         *        Web Services account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To add tags to a resource, you need the necessary permissions for the service that the resource
         *        belongs to as well as permissions for adding tags. For more information, see the documentation for
         *        each service.
         *        </p>
         *        </li>
         *        </ul>
         *        <important>
         *        <p>
         *        Do not store personally identifiable information (PII) or other confidential or sensitive information
         *        in tags. We use tags to provide you with billing and administration services. Tags are not intended to
         *        be used for private or sensitive data.
         *        </p>
         *        </important>
         *        <p>
         *        <b>Minimum permissions</b>
         *        </p>
         *        <p>
         *        In addition to the <code>tag:TagResources</code> permission required by this operation, you must also
         *        have the tagging permission defined by the service that created the resource. For example, to tag a
         *        <code>ChimeSDKMeetings</code> instance using the <code>TagResources</code> operation, you must have
         *        both of the following permissions:
         *        </p>
         *        <p>
         *        <code>tag:TagResources</code>
         *        </p>
         *        <p>
         *        <code>ChimeSDKMeetings:CreateTags</code>
         *        </p>
         *        <note>
         *        <p>
         *        Some services might have specific requirements for tagging some resources. For example, to tag an
         *        Amazon S3 bucket, you must also have the <code>s3:GetBucketTagging</code> permission. If the expected
         *        minimum permissions don't work, check the documentation for that service's tagging APIs for more
         *        information.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Applies one or more tags to an Amazon Chime SDK meeting. Note the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Not all resources have tags. For a list of services with resources that support tagging using this operation,
         * see <a href="https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/supported-services.html">
         * Services that support the Resource Groups Tagging API</a>. If the resource doesn't yet support this
         * operation, the resource's service might support tagging using its own API operations. For more information,
         * refer to the documentation for that service.
         * </p>
         * </li>
         * <li>
         * <p>
         * Each resource can have up to 50 tags. For other limits, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html#tag-conventions">Tag Naming and Usage
         * Conventions</a> in the <i>AWS General Reference</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * You can only tag resources that are located in the specified Amazon Web Services Region for the Amazon Web
         * Services account.
         * </p>
         * </li>
         * <li>
         * <p>
         * To add tags to a resource, you need the necessary permissions for the service that the resource belongs to as
         * well as permissions for adding tags. For more information, see the documentation for each service.
         * </p>
         * </li>
         * </ul>
         * <important>
         * <p>
         * Do not store personally identifiable information (PII) or other confidential or sensitive information in
         * tags. We use tags to provide you with billing and administration services. Tags are not intended to be used
         * for private or sensitive data.
         * </p>
         * </important>
         * <p>
         * <b>Minimum permissions</b>
         * </p>
         * <p>
         * In addition to the <code>tag:TagResources</code> permission required by this operation, you must also have
         * the tagging permission defined by the service that created the resource. For example, to tag a
         * <code>ChimeSDKMeetings</code> instance using the <code>TagResources</code> operation, you must have both of
         * the following permissions:
         * </p>
         * <p>
         * <code>tag:TagResources</code>
         * </p>
         * <p>
         * <code>ChimeSDKMeetings:CreateTags</code>
         * </p>
         * <note>
         * <p>
         * Some services might have specific requirements for tagging some resources. For example, to tag an Amazon S3
         * bucket, you must also have the <code>s3:GetBucketTagging</code> permission. If the expected minimum
         * permissions don't work, check the documentation for that service's tagging APIs for more information.
         * </p>
         * </note>
         * 
         * @param tags
         *        Applies one or more tags to an Amazon Chime SDK meeting. Note the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Not all resources have tags. For a list of services with resources that support tagging using this
         *        operation, see <a
         *        href="https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/supported-services.html"
         *        >Services that support the Resource Groups Tagging API</a>. If the resource doesn't yet support this
         *        operation, the resource's service might support tagging using its own API operations. For more
         *        information, refer to the documentation for that service.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Each resource can have up to 50 tags. For other limits, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html#tag-conventions">Tag Naming and
         *        Usage Conventions</a> in the <i>AWS General Reference</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You can only tag resources that are located in the specified Amazon Web Services Region for the Amazon
         *        Web Services account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To add tags to a resource, you need the necessary permissions for the service that the resource
         *        belongs to as well as permissions for adding tags. For more information, see the documentation for
         *        each service.
         *        </p>
         *        </li>
         *        </ul>
         *        <important>
         *        <p>
         *        Do not store personally identifiable information (PII) or other confidential or sensitive information
         *        in tags. We use tags to provide you with billing and administration services. Tags are not intended to
         *        be used for private or sensitive data.
         *        </p>
         *        </important>
         *        <p>
         *        <b>Minimum permissions</b>
         *        </p>
         *        <p>
         *        In addition to the <code>tag:TagResources</code> permission required by this operation, you must also
         *        have the tagging permission defined by the service that created the resource. For example, to tag a
         *        <code>ChimeSDKMeetings</code> instance using the <code>TagResources</code> operation, you must have
         *        both of the following permissions:
         *        </p>
         *        <p>
         *        <code>tag:TagResources</code>
         *        </p>
         *        <p>
         *        <code>ChimeSDKMeetings:CreateTags</code>
         *        </p>
         *        <note>
         *        <p>
         *        Some services might have specific requirements for tagging some resources. For example, to tag an
         *        Amazon S3 bucket, you must also have the <code>s3:GetBucketTagging</code> permission. If the expected
         *        minimum permissions don't work, check the documentation for that service's tagging APIs for more
         *        information.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Applies one or more tags to an Amazon Chime SDK meeting. Note the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Not all resources have tags. For a list of services with resources that support tagging using this operation,
         * see <a href="https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/supported-services.html">
         * Services that support the Resource Groups Tagging API</a>. If the resource doesn't yet support this
         * operation, the resource's service might support tagging using its own API operations. For more information,
         * refer to the documentation for that service.
         * </p>
         * </li>
         * <li>
         * <p>
         * Each resource can have up to 50 tags. For other limits, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html#tag-conventions">Tag Naming and Usage
         * Conventions</a> in the <i>AWS General Reference</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * You can only tag resources that are located in the specified Amazon Web Services Region for the Amazon Web
         * Services account.
         * </p>
         * </li>
         * <li>
         * <p>
         * To add tags to a resource, you need the necessary permissions for the service that the resource belongs to as
         * well as permissions for adding tags. For more information, see the documentation for each service.
         * </p>
         * </li>
         * </ul>
         * <important>
         * <p>
         * Do not store personally identifiable information (PII) or other confidential or sensitive information in
         * tags. We use tags to provide you with billing and administration services. Tags are not intended to be used
         * for private or sensitive data.
         * </p>
         * </important>
         * <p>
         * <b>Minimum permissions</b>
         * </p>
         * <p>
         * In addition to the <code>tag:TagResources</code> permission required by this operation, you must also have
         * the tagging permission defined by the service that created the resource. For example, to tag a
         * <code>ChimeSDKMeetings</code> instance using the <code>TagResources</code> operation, you must have both of
         * the following permissions:
         * </p>
         * <p>
         * <code>tag:TagResources</code>
         * </p>
         * <p>
         * <code>ChimeSDKMeetings:CreateTags</code>
         * </p>
         * <note>
         * <p>
         * Some services might have specific requirements for tagging some resources. For example, to tag an Amazon S3
         * bucket, you must also have the <code>s3:GetBucketTagging</code> permission. If the expected minimum
         * permissions don't work, check the documentation for that service's tagging APIs for more information.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.chimesdkmeetings.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.chimesdkmeetings.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.chimesdkmeetings.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.chimesdkmeetings.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeSdkMeetingsRequest.BuilderImpl implements Builder {
        private String clientRequestToken;

        private String mediaRegion;

        private String meetingHostId;

        private String externalMeetingId;

        private NotificationsConfiguration notificationsConfiguration;

        private MeetingFeaturesConfiguration meetingFeatures;

        private String primaryMeetingId;

        private List<String> tenantIds = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMeetingRequest model) {
            super(model);
            clientRequestToken(model.clientRequestToken);
            mediaRegion(model.mediaRegion);
            meetingHostId(model.meetingHostId);
            externalMeetingId(model.externalMeetingId);
            notificationsConfiguration(model.notificationsConfiguration);
            meetingFeatures(model.meetingFeatures);
            primaryMeetingId(model.primaryMeetingId);
            tenantIds(model.tenantIds);
            tags(model.tags);
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getMediaRegion() {
            return mediaRegion;
        }

        public final void setMediaRegion(String mediaRegion) {
            this.mediaRegion = mediaRegion;
        }

        @Override
        public final Builder mediaRegion(String mediaRegion) {
            this.mediaRegion = mediaRegion;
            return this;
        }

        public final String getMeetingHostId() {
            return meetingHostId;
        }

        public final void setMeetingHostId(String meetingHostId) {
            this.meetingHostId = meetingHostId;
        }

        @Override
        public final Builder meetingHostId(String meetingHostId) {
            this.meetingHostId = meetingHostId;
            return this;
        }

        public final String getExternalMeetingId() {
            return externalMeetingId;
        }

        public final void setExternalMeetingId(String externalMeetingId) {
            this.externalMeetingId = externalMeetingId;
        }

        @Override
        public final Builder externalMeetingId(String externalMeetingId) {
            this.externalMeetingId = externalMeetingId;
            return this;
        }

        public final NotificationsConfiguration.Builder getNotificationsConfiguration() {
            return notificationsConfiguration != null ? notificationsConfiguration.toBuilder() : null;
        }

        public final void setNotificationsConfiguration(NotificationsConfiguration.BuilderImpl notificationsConfiguration) {
            this.notificationsConfiguration = notificationsConfiguration != null ? notificationsConfiguration.build() : null;
        }

        @Override
        public final Builder notificationsConfiguration(NotificationsConfiguration notificationsConfiguration) {
            this.notificationsConfiguration = notificationsConfiguration;
            return this;
        }

        public final MeetingFeaturesConfiguration.Builder getMeetingFeatures() {
            return meetingFeatures != null ? meetingFeatures.toBuilder() : null;
        }

        public final void setMeetingFeatures(MeetingFeaturesConfiguration.BuilderImpl meetingFeatures) {
            this.meetingFeatures = meetingFeatures != null ? meetingFeatures.build() : null;
        }

        @Override
        public final Builder meetingFeatures(MeetingFeaturesConfiguration meetingFeatures) {
            this.meetingFeatures = meetingFeatures;
            return this;
        }

        public final String getPrimaryMeetingId() {
            return primaryMeetingId;
        }

        public final void setPrimaryMeetingId(String primaryMeetingId) {
            this.primaryMeetingId = primaryMeetingId;
        }

        @Override
        public final Builder primaryMeetingId(String primaryMeetingId) {
            this.primaryMeetingId = primaryMeetingId;
            return this;
        }

        public final Collection<String> getTenantIds() {
            if (tenantIds instanceof SdkAutoConstructList) {
                return null;
            }
            return tenantIds;
        }

        public final void setTenantIds(Collection<String> tenantIds) {
            this.tenantIds = TenantIdListCopier.copy(tenantIds);
        }

        @Override
        public final Builder tenantIds(Collection<String> tenantIds) {
            this.tenantIds = TenantIdListCopier.copy(tenantIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tenantIds(String... tenantIds) {
            tenantIds(Arrays.asList(tenantIds));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMeetingRequest build() {
            return new CreateMeetingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
