/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateConfiguredAudienceModelAssociationRequest extends CleanRoomsRequest
        implements
        ToCopyableBuilder<CreateConfiguredAudienceModelAssociationRequest.Builder, CreateConfiguredAudienceModelAssociationRequest> {
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipIdentifier")
            .getter(getter(CreateConfiguredAudienceModelAssociationRequest::membershipIdentifier))
            .setter(setter(Builder::membershipIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()).build();

    private static final SdkField<String> CONFIGURED_AUDIENCE_MODEL_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("configuredAudienceModelArn")
            .getter(getter(CreateConfiguredAudienceModelAssociationRequest::configuredAudienceModelArn))
            .setter(setter(Builder::configuredAudienceModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredAudienceModelArn").build())
            .build();

    private static final SdkField<String> CONFIGURED_AUDIENCE_MODEL_ASSOCIATION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("configuredAudienceModelAssociationName")
            .getter(getter(CreateConfiguredAudienceModelAssociationRequest::configuredAudienceModelAssociationName))
            .setter(setter(Builder::configuredAudienceModelAssociationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("configuredAudienceModelAssociationName").build()).build();

    private static final SdkField<Boolean> MANAGE_RESOURCE_POLICIES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("manageResourcePolicies")
            .getter(getter(CreateConfiguredAudienceModelAssociationRequest::manageResourcePolicies))
            .setter(setter(Builder::manageResourcePolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manageResourcePolicies").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateConfiguredAudienceModelAssociationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateConfiguredAudienceModelAssociationRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERSHIP_IDENTIFIER_FIELD,
            CONFIGURED_AUDIENCE_MODEL_ARN_FIELD, CONFIGURED_AUDIENCE_MODEL_ASSOCIATION_NAME_FIELD,
            MANAGE_RESOURCE_POLICIES_FIELD, TAGS_FIELD, DESCRIPTION_FIELD));

    private final String membershipIdentifier;

    private final String configuredAudienceModelArn;

    private final String configuredAudienceModelAssociationName;

    private final Boolean manageResourcePolicies;

    private final Map<String, String> tags;

    private final String description;

    private CreateConfiguredAudienceModelAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.membershipIdentifier = builder.membershipIdentifier;
        this.configuredAudienceModelArn = builder.configuredAudienceModelArn;
        this.configuredAudienceModelAssociationName = builder.configuredAudienceModelAssociationName;
        this.manageResourcePolicies = builder.manageResourcePolicies;
        this.tags = builder.tags;
        this.description = builder.description;
    }

    /**
     * <p>
     * A unique identifier for one of your memberships for a collaboration. The configured audience model is associated
     * to the collaboration that this membership belongs to. Accepts a membership ID.
     * </p>
     * 
     * @return A unique identifier for one of your memberships for a collaboration. The configured audience model is
     *         associated to the collaboration that this membership belongs to. Accepts a membership ID.
     */
    public final String membershipIdentifier() {
        return membershipIdentifier;
    }

    /**
     * <p>
     * A unique identifier for the configured audience model that you want to associate.
     * </p>
     * 
     * @return A unique identifier for the configured audience model that you want to associate.
     */
    public final String configuredAudienceModelArn() {
        return configuredAudienceModelArn;
    }

    /**
     * <p>
     * The name of the configured audience model association.
     * </p>
     * 
     * @return The name of the configured audience model association.
     */
    public final String configuredAudienceModelAssociationName() {
        return configuredAudienceModelAssociationName;
    }

    /**
     * <p>
     * When <code>TRUE</code>, indicates that the resource policy for the configured audience model resource being
     * associated is configured for Clean Rooms to manage permissions related to the given collaboration. When
     * <code>FALSE</code>, indicates that the configured audience model resource owner will manage permissions related
     * to the given collaboration.
     * </p>
     * <p>
     * Setting this to <code>TRUE</code> requires you to have permissions to create, update, and delete the resource
     * policy for the <code>cleanrooms-ml</code> resource when you call the
     * <a>DeleteConfiguredAudienceModelAssociation</a> resource. In addition, if you are the collaboration creator and
     * specify <code>TRUE</code>, you must have the same permissions when you call the <a>DeleteMember</a> and
     * <a>DeleteCollaboration</a> APIs.
     * </p>
     * 
     * @return When <code>TRUE</code>, indicates that the resource policy for the configured audience model resource
     *         being associated is configured for Clean Rooms to manage permissions related to the given collaboration.
     *         When <code>FALSE</code>, indicates that the configured audience model resource owner will manage
     *         permissions related to the given collaboration.</p>
     *         <p>
     *         Setting this to <code>TRUE</code> requires you to have permissions to create, update, and delete the
     *         resource policy for the <code>cleanrooms-ml</code> resource when you call the
     *         <a>DeleteConfiguredAudienceModelAssociation</a> resource. In addition, if you are the collaboration
     *         creator and specify <code>TRUE</code>, you must have the same permissions when you call the
     *         <a>DeleteMember</a> and <a>DeleteCollaboration</a> APIs.
     */
    public final Boolean manageResourcePolicies() {
        return manageResourcePolicies;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An optional label that you can assign to a resource when you create it. Each tag consists of a key and an
     * optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM
     * policies to control access to this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An optional label that you can assign to a resource when you create it. Each tag consists of a key and an
     *         optional value, both of which you define. When you use tagging, you can also use tag-based access control
     *         in IAM policies to control access to this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * A description of the configured audience model association.
     * </p>
     * 
     * @return A description of the configured audience model association.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(configuredAudienceModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(configuredAudienceModelAssociationName());
        hashCode = 31 * hashCode + Objects.hashCode(manageResourcePolicies());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConfiguredAudienceModelAssociationRequest)) {
            return false;
        }
        CreateConfiguredAudienceModelAssociationRequest other = (CreateConfiguredAudienceModelAssociationRequest) obj;
        return Objects.equals(membershipIdentifier(), other.membershipIdentifier())
                && Objects.equals(configuredAudienceModelArn(), other.configuredAudienceModelArn())
                && Objects.equals(configuredAudienceModelAssociationName(), other.configuredAudienceModelAssociationName())
                && Objects.equals(manageResourcePolicies(), other.manageResourcePolicies()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateConfiguredAudienceModelAssociationRequest")
                .add("MembershipIdentifier", membershipIdentifier())
                .add("ConfiguredAudienceModelArn", configuredAudienceModelArn())
                .add("ConfiguredAudienceModelAssociationName", configuredAudienceModelAssociationName())
                .add("ManageResourcePolicies", manageResourcePolicies()).add("Tags", hasTags() ? tags() : null)
                .add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "membershipIdentifier":
            return Optional.ofNullable(clazz.cast(membershipIdentifier()));
        case "configuredAudienceModelArn":
            return Optional.ofNullable(clazz.cast(configuredAudienceModelArn()));
        case "configuredAudienceModelAssociationName":
            return Optional.ofNullable(clazz.cast(configuredAudienceModelAssociationName()));
        case "manageResourcePolicies":
            return Optional.ofNullable(clazz.cast(manageResourcePolicies()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateConfiguredAudienceModelAssociationRequest, T> g) {
        return obj -> g.apply((CreateConfiguredAudienceModelAssociationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateConfiguredAudienceModelAssociationRequest> {
        /**
         * <p>
         * A unique identifier for one of your memberships for a collaboration. The configured audience model is
         * associated to the collaboration that this membership belongs to. Accepts a membership ID.
         * </p>
         * 
         * @param membershipIdentifier
         *        A unique identifier for one of your memberships for a collaboration. The configured audience model is
         *        associated to the collaboration that this membership belongs to. Accepts a membership ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipIdentifier(String membershipIdentifier);

        /**
         * <p>
         * A unique identifier for the configured audience model that you want to associate.
         * </p>
         * 
         * @param configuredAudienceModelArn
         *        A unique identifier for the configured audience model that you want to associate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredAudienceModelArn(String configuredAudienceModelArn);

        /**
         * <p>
         * The name of the configured audience model association.
         * </p>
         * 
         * @param configuredAudienceModelAssociationName
         *        The name of the configured audience model association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredAudienceModelAssociationName(String configuredAudienceModelAssociationName);

        /**
         * <p>
         * When <code>TRUE</code>, indicates that the resource policy for the configured audience model resource being
         * associated is configured for Clean Rooms to manage permissions related to the given collaboration. When
         * <code>FALSE</code>, indicates that the configured audience model resource owner will manage permissions
         * related to the given collaboration.
         * </p>
         * <p>
         * Setting this to <code>TRUE</code> requires you to have permissions to create, update, and delete the resource
         * policy for the <code>cleanrooms-ml</code> resource when you call the
         * <a>DeleteConfiguredAudienceModelAssociation</a> resource. In addition, if you are the collaboration creator
         * and specify <code>TRUE</code>, you must have the same permissions when you call the <a>DeleteMember</a> and
         * <a>DeleteCollaboration</a> APIs.
         * </p>
         * 
         * @param manageResourcePolicies
         *        When <code>TRUE</code>, indicates that the resource policy for the configured audience model resource
         *        being associated is configured for Clean Rooms to manage permissions related to the given
         *        collaboration. When <code>FALSE</code>, indicates that the configured audience model resource owner
         *        will manage permissions related to the given collaboration.</p>
         *        <p>
         *        Setting this to <code>TRUE</code> requires you to have permissions to create, update, and delete the
         *        resource policy for the <code>cleanrooms-ml</code> resource when you call the
         *        <a>DeleteConfiguredAudienceModelAssociation</a> resource. In addition, if you are the collaboration
         *        creator and specify <code>TRUE</code>, you must have the same permissions when you call the
         *        <a>DeleteMember</a> and <a>DeleteCollaboration</a> APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manageResourcePolicies(Boolean manageResourcePolicies);

        /**
         * <p>
         * An optional label that you can assign to a resource when you create it. Each tag consists of a key and an
         * optional value, both of which you define. When you use tagging, you can also use tag-based access control in
         * IAM policies to control access to this resource.
         * </p>
         * 
         * @param tags
         *        An optional label that you can assign to a resource when you create it. Each tag consists of a key and
         *        an optional value, both of which you define. When you use tagging, you can also use tag-based access
         *        control in IAM policies to control access to this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * A description of the configured audience model association.
         * </p>
         * 
         * @param description
         *        A description of the configured audience model association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CleanRoomsRequest.BuilderImpl implements Builder {
        private String membershipIdentifier;

        private String configuredAudienceModelArn;

        private String configuredAudienceModelAssociationName;

        private Boolean manageResourcePolicies;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConfiguredAudienceModelAssociationRequest model) {
            super(model);
            membershipIdentifier(model.membershipIdentifier);
            configuredAudienceModelArn(model.configuredAudienceModelArn);
            configuredAudienceModelAssociationName(model.configuredAudienceModelAssociationName);
            manageResourcePolicies(model.manageResourcePolicies);
            tags(model.tags);
            description(model.description);
        }

        public final String getMembershipIdentifier() {
            return membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getConfiguredAudienceModelArn() {
            return configuredAudienceModelArn;
        }

        public final void setConfiguredAudienceModelArn(String configuredAudienceModelArn) {
            this.configuredAudienceModelArn = configuredAudienceModelArn;
        }

        @Override
        public final Builder configuredAudienceModelArn(String configuredAudienceModelArn) {
            this.configuredAudienceModelArn = configuredAudienceModelArn;
            return this;
        }

        public final String getConfiguredAudienceModelAssociationName() {
            return configuredAudienceModelAssociationName;
        }

        public final void setConfiguredAudienceModelAssociationName(String configuredAudienceModelAssociationName) {
            this.configuredAudienceModelAssociationName = configuredAudienceModelAssociationName;
        }

        @Override
        public final Builder configuredAudienceModelAssociationName(String configuredAudienceModelAssociationName) {
            this.configuredAudienceModelAssociationName = configuredAudienceModelAssociationName;
            return this;
        }

        public final Boolean getManageResourcePolicies() {
            return manageResourcePolicies;
        }

        public final void setManageResourcePolicies(Boolean manageResourcePolicies) {
            this.manageResourcePolicies = manageResourcePolicies;
        }

        @Override
        public final Builder manageResourcePolicies(Boolean manageResourcePolicies) {
            this.manageResourcePolicies = manageResourcePolicies;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConfiguredAudienceModelAssociationRequest build() {
            return new CreateConfiguredAudienceModelAssociationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
