/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCollaborationPrivacyBudgetTemplateResponse extends CleanRoomsResponse implements
        ToCopyableBuilder<GetCollaborationPrivacyBudgetTemplateResponse.Builder, GetCollaborationPrivacyBudgetTemplateResponse> {
    private static final SdkField<CollaborationPrivacyBudgetTemplate> COLLABORATION_PRIVACY_BUDGET_TEMPLATE_FIELD = SdkField
            .<CollaborationPrivacyBudgetTemplate> builder(MarshallingType.SDK_POJO)
            .memberName("collaborationPrivacyBudgetTemplate")
            .getter(getter(GetCollaborationPrivacyBudgetTemplateResponse::collaborationPrivacyBudgetTemplate))
            .setter(setter(Builder::collaborationPrivacyBudgetTemplate))
            .constructor(CollaborationPrivacyBudgetTemplate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationPrivacyBudgetTemplate")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(COLLABORATION_PRIVACY_BUDGET_TEMPLATE_FIELD));

    private final CollaborationPrivacyBudgetTemplate collaborationPrivacyBudgetTemplate;

    private GetCollaborationPrivacyBudgetTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.collaborationPrivacyBudgetTemplate = builder.collaborationPrivacyBudgetTemplate;
    }

    /**
     * <p>
     * Returns the details of the privacy budget template that you requested.
     * </p>
     * 
     * @return Returns the details of the privacy budget template that you requested.
     */
    public final CollaborationPrivacyBudgetTemplate collaborationPrivacyBudgetTemplate() {
        return collaborationPrivacyBudgetTemplate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(collaborationPrivacyBudgetTemplate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCollaborationPrivacyBudgetTemplateResponse)) {
            return false;
        }
        GetCollaborationPrivacyBudgetTemplateResponse other = (GetCollaborationPrivacyBudgetTemplateResponse) obj;
        return Objects.equals(collaborationPrivacyBudgetTemplate(), other.collaborationPrivacyBudgetTemplate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCollaborationPrivacyBudgetTemplateResponse")
                .add("CollaborationPrivacyBudgetTemplate", collaborationPrivacyBudgetTemplate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "collaborationPrivacyBudgetTemplate":
            return Optional.ofNullable(clazz.cast(collaborationPrivacyBudgetTemplate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCollaborationPrivacyBudgetTemplateResponse, T> g) {
        return obj -> g.apply((GetCollaborationPrivacyBudgetTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetCollaborationPrivacyBudgetTemplateResponse> {
        /**
         * <p>
         * Returns the details of the privacy budget template that you requested.
         * </p>
         * 
         * @param collaborationPrivacyBudgetTemplate
         *        Returns the details of the privacy budget template that you requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationPrivacyBudgetTemplate(CollaborationPrivacyBudgetTemplate collaborationPrivacyBudgetTemplate);

        /**
         * <p>
         * Returns the details of the privacy budget template that you requested.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CollaborationPrivacyBudgetTemplate.Builder} avoiding the need to create one manually via
         * {@link CollaborationPrivacyBudgetTemplate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CollaborationPrivacyBudgetTemplate.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #collaborationPrivacyBudgetTemplate(CollaborationPrivacyBudgetTemplate)}.
         * 
         * @param collaborationPrivacyBudgetTemplate
         *        a consumer that will call methods on {@link CollaborationPrivacyBudgetTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #collaborationPrivacyBudgetTemplate(CollaborationPrivacyBudgetTemplate)
         */
        default Builder collaborationPrivacyBudgetTemplate(
                Consumer<CollaborationPrivacyBudgetTemplate.Builder> collaborationPrivacyBudgetTemplate) {
            return collaborationPrivacyBudgetTemplate(CollaborationPrivacyBudgetTemplate.builder()
                    .applyMutation(collaborationPrivacyBudgetTemplate).build());
        }
    }

    static final class BuilderImpl extends CleanRoomsResponse.BuilderImpl implements Builder {
        private CollaborationPrivacyBudgetTemplate collaborationPrivacyBudgetTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCollaborationPrivacyBudgetTemplateResponse model) {
            super(model);
            collaborationPrivacyBudgetTemplate(model.collaborationPrivacyBudgetTemplate);
        }

        public final CollaborationPrivacyBudgetTemplate.Builder getCollaborationPrivacyBudgetTemplate() {
            return collaborationPrivacyBudgetTemplate != null ? collaborationPrivacyBudgetTemplate.toBuilder() : null;
        }

        public final void setCollaborationPrivacyBudgetTemplate(
                CollaborationPrivacyBudgetTemplate.BuilderImpl collaborationPrivacyBudgetTemplate) {
            this.collaborationPrivacyBudgetTemplate = collaborationPrivacyBudgetTemplate != null ? collaborationPrivacyBudgetTemplate
                    .build() : null;
        }

        @Override
        public final Builder collaborationPrivacyBudgetTemplate(
                CollaborationPrivacyBudgetTemplate collaborationPrivacyBudgetTemplate) {
            this.collaborationPrivacyBudgetTemplate = collaborationPrivacyBudgetTemplate;
            return this;
        }

        @Override
        public GetCollaborationPrivacyBudgetTemplateResponse build() {
            return new GetCollaborationPrivacyBudgetTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
