/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCollaborationsResponse extends CleanRoomsResponse implements
        ToCopyableBuilder<ListCollaborationsResponse.Builder, ListCollaborationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListCollaborationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<CollaborationSummary>> COLLABORATION_LIST_FIELD = SdkField
            .<List<CollaborationSummary>> builder(MarshallingType.LIST)
            .memberName("collaborationList")
            .getter(getter(ListCollaborationsResponse::collaborationList))
            .setter(setter(Builder::collaborationList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CollaborationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(CollaborationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            COLLABORATION_LIST_FIELD));

    private final String nextToken;

    private final List<CollaborationSummary> collaborationList;

    private ListCollaborationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.collaborationList = builder.collaborationList;
    }

    /**
     * <p>
     * The token value retrieved from a previous call to access the next page of results.
     * </p>
     * 
     * @return The token value retrieved from a previous call to access the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the CollaborationList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCollaborationList() {
        return collaborationList != null && !(collaborationList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of collaborations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCollaborationList} method.
     * </p>
     * 
     * @return The list of collaborations.
     */
    public final List<CollaborationSummary> collaborationList() {
        return collaborationList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasCollaborationList() ? collaborationList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCollaborationsResponse)) {
            return false;
        }
        ListCollaborationsResponse other = (ListCollaborationsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasCollaborationList() == other.hasCollaborationList()
                && Objects.equals(collaborationList(), other.collaborationList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCollaborationsResponse").add("NextToken", nextToken())
                .add("CollaborationList", hasCollaborationList() ? collaborationList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "collaborationList":
            return Optional.ofNullable(clazz.cast(collaborationList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCollaborationsResponse, T> g) {
        return obj -> g.apply((ListCollaborationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListCollaborationsResponse> {
        /**
         * <p>
         * The token value retrieved from a previous call to access the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token value retrieved from a previous call to access the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The list of collaborations.
         * </p>
         * 
         * @param collaborationList
         *        The list of collaborations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationList(Collection<CollaborationSummary> collaborationList);

        /**
         * <p>
         * The list of collaborations.
         * </p>
         * 
         * @param collaborationList
         *        The list of collaborations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationList(CollaborationSummary... collaborationList);

        /**
         * <p>
         * The list of collaborations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanrooms.model.CollaborationSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.cleanrooms.model.CollaborationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanrooms.model.CollaborationSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #collaborationList(List<CollaborationSummary>)}.
         * 
         * @param collaborationList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanrooms.model.CollaborationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #collaborationList(java.util.Collection<CollaborationSummary>)
         */
        Builder collaborationList(Consumer<CollaborationSummary.Builder>... collaborationList);
    }

    static final class BuilderImpl extends CleanRoomsResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<CollaborationSummary> collaborationList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCollaborationsResponse model) {
            super(model);
            nextToken(model.nextToken);
            collaborationList(model.collaborationList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<CollaborationSummary.Builder> getCollaborationList() {
            List<CollaborationSummary.Builder> result = CollaborationSummaryListCopier.copyToBuilder(this.collaborationList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCollaborationList(Collection<CollaborationSummary.BuilderImpl> collaborationList) {
            this.collaborationList = CollaborationSummaryListCopier.copyFromBuilder(collaborationList);
        }

        @Override
        public final Builder collaborationList(Collection<CollaborationSummary> collaborationList) {
            this.collaborationList = CollaborationSummaryListCopier.copy(collaborationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collaborationList(CollaborationSummary... collaborationList) {
            collaborationList(Arrays.asList(collaborationList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collaborationList(Consumer<CollaborationSummary.Builder>... collaborationList) {
            collaborationList(Stream.of(collaborationList).map(c -> CollaborationSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListCollaborationsResponse build() {
            return new ListCollaborationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
