/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPrivacyBudgetTemplatesResponse extends CleanRoomsResponse implements
        ToCopyableBuilder<ListPrivacyBudgetTemplatesResponse.Builder, ListPrivacyBudgetTemplatesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListPrivacyBudgetTemplatesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<PrivacyBudgetTemplateSummary>> PRIVACY_BUDGET_TEMPLATE_SUMMARIES_FIELD = SdkField
            .<List<PrivacyBudgetTemplateSummary>> builder(MarshallingType.LIST)
            .memberName("privacyBudgetTemplateSummaries")
            .getter(getter(ListPrivacyBudgetTemplatesResponse::privacyBudgetTemplateSummaries))
            .setter(setter(Builder::privacyBudgetTemplateSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privacyBudgetTemplateSummaries")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PrivacyBudgetTemplateSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(PrivacyBudgetTemplateSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            PRIVACY_BUDGET_TEMPLATE_SUMMARIES_FIELD));

    private final String nextToken;

    private final List<PrivacyBudgetTemplateSummary> privacyBudgetTemplateSummaries;

    private ListPrivacyBudgetTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.privacyBudgetTemplateSummaries = builder.privacyBudgetTemplateSummaries;
    }

    /**
     * <p>
     * The token value retrieved from a previous call to access the next page of results.
     * </p>
     * 
     * @return The token value retrieved from a previous call to access the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the PrivacyBudgetTemplateSummaries property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPrivacyBudgetTemplateSummaries() {
        return privacyBudgetTemplateSummaries != null && !(privacyBudgetTemplateSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that summarizes the privacy budget templates. The summary includes collaboration information, creation
     * information, and privacy budget type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrivacyBudgetTemplateSummaries} method.
     * </p>
     * 
     * @return An array that summarizes the privacy budget templates. The summary includes collaboration information,
     *         creation information, and privacy budget type.
     */
    public final List<PrivacyBudgetTemplateSummary> privacyBudgetTemplateSummaries() {
        return privacyBudgetTemplateSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasPrivacyBudgetTemplateSummaries() ? privacyBudgetTemplateSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPrivacyBudgetTemplatesResponse)) {
            return false;
        }
        ListPrivacyBudgetTemplatesResponse other = (ListPrivacyBudgetTemplatesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasPrivacyBudgetTemplateSummaries() == other.hasPrivacyBudgetTemplateSummaries()
                && Objects.equals(privacyBudgetTemplateSummaries(), other.privacyBudgetTemplateSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListPrivacyBudgetTemplatesResponse")
                .add("NextToken", nextToken())
                .add("PrivacyBudgetTemplateSummaries",
                        hasPrivacyBudgetTemplateSummaries() ? privacyBudgetTemplateSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "privacyBudgetTemplateSummaries":
            return Optional.ofNullable(clazz.cast(privacyBudgetTemplateSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPrivacyBudgetTemplatesResponse, T> g) {
        return obj -> g.apply((ListPrivacyBudgetTemplatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListPrivacyBudgetTemplatesResponse> {
        /**
         * <p>
         * The token value retrieved from a previous call to access the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token value retrieved from a previous call to access the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array that summarizes the privacy budget templates. The summary includes collaboration information,
         * creation information, and privacy budget type.
         * </p>
         * 
         * @param privacyBudgetTemplateSummaries
         *        An array that summarizes the privacy budget templates. The summary includes collaboration information,
         *        creation information, and privacy budget type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privacyBudgetTemplateSummaries(Collection<PrivacyBudgetTemplateSummary> privacyBudgetTemplateSummaries);

        /**
         * <p>
         * An array that summarizes the privacy budget templates. The summary includes collaboration information,
         * creation information, and privacy budget type.
         * </p>
         * 
         * @param privacyBudgetTemplateSummaries
         *        An array that summarizes the privacy budget templates. The summary includes collaboration information,
         *        creation information, and privacy budget type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privacyBudgetTemplateSummaries(PrivacyBudgetTemplateSummary... privacyBudgetTemplateSummaries);

        /**
         * <p>
         * An array that summarizes the privacy budget templates. The summary includes collaboration information,
         * creation information, and privacy budget type.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanrooms.model.PrivacyBudgetTemplateSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.cleanrooms.model.PrivacyBudgetTemplateSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanrooms.model.PrivacyBudgetTemplateSummary.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #privacyBudgetTemplateSummaries(List<PrivacyBudgetTemplateSummary>)}.
         * 
         * @param privacyBudgetTemplateSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanrooms.model.PrivacyBudgetTemplateSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #privacyBudgetTemplateSummaries(java.util.Collection<PrivacyBudgetTemplateSummary>)
         */
        Builder privacyBudgetTemplateSummaries(Consumer<PrivacyBudgetTemplateSummary.Builder>... privacyBudgetTemplateSummaries);
    }

    static final class BuilderImpl extends CleanRoomsResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<PrivacyBudgetTemplateSummary> privacyBudgetTemplateSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPrivacyBudgetTemplatesResponse model) {
            super(model);
            nextToken(model.nextToken);
            privacyBudgetTemplateSummaries(model.privacyBudgetTemplateSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<PrivacyBudgetTemplateSummary.Builder> getPrivacyBudgetTemplateSummaries() {
            List<PrivacyBudgetTemplateSummary.Builder> result = PrivacyBudgetTemplateSummaryListCopier
                    .copyToBuilder(this.privacyBudgetTemplateSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrivacyBudgetTemplateSummaries(
                Collection<PrivacyBudgetTemplateSummary.BuilderImpl> privacyBudgetTemplateSummaries) {
            this.privacyBudgetTemplateSummaries = PrivacyBudgetTemplateSummaryListCopier
                    .copyFromBuilder(privacyBudgetTemplateSummaries);
        }

        @Override
        public final Builder privacyBudgetTemplateSummaries(
                Collection<PrivacyBudgetTemplateSummary> privacyBudgetTemplateSummaries) {
            this.privacyBudgetTemplateSummaries = PrivacyBudgetTemplateSummaryListCopier.copy(privacyBudgetTemplateSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privacyBudgetTemplateSummaries(PrivacyBudgetTemplateSummary... privacyBudgetTemplateSummaries) {
            privacyBudgetTemplateSummaries(Arrays.asList(privacyBudgetTemplateSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privacyBudgetTemplateSummaries(
                Consumer<PrivacyBudgetTemplateSummary.Builder>... privacyBudgetTemplateSummaries) {
            privacyBudgetTemplateSummaries(Stream.of(privacyBudgetTemplateSummaries)
                    .map(c -> PrivacyBudgetTemplateSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListPrivacyBudgetTemplatesResponse build() {
            return new ListPrivacyBudgetTemplatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
