/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the payment responsibilities accepted by the collaboration member.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MembershipPaymentConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<MembershipPaymentConfiguration.Builder, MembershipPaymentConfiguration> {
    private static final SdkField<MembershipQueryComputePaymentConfig> QUERY_COMPUTE_FIELD = SdkField
            .<MembershipQueryComputePaymentConfig> builder(MarshallingType.SDK_POJO).memberName("queryCompute")
            .getter(getter(MembershipPaymentConfiguration::queryCompute)).setter(setter(Builder::queryCompute))
            .constructor(MembershipQueryComputePaymentConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryCompute").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_COMPUTE_FIELD));

    private static final long serialVersionUID = 1L;

    private final MembershipQueryComputePaymentConfig queryCompute;

    private MembershipPaymentConfiguration(BuilderImpl builder) {
        this.queryCompute = builder.queryCompute;
    }

    /**
     * <p>
     * The payment responsibilities accepted by the collaboration member for query compute costs.
     * </p>
     * 
     * @return The payment responsibilities accepted by the collaboration member for query compute costs.
     */
    public final MembershipQueryComputePaymentConfig queryCompute() {
        return queryCompute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queryCompute());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MembershipPaymentConfiguration)) {
            return false;
        }
        MembershipPaymentConfiguration other = (MembershipPaymentConfiguration) obj;
        return Objects.equals(queryCompute(), other.queryCompute());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MembershipPaymentConfiguration").add("QueryCompute", queryCompute()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "queryCompute":
            return Optional.ofNullable(clazz.cast(queryCompute()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MembershipPaymentConfiguration, T> g) {
        return obj -> g.apply((MembershipPaymentConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MembershipPaymentConfiguration> {
        /**
         * <p>
         * The payment responsibilities accepted by the collaboration member for query compute costs.
         * </p>
         * 
         * @param queryCompute
         *        The payment responsibilities accepted by the collaboration member for query compute costs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryCompute(MembershipQueryComputePaymentConfig queryCompute);

        /**
         * <p>
         * The payment responsibilities accepted by the collaboration member for query compute costs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MembershipQueryComputePaymentConfig.Builder} avoiding the need to create one manually via
         * {@link MembershipQueryComputePaymentConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MembershipQueryComputePaymentConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #queryCompute(MembershipQueryComputePaymentConfig)}.
         * 
         * @param queryCompute
         *        a consumer that will call methods on {@link MembershipQueryComputePaymentConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryCompute(MembershipQueryComputePaymentConfig)
         */
        default Builder queryCompute(Consumer<MembershipQueryComputePaymentConfig.Builder> queryCompute) {
            return queryCompute(MembershipQueryComputePaymentConfig.builder().applyMutation(queryCompute).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private MembershipQueryComputePaymentConfig queryCompute;

        private BuilderImpl() {
        }

        private BuilderImpl(MembershipPaymentConfiguration model) {
            queryCompute(model.queryCompute);
        }

        public final MembershipQueryComputePaymentConfig.Builder getQueryCompute() {
            return queryCompute != null ? queryCompute.toBuilder() : null;
        }

        public final void setQueryCompute(MembershipQueryComputePaymentConfig.BuilderImpl queryCompute) {
            this.queryCompute = queryCompute != null ? queryCompute.build() : null;
        }

        @Override
        public final Builder queryCompute(MembershipQueryComputePaymentConfig queryCompute) {
            this.queryCompute = queryCompute;
            return this;
        }

        @Override
        public MembershipPaymentConfiguration build() {
            return new MembershipPaymentConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
