/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The schema summary for the objects listed by the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SchemaSummary implements SdkPojo, Serializable, ToCopyableBuilder<SchemaSummary.Builder, SchemaSummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(SchemaSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(SchemaSummary::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> CREATOR_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("creatorAccountId").getter(getter(SchemaSummary::creatorAccountId))
            .setter(setter(Builder::creatorAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creatorAccountId").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime").getter(getter(SchemaSummary::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime").getter(getter(SchemaSummary::updateTime)).setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build()).build();

    private static final SdkField<String> COLLABORATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationId").getter(getter(SchemaSummary::collaborationId))
            .setter(setter(Builder::collaborationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationId").build()).build();

    private static final SdkField<String> COLLABORATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationArn").getter(getter(SchemaSummary::collaborationArn))
            .setter(setter(Builder::collaborationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationArn").build()).build();

    private static final SdkField<List<String>> ANALYSIS_RULE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("analysisRuleTypes")
            .getter(getter(SchemaSummary::analysisRuleTypesAsStrings))
            .setter(setter(Builder::analysisRuleTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisRuleTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ANALYSIS_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("analysisMethod").getter(getter(SchemaSummary::analysisMethodAsString))
            .setter(setter(Builder::analysisMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisMethod").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD,
            CREATOR_ACCOUNT_ID_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD, COLLABORATION_ID_FIELD, COLLABORATION_ARN_FIELD,
            ANALYSIS_RULE_TYPES_FIELD, ANALYSIS_METHOD_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String type;

    private final String creatorAccountId;

    private final Instant createTime;

    private final Instant updateTime;

    private final String collaborationId;

    private final String collaborationArn;

    private final List<String> analysisRuleTypes;

    private final String analysisMethod;

    private SchemaSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.creatorAccountId = builder.creatorAccountId;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.collaborationId = builder.collaborationId;
        this.collaborationArn = builder.collaborationArn;
        this.analysisRuleTypes = builder.analysisRuleTypes;
        this.analysisMethod = builder.analysisMethod;
    }

    /**
     * <p>
     * The name for the schema object.
     * </p>
     * 
     * @return The name for the schema object.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of schema object. The only valid schema type is currently `TABLE`.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SchemaType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of schema object. The only valid schema type is currently `TABLE`.
     * @see SchemaType
     */
    public final SchemaType type() {
        return SchemaType.fromValue(type);
    }

    /**
     * <p>
     * The type of schema object. The only valid schema type is currently `TABLE`.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SchemaType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of schema object. The only valid schema type is currently `TABLE`.
     * @see SchemaType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The unique account ID for the Amazon Web Services account that owns the schema.
     * </p>
     * 
     * @return The unique account ID for the Amazon Web Services account that owns the schema.
     */
    public final String creatorAccountId() {
        return creatorAccountId;
    }

    /**
     * <p>
     * The time the schema object was created.
     * </p>
     * 
     * @return The time the schema object was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The time the schema object was last updated.
     * </p>
     * 
     * @return The time the schema object was last updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    /**
     * <p>
     * The unique ID for the collaboration that the schema belongs to.
     * </p>
     * 
     * @return The unique ID for the collaboration that the schema belongs to.
     */
    public final String collaborationId() {
        return collaborationId;
    }

    /**
     * <p>
     * The unique ARN for the collaboration that the schema belongs to.
     * </p>
     * 
     * @return The unique ARN for the collaboration that the schema belongs to.
     */
    public final String collaborationArn() {
        return collaborationArn;
    }

    /**
     * <p>
     * The types of analysis rules that are associated with this schema object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnalysisRuleTypes} method.
     * </p>
     * 
     * @return The types of analysis rules that are associated with this schema object.
     */
    public final List<AnalysisRuleType> analysisRuleTypes() {
        return AnalysisRuleTypeListCopier.copyStringToEnum(analysisRuleTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the AnalysisRuleTypes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAnalysisRuleTypes() {
        return analysisRuleTypes != null && !(analysisRuleTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The types of analysis rules that are associated with this schema object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnalysisRuleTypes} method.
     * </p>
     * 
     * @return The types of analysis rules that are associated with this schema object.
     */
    public final List<String> analysisRuleTypesAsStrings() {
        return analysisRuleTypes;
    }

    /**
     * <p>
     * The analysis method for the associated schema. The only valid value is currently `DIRECT_QUERY`.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #analysisMethod}
     * will return {@link AnalysisMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #analysisMethodAsString}.
     * </p>
     * 
     * @return The analysis method for the associated schema. The only valid value is currently `DIRECT_QUERY`.
     * @see AnalysisMethod
     */
    public final AnalysisMethod analysisMethod() {
        return AnalysisMethod.fromValue(analysisMethod);
    }

    /**
     * <p>
     * The analysis method for the associated schema. The only valid value is currently `DIRECT_QUERY`.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #analysisMethod}
     * will return {@link AnalysisMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #analysisMethodAsString}.
     * </p>
     * 
     * @return The analysis method for the associated schema. The only valid value is currently `DIRECT_QUERY`.
     * @see AnalysisMethod
     */
    public final String analysisMethodAsString() {
        return analysisMethod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creatorAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(collaborationId());
        hashCode = 31 * hashCode + Objects.hashCode(collaborationArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasAnalysisRuleTypes() ? analysisRuleTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(analysisMethodAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaSummary)) {
            return false;
        }
        SchemaSummary other = (SchemaSummary) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(creatorAccountId(), other.creatorAccountId())
                && Objects.equals(createTime(), other.createTime()) && Objects.equals(updateTime(), other.updateTime())
                && Objects.equals(collaborationId(), other.collaborationId())
                && Objects.equals(collaborationArn(), other.collaborationArn())
                && hasAnalysisRuleTypes() == other.hasAnalysisRuleTypes()
                && Objects.equals(analysisRuleTypesAsStrings(), other.analysisRuleTypesAsStrings())
                && Objects.equals(analysisMethodAsString(), other.analysisMethodAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SchemaSummary").add("Name", name()).add("Type", typeAsString())
                .add("CreatorAccountId", creatorAccountId()).add("CreateTime", createTime()).add("UpdateTime", updateTime())
                .add("CollaborationId", collaborationId()).add("CollaborationArn", collaborationArn())
                .add("AnalysisRuleTypes", hasAnalysisRuleTypes() ? analysisRuleTypesAsStrings() : null)
                .add("AnalysisMethod", analysisMethodAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "creatorAccountId":
            return Optional.ofNullable(clazz.cast(creatorAccountId()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        case "collaborationId":
            return Optional.ofNullable(clazz.cast(collaborationId()));
        case "collaborationArn":
            return Optional.ofNullable(clazz.cast(collaborationArn()));
        case "analysisRuleTypes":
            return Optional.ofNullable(clazz.cast(analysisRuleTypesAsStrings()));
        case "analysisMethod":
            return Optional.ofNullable(clazz.cast(analysisMethodAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SchemaSummary, T> g) {
        return obj -> g.apply((SchemaSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SchemaSummary> {
        /**
         * <p>
         * The name for the schema object.
         * </p>
         * 
         * @param name
         *        The name for the schema object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of schema object. The only valid schema type is currently `TABLE`.
         * </p>
         * 
         * @param type
         *        The type of schema object. The only valid schema type is currently `TABLE`.
         * @see SchemaType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchemaType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of schema object. The only valid schema type is currently `TABLE`.
         * </p>
         * 
         * @param type
         *        The type of schema object. The only valid schema type is currently `TABLE`.
         * @see SchemaType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchemaType
         */
        Builder type(SchemaType type);

        /**
         * <p>
         * The unique account ID for the Amazon Web Services account that owns the schema.
         * </p>
         * 
         * @param creatorAccountId
         *        The unique account ID for the Amazon Web Services account that owns the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorAccountId(String creatorAccountId);

        /**
         * <p>
         * The time the schema object was created.
         * </p>
         * 
         * @param createTime
         *        The time the schema object was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The time the schema object was last updated.
         * </p>
         * 
         * @param updateTime
         *        The time the schema object was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);

        /**
         * <p>
         * The unique ID for the collaboration that the schema belongs to.
         * </p>
         * 
         * @param collaborationId
         *        The unique ID for the collaboration that the schema belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationId(String collaborationId);

        /**
         * <p>
         * The unique ARN for the collaboration that the schema belongs to.
         * </p>
         * 
         * @param collaborationArn
         *        The unique ARN for the collaboration that the schema belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationArn(String collaborationArn);

        /**
         * <p>
         * The types of analysis rules that are associated with this schema object.
         * </p>
         * 
         * @param analysisRuleTypes
         *        The types of analysis rules that are associated with this schema object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisRuleTypesWithStrings(Collection<String> analysisRuleTypes);

        /**
         * <p>
         * The types of analysis rules that are associated with this schema object.
         * </p>
         * 
         * @param analysisRuleTypes
         *        The types of analysis rules that are associated with this schema object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisRuleTypesWithStrings(String... analysisRuleTypes);

        /**
         * <p>
         * The types of analysis rules that are associated with this schema object.
         * </p>
         * 
         * @param analysisRuleTypes
         *        The types of analysis rules that are associated with this schema object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisRuleTypes(Collection<AnalysisRuleType> analysisRuleTypes);

        /**
         * <p>
         * The types of analysis rules that are associated with this schema object.
         * </p>
         * 
         * @param analysisRuleTypes
         *        The types of analysis rules that are associated with this schema object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisRuleTypes(AnalysisRuleType... analysisRuleTypes);

        /**
         * <p>
         * The analysis method for the associated schema. The only valid value is currently `DIRECT_QUERY`.
         * </p>
         * 
         * @param analysisMethod
         *        The analysis method for the associated schema. The only valid value is currently `DIRECT_QUERY`.
         * @see AnalysisMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisMethod
         */
        Builder analysisMethod(String analysisMethod);

        /**
         * <p>
         * The analysis method for the associated schema. The only valid value is currently `DIRECT_QUERY`.
         * </p>
         * 
         * @param analysisMethod
         *        The analysis method for the associated schema. The only valid value is currently `DIRECT_QUERY`.
         * @see AnalysisMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisMethod
         */
        Builder analysisMethod(AnalysisMethod analysisMethod);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String type;

        private String creatorAccountId;

        private Instant createTime;

        private Instant updateTime;

        private String collaborationId;

        private String collaborationArn;

        private List<String> analysisRuleTypes = DefaultSdkAutoConstructList.getInstance();

        private String analysisMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(SchemaSummary model) {
            name(model.name);
            type(model.type);
            creatorAccountId(model.creatorAccountId);
            createTime(model.createTime);
            updateTime(model.updateTime);
            collaborationId(model.collaborationId);
            collaborationArn(model.collaborationArn);
            analysisRuleTypesWithStrings(model.analysisRuleTypes);
            analysisMethod(model.analysisMethod);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SchemaType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getCreatorAccountId() {
            return creatorAccountId;
        }

        public final void setCreatorAccountId(String creatorAccountId) {
            this.creatorAccountId = creatorAccountId;
        }

        @Override
        public final Builder creatorAccountId(String creatorAccountId) {
            this.creatorAccountId = creatorAccountId;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getCollaborationId() {
            return collaborationId;
        }

        public final void setCollaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
        }

        @Override
        public final Builder collaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
            return this;
        }

        public final String getCollaborationArn() {
            return collaborationArn;
        }

        public final void setCollaborationArn(String collaborationArn) {
            this.collaborationArn = collaborationArn;
        }

        @Override
        public final Builder collaborationArn(String collaborationArn) {
            this.collaborationArn = collaborationArn;
            return this;
        }

        public final Collection<String> getAnalysisRuleTypes() {
            if (analysisRuleTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return analysisRuleTypes;
        }

        public final void setAnalysisRuleTypes(Collection<String> analysisRuleTypes) {
            this.analysisRuleTypes = AnalysisRuleTypeListCopier.copy(analysisRuleTypes);
        }

        @Override
        public final Builder analysisRuleTypesWithStrings(Collection<String> analysisRuleTypes) {
            this.analysisRuleTypes = AnalysisRuleTypeListCopier.copy(analysisRuleTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisRuleTypesWithStrings(String... analysisRuleTypes) {
            analysisRuleTypesWithStrings(Arrays.asList(analysisRuleTypes));
            return this;
        }

        @Override
        public final Builder analysisRuleTypes(Collection<AnalysisRuleType> analysisRuleTypes) {
            this.analysisRuleTypes = AnalysisRuleTypeListCopier.copyEnumToString(analysisRuleTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisRuleTypes(AnalysisRuleType... analysisRuleTypes) {
            analysisRuleTypes(Arrays.asList(analysisRuleTypes));
            return this;
        }

        public final String getAnalysisMethod() {
            return analysisMethod;
        }

        public final void setAnalysisMethod(String analysisMethod) {
            this.analysisMethod = analysisMethod;
        }

        @Override
        public final Builder analysisMethod(String analysisMethod) {
            this.analysisMethod = analysisMethod;
            return this;
        }

        @Override
        public final Builder analysisMethod(AnalysisMethod analysisMethod) {
            this.analysisMethod(analysisMethod == null ? null : analysisMethod.toString());
            return this;
        }

        @Override
        public SchemaSummary build() {
            return new SchemaSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
