/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartProtectedQueryRequest extends CleanRoomsRequest implements
        ToCopyableBuilder<StartProtectedQueryRequest.Builder, StartProtectedQueryRequest> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(StartProtectedQueryRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipIdentifier").getter(getter(StartProtectedQueryRequest::membershipIdentifier))
            .setter(setter(Builder::membershipIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()).build();

    private static final SdkField<ProtectedQuerySQLParameters> SQL_PARAMETERS_FIELD = SdkField
            .<ProtectedQuerySQLParameters> builder(MarshallingType.SDK_POJO).memberName("sqlParameters")
            .getter(getter(StartProtectedQueryRequest::sqlParameters)).setter(setter(Builder::sqlParameters))
            .constructor(ProtectedQuerySQLParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sqlParameters").build()).build();

    private static final SdkField<ProtectedQueryResultConfiguration> RESULT_CONFIGURATION_FIELD = SdkField
            .<ProtectedQueryResultConfiguration> builder(MarshallingType.SDK_POJO).memberName("resultConfiguration")
            .getter(getter(StartProtectedQueryRequest::resultConfiguration)).setter(setter(Builder::resultConfiguration))
            .constructor(ProtectedQueryResultConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resultConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            MEMBERSHIP_IDENTIFIER_FIELD, SQL_PARAMETERS_FIELD, RESULT_CONFIGURATION_FIELD));

    private final String type;

    private final String membershipIdentifier;

    private final ProtectedQuerySQLParameters sqlParameters;

    private final ProtectedQueryResultConfiguration resultConfiguration;

    private StartProtectedQueryRequest(BuilderImpl builder) {
        super(builder);
        this.type = builder.type;
        this.membershipIdentifier = builder.membershipIdentifier;
        this.sqlParameters = builder.sqlParameters;
        this.resultConfiguration = builder.resultConfiguration;
    }

    /**
     * <p>
     * The type of the protected query to be started.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ProtectedQueryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the protected query to be started.
     * @see ProtectedQueryType
     */
    public final ProtectedQueryType type() {
        return ProtectedQueryType.fromValue(type);
    }

    /**
     * <p>
     * The type of the protected query to be started.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ProtectedQueryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the protected query to be started.
     * @see ProtectedQueryType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * A unique identifier for the membership to run this query against. Currently accepts a membership ID.
     * </p>
     * 
     * @return A unique identifier for the membership to run this query against. Currently accepts a membership ID.
     */
    public final String membershipIdentifier() {
        return membershipIdentifier;
    }

    /**
     * <p>
     * The protected SQL query parameters.
     * </p>
     * 
     * @return The protected SQL query parameters.
     */
    public final ProtectedQuerySQLParameters sqlParameters() {
        return sqlParameters;
    }

    /**
     * <p>
     * The details needed to write the query results.
     * </p>
     * 
     * @return The details needed to write the query results.
     */
    public final ProtectedQueryResultConfiguration resultConfiguration() {
        return resultConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(sqlParameters());
        hashCode = 31 * hashCode + Objects.hashCode(resultConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartProtectedQueryRequest)) {
            return false;
        }
        StartProtectedQueryRequest other = (StartProtectedQueryRequest) obj;
        return Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(membershipIdentifier(), other.membershipIdentifier())
                && Objects.equals(sqlParameters(), other.sqlParameters())
                && Objects.equals(resultConfiguration(), other.resultConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartProtectedQueryRequest").add("Type", typeAsString())
                .add("MembershipIdentifier", membershipIdentifier())
                .add("SqlParameters", sqlParameters() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ResultConfiguration", resultConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "membershipIdentifier":
            return Optional.ofNullable(clazz.cast(membershipIdentifier()));
        case "sqlParameters":
            return Optional.ofNullable(clazz.cast(sqlParameters()));
        case "resultConfiguration":
            return Optional.ofNullable(clazz.cast(resultConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartProtectedQueryRequest, T> g) {
        return obj -> g.apply((StartProtectedQueryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartProtectedQueryRequest> {
        /**
         * <p>
         * The type of the protected query to be started.
         * </p>
         * 
         * @param type
         *        The type of the protected query to be started.
         * @see ProtectedQueryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtectedQueryType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the protected query to be started.
         * </p>
         * 
         * @param type
         *        The type of the protected query to be started.
         * @see ProtectedQueryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtectedQueryType
         */
        Builder type(ProtectedQueryType type);

        /**
         * <p>
         * A unique identifier for the membership to run this query against. Currently accepts a membership ID.
         * </p>
         * 
         * @param membershipIdentifier
         *        A unique identifier for the membership to run this query against. Currently accepts a membership ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipIdentifier(String membershipIdentifier);

        /**
         * <p>
         * The protected SQL query parameters.
         * </p>
         * 
         * @param sqlParameters
         *        The protected SQL query parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqlParameters(ProtectedQuerySQLParameters sqlParameters);

        /**
         * <p>
         * The protected SQL query parameters.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProtectedQuerySQLParameters.Builder}
         * avoiding the need to create one manually via {@link ProtectedQuerySQLParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProtectedQuerySQLParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #sqlParameters(ProtectedQuerySQLParameters)}.
         * 
         * @param sqlParameters
         *        a consumer that will call methods on {@link ProtectedQuerySQLParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sqlParameters(ProtectedQuerySQLParameters)
         */
        default Builder sqlParameters(Consumer<ProtectedQuerySQLParameters.Builder> sqlParameters) {
            return sqlParameters(ProtectedQuerySQLParameters.builder().applyMutation(sqlParameters).build());
        }

        /**
         * <p>
         * The details needed to write the query results.
         * </p>
         * 
         * @param resultConfiguration
         *        The details needed to write the query results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultConfiguration(ProtectedQueryResultConfiguration resultConfiguration);

        /**
         * <p>
         * The details needed to write the query results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ProtectedQueryResultConfiguration.Builder} avoiding the need to create one manually via
         * {@link ProtectedQueryResultConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProtectedQueryResultConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #resultConfiguration(ProtectedQueryResultConfiguration)}.
         * 
         * @param resultConfiguration
         *        a consumer that will call methods on {@link ProtectedQueryResultConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resultConfiguration(ProtectedQueryResultConfiguration)
         */
        default Builder resultConfiguration(Consumer<ProtectedQueryResultConfiguration.Builder> resultConfiguration) {
            return resultConfiguration(ProtectedQueryResultConfiguration.builder().applyMutation(resultConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CleanRoomsRequest.BuilderImpl implements Builder {
        private String type;

        private String membershipIdentifier;

        private ProtectedQuerySQLParameters sqlParameters;

        private ProtectedQueryResultConfiguration resultConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(StartProtectedQueryRequest model) {
            super(model);
            type(model.type);
            membershipIdentifier(model.membershipIdentifier);
            sqlParameters(model.sqlParameters);
            resultConfiguration(model.resultConfiguration);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ProtectedQueryType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getMembershipIdentifier() {
            return membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final ProtectedQuerySQLParameters.Builder getSqlParameters() {
            return sqlParameters != null ? sqlParameters.toBuilder() : null;
        }

        public final void setSqlParameters(ProtectedQuerySQLParameters.BuilderImpl sqlParameters) {
            this.sqlParameters = sqlParameters != null ? sqlParameters.build() : null;
        }

        @Override
        public final Builder sqlParameters(ProtectedQuerySQLParameters sqlParameters) {
            this.sqlParameters = sqlParameters;
            return this;
        }

        public final ProtectedQueryResultConfiguration.Builder getResultConfiguration() {
            return resultConfiguration != null ? resultConfiguration.toBuilder() : null;
        }

        public final void setResultConfiguration(ProtectedQueryResultConfiguration.BuilderImpl resultConfiguration) {
            this.resultConfiguration = resultConfiguration != null ? resultConfiguration.build() : null;
        }

        @Override
        public final Builder resultConfiguration(ProtectedQueryResultConfiguration resultConfiguration) {
            this.resultConfiguration = resultConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartProtectedQueryRequest build() {
            return new StartProtectedQueryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
