/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the configured audience model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfiguredAudienceModelSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfiguredAudienceModelSummary.Builder, ConfiguredAudienceModelSummary> {
    private static final SdkField<String> AUDIENCE_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("audienceModelArn").getter(getter(ConfiguredAudienceModelSummary::audienceModelArn))
            .setter(setter(Builder::audienceModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audienceModelArn").build()).build();

    private static final SdkField<String> CONFIGURED_AUDIENCE_MODEL_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("configuredAudienceModelArn")
            .getter(getter(ConfiguredAudienceModelSummary::configuredAudienceModelArn))
            .setter(setter(Builder::configuredAudienceModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredAudienceModelArn").build())
            .build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime")
            .getter(getter(ConfiguredAudienceModelSummary::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(ConfiguredAudienceModelSummary::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ConfiguredAudienceModelSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<ConfiguredAudienceModelOutputConfig> OUTPUT_CONFIG_FIELD = SdkField
            .<ConfiguredAudienceModelOutputConfig> builder(MarshallingType.SDK_POJO).memberName("outputConfig")
            .getter(getter(ConfiguredAudienceModelSummary::outputConfig)).setter(setter(Builder::outputConfig))
            .constructor(ConfiguredAudienceModelOutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputConfig").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ConfiguredAudienceModelSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime")
            .getter(getter(ConfiguredAudienceModelSummary::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIENCE_MODEL_ARN_FIELD,
            CONFIGURED_AUDIENCE_MODEL_ARN_FIELD, CREATE_TIME_FIELD, DESCRIPTION_FIELD, NAME_FIELD, OUTPUT_CONFIG_FIELD,
            STATUS_FIELD, UPDATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String audienceModelArn;

    private final String configuredAudienceModelArn;

    private final Instant createTime;

    private final String description;

    private final String name;

    private final ConfiguredAudienceModelOutputConfig outputConfig;

    private final String status;

    private final Instant updateTime;

    private ConfiguredAudienceModelSummary(BuilderImpl builder) {
        this.audienceModelArn = builder.audienceModelArn;
        this.configuredAudienceModelArn = builder.configuredAudienceModelArn;
        this.createTime = builder.createTime;
        this.description = builder.description;
        this.name = builder.name;
        this.outputConfig = builder.outputConfig;
        this.status = builder.status;
        this.updateTime = builder.updateTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the audience model that was used to create the configured audience model.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the audience model that was used to create the configured audience
     *         model.
     */
    public final String audienceModelArn() {
        return audienceModelArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the configured audience model that you are interested in.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the configured audience model that you are interested in.
     */
    public final String configuredAudienceModelArn() {
        return configuredAudienceModelArn;
    }

    /**
     * <p>
     * The time at which the configured audience model was created.
     * </p>
     * 
     * @return The time at which the configured audience model was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The description of the configured audience model.
     * </p>
     * 
     * @return The description of the configured audience model.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the configured audience model.
     * </p>
     * 
     * @return The name of the configured audience model.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The output configuration of the configured audience model.
     * </p>
     * 
     * @return The output configuration of the configured audience model.
     */
    public final ConfiguredAudienceModelOutputConfig outputConfig() {
        return outputConfig;
    }

    /**
     * <p>
     * The status of the configured audience model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ConfiguredAudienceModelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the configured audience model.
     * @see ConfiguredAudienceModelStatus
     */
    public final ConfiguredAudienceModelStatus status() {
        return ConfiguredAudienceModelStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the configured audience model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ConfiguredAudienceModelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the configured audience model.
     * @see ConfiguredAudienceModelStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The most recent time at which the configured audience model was updated.
     * </p>
     * 
     * @return The most recent time at which the configured audience model was updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(audienceModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(configuredAudienceModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfiguredAudienceModelSummary)) {
            return false;
        }
        ConfiguredAudienceModelSummary other = (ConfiguredAudienceModelSummary) obj;
        return Objects.equals(audienceModelArn(), other.audienceModelArn())
                && Objects.equals(configuredAudienceModelArn(), other.configuredAudienceModelArn())
                && Objects.equals(createTime(), other.createTime()) && Objects.equals(description(), other.description())
                && Objects.equals(name(), other.name()) && Objects.equals(outputConfig(), other.outputConfig())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(updateTime(), other.updateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfiguredAudienceModelSummary").add("AudienceModelArn", audienceModelArn())
                .add("ConfiguredAudienceModelArn", configuredAudienceModelArn()).add("CreateTime", createTime())
                .add("Description", description()).add("Name", name()).add("OutputConfig", outputConfig())
                .add("Status", statusAsString()).add("UpdateTime", updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "audienceModelArn":
            return Optional.ofNullable(clazz.cast(audienceModelArn()));
        case "configuredAudienceModelArn":
            return Optional.ofNullable(clazz.cast(configuredAudienceModelArn()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "outputConfig":
            return Optional.ofNullable(clazz.cast(outputConfig()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfiguredAudienceModelSummary, T> g) {
        return obj -> g.apply((ConfiguredAudienceModelSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfiguredAudienceModelSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the audience model that was used to create the configured audience model.
         * </p>
         * 
         * @param audienceModelArn
         *        The Amazon Resource Name (ARN) of the audience model that was used to create the configured audience
         *        model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audienceModelArn(String audienceModelArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the configured audience model that you are interested in.
         * </p>
         * 
         * @param configuredAudienceModelArn
         *        The Amazon Resource Name (ARN) of the configured audience model that you are interested in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredAudienceModelArn(String configuredAudienceModelArn);

        /**
         * <p>
         * The time at which the configured audience model was created.
         * </p>
         * 
         * @param createTime
         *        The time at which the configured audience model was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The description of the configured audience model.
         * </p>
         * 
         * @param description
         *        The description of the configured audience model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the configured audience model.
         * </p>
         * 
         * @param name
         *        The name of the configured audience model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The output configuration of the configured audience model.
         * </p>
         * 
         * @param outputConfig
         *        The output configuration of the configured audience model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfig(ConfiguredAudienceModelOutputConfig outputConfig);

        /**
         * <p>
         * The output configuration of the configured audience model.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ConfiguredAudienceModelOutputConfig.Builder} avoiding the need to create one manually via
         * {@link ConfiguredAudienceModelOutputConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConfiguredAudienceModelOutputConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #outputConfig(ConfiguredAudienceModelOutputConfig)}.
         * 
         * @param outputConfig
         *        a consumer that will call methods on {@link ConfiguredAudienceModelOutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfig(ConfiguredAudienceModelOutputConfig)
         */
        default Builder outputConfig(Consumer<ConfiguredAudienceModelOutputConfig.Builder> outputConfig) {
            return outputConfig(ConfiguredAudienceModelOutputConfig.builder().applyMutation(outputConfig).build());
        }

        /**
         * <p>
         * The status of the configured audience model.
         * </p>
         * 
         * @param status
         *        The status of the configured audience model.
         * @see ConfiguredAudienceModelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfiguredAudienceModelStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the configured audience model.
         * </p>
         * 
         * @param status
         *        The status of the configured audience model.
         * @see ConfiguredAudienceModelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfiguredAudienceModelStatus
         */
        Builder status(ConfiguredAudienceModelStatus status);

        /**
         * <p>
         * The most recent time at which the configured audience model was updated.
         * </p>
         * 
         * @param updateTime
         *        The most recent time at which the configured audience model was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);
    }

    static final class BuilderImpl implements Builder {
        private String audienceModelArn;

        private String configuredAudienceModelArn;

        private Instant createTime;

        private String description;

        private String name;

        private ConfiguredAudienceModelOutputConfig outputConfig;

        private String status;

        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfiguredAudienceModelSummary model) {
            audienceModelArn(model.audienceModelArn);
            configuredAudienceModelArn(model.configuredAudienceModelArn);
            createTime(model.createTime);
            description(model.description);
            name(model.name);
            outputConfig(model.outputConfig);
            status(model.status);
            updateTime(model.updateTime);
        }

        public final String getAudienceModelArn() {
            return audienceModelArn;
        }

        public final void setAudienceModelArn(String audienceModelArn) {
            this.audienceModelArn = audienceModelArn;
        }

        @Override
        public final Builder audienceModelArn(String audienceModelArn) {
            this.audienceModelArn = audienceModelArn;
            return this;
        }

        public final String getConfiguredAudienceModelArn() {
            return configuredAudienceModelArn;
        }

        public final void setConfiguredAudienceModelArn(String configuredAudienceModelArn) {
            this.configuredAudienceModelArn = configuredAudienceModelArn;
        }

        @Override
        public final Builder configuredAudienceModelArn(String configuredAudienceModelArn) {
            this.configuredAudienceModelArn = configuredAudienceModelArn;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ConfiguredAudienceModelOutputConfig.Builder getOutputConfig() {
            return outputConfig != null ? outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(ConfiguredAudienceModelOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(ConfiguredAudienceModelOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ConfiguredAudienceModelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @Override
        public ConfiguredAudienceModelSummary build() {
            return new ConfiguredAudienceModelSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
