/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPolicyAttachmentsRequest extends CloudDirectoryRequest implements
        ToCopyableBuilder<ListPolicyAttachmentsRequest.Builder, ListPolicyAttachmentsRequest> {
    private static final SdkField<String> DIRECTORY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryArn").getter(getter(ListPolicyAttachmentsRequest::directoryArn))
            .setter(setter(Builder::directoryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-data-partition").build())
            .build();

    private static final SdkField<ObjectReference> POLICY_REFERENCE_FIELD = SdkField
            .<ObjectReference> builder(MarshallingType.SDK_POJO).memberName("PolicyReference")
            .getter(getter(ListPolicyAttachmentsRequest::policyReference)).setter(setter(Builder::policyReference))
            .constructor(ObjectReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyReference").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPolicyAttachmentsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListPolicyAttachmentsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> CONSISTENCY_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConsistencyLevel").getter(getter(ListPolicyAttachmentsRequest::consistencyLevelAsString))
            .setter(setter(Builder::consistencyLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-consistency-level").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ARN_FIELD,
            POLICY_REFERENCE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, CONSISTENCY_LEVEL_FIELD));

    private final String directoryArn;

    private final ObjectReference policyReference;

    private final String nextToken;

    private final Integer maxResults;

    private final String consistencyLevel;

    private ListPolicyAttachmentsRequest(BuilderImpl builder) {
        super(builder);
        this.directoryArn = builder.directoryArn;
        this.policyReference = builder.policyReference;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.consistencyLevel = builder.consistencyLevel;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that is associated with the <a>Directory</a> where objects reside. For more
     * information, see <a>arns</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that is associated with the <a>Directory</a> where objects reside. For
     *         more information, see <a>arns</a>.
     */
    public final String directoryArn() {
        return directoryArn;
    }

    /**
     * <p>
     * The reference that identifies the policy object.
     * </p>
     * 
     * @return The reference that identifies the policy object.
     */
    public final ObjectReference policyReference() {
        return policyReference;
    }

    /**
     * <p>
     * The pagination token.
     * </p>
     * 
     * @return The pagination token.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to be retrieved in a single call. This is an approximate number.
     * </p>
     * 
     * @return The maximum number of items to be retrieved in a single call. This is an approximate number.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Represents the manner and timing in which the successful write or update of an object is reflected in a
     * subsequent read operation of that same object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #consistencyLevel}
     * will return {@link ConsistencyLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #consistencyLevelAsString}.
     * </p>
     * 
     * @return Represents the manner and timing in which the successful write or update of an object is reflected in a
     *         subsequent read operation of that same object.
     * @see ConsistencyLevel
     */
    public final ConsistencyLevel consistencyLevel() {
        return ConsistencyLevel.fromValue(consistencyLevel);
    }

    /**
     * <p>
     * Represents the manner and timing in which the successful write or update of an object is reflected in a
     * subsequent read operation of that same object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #consistencyLevel}
     * will return {@link ConsistencyLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #consistencyLevelAsString}.
     * </p>
     * 
     * @return Represents the manner and timing in which the successful write or update of an object is reflected in a
     *         subsequent read operation of that same object.
     * @see ConsistencyLevel
     */
    public final String consistencyLevelAsString() {
        return consistencyLevel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(policyReference());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(consistencyLevelAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPolicyAttachmentsRequest)) {
            return false;
        }
        ListPolicyAttachmentsRequest other = (ListPolicyAttachmentsRequest) obj;
        return Objects.equals(directoryArn(), other.directoryArn()) && Objects.equals(policyReference(), other.policyReference())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(consistencyLevelAsString(), other.consistencyLevelAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPolicyAttachmentsRequest").add("DirectoryArn", directoryArn())
                .add("PolicyReference", policyReference()).add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("ConsistencyLevel", consistencyLevelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryArn":
            return Optional.ofNullable(clazz.cast(directoryArn()));
        case "PolicyReference":
            return Optional.ofNullable(clazz.cast(policyReference()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "ConsistencyLevel":
            return Optional.ofNullable(clazz.cast(consistencyLevelAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPolicyAttachmentsRequest, T> g) {
        return obj -> g.apply((ListPolicyAttachmentsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudDirectoryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListPolicyAttachmentsRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that is associated with the <a>Directory</a> where objects reside. For more
         * information, see <a>arns</a>.
         * </p>
         * 
         * @param directoryArn
         *        The Amazon Resource Name (ARN) that is associated with the <a>Directory</a> where objects reside. For
         *        more information, see <a>arns</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryArn(String directoryArn);

        /**
         * <p>
         * The reference that identifies the policy object.
         * </p>
         * 
         * @param policyReference
         *        The reference that identifies the policy object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyReference(ObjectReference policyReference);

        /**
         * <p>
         * The reference that identifies the policy object.
         * </p>
         * This is a convenience method that creates an instance of the {@link ObjectReference.Builder} avoiding the
         * need to create one manually via {@link ObjectReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ObjectReference.Builder#build()} is called immediately and its
         * result is passed to {@link #policyReference(ObjectReference)}.
         * 
         * @param policyReference
         *        a consumer that will call methods on {@link ObjectReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policyReference(ObjectReference)
         */
        default Builder policyReference(Consumer<ObjectReference.Builder> policyReference) {
            return policyReference(ObjectReference.builder().applyMutation(policyReference).build());
        }

        /**
         * <p>
         * The pagination token.
         * </p>
         * 
         * @param nextToken
         *        The pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to be retrieved in a single call. This is an approximate number.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to be retrieved in a single call. This is an approximate number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Represents the manner and timing in which the successful write or update of an object is reflected in a
         * subsequent read operation of that same object.
         * </p>
         * 
         * @param consistencyLevel
         *        Represents the manner and timing in which the successful write or update of an object is reflected in
         *        a subsequent read operation of that same object.
         * @see ConsistencyLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConsistencyLevel
         */
        Builder consistencyLevel(String consistencyLevel);

        /**
         * <p>
         * Represents the manner and timing in which the successful write or update of an object is reflected in a
         * subsequent read operation of that same object.
         * </p>
         * 
         * @param consistencyLevel
         *        Represents the manner and timing in which the successful write or update of an object is reflected in
         *        a subsequent read operation of that same object.
         * @see ConsistencyLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConsistencyLevel
         */
        Builder consistencyLevel(ConsistencyLevel consistencyLevel);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudDirectoryRequest.BuilderImpl implements Builder {
        private String directoryArn;

        private ObjectReference policyReference;

        private String nextToken;

        private Integer maxResults;

        private String consistencyLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPolicyAttachmentsRequest model) {
            super(model);
            directoryArn(model.directoryArn);
            policyReference(model.policyReference);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            consistencyLevel(model.consistencyLevel);
        }

        public final String getDirectoryArn() {
            return directoryArn;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final ObjectReference.Builder getPolicyReference() {
            return policyReference != null ? policyReference.toBuilder() : null;
        }

        public final void setPolicyReference(ObjectReference.BuilderImpl policyReference) {
            this.policyReference = policyReference != null ? policyReference.build() : null;
        }

        @Override
        public final Builder policyReference(ObjectReference policyReference) {
            this.policyReference = policyReference;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getConsistencyLevel() {
            return consistencyLevel;
        }

        public final void setConsistencyLevel(String consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
        }

        @Override
        public final Builder consistencyLevel(String consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
            return this;
        }

        @Override
        public final Builder consistencyLevel(ConsistencyLevel consistencyLevel) {
            this.consistencyLevel(consistencyLevel == null ? null : consistencyLevel.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListPolicyAttachmentsRequest build() {
            return new ListPolicyAttachmentsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
