/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePublisherRequest extends CloudFormationRequest implements
        ToCopyableBuilder<DescribePublisherRequest.Builder, DescribePublisherRequest> {
    private static final SdkField<String> PUBLISHER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublisherId").getter(getter(DescribePublisherRequest::publisherId)).setter(setter(Builder::publisherId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublisherId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUBLISHER_ID_FIELD));

    private final String publisherId;

    private DescribePublisherRequest(BuilderImpl builder) {
        super(builder);
        this.publisherId = builder.publisherId;
    }

    /**
     * <p>
     * The ID of the extension publisher.
     * </p>
     * <p>
     * If you don't supply a <code>PublisherId</code>, and you have registered as an extension publisher,
     * <code>DescribePublisher</code> returns information about your own publisher account.
     * </p>
     * 
     * @return The ID of the extension publisher.</p>
     *         <p>
     *         If you don't supply a <code>PublisherId</code>, and you have registered as an extension publisher,
     *         <code>DescribePublisher</code> returns information about your own publisher account.
     */
    public final String publisherId() {
        return publisherId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(publisherId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePublisherRequest)) {
            return false;
        }
        DescribePublisherRequest other = (DescribePublisherRequest) obj;
        return Objects.equals(publisherId(), other.publisherId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribePublisherRequest").add("PublisherId", publisherId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PublisherId":
            return Optional.ofNullable(clazz.cast(publisherId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePublisherRequest, T> g) {
        return obj -> g.apply((DescribePublisherRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribePublisherRequest> {
        /**
         * <p>
         * The ID of the extension publisher.
         * </p>
         * <p>
         * If you don't supply a <code>PublisherId</code>, and you have registered as an extension publisher,
         * <code>DescribePublisher</code> returns information about your own publisher account.
         * </p>
         * 
         * @param publisherId
         *        The ID of the extension publisher.</p>
         *        <p>
         *        If you don't supply a <code>PublisherId</code>, and you have registered as an extension publisher,
         *        <code>DescribePublisher</code> returns information about your own publisher account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publisherId(String publisherId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String publisherId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePublisherRequest model) {
            super(model);
            publisherId(model.publisherId);
        }

        public final String getPublisherId() {
            return publisherId;
        }

        public final void setPublisherId(String publisherId) {
            this.publisherId = publisherId;
        }

        @Override
        public final Builder publisherId(String publisherId) {
            this.publisherId = publisherId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribePublisherRequest build() {
            return new DescribePublisherRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
